# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetManagementZonesResult',
    'AwaitableGetManagementZonesResult',
    'get_management_zones',
    'get_management_zones_output',
]

@pulumi.output_type
class GetManagementZonesResult:
    """
    A collection of values returned by getManagementZones.
    """
    def __init__(__self__, id=None, values=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if values and not isinstance(values, list):
            raise TypeError("Expected argument 'values' to be a list")
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def values(self) -> Sequence['outputs.GetManagementZonesValueResult']:
        return pulumi.get(self, "values")


class AwaitableGetManagementZonesResult(GetManagementZonesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagementZonesResult(
            id=self.id,
            values=self.values)


def get_management_zones(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagementZonesResult:
    """
    The management zones data source allows retrieval of all management zones.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dynatrace as dynatrace
    import pulumiverse_dynatrace as dynatrace

    test = dynatrace.get_management_zones()
    _name_ = dynatrace.CalculatedServiceMetric("#name#",
        enabled=True,
        management_zones=[test.values[0].id],
        metric_key="calc:service.#name#",
        unit="MILLI_SECOND_PER_MINUTE",
        conditions=[{
            "conditions": [{
                "attribute": "HTTP_REQUEST_METHOD",
                "comparison": {
                    "negate": False,
                    "http_method": {
                        "operator": "EQUALS_ANY_OF",
                        "values": [
                            "POST",
                            "GET",
                        ],
                    },
                },
            }],
        }],
        metric_definition={
            "metric": "REQUEST_ATTRIBUTE",
            "request_attribute": "foo",
        })
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dynatrace:index/getManagementZones:getManagementZones', __args__, opts=opts, typ=GetManagementZonesResult).value

    return AwaitableGetManagementZonesResult(
        id=pulumi.get(__ret__, 'id'),
        values=pulumi.get(__ret__, 'values'))
def get_management_zones_output(opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagementZonesResult]:
    """
    The management zones data source allows retrieval of all management zones.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dynatrace as dynatrace
    import pulumiverse_dynatrace as dynatrace

    test = dynatrace.get_management_zones()
    _name_ = dynatrace.CalculatedServiceMetric("#name#",
        enabled=True,
        management_zones=[test.values[0].id],
        metric_key="calc:service.#name#",
        unit="MILLI_SECOND_PER_MINUTE",
        conditions=[{
            "conditions": [{
                "attribute": "HTTP_REQUEST_METHOD",
                "comparison": {
                    "negate": False,
                    "http_method": {
                        "operator": "EQUALS_ANY_OF",
                        "values": [
                            "POST",
                            "GET",
                        ],
                    },
                },
            }],
        }],
        metric_definition={
            "metric": "REQUEST_ATTRIBUTE",
            "request_attribute": "foo",
        })
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dynatrace:index/getManagementZones:getManagementZones', __args__, opts=opts, typ=GetManagementZonesResult)
    return __ret__.apply(lambda __response__: GetManagementZonesResult(
        id=pulumi.get(__response__, 'id'),
        values=pulumi.get(__response__, 'values')))
