# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetPlatformSloTemplateResult',
    'AwaitableGetPlatformSloTemplateResult',
    'get_platform_slo_template',
    'get_platform_slo_template_output',
]

@pulumi.output_type
class GetPlatformSloTemplateResult:
    """
    A collection of values returned by getPlatformSloTemplate.
    """
    def __init__(__self__, id=None, name=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        ID of the SLO objective template
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the SLO objective template
        """
        return pulumi.get(self, "name")


class AwaitableGetPlatformSloTemplateResult(GetPlatformSloTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPlatformSloTemplateResult(
            id=self.id,
            name=self.name)


def get_platform_slo_template(name: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPlatformSloTemplateResult:
    """
    > To utilize this data source, please define the environment variables `DT_CLIENT_ID`, `DT_CLIENT_SECRET`, `DT_ACCOUNT_ID` with an OAuth client including the following permissions: **View SLOs** (`slo:slos:read`) and **View SLO objective templates** (`slo:objective-templates:read`).

    The SLO objective template data source allows the ID to be retrieved by its name.

    - `name` (String) Name of the SLO objective template

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dynatrace as dynatrace
    import pulumiverse_dynatrace as dynatrace

    host_cpu = dynatrace.get_platform_slo_template(name="Host CPU usage utilization")
    _name_ = dynatrace.PlatformSlo("#name#",
        description="Measures the CPU usage of selected hosts over time.",
        criteria={
            "criteria_details": [{
                "target": 95,
                "timeframe_from": "now-7d",
                "timeframe_to": "now",
            }],
        },
        sli_reference={
            "template_id": host_cpu.id,
            "variables": {
                "sli_reference_variables": [{
                    "name": "hosts",
                    "value": "\\"HOST-1234567890000000\\"",
                }],
            },
        })
    ```


    :param builtins.str name: Name of the SLO objective template
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dynatrace:index/getPlatformSloTemplate:getPlatformSloTemplate', __args__, opts=opts, typ=GetPlatformSloTemplateResult).value

    return AwaitableGetPlatformSloTemplateResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'))
def get_platform_slo_template_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPlatformSloTemplateResult]:
    """
    > To utilize this data source, please define the environment variables `DT_CLIENT_ID`, `DT_CLIENT_SECRET`, `DT_ACCOUNT_ID` with an OAuth client including the following permissions: **View SLOs** (`slo:slos:read`) and **View SLO objective templates** (`slo:objective-templates:read`).

    The SLO objective template data source allows the ID to be retrieved by its name.

    - `name` (String) Name of the SLO objective template

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dynatrace as dynatrace
    import pulumiverse_dynatrace as dynatrace

    host_cpu = dynatrace.get_platform_slo_template(name="Host CPU usage utilization")
    _name_ = dynatrace.PlatformSlo("#name#",
        description="Measures the CPU usage of selected hosts over time.",
        criteria={
            "criteria_details": [{
                "target": 95,
                "timeframe_from": "now-7d",
                "timeframe_to": "now",
            }],
        },
        sli_reference={
            "template_id": host_cpu.id,
            "variables": {
                "sli_reference_variables": [{
                    "name": "hosts",
                    "value": "\\"HOST-1234567890000000\\"",
                }],
            },
        })
    ```


    :param builtins.str name: Name of the SLO objective template
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dynatrace:index/getPlatformSloTemplate:getPlatformSloTemplate', __args__, opts=opts, typ=GetPlatformSloTemplateResult)
    return __ret__.apply(lambda __response__: GetPlatformSloTemplateResult(
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name')))
