# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GrailSecurityContextArgs', 'GrailSecurityContext']

@pulumi.input_type
class GrailSecurityContextArgs:
    def __init__(__self__, *,
                 destination_property: pulumi.Input[builtins.str],
                 entity_type: pulumi.Input[builtins.str],
                 insert_after: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a GrailSecurityContext resource.
        :param pulumi.Input[builtins.str] destination_property: The case-sensitive name of a property of the destination type.
        :param pulumi.Input[builtins.str] entity_type: Type of the entity whose security context to override.
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        pulumi.set(__self__, "destination_property", destination_property)
        pulumi.set(__self__, "entity_type", entity_type)
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)

    @property
    @pulumi.getter(name="destinationProperty")
    def destination_property(self) -> pulumi.Input[builtins.str]:
        """
        The case-sensitive name of a property of the destination type.
        """
        return pulumi.get(self, "destination_property")

    @destination_property.setter
    def destination_property(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "destination_property", value)

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> pulumi.Input[builtins.str]:
        """
        Type of the entity whose security context to override.
        """
        return pulumi.get(self, "entity_type")

    @entity_type.setter
    def entity_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "entity_type", value)

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "insert_after", value)


@pulumi.input_type
class _GrailSecurityContextState:
    def __init__(__self__, *,
                 destination_property: Optional[pulumi.Input[builtins.str]] = None,
                 entity_type: Optional[pulumi.Input[builtins.str]] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering GrailSecurityContext resources.
        :param pulumi.Input[builtins.str] destination_property: The case-sensitive name of a property of the destination type.
        :param pulumi.Input[builtins.str] entity_type: Type of the entity whose security context to override.
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        if destination_property is not None:
            pulumi.set(__self__, "destination_property", destination_property)
        if entity_type is not None:
            pulumi.set(__self__, "entity_type", entity_type)
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)

    @property
    @pulumi.getter(name="destinationProperty")
    def destination_property(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The case-sensitive name of a property of the destination type.
        """
        return pulumi.get(self, "destination_property")

    @destination_property.setter
    def destination_property(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_property", value)

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of the entity whose security context to override.
        """
        return pulumi.get(self, "entity_type")

    @entity_type.setter
    def entity_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "entity_type", value)

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "insert_after", value)


@pulumi.type_token("dynatrace:index/grailSecurityContext:GrailSecurityContext")
class GrailSecurityContext(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_property: Optional[pulumi.Input[builtins.str]] = None,
                 entity_type: Optional[pulumi.Input[builtins.str]] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a GrailSecurityContext resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] destination_property: The case-sensitive name of a property of the destination type.
        :param pulumi.Input[builtins.str] entity_type: Type of the entity whose security context to override.
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GrailSecurityContextArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a GrailSecurityContext resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param GrailSecurityContextArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GrailSecurityContextArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_property: Optional[pulumi.Input[builtins.str]] = None,
                 entity_type: Optional[pulumi.Input[builtins.str]] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GrailSecurityContextArgs.__new__(GrailSecurityContextArgs)

            if destination_property is None and not opts.urn:
                raise TypeError("Missing required property 'destination_property'")
            __props__.__dict__["destination_property"] = destination_property
            if entity_type is None and not opts.urn:
                raise TypeError("Missing required property 'entity_type'")
            __props__.__dict__["entity_type"] = entity_type
            __props__.__dict__["insert_after"] = insert_after
        super(GrailSecurityContext, __self__).__init__(
            'dynatrace:index/grailSecurityContext:GrailSecurityContext',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            destination_property: Optional[pulumi.Input[builtins.str]] = None,
            entity_type: Optional[pulumi.Input[builtins.str]] = None,
            insert_after: Optional[pulumi.Input[builtins.str]] = None) -> 'GrailSecurityContext':
        """
        Get an existing GrailSecurityContext resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] destination_property: The case-sensitive name of a property of the destination type.
        :param pulumi.Input[builtins.str] entity_type: Type of the entity whose security context to override.
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GrailSecurityContextState.__new__(_GrailSecurityContextState)

        __props__.__dict__["destination_property"] = destination_property
        __props__.__dict__["entity_type"] = entity_type
        __props__.__dict__["insert_after"] = insert_after
        return GrailSecurityContext(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="destinationProperty")
    def destination_property(self) -> pulumi.Output[builtins.str]:
        """
        The case-sensitive name of a property of the destination type.
        """
        return pulumi.get(self, "destination_property")

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> pulumi.Output[builtins.str]:
        """
        Type of the entity whose security context to override.
        """
        return pulumi.get(self, "entity_type")

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> pulumi.Output[builtins.str]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

