# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HttpMonitorScriptInitArgs', 'HttpMonitorScript']

@pulumi.input_type
class HttpMonitorScriptInitArgs:
    def __init__(__self__, *,
                 http_id: pulumi.Input[builtins.str],
                 script: pulumi.Input['HttpMonitorScriptScriptArgs']):
        """
        The set of arguments for constructing a HttpMonitorScript resource.
        :param pulumi.Input[builtins.str] http_id: The ID of the HTTP monitor
        :param pulumi.Input['HttpMonitorScriptScriptArgs'] script: The HTTP Script
        """
        pulumi.set(__self__, "http_id", http_id)
        pulumi.set(__self__, "script", script)

    @property
    @pulumi.getter(name="httpId")
    def http_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the HTTP monitor
        """
        return pulumi.get(self, "http_id")

    @http_id.setter
    def http_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "http_id", value)

    @property
    @pulumi.getter
    def script(self) -> pulumi.Input['HttpMonitorScriptScriptArgs']:
        """
        The HTTP Script
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: pulumi.Input['HttpMonitorScriptScriptArgs']):
        pulumi.set(self, "script", value)


@pulumi.input_type
class _HttpMonitorScriptState:
    def __init__(__self__, *,
                 http_id: Optional[pulumi.Input[builtins.str]] = None,
                 script: Optional[pulumi.Input['HttpMonitorScriptScriptArgs']] = None):
        """
        Input properties used for looking up and filtering HttpMonitorScript resources.
        :param pulumi.Input[builtins.str] http_id: The ID of the HTTP monitor
        :param pulumi.Input['HttpMonitorScriptScriptArgs'] script: The HTTP Script
        """
        if http_id is not None:
            pulumi.set(__self__, "http_id", http_id)
        if script is not None:
            pulumi.set(__self__, "script", script)

    @property
    @pulumi.getter(name="httpId")
    def http_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the HTTP monitor
        """
        return pulumi.get(self, "http_id")

    @http_id.setter
    def http_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "http_id", value)

    @property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input['HttpMonitorScriptScriptArgs']]:
        """
        The HTTP Script
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input['HttpMonitorScriptScriptArgs']]):
        pulumi.set(self, "script", value)


@pulumi.type_token("dynatrace:index/httpMonitorScript:HttpMonitorScript")
class HttpMonitorScript(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 http_id: Optional[pulumi.Input[builtins.str]] = None,
                 script: Optional[pulumi.Input[Union['HttpMonitorScriptScriptArgs', 'HttpMonitorScriptScriptArgsDict']]] = None,
                 __props__=None):
        """
        Create a HttpMonitorScript resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] http_id: The ID of the HTTP monitor
        :param pulumi.Input[Union['HttpMonitorScriptScriptArgs', 'HttpMonitorScriptScriptArgsDict']] script: The HTTP Script
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HttpMonitorScriptInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a HttpMonitorScript resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param HttpMonitorScriptInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HttpMonitorScriptInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 http_id: Optional[pulumi.Input[builtins.str]] = None,
                 script: Optional[pulumi.Input[Union['HttpMonitorScriptScriptArgs', 'HttpMonitorScriptScriptArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HttpMonitorScriptInitArgs.__new__(HttpMonitorScriptInitArgs)

            if http_id is None and not opts.urn:
                raise TypeError("Missing required property 'http_id'")
            __props__.__dict__["http_id"] = http_id
            if script is None and not opts.urn:
                raise TypeError("Missing required property 'script'")
            __props__.__dict__["script"] = script
        super(HttpMonitorScript, __self__).__init__(
            'dynatrace:index/httpMonitorScript:HttpMonitorScript',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            http_id: Optional[pulumi.Input[builtins.str]] = None,
            script: Optional[pulumi.Input[Union['HttpMonitorScriptScriptArgs', 'HttpMonitorScriptScriptArgsDict']]] = None) -> 'HttpMonitorScript':
        """
        Get an existing HttpMonitorScript resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] http_id: The ID of the HTTP monitor
        :param pulumi.Input[Union['HttpMonitorScriptScriptArgs', 'HttpMonitorScriptScriptArgsDict']] script: The HTTP Script
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HttpMonitorScriptState.__new__(_HttpMonitorScriptState)

        __props__.__dict__["http_id"] = http_id
        __props__.__dict__["script"] = script
        return HttpMonitorScript(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="httpId")
    def http_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the HTTP monitor
        """
        return pulumi.get(self, "http_id")

    @property
    @pulumi.getter
    def script(self) -> pulumi.Output['outputs.HttpMonitorScriptScript']:
        """
        The HTTP Script
        """
        return pulumi.get(self, "script")

