# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['IamPolicyBoundaryArgs', 'IamPolicyBoundary']

@pulumi.input_type
class IamPolicyBoundaryArgs:
    def __init__(__self__, *,
                 query: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a IamPolicyBoundary resource.
        :param pulumi.Input[builtins.str] query: The boundary query
        :param pulumi.Input[builtins.str] name: The name of the policy
        """
        pulumi.set(__self__, "query", query)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def query(self) -> pulumi.Input[builtins.str]:
        """
        The boundary query
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _IamPolicyBoundaryState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 query: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering IamPolicyBoundary resources.
        :param pulumi.Input[builtins.str] name: The name of the policy
        :param pulumi.Input[builtins.str] query: The boundary query
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The boundary query
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "query", value)


@pulumi.type_token("dynatrace:index/iamPolicyBoundary:IamPolicyBoundary")
class IamPolicyBoundary(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 query: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        > **Dynatrace SaaS only**

        > To utilize this resource, please define the environment variables `DT_CLIENT_ID`, `DT_CLIENT_SECRET`, `DT_ACCOUNT_ID` with an OAuth client including the following permissions: **Allow IAM policy configuration for environments** (`iam-policies-management`) and **View environments** (`account-env-read`).

        > This resource is excluded by default in the export utility, please explicitly specify the resource to retrieve existing configuration.

        ## Dynatrace Documentation

        - Dynatrace IAM Group Permissions - https://docs.dynatrace.com/docs/manage/identity-access-management/permission-management/manage-user-permissions-policies

        - Settings API - https://www.dynatrace.com/support/help/how-to-use-dynatrace/user-management-and-sso/manage-groups-and-permissions/iam/iam-getting-started

        ## Resource Example Usage

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        this_iam_policy_boundary = dynatrace.IamPolicyBoundary("thisIamPolicyBoundary", query="environment:management-zone startsWith \\"[Foo]\\";")
        this_iam_group = dynatrace.IamGroup("thisIamGroup")
        this_iam_policy = dynatrace.IamPolicy("thisIamPolicy",
            account="########-####-####-####-############",
            statement_query="ALLOW settings:objects:read, settings:schemas:read WHERE settings:schemaId = \\"#########\\";")
        this_iam_policy_bindings_v2 = dynatrace.IamPolicyBindingsV2("thisIamPolicyBindingsV2",
            environment="########",
            group=this_iam_group.id,
            policies=[{
                "id": this_iam_policy.id,
                "boundaries": [this_iam_policy_boundary.id],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The name of the policy
        :param pulumi.Input[builtins.str] query: The boundary query
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IamPolicyBoundaryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **Dynatrace SaaS only**

        > To utilize this resource, please define the environment variables `DT_CLIENT_ID`, `DT_CLIENT_SECRET`, `DT_ACCOUNT_ID` with an OAuth client including the following permissions: **Allow IAM policy configuration for environments** (`iam-policies-management`) and **View environments** (`account-env-read`).

        > This resource is excluded by default in the export utility, please explicitly specify the resource to retrieve existing configuration.

        ## Dynatrace Documentation

        - Dynatrace IAM Group Permissions - https://docs.dynatrace.com/docs/manage/identity-access-management/permission-management/manage-user-permissions-policies

        - Settings API - https://www.dynatrace.com/support/help/how-to-use-dynatrace/user-management-and-sso/manage-groups-and-permissions/iam/iam-getting-started

        ## Resource Example Usage

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        this_iam_policy_boundary = dynatrace.IamPolicyBoundary("thisIamPolicyBoundary", query="environment:management-zone startsWith \\"[Foo]\\";")
        this_iam_group = dynatrace.IamGroup("thisIamGroup")
        this_iam_policy = dynatrace.IamPolicy("thisIamPolicy",
            account="########-####-####-####-############",
            statement_query="ALLOW settings:objects:read, settings:schemas:read WHERE settings:schemaId = \\"#########\\";")
        this_iam_policy_bindings_v2 = dynatrace.IamPolicyBindingsV2("thisIamPolicyBindingsV2",
            environment="########",
            group=this_iam_group.id,
            policies=[{
                "id": this_iam_policy.id,
                "boundaries": [this_iam_policy_boundary.id],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param IamPolicyBoundaryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IamPolicyBoundaryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 query: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IamPolicyBoundaryArgs.__new__(IamPolicyBoundaryArgs)

            __props__.__dict__["name"] = name
            if query is None and not opts.urn:
                raise TypeError("Missing required property 'query'")
            __props__.__dict__["query"] = query
        super(IamPolicyBoundary, __self__).__init__(
            'dynatrace:index/iamPolicyBoundary:IamPolicyBoundary',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            query: Optional[pulumi.Input[builtins.str]] = None) -> 'IamPolicyBoundary':
        """
        Get an existing IamPolicyBoundary resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The name of the policy
        :param pulumi.Input[builtins.str] query: The boundary query
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IamPolicyBoundaryState.__new__(_IamPolicyBoundaryState)

        __props__.__dict__["name"] = name
        __props__.__dict__["query"] = query
        return IamPolicyBoundary(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the policy
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def query(self) -> pulumi.Output[builtins.str]:
        """
        The boundary query
        """
        return pulumi.get(self, "query")

