# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['JenkinsConnectionArgs', 'JenkinsConnection']

@pulumi.input_type
class JenkinsConnectionArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[builtins.str],
                 url: pulumi.Input[builtins.str],
                 username: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a JenkinsConnection resource.
        :param pulumi.Input[builtins.str] password: The password of the user or API token obtained from the Jenkins UI (Dashboard > User > Configure > API Token)
        :param pulumi.Input[builtins.str] url: Base URL of your Jenkins instance (e.g. https://[YOUR*JENKINS*DOMAIN]/)
        :param pulumi.Input[builtins.str] username: The name of your Jenkins user (e.g. jenkins)
        :param pulumi.Input[builtins.str] name: The name of the Jenkins connection
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "username", username)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[builtins.str]:
        """
        The password of the user or API token obtained from the Jenkins UI (Dashboard > User > Configure > API Token)
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[builtins.str]:
        """
        Base URL of your Jenkins instance (e.g. https://[YOUR*JENKINS*DOMAIN]/)
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[builtins.str]:
        """
        The name of your Jenkins user (e.g. jenkins)
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Jenkins connection
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _JenkinsConnectionState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering JenkinsConnection resources.
        :param pulumi.Input[builtins.str] name: The name of the Jenkins connection
        :param pulumi.Input[builtins.str] password: The password of the user or API token obtained from the Jenkins UI (Dashboard > User > Configure > API Token)
        :param pulumi.Input[builtins.str] url: Base URL of your Jenkins instance (e.g. https://[YOUR*JENKINS*DOMAIN]/)
        :param pulumi.Input[builtins.str] username: The name of your Jenkins user (e.g. jenkins)
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Jenkins connection
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password of the user or API token obtained from the Jenkins UI (Dashboard > User > Configure > API Token)
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base URL of your Jenkins instance (e.g. https://[YOUR*JENKINS*DOMAIN]/)
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of your Jenkins user (e.g. jenkins)
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("dynatrace:index/jenkinsConnection:JenkinsConnection")
class JenkinsConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a JenkinsConnection resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The name of the Jenkins connection
        :param pulumi.Input[builtins.str] password: The password of the user or API token obtained from the Jenkins UI (Dashboard > User > Configure > API Token)
        :param pulumi.Input[builtins.str] url: Base URL of your Jenkins instance (e.g. https://[YOUR*JENKINS*DOMAIN]/)
        :param pulumi.Input[builtins.str] username: The name of your Jenkins user (e.g. jenkins)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JenkinsConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a JenkinsConnection resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param JenkinsConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JenkinsConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JenkinsConnectionArgs.__new__(JenkinsConnectionArgs)

            __props__.__dict__["name"] = name
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(JenkinsConnection, __self__).__init__(
            'dynatrace:index/jenkinsConnection:JenkinsConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            url: Optional[pulumi.Input[builtins.str]] = None,
            username: Optional[pulumi.Input[builtins.str]] = None) -> 'JenkinsConnection':
        """
        Get an existing JenkinsConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The name of the Jenkins connection
        :param pulumi.Input[builtins.str] password: The password of the user or API token obtained from the Jenkins UI (Dashboard > User > Configure > API Token)
        :param pulumi.Input[builtins.str] url: Base URL of your Jenkins instance (e.g. https://[YOUR*JENKINS*DOMAIN]/)
        :param pulumi.Input[builtins.str] username: The name of your Jenkins user (e.g. jenkins)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JenkinsConnectionState.__new__(_JenkinsConnectionState)

        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["url"] = url
        __props__.__dict__["username"] = username
        return JenkinsConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Jenkins connection
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[builtins.str]:
        """
        The password of the user or API token obtained from the Jenkins UI (Dashboard > User > Configure > API Token)
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[builtins.str]:
        """
        Base URL of your Jenkins instance (e.g. https://[YOUR*JENKINS*DOMAIN]/)
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[builtins.str]:
        """
        The name of your Jenkins user (e.g. jenkins)
        """
        return pulumi.get(self, "username")

