# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['LogCustomAttributeArgs', 'LogCustomAttribute']

@pulumi.input_type
class LogCustomAttributeArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[builtins.str],
                 sidebar: pulumi.Input[builtins.bool]):
        """
        The set of arguments for constructing a LogCustomAttribute resource.
        :param pulumi.Input[builtins.str] key: The attribute key is case sensitive in log data ingestion.
        :param pulumi.Input[builtins.bool] sidebar: Show attribute values in side bar
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "sidebar", sidebar)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[builtins.str]:
        """
        The attribute key is case sensitive in log data ingestion.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def sidebar(self) -> pulumi.Input[builtins.bool]:
        """
        Show attribute values in side bar
        """
        return pulumi.get(self, "sidebar")

    @sidebar.setter
    def sidebar(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "sidebar", value)


@pulumi.input_type
class _LogCustomAttributeState:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 sidebar: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering LogCustomAttribute resources.
        :param pulumi.Input[builtins.str] key: The attribute key is case sensitive in log data ingestion.
        :param pulumi.Input[builtins.bool] sidebar: Show attribute values in side bar
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if sidebar is not None:
            pulumi.set(__self__, "sidebar", sidebar)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The attribute key is case sensitive in log data ingestion.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def sidebar(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Show attribute values in side bar
        """
        return pulumi.get(self, "sidebar")

    @sidebar.setter
    def sidebar(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "sidebar", value)


@pulumi.type_token("dynatrace:index/logCustomAttribute:LogCustomAttribute")
class LogCustomAttribute(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 sidebar: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        Create a LogCustomAttribute resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] key: The attribute key is case sensitive in log data ingestion.
        :param pulumi.Input[builtins.bool] sidebar: Show attribute values in side bar
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogCustomAttributeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a LogCustomAttribute resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param LogCustomAttributeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogCustomAttributeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 sidebar: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogCustomAttributeArgs.__new__(LogCustomAttributeArgs)

            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            if sidebar is None and not opts.urn:
                raise TypeError("Missing required property 'sidebar'")
            __props__.__dict__["sidebar"] = sidebar
        super(LogCustomAttribute, __self__).__init__(
            'dynatrace:index/logCustomAttribute:LogCustomAttribute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            key: Optional[pulumi.Input[builtins.str]] = None,
            sidebar: Optional[pulumi.Input[builtins.bool]] = None) -> 'LogCustomAttribute':
        """
        Get an existing LogCustomAttribute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] key: The attribute key is case sensitive in log data ingestion.
        :param pulumi.Input[builtins.bool] sidebar: Show attribute values in side bar
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogCustomAttributeState.__new__(_LogCustomAttributeState)

        __props__.__dict__["key"] = key
        __props__.__dict__["sidebar"] = sidebar
        return LogCustomAttribute(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[builtins.str]:
        """
        The attribute key is case sensitive in log data ingestion.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def sidebar(self) -> pulumi.Output[builtins.bool]:
        """
        Show attribute values in side bar
        """
        return pulumi.get(self, "sidebar")

