# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['LogOneagentArgs', 'LogOneagent']

@pulumi.input_type
class LogOneagentArgs:
    def __init__(__self__, *,
                 container_timezone_heuristic_enabled: pulumi.Input[builtins.bool],
                 containers_logs_detection_enabled: pulumi.Input[builtins.bool],
                 date_search_limit_bytes: pulumi.Input[builtins.int],
                 default_timezone: pulumi.Input[builtins.str],
                 event_log_query_timeout_sec: pulumi.Input[builtins.int],
                 iisdetection_enabled: pulumi.Input[builtins.bool],
                 log_scanner_linux_nfs_enabled: pulumi.Input[builtins.bool],
                 max_lgis_per_entity_count: pulumi.Input[builtins.int],
                 min_binary_detection_limit_bytes: pulumi.Input[builtins.int],
                 monitor_own_logs_enabled: pulumi.Input[builtins.bool],
                 open_log_files_detection_enabled: pulumi.Input[builtins.bool],
                 severity_detection_limit_bytes: pulumi.Input[builtins.int],
                 severity_detection_lines_limit: pulumi.Input[builtins.int],
                 system_logs_detection_enabled: pulumi.Input[builtins.bool],
                 scope: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a LogOneagent resource.
        :param pulumi.Input[builtins.bool] container_timezone_heuristic_enabled: Enables automatic detection of timezone in container's logs if it is not explicitly defined in content or configured.
        :param pulumi.Input[builtins.bool] containers_logs_detection_enabled: Allows detection of log messages written to the containerized application's stdout/stderr streams.
        :param pulumi.Input[builtins.int] date_search_limit_bytes: Defines the number of characters in every log line (starting from the first character in the line) where the timestamp is searched.
        :param pulumi.Input[builtins.str] default_timezone: Default timezone for agent if more specific configurations is not defined.
        :param pulumi.Input[builtins.int] event_log_query_timeout_sec: Defines the maximum timeout value, in seconds, for the query extracting Windows Event Logs
        :param pulumi.Input[builtins.bool] iisdetection_enabled: Allows detection of logs and event logs written by IIS server.
        :param pulumi.Input[builtins.bool] log_scanner_linux_nfs_enabled: Allows detection of logs written to mounted network storage drives. Applies only to Linux hosts. For other OSes it's always enabled.
        :param pulumi.Input[builtins.int] max_lgis_per_entity_count: Defines the maximum number of log group instances per entity after which, the new automatic ones wouldn't be added.
        :param pulumi.Input[builtins.int] min_binary_detection_limit_bytes: Defines the minimum number of bytes in log file required for binary detection.
        :param pulumi.Input[builtins.bool] monitor_own_logs_enabled: Enabling this option may affect your licensing costs. For more details, see [documentation](https://dt-url.net/4l02yi8).
        :param pulumi.Input[builtins.bool] open_log_files_detection_enabled: Automatically detect logs written by important processes. For more details, check our [documentation](https://dt-url.net/7v02z76)
        :param pulumi.Input[builtins.int] severity_detection_limit_bytes: Defines the number of characters in every log line (starting from the first character in the line) where severity is searched.
        :param pulumi.Input[builtins.int] severity_detection_lines_limit: Defines the number of the first lines of every log entry where severity is searched.
        :param pulumi.Input[builtins.bool] system_logs_detection_enabled: Linux: syslog, message log Windows: system, application, security event logs
        :param pulumi.Input[builtins.str] scope: The scope of this setting (HOST, KUBERNETES*CLUSTER, HOST*GROUP). Omit this property if you want to cover the whole environment.
        """
        pulumi.set(__self__, "container_timezone_heuristic_enabled", container_timezone_heuristic_enabled)
        pulumi.set(__self__, "containers_logs_detection_enabled", containers_logs_detection_enabled)
        pulumi.set(__self__, "date_search_limit_bytes", date_search_limit_bytes)
        pulumi.set(__self__, "default_timezone", default_timezone)
        pulumi.set(__self__, "event_log_query_timeout_sec", event_log_query_timeout_sec)
        pulumi.set(__self__, "iisdetection_enabled", iisdetection_enabled)
        pulumi.set(__self__, "log_scanner_linux_nfs_enabled", log_scanner_linux_nfs_enabled)
        pulumi.set(__self__, "max_lgis_per_entity_count", max_lgis_per_entity_count)
        pulumi.set(__self__, "min_binary_detection_limit_bytes", min_binary_detection_limit_bytes)
        pulumi.set(__self__, "monitor_own_logs_enabled", monitor_own_logs_enabled)
        pulumi.set(__self__, "open_log_files_detection_enabled", open_log_files_detection_enabled)
        pulumi.set(__self__, "severity_detection_limit_bytes", severity_detection_limit_bytes)
        pulumi.set(__self__, "severity_detection_lines_limit", severity_detection_lines_limit)
        pulumi.set(__self__, "system_logs_detection_enabled", system_logs_detection_enabled)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="containerTimezoneHeuristicEnabled")
    def container_timezone_heuristic_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Enables automatic detection of timezone in container's logs if it is not explicitly defined in content or configured.
        """
        return pulumi.get(self, "container_timezone_heuristic_enabled")

    @container_timezone_heuristic_enabled.setter
    def container_timezone_heuristic_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "container_timezone_heuristic_enabled", value)

    @property
    @pulumi.getter(name="containersLogsDetectionEnabled")
    def containers_logs_detection_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Allows detection of log messages written to the containerized application's stdout/stderr streams.
        """
        return pulumi.get(self, "containers_logs_detection_enabled")

    @containers_logs_detection_enabled.setter
    def containers_logs_detection_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "containers_logs_detection_enabled", value)

    @property
    @pulumi.getter(name="dateSearchLimitBytes")
    def date_search_limit_bytes(self) -> pulumi.Input[builtins.int]:
        """
        Defines the number of characters in every log line (starting from the first character in the line) where the timestamp is searched.
        """
        return pulumi.get(self, "date_search_limit_bytes")

    @date_search_limit_bytes.setter
    def date_search_limit_bytes(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "date_search_limit_bytes", value)

    @property
    @pulumi.getter(name="defaultTimezone")
    def default_timezone(self) -> pulumi.Input[builtins.str]:
        """
        Default timezone for agent if more specific configurations is not defined.
        """
        return pulumi.get(self, "default_timezone")

    @default_timezone.setter
    def default_timezone(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "default_timezone", value)

    @property
    @pulumi.getter(name="eventLogQueryTimeoutSec")
    def event_log_query_timeout_sec(self) -> pulumi.Input[builtins.int]:
        """
        Defines the maximum timeout value, in seconds, for the query extracting Windows Event Logs
        """
        return pulumi.get(self, "event_log_query_timeout_sec")

    @event_log_query_timeout_sec.setter
    def event_log_query_timeout_sec(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "event_log_query_timeout_sec", value)

    @property
    @pulumi.getter(name="iisdetectionEnabled")
    def iisdetection_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Allows detection of logs and event logs written by IIS server.
        """
        return pulumi.get(self, "iisdetection_enabled")

    @iisdetection_enabled.setter
    def iisdetection_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "iisdetection_enabled", value)

    @property
    @pulumi.getter(name="logScannerLinuxNfsEnabled")
    def log_scanner_linux_nfs_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Allows detection of logs written to mounted network storage drives. Applies only to Linux hosts. For other OSes it's always enabled.
        """
        return pulumi.get(self, "log_scanner_linux_nfs_enabled")

    @log_scanner_linux_nfs_enabled.setter
    def log_scanner_linux_nfs_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "log_scanner_linux_nfs_enabled", value)

    @property
    @pulumi.getter(name="maxLgisPerEntityCount")
    def max_lgis_per_entity_count(self) -> pulumi.Input[builtins.int]:
        """
        Defines the maximum number of log group instances per entity after which, the new automatic ones wouldn't be added.
        """
        return pulumi.get(self, "max_lgis_per_entity_count")

    @max_lgis_per_entity_count.setter
    def max_lgis_per_entity_count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "max_lgis_per_entity_count", value)

    @property
    @pulumi.getter(name="minBinaryDetectionLimitBytes")
    def min_binary_detection_limit_bytes(self) -> pulumi.Input[builtins.int]:
        """
        Defines the minimum number of bytes in log file required for binary detection.
        """
        return pulumi.get(self, "min_binary_detection_limit_bytes")

    @min_binary_detection_limit_bytes.setter
    def min_binary_detection_limit_bytes(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "min_binary_detection_limit_bytes", value)

    @property
    @pulumi.getter(name="monitorOwnLogsEnabled")
    def monitor_own_logs_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Enabling this option may affect your licensing costs. For more details, see [documentation](https://dt-url.net/4l02yi8).
        """
        return pulumi.get(self, "monitor_own_logs_enabled")

    @monitor_own_logs_enabled.setter
    def monitor_own_logs_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "monitor_own_logs_enabled", value)

    @property
    @pulumi.getter(name="openLogFilesDetectionEnabled")
    def open_log_files_detection_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Automatically detect logs written by important processes. For more details, check our [documentation](https://dt-url.net/7v02z76)
        """
        return pulumi.get(self, "open_log_files_detection_enabled")

    @open_log_files_detection_enabled.setter
    def open_log_files_detection_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "open_log_files_detection_enabled", value)

    @property
    @pulumi.getter(name="severityDetectionLimitBytes")
    def severity_detection_limit_bytes(self) -> pulumi.Input[builtins.int]:
        """
        Defines the number of characters in every log line (starting from the first character in the line) where severity is searched.
        """
        return pulumi.get(self, "severity_detection_limit_bytes")

    @severity_detection_limit_bytes.setter
    def severity_detection_limit_bytes(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "severity_detection_limit_bytes", value)

    @property
    @pulumi.getter(name="severityDetectionLinesLimit")
    def severity_detection_lines_limit(self) -> pulumi.Input[builtins.int]:
        """
        Defines the number of the first lines of every log entry where severity is searched.
        """
        return pulumi.get(self, "severity_detection_lines_limit")

    @severity_detection_lines_limit.setter
    def severity_detection_lines_limit(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "severity_detection_lines_limit", value)

    @property
    @pulumi.getter(name="systemLogsDetectionEnabled")
    def system_logs_detection_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Linux: syslog, message log Windows: system, application, security event logs
        """
        return pulumi.get(self, "system_logs_detection_enabled")

    @system_logs_detection_enabled.setter
    def system_logs_detection_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "system_logs_detection_enabled", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of this setting (HOST, KUBERNETES*CLUSTER, HOST*GROUP). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class _LogOneagentState:
    def __init__(__self__, *,
                 container_timezone_heuristic_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 containers_logs_detection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 date_search_limit_bytes: Optional[pulumi.Input[builtins.int]] = None,
                 default_timezone: Optional[pulumi.Input[builtins.str]] = None,
                 event_log_query_timeout_sec: Optional[pulumi.Input[builtins.int]] = None,
                 iisdetection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 log_scanner_linux_nfs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 max_lgis_per_entity_count: Optional[pulumi.Input[builtins.int]] = None,
                 min_binary_detection_limit_bytes: Optional[pulumi.Input[builtins.int]] = None,
                 monitor_own_logs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 open_log_files_detection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 severity_detection_limit_bytes: Optional[pulumi.Input[builtins.int]] = None,
                 severity_detection_lines_limit: Optional[pulumi.Input[builtins.int]] = None,
                 system_logs_detection_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering LogOneagent resources.
        :param pulumi.Input[builtins.bool] container_timezone_heuristic_enabled: Enables automatic detection of timezone in container's logs if it is not explicitly defined in content or configured.
        :param pulumi.Input[builtins.bool] containers_logs_detection_enabled: Allows detection of log messages written to the containerized application's stdout/stderr streams.
        :param pulumi.Input[builtins.int] date_search_limit_bytes: Defines the number of characters in every log line (starting from the first character in the line) where the timestamp is searched.
        :param pulumi.Input[builtins.str] default_timezone: Default timezone for agent if more specific configurations is not defined.
        :param pulumi.Input[builtins.int] event_log_query_timeout_sec: Defines the maximum timeout value, in seconds, for the query extracting Windows Event Logs
        :param pulumi.Input[builtins.bool] iisdetection_enabled: Allows detection of logs and event logs written by IIS server.
        :param pulumi.Input[builtins.bool] log_scanner_linux_nfs_enabled: Allows detection of logs written to mounted network storage drives. Applies only to Linux hosts. For other OSes it's always enabled.
        :param pulumi.Input[builtins.int] max_lgis_per_entity_count: Defines the maximum number of log group instances per entity after which, the new automatic ones wouldn't be added.
        :param pulumi.Input[builtins.int] min_binary_detection_limit_bytes: Defines the minimum number of bytes in log file required for binary detection.
        :param pulumi.Input[builtins.bool] monitor_own_logs_enabled: Enabling this option may affect your licensing costs. For more details, see [documentation](https://dt-url.net/4l02yi8).
        :param pulumi.Input[builtins.bool] open_log_files_detection_enabled: Automatically detect logs written by important processes. For more details, check our [documentation](https://dt-url.net/7v02z76)
        :param pulumi.Input[builtins.str] scope: The scope of this setting (HOST, KUBERNETES*CLUSTER, HOST*GROUP). Omit this property if you want to cover the whole environment.
        :param pulumi.Input[builtins.int] severity_detection_limit_bytes: Defines the number of characters in every log line (starting from the first character in the line) where severity is searched.
        :param pulumi.Input[builtins.int] severity_detection_lines_limit: Defines the number of the first lines of every log entry where severity is searched.
        :param pulumi.Input[builtins.bool] system_logs_detection_enabled: Linux: syslog, message log Windows: system, application, security event logs
        """
        if container_timezone_heuristic_enabled is not None:
            pulumi.set(__self__, "container_timezone_heuristic_enabled", container_timezone_heuristic_enabled)
        if containers_logs_detection_enabled is not None:
            pulumi.set(__self__, "containers_logs_detection_enabled", containers_logs_detection_enabled)
        if date_search_limit_bytes is not None:
            pulumi.set(__self__, "date_search_limit_bytes", date_search_limit_bytes)
        if default_timezone is not None:
            pulumi.set(__self__, "default_timezone", default_timezone)
        if event_log_query_timeout_sec is not None:
            pulumi.set(__self__, "event_log_query_timeout_sec", event_log_query_timeout_sec)
        if iisdetection_enabled is not None:
            pulumi.set(__self__, "iisdetection_enabled", iisdetection_enabled)
        if log_scanner_linux_nfs_enabled is not None:
            pulumi.set(__self__, "log_scanner_linux_nfs_enabled", log_scanner_linux_nfs_enabled)
        if max_lgis_per_entity_count is not None:
            pulumi.set(__self__, "max_lgis_per_entity_count", max_lgis_per_entity_count)
        if min_binary_detection_limit_bytes is not None:
            pulumi.set(__self__, "min_binary_detection_limit_bytes", min_binary_detection_limit_bytes)
        if monitor_own_logs_enabled is not None:
            pulumi.set(__self__, "monitor_own_logs_enabled", monitor_own_logs_enabled)
        if open_log_files_detection_enabled is not None:
            pulumi.set(__self__, "open_log_files_detection_enabled", open_log_files_detection_enabled)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if severity_detection_limit_bytes is not None:
            pulumi.set(__self__, "severity_detection_limit_bytes", severity_detection_limit_bytes)
        if severity_detection_lines_limit is not None:
            pulumi.set(__self__, "severity_detection_lines_limit", severity_detection_lines_limit)
        if system_logs_detection_enabled is not None:
            pulumi.set(__self__, "system_logs_detection_enabled", system_logs_detection_enabled)

    @property
    @pulumi.getter(name="containerTimezoneHeuristicEnabled")
    def container_timezone_heuristic_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables automatic detection of timezone in container's logs if it is not explicitly defined in content or configured.
        """
        return pulumi.get(self, "container_timezone_heuristic_enabled")

    @container_timezone_heuristic_enabled.setter
    def container_timezone_heuristic_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "container_timezone_heuristic_enabled", value)

    @property
    @pulumi.getter(name="containersLogsDetectionEnabled")
    def containers_logs_detection_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allows detection of log messages written to the containerized application's stdout/stderr streams.
        """
        return pulumi.get(self, "containers_logs_detection_enabled")

    @containers_logs_detection_enabled.setter
    def containers_logs_detection_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "containers_logs_detection_enabled", value)

    @property
    @pulumi.getter(name="dateSearchLimitBytes")
    def date_search_limit_bytes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Defines the number of characters in every log line (starting from the first character in the line) where the timestamp is searched.
        """
        return pulumi.get(self, "date_search_limit_bytes")

    @date_search_limit_bytes.setter
    def date_search_limit_bytes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "date_search_limit_bytes", value)

    @property
    @pulumi.getter(name="defaultTimezone")
    def default_timezone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Default timezone for agent if more specific configurations is not defined.
        """
        return pulumi.get(self, "default_timezone")

    @default_timezone.setter
    def default_timezone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_timezone", value)

    @property
    @pulumi.getter(name="eventLogQueryTimeoutSec")
    def event_log_query_timeout_sec(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Defines the maximum timeout value, in seconds, for the query extracting Windows Event Logs
        """
        return pulumi.get(self, "event_log_query_timeout_sec")

    @event_log_query_timeout_sec.setter
    def event_log_query_timeout_sec(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "event_log_query_timeout_sec", value)

    @property
    @pulumi.getter(name="iisdetectionEnabled")
    def iisdetection_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allows detection of logs and event logs written by IIS server.
        """
        return pulumi.get(self, "iisdetection_enabled")

    @iisdetection_enabled.setter
    def iisdetection_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "iisdetection_enabled", value)

    @property
    @pulumi.getter(name="logScannerLinuxNfsEnabled")
    def log_scanner_linux_nfs_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allows detection of logs written to mounted network storage drives. Applies only to Linux hosts. For other OSes it's always enabled.
        """
        return pulumi.get(self, "log_scanner_linux_nfs_enabled")

    @log_scanner_linux_nfs_enabled.setter
    def log_scanner_linux_nfs_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "log_scanner_linux_nfs_enabled", value)

    @property
    @pulumi.getter(name="maxLgisPerEntityCount")
    def max_lgis_per_entity_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Defines the maximum number of log group instances per entity after which, the new automatic ones wouldn't be added.
        """
        return pulumi.get(self, "max_lgis_per_entity_count")

    @max_lgis_per_entity_count.setter
    def max_lgis_per_entity_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_lgis_per_entity_count", value)

    @property
    @pulumi.getter(name="minBinaryDetectionLimitBytes")
    def min_binary_detection_limit_bytes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Defines the minimum number of bytes in log file required for binary detection.
        """
        return pulumi.get(self, "min_binary_detection_limit_bytes")

    @min_binary_detection_limit_bytes.setter
    def min_binary_detection_limit_bytes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_binary_detection_limit_bytes", value)

    @property
    @pulumi.getter(name="monitorOwnLogsEnabled")
    def monitor_own_logs_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enabling this option may affect your licensing costs. For more details, see [documentation](https://dt-url.net/4l02yi8).
        """
        return pulumi.get(self, "monitor_own_logs_enabled")

    @monitor_own_logs_enabled.setter
    def monitor_own_logs_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "monitor_own_logs_enabled", value)

    @property
    @pulumi.getter(name="openLogFilesDetectionEnabled")
    def open_log_files_detection_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Automatically detect logs written by important processes. For more details, check our [documentation](https://dt-url.net/7v02z76)
        """
        return pulumi.get(self, "open_log_files_detection_enabled")

    @open_log_files_detection_enabled.setter
    def open_log_files_detection_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "open_log_files_detection_enabled", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of this setting (HOST, KUBERNETES*CLUSTER, HOST*GROUP). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="severityDetectionLimitBytes")
    def severity_detection_limit_bytes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Defines the number of characters in every log line (starting from the first character in the line) where severity is searched.
        """
        return pulumi.get(self, "severity_detection_limit_bytes")

    @severity_detection_limit_bytes.setter
    def severity_detection_limit_bytes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "severity_detection_limit_bytes", value)

    @property
    @pulumi.getter(name="severityDetectionLinesLimit")
    def severity_detection_lines_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Defines the number of the first lines of every log entry where severity is searched.
        """
        return pulumi.get(self, "severity_detection_lines_limit")

    @severity_detection_lines_limit.setter
    def severity_detection_lines_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "severity_detection_lines_limit", value)

    @property
    @pulumi.getter(name="systemLogsDetectionEnabled")
    def system_logs_detection_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Linux: syslog, message log Windows: system, application, security event logs
        """
        return pulumi.get(self, "system_logs_detection_enabled")

    @system_logs_detection_enabled.setter
    def system_logs_detection_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "system_logs_detection_enabled", value)


@pulumi.type_token("dynatrace:index/logOneagent:LogOneagent")
class LogOneagent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container_timezone_heuristic_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 containers_logs_detection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 date_search_limit_bytes: Optional[pulumi.Input[builtins.int]] = None,
                 default_timezone: Optional[pulumi.Input[builtins.str]] = None,
                 event_log_query_timeout_sec: Optional[pulumi.Input[builtins.int]] = None,
                 iisdetection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 log_scanner_linux_nfs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 max_lgis_per_entity_count: Optional[pulumi.Input[builtins.int]] = None,
                 min_binary_detection_limit_bytes: Optional[pulumi.Input[builtins.int]] = None,
                 monitor_own_logs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 open_log_files_detection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 severity_detection_limit_bytes: Optional[pulumi.Input[builtins.int]] = None,
                 severity_detection_lines_limit: Optional[pulumi.Input[builtins.int]] = None,
                 system_logs_detection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        Create a LogOneagent resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] container_timezone_heuristic_enabled: Enables automatic detection of timezone in container's logs if it is not explicitly defined in content or configured.
        :param pulumi.Input[builtins.bool] containers_logs_detection_enabled: Allows detection of log messages written to the containerized application's stdout/stderr streams.
        :param pulumi.Input[builtins.int] date_search_limit_bytes: Defines the number of characters in every log line (starting from the first character in the line) where the timestamp is searched.
        :param pulumi.Input[builtins.str] default_timezone: Default timezone for agent if more specific configurations is not defined.
        :param pulumi.Input[builtins.int] event_log_query_timeout_sec: Defines the maximum timeout value, in seconds, for the query extracting Windows Event Logs
        :param pulumi.Input[builtins.bool] iisdetection_enabled: Allows detection of logs and event logs written by IIS server.
        :param pulumi.Input[builtins.bool] log_scanner_linux_nfs_enabled: Allows detection of logs written to mounted network storage drives. Applies only to Linux hosts. For other OSes it's always enabled.
        :param pulumi.Input[builtins.int] max_lgis_per_entity_count: Defines the maximum number of log group instances per entity after which, the new automatic ones wouldn't be added.
        :param pulumi.Input[builtins.int] min_binary_detection_limit_bytes: Defines the minimum number of bytes in log file required for binary detection.
        :param pulumi.Input[builtins.bool] monitor_own_logs_enabled: Enabling this option may affect your licensing costs. For more details, see [documentation](https://dt-url.net/4l02yi8).
        :param pulumi.Input[builtins.bool] open_log_files_detection_enabled: Automatically detect logs written by important processes. For more details, check our [documentation](https://dt-url.net/7v02z76)
        :param pulumi.Input[builtins.str] scope: The scope of this setting (HOST, KUBERNETES*CLUSTER, HOST*GROUP). Omit this property if you want to cover the whole environment.
        :param pulumi.Input[builtins.int] severity_detection_limit_bytes: Defines the number of characters in every log line (starting from the first character in the line) where severity is searched.
        :param pulumi.Input[builtins.int] severity_detection_lines_limit: Defines the number of the first lines of every log entry where severity is searched.
        :param pulumi.Input[builtins.bool] system_logs_detection_enabled: Linux: syslog, message log Windows: system, application, security event logs
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogOneagentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a LogOneagent resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param LogOneagentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogOneagentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container_timezone_heuristic_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 containers_logs_detection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 date_search_limit_bytes: Optional[pulumi.Input[builtins.int]] = None,
                 default_timezone: Optional[pulumi.Input[builtins.str]] = None,
                 event_log_query_timeout_sec: Optional[pulumi.Input[builtins.int]] = None,
                 iisdetection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 log_scanner_linux_nfs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 max_lgis_per_entity_count: Optional[pulumi.Input[builtins.int]] = None,
                 min_binary_detection_limit_bytes: Optional[pulumi.Input[builtins.int]] = None,
                 monitor_own_logs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 open_log_files_detection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 severity_detection_limit_bytes: Optional[pulumi.Input[builtins.int]] = None,
                 severity_detection_lines_limit: Optional[pulumi.Input[builtins.int]] = None,
                 system_logs_detection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogOneagentArgs.__new__(LogOneagentArgs)

            if container_timezone_heuristic_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'container_timezone_heuristic_enabled'")
            __props__.__dict__["container_timezone_heuristic_enabled"] = container_timezone_heuristic_enabled
            if containers_logs_detection_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'containers_logs_detection_enabled'")
            __props__.__dict__["containers_logs_detection_enabled"] = containers_logs_detection_enabled
            if date_search_limit_bytes is None and not opts.urn:
                raise TypeError("Missing required property 'date_search_limit_bytes'")
            __props__.__dict__["date_search_limit_bytes"] = date_search_limit_bytes
            if default_timezone is None and not opts.urn:
                raise TypeError("Missing required property 'default_timezone'")
            __props__.__dict__["default_timezone"] = default_timezone
            if event_log_query_timeout_sec is None and not opts.urn:
                raise TypeError("Missing required property 'event_log_query_timeout_sec'")
            __props__.__dict__["event_log_query_timeout_sec"] = event_log_query_timeout_sec
            if iisdetection_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'iisdetection_enabled'")
            __props__.__dict__["iisdetection_enabled"] = iisdetection_enabled
            if log_scanner_linux_nfs_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'log_scanner_linux_nfs_enabled'")
            __props__.__dict__["log_scanner_linux_nfs_enabled"] = log_scanner_linux_nfs_enabled
            if max_lgis_per_entity_count is None and not opts.urn:
                raise TypeError("Missing required property 'max_lgis_per_entity_count'")
            __props__.__dict__["max_lgis_per_entity_count"] = max_lgis_per_entity_count
            if min_binary_detection_limit_bytes is None and not opts.urn:
                raise TypeError("Missing required property 'min_binary_detection_limit_bytes'")
            __props__.__dict__["min_binary_detection_limit_bytes"] = min_binary_detection_limit_bytes
            if monitor_own_logs_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'monitor_own_logs_enabled'")
            __props__.__dict__["monitor_own_logs_enabled"] = monitor_own_logs_enabled
            if open_log_files_detection_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'open_log_files_detection_enabled'")
            __props__.__dict__["open_log_files_detection_enabled"] = open_log_files_detection_enabled
            __props__.__dict__["scope"] = scope
            if severity_detection_limit_bytes is None and not opts.urn:
                raise TypeError("Missing required property 'severity_detection_limit_bytes'")
            __props__.__dict__["severity_detection_limit_bytes"] = severity_detection_limit_bytes
            if severity_detection_lines_limit is None and not opts.urn:
                raise TypeError("Missing required property 'severity_detection_lines_limit'")
            __props__.__dict__["severity_detection_lines_limit"] = severity_detection_lines_limit
            if system_logs_detection_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'system_logs_detection_enabled'")
            __props__.__dict__["system_logs_detection_enabled"] = system_logs_detection_enabled
        super(LogOneagent, __self__).__init__(
            'dynatrace:index/logOneagent:LogOneagent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            container_timezone_heuristic_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            containers_logs_detection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            date_search_limit_bytes: Optional[pulumi.Input[builtins.int]] = None,
            default_timezone: Optional[pulumi.Input[builtins.str]] = None,
            event_log_query_timeout_sec: Optional[pulumi.Input[builtins.int]] = None,
            iisdetection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            log_scanner_linux_nfs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            max_lgis_per_entity_count: Optional[pulumi.Input[builtins.int]] = None,
            min_binary_detection_limit_bytes: Optional[pulumi.Input[builtins.int]] = None,
            monitor_own_logs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            open_log_files_detection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            scope: Optional[pulumi.Input[builtins.str]] = None,
            severity_detection_limit_bytes: Optional[pulumi.Input[builtins.int]] = None,
            severity_detection_lines_limit: Optional[pulumi.Input[builtins.int]] = None,
            system_logs_detection_enabled: Optional[pulumi.Input[builtins.bool]] = None) -> 'LogOneagent':
        """
        Get an existing LogOneagent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] container_timezone_heuristic_enabled: Enables automatic detection of timezone in container's logs if it is not explicitly defined in content or configured.
        :param pulumi.Input[builtins.bool] containers_logs_detection_enabled: Allows detection of log messages written to the containerized application's stdout/stderr streams.
        :param pulumi.Input[builtins.int] date_search_limit_bytes: Defines the number of characters in every log line (starting from the first character in the line) where the timestamp is searched.
        :param pulumi.Input[builtins.str] default_timezone: Default timezone for agent if more specific configurations is not defined.
        :param pulumi.Input[builtins.int] event_log_query_timeout_sec: Defines the maximum timeout value, in seconds, for the query extracting Windows Event Logs
        :param pulumi.Input[builtins.bool] iisdetection_enabled: Allows detection of logs and event logs written by IIS server.
        :param pulumi.Input[builtins.bool] log_scanner_linux_nfs_enabled: Allows detection of logs written to mounted network storage drives. Applies only to Linux hosts. For other OSes it's always enabled.
        :param pulumi.Input[builtins.int] max_lgis_per_entity_count: Defines the maximum number of log group instances per entity after which, the new automatic ones wouldn't be added.
        :param pulumi.Input[builtins.int] min_binary_detection_limit_bytes: Defines the minimum number of bytes in log file required for binary detection.
        :param pulumi.Input[builtins.bool] monitor_own_logs_enabled: Enabling this option may affect your licensing costs. For more details, see [documentation](https://dt-url.net/4l02yi8).
        :param pulumi.Input[builtins.bool] open_log_files_detection_enabled: Automatically detect logs written by important processes. For more details, check our [documentation](https://dt-url.net/7v02z76)
        :param pulumi.Input[builtins.str] scope: The scope of this setting (HOST, KUBERNETES*CLUSTER, HOST*GROUP). Omit this property if you want to cover the whole environment.
        :param pulumi.Input[builtins.int] severity_detection_limit_bytes: Defines the number of characters in every log line (starting from the first character in the line) where severity is searched.
        :param pulumi.Input[builtins.int] severity_detection_lines_limit: Defines the number of the first lines of every log entry where severity is searched.
        :param pulumi.Input[builtins.bool] system_logs_detection_enabled: Linux: syslog, message log Windows: system, application, security event logs
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogOneagentState.__new__(_LogOneagentState)

        __props__.__dict__["container_timezone_heuristic_enabled"] = container_timezone_heuristic_enabled
        __props__.__dict__["containers_logs_detection_enabled"] = containers_logs_detection_enabled
        __props__.__dict__["date_search_limit_bytes"] = date_search_limit_bytes
        __props__.__dict__["default_timezone"] = default_timezone
        __props__.__dict__["event_log_query_timeout_sec"] = event_log_query_timeout_sec
        __props__.__dict__["iisdetection_enabled"] = iisdetection_enabled
        __props__.__dict__["log_scanner_linux_nfs_enabled"] = log_scanner_linux_nfs_enabled
        __props__.__dict__["max_lgis_per_entity_count"] = max_lgis_per_entity_count
        __props__.__dict__["min_binary_detection_limit_bytes"] = min_binary_detection_limit_bytes
        __props__.__dict__["monitor_own_logs_enabled"] = monitor_own_logs_enabled
        __props__.__dict__["open_log_files_detection_enabled"] = open_log_files_detection_enabled
        __props__.__dict__["scope"] = scope
        __props__.__dict__["severity_detection_limit_bytes"] = severity_detection_limit_bytes
        __props__.__dict__["severity_detection_lines_limit"] = severity_detection_lines_limit
        __props__.__dict__["system_logs_detection_enabled"] = system_logs_detection_enabled
        return LogOneagent(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="containerTimezoneHeuristicEnabled")
    def container_timezone_heuristic_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Enables automatic detection of timezone in container's logs if it is not explicitly defined in content or configured.
        """
        return pulumi.get(self, "container_timezone_heuristic_enabled")

    @property
    @pulumi.getter(name="containersLogsDetectionEnabled")
    def containers_logs_detection_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Allows detection of log messages written to the containerized application's stdout/stderr streams.
        """
        return pulumi.get(self, "containers_logs_detection_enabled")

    @property
    @pulumi.getter(name="dateSearchLimitBytes")
    def date_search_limit_bytes(self) -> pulumi.Output[builtins.int]:
        """
        Defines the number of characters in every log line (starting from the first character in the line) where the timestamp is searched.
        """
        return pulumi.get(self, "date_search_limit_bytes")

    @property
    @pulumi.getter(name="defaultTimezone")
    def default_timezone(self) -> pulumi.Output[builtins.str]:
        """
        Default timezone for agent if more specific configurations is not defined.
        """
        return pulumi.get(self, "default_timezone")

    @property
    @pulumi.getter(name="eventLogQueryTimeoutSec")
    def event_log_query_timeout_sec(self) -> pulumi.Output[builtins.int]:
        """
        Defines the maximum timeout value, in seconds, for the query extracting Windows Event Logs
        """
        return pulumi.get(self, "event_log_query_timeout_sec")

    @property
    @pulumi.getter(name="iisdetectionEnabled")
    def iisdetection_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Allows detection of logs and event logs written by IIS server.
        """
        return pulumi.get(self, "iisdetection_enabled")

    @property
    @pulumi.getter(name="logScannerLinuxNfsEnabled")
    def log_scanner_linux_nfs_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Allows detection of logs written to mounted network storage drives. Applies only to Linux hosts. For other OSes it's always enabled.
        """
        return pulumi.get(self, "log_scanner_linux_nfs_enabled")

    @property
    @pulumi.getter(name="maxLgisPerEntityCount")
    def max_lgis_per_entity_count(self) -> pulumi.Output[builtins.int]:
        """
        Defines the maximum number of log group instances per entity after which, the new automatic ones wouldn't be added.
        """
        return pulumi.get(self, "max_lgis_per_entity_count")

    @property
    @pulumi.getter(name="minBinaryDetectionLimitBytes")
    def min_binary_detection_limit_bytes(self) -> pulumi.Output[builtins.int]:
        """
        Defines the minimum number of bytes in log file required for binary detection.
        """
        return pulumi.get(self, "min_binary_detection_limit_bytes")

    @property
    @pulumi.getter(name="monitorOwnLogsEnabled")
    def monitor_own_logs_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Enabling this option may affect your licensing costs. For more details, see [documentation](https://dt-url.net/4l02yi8).
        """
        return pulumi.get(self, "monitor_own_logs_enabled")

    @property
    @pulumi.getter(name="openLogFilesDetectionEnabled")
    def open_log_files_detection_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Automatically detect logs written by important processes. For more details, check our [documentation](https://dt-url.net/7v02z76)
        """
        return pulumi.get(self, "open_log_files_detection_enabled")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The scope of this setting (HOST, KUBERNETES*CLUSTER, HOST*GROUP). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="severityDetectionLimitBytes")
    def severity_detection_limit_bytes(self) -> pulumi.Output[builtins.int]:
        """
        Defines the number of characters in every log line (starting from the first character in the line) where severity is searched.
        """
        return pulumi.get(self, "severity_detection_limit_bytes")

    @property
    @pulumi.getter(name="severityDetectionLinesLimit")
    def severity_detection_lines_limit(self) -> pulumi.Output[builtins.int]:
        """
        Defines the number of the first lines of every log entry where severity is searched.
        """
        return pulumi.get(self, "severity_detection_lines_limit")

    @property
    @pulumi.getter(name="systemLogsDetectionEnabled")
    def system_logs_detection_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Linux: syslog, message log Windows: system, application, security event logs
        """
        return pulumi.get(self, "system_logs_detection_enabled")

