# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['MainframeTransactionMonitoringArgs', 'MainframeTransactionMonitoring']

@pulumi.input_type
class MainframeTransactionMonitoringArgs:
    def __init__(__self__, *,
                 group_cics_regions: pulumi.Input[builtins.bool],
                 group_ims_regions: pulumi.Input[builtins.bool],
                 monitor_all_ctg_protocols: pulumi.Input[builtins.bool],
                 monitor_all_incoming_web_requests: pulumi.Input[builtins.bool],
                 node_limit: pulumi.Input[builtins.int],
                 zos_cics_service_detection_uses_transaction_id: pulumi.Input[builtins.bool],
                 zos_ims_service_detection_uses_transaction_id: pulumi.Input[builtins.bool]):
        """
        The set of arguments for constructing a MainframeTransactionMonitoring resource.
        :param pulumi.Input[builtins.bool] group_cics_regions: If enabled, CICS regions belonging to the same CICSPlex will be grouped into a single process group. If disabled, a process group will be created for each CICS region.
        :param pulumi.Input[builtins.bool] group_ims_regions: If enabled, IMS regions belonging to the same subsystem will be grouped into a single process group. If disabled, a process group will be created for each IMS region.
        :param pulumi.Input[builtins.bool] monitor_all_ctg_protocols: If enabled, the CICS Transaction Gateway sensor will trace all EXCI requests including those that are using the TCP/IP or SNA protocol.
        :param pulumi.Input[builtins.bool] monitor_all_incoming_web_requests: Dynatrace automatically traces incoming web requests when they are called by already-monitored services. Enable this setting to monitor all incoming web requests. We recommend enabling it only over a short period of time.
        :param pulumi.Input[builtins.int] node_limit: We recommend the default limit of 500 nodes. The value 0 means unlimited number of nodes.
        :param pulumi.Input[builtins.bool] zos_cics_service_detection_uses_transaction_id: If enabled, a CICS service will be created for each monitored transaction ID within a process group. If disabled, a CICS service will be created for each monitored CICS region within a process group. We recommend enabling it only when the CICS regions are grouped by their CICSPlex.
        :param pulumi.Input[builtins.bool] zos_ims_service_detection_uses_transaction_id: If enabled, an IMS service will be created for each monitored transaction ID within a process group. If disabled, an IMS service will be created for each monitored IMS region within a process group. We recommend enabling it only when the IMS regions are grouped by their subsystem.
        """
        pulumi.set(__self__, "group_cics_regions", group_cics_regions)
        pulumi.set(__self__, "group_ims_regions", group_ims_regions)
        pulumi.set(__self__, "monitor_all_ctg_protocols", monitor_all_ctg_protocols)
        pulumi.set(__self__, "monitor_all_incoming_web_requests", monitor_all_incoming_web_requests)
        pulumi.set(__self__, "node_limit", node_limit)
        pulumi.set(__self__, "zos_cics_service_detection_uses_transaction_id", zos_cics_service_detection_uses_transaction_id)
        pulumi.set(__self__, "zos_ims_service_detection_uses_transaction_id", zos_ims_service_detection_uses_transaction_id)

    @property
    @pulumi.getter(name="groupCicsRegions")
    def group_cics_regions(self) -> pulumi.Input[builtins.bool]:
        """
        If enabled, CICS regions belonging to the same CICSPlex will be grouped into a single process group. If disabled, a process group will be created for each CICS region.
        """
        return pulumi.get(self, "group_cics_regions")

    @group_cics_regions.setter
    def group_cics_regions(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "group_cics_regions", value)

    @property
    @pulumi.getter(name="groupImsRegions")
    def group_ims_regions(self) -> pulumi.Input[builtins.bool]:
        """
        If enabled, IMS regions belonging to the same subsystem will be grouped into a single process group. If disabled, a process group will be created for each IMS region.
        """
        return pulumi.get(self, "group_ims_regions")

    @group_ims_regions.setter
    def group_ims_regions(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "group_ims_regions", value)

    @property
    @pulumi.getter(name="monitorAllCtgProtocols")
    def monitor_all_ctg_protocols(self) -> pulumi.Input[builtins.bool]:
        """
        If enabled, the CICS Transaction Gateway sensor will trace all EXCI requests including those that are using the TCP/IP or SNA protocol.
        """
        return pulumi.get(self, "monitor_all_ctg_protocols")

    @monitor_all_ctg_protocols.setter
    def monitor_all_ctg_protocols(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "monitor_all_ctg_protocols", value)

    @property
    @pulumi.getter(name="monitorAllIncomingWebRequests")
    def monitor_all_incoming_web_requests(self) -> pulumi.Input[builtins.bool]:
        """
        Dynatrace automatically traces incoming web requests when they are called by already-monitored services. Enable this setting to monitor all incoming web requests. We recommend enabling it only over a short period of time.
        """
        return pulumi.get(self, "monitor_all_incoming_web_requests")

    @monitor_all_incoming_web_requests.setter
    def monitor_all_incoming_web_requests(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "monitor_all_incoming_web_requests", value)

    @property
    @pulumi.getter(name="nodeLimit")
    def node_limit(self) -> pulumi.Input[builtins.int]:
        """
        We recommend the default limit of 500 nodes. The value 0 means unlimited number of nodes.
        """
        return pulumi.get(self, "node_limit")

    @node_limit.setter
    def node_limit(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "node_limit", value)

    @property
    @pulumi.getter(name="zosCicsServiceDetectionUsesTransactionId")
    def zos_cics_service_detection_uses_transaction_id(self) -> pulumi.Input[builtins.bool]:
        """
        If enabled, a CICS service will be created for each monitored transaction ID within a process group. If disabled, a CICS service will be created for each monitored CICS region within a process group. We recommend enabling it only when the CICS regions are grouped by their CICSPlex.
        """
        return pulumi.get(self, "zos_cics_service_detection_uses_transaction_id")

    @zos_cics_service_detection_uses_transaction_id.setter
    def zos_cics_service_detection_uses_transaction_id(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "zos_cics_service_detection_uses_transaction_id", value)

    @property
    @pulumi.getter(name="zosImsServiceDetectionUsesTransactionId")
    def zos_ims_service_detection_uses_transaction_id(self) -> pulumi.Input[builtins.bool]:
        """
        If enabled, an IMS service will be created for each monitored transaction ID within a process group. If disabled, an IMS service will be created for each monitored IMS region within a process group. We recommend enabling it only when the IMS regions are grouped by their subsystem.
        """
        return pulumi.get(self, "zos_ims_service_detection_uses_transaction_id")

    @zos_ims_service_detection_uses_transaction_id.setter
    def zos_ims_service_detection_uses_transaction_id(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "zos_ims_service_detection_uses_transaction_id", value)


@pulumi.input_type
class _MainframeTransactionMonitoringState:
    def __init__(__self__, *,
                 group_cics_regions: Optional[pulumi.Input[builtins.bool]] = None,
                 group_ims_regions: Optional[pulumi.Input[builtins.bool]] = None,
                 monitor_all_ctg_protocols: Optional[pulumi.Input[builtins.bool]] = None,
                 monitor_all_incoming_web_requests: Optional[pulumi.Input[builtins.bool]] = None,
                 node_limit: Optional[pulumi.Input[builtins.int]] = None,
                 zos_cics_service_detection_uses_transaction_id: Optional[pulumi.Input[builtins.bool]] = None,
                 zos_ims_service_detection_uses_transaction_id: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering MainframeTransactionMonitoring resources.
        :param pulumi.Input[builtins.bool] group_cics_regions: If enabled, CICS regions belonging to the same CICSPlex will be grouped into a single process group. If disabled, a process group will be created for each CICS region.
        :param pulumi.Input[builtins.bool] group_ims_regions: If enabled, IMS regions belonging to the same subsystem will be grouped into a single process group. If disabled, a process group will be created for each IMS region.
        :param pulumi.Input[builtins.bool] monitor_all_ctg_protocols: If enabled, the CICS Transaction Gateway sensor will trace all EXCI requests including those that are using the TCP/IP or SNA protocol.
        :param pulumi.Input[builtins.bool] monitor_all_incoming_web_requests: Dynatrace automatically traces incoming web requests when they are called by already-monitored services. Enable this setting to monitor all incoming web requests. We recommend enabling it only over a short period of time.
        :param pulumi.Input[builtins.int] node_limit: We recommend the default limit of 500 nodes. The value 0 means unlimited number of nodes.
        :param pulumi.Input[builtins.bool] zos_cics_service_detection_uses_transaction_id: If enabled, a CICS service will be created for each monitored transaction ID within a process group. If disabled, a CICS service will be created for each monitored CICS region within a process group. We recommend enabling it only when the CICS regions are grouped by their CICSPlex.
        :param pulumi.Input[builtins.bool] zos_ims_service_detection_uses_transaction_id: If enabled, an IMS service will be created for each monitored transaction ID within a process group. If disabled, an IMS service will be created for each monitored IMS region within a process group. We recommend enabling it only when the IMS regions are grouped by their subsystem.
        """
        if group_cics_regions is not None:
            pulumi.set(__self__, "group_cics_regions", group_cics_regions)
        if group_ims_regions is not None:
            pulumi.set(__self__, "group_ims_regions", group_ims_regions)
        if monitor_all_ctg_protocols is not None:
            pulumi.set(__self__, "monitor_all_ctg_protocols", monitor_all_ctg_protocols)
        if monitor_all_incoming_web_requests is not None:
            pulumi.set(__self__, "monitor_all_incoming_web_requests", monitor_all_incoming_web_requests)
        if node_limit is not None:
            pulumi.set(__self__, "node_limit", node_limit)
        if zos_cics_service_detection_uses_transaction_id is not None:
            pulumi.set(__self__, "zos_cics_service_detection_uses_transaction_id", zos_cics_service_detection_uses_transaction_id)
        if zos_ims_service_detection_uses_transaction_id is not None:
            pulumi.set(__self__, "zos_ims_service_detection_uses_transaction_id", zos_ims_service_detection_uses_transaction_id)

    @property
    @pulumi.getter(name="groupCicsRegions")
    def group_cics_regions(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If enabled, CICS regions belonging to the same CICSPlex will be grouped into a single process group. If disabled, a process group will be created for each CICS region.
        """
        return pulumi.get(self, "group_cics_regions")

    @group_cics_regions.setter
    def group_cics_regions(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "group_cics_regions", value)

    @property
    @pulumi.getter(name="groupImsRegions")
    def group_ims_regions(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If enabled, IMS regions belonging to the same subsystem will be grouped into a single process group. If disabled, a process group will be created for each IMS region.
        """
        return pulumi.get(self, "group_ims_regions")

    @group_ims_regions.setter
    def group_ims_regions(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "group_ims_regions", value)

    @property
    @pulumi.getter(name="monitorAllCtgProtocols")
    def monitor_all_ctg_protocols(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If enabled, the CICS Transaction Gateway sensor will trace all EXCI requests including those that are using the TCP/IP or SNA protocol.
        """
        return pulumi.get(self, "monitor_all_ctg_protocols")

    @monitor_all_ctg_protocols.setter
    def monitor_all_ctg_protocols(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "monitor_all_ctg_protocols", value)

    @property
    @pulumi.getter(name="monitorAllIncomingWebRequests")
    def monitor_all_incoming_web_requests(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Dynatrace automatically traces incoming web requests when they are called by already-monitored services. Enable this setting to monitor all incoming web requests. We recommend enabling it only over a short period of time.
        """
        return pulumi.get(self, "monitor_all_incoming_web_requests")

    @monitor_all_incoming_web_requests.setter
    def monitor_all_incoming_web_requests(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "monitor_all_incoming_web_requests", value)

    @property
    @pulumi.getter(name="nodeLimit")
    def node_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        We recommend the default limit of 500 nodes. The value 0 means unlimited number of nodes.
        """
        return pulumi.get(self, "node_limit")

    @node_limit.setter
    def node_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "node_limit", value)

    @property
    @pulumi.getter(name="zosCicsServiceDetectionUsesTransactionId")
    def zos_cics_service_detection_uses_transaction_id(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If enabled, a CICS service will be created for each monitored transaction ID within a process group. If disabled, a CICS service will be created for each monitored CICS region within a process group. We recommend enabling it only when the CICS regions are grouped by their CICSPlex.
        """
        return pulumi.get(self, "zos_cics_service_detection_uses_transaction_id")

    @zos_cics_service_detection_uses_transaction_id.setter
    def zos_cics_service_detection_uses_transaction_id(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "zos_cics_service_detection_uses_transaction_id", value)

    @property
    @pulumi.getter(name="zosImsServiceDetectionUsesTransactionId")
    def zos_ims_service_detection_uses_transaction_id(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If enabled, an IMS service will be created for each monitored transaction ID within a process group. If disabled, an IMS service will be created for each monitored IMS region within a process group. We recommend enabling it only when the IMS regions are grouped by their subsystem.
        """
        return pulumi.get(self, "zos_ims_service_detection_uses_transaction_id")

    @zos_ims_service_detection_uses_transaction_id.setter
    def zos_ims_service_detection_uses_transaction_id(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "zos_ims_service_detection_uses_transaction_id", value)


@pulumi.type_token("dynatrace:index/mainframeTransactionMonitoring:MainframeTransactionMonitoring")
class MainframeTransactionMonitoring(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_cics_regions: Optional[pulumi.Input[builtins.bool]] = None,
                 group_ims_regions: Optional[pulumi.Input[builtins.bool]] = None,
                 monitor_all_ctg_protocols: Optional[pulumi.Input[builtins.bool]] = None,
                 monitor_all_incoming_web_requests: Optional[pulumi.Input[builtins.bool]] = None,
                 node_limit: Optional[pulumi.Input[builtins.int]] = None,
                 zos_cics_service_detection_uses_transaction_id: Optional[pulumi.Input[builtins.bool]] = None,
                 zos_ims_service_detection_uses_transaction_id: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        Create a MainframeTransactionMonitoring resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] group_cics_regions: If enabled, CICS regions belonging to the same CICSPlex will be grouped into a single process group. If disabled, a process group will be created for each CICS region.
        :param pulumi.Input[builtins.bool] group_ims_regions: If enabled, IMS regions belonging to the same subsystem will be grouped into a single process group. If disabled, a process group will be created for each IMS region.
        :param pulumi.Input[builtins.bool] monitor_all_ctg_protocols: If enabled, the CICS Transaction Gateway sensor will trace all EXCI requests including those that are using the TCP/IP or SNA protocol.
        :param pulumi.Input[builtins.bool] monitor_all_incoming_web_requests: Dynatrace automatically traces incoming web requests when they are called by already-monitored services. Enable this setting to monitor all incoming web requests. We recommend enabling it only over a short period of time.
        :param pulumi.Input[builtins.int] node_limit: We recommend the default limit of 500 nodes. The value 0 means unlimited number of nodes.
        :param pulumi.Input[builtins.bool] zos_cics_service_detection_uses_transaction_id: If enabled, a CICS service will be created for each monitored transaction ID within a process group. If disabled, a CICS service will be created for each monitored CICS region within a process group. We recommend enabling it only when the CICS regions are grouped by their CICSPlex.
        :param pulumi.Input[builtins.bool] zos_ims_service_detection_uses_transaction_id: If enabled, an IMS service will be created for each monitored transaction ID within a process group. If disabled, an IMS service will be created for each monitored IMS region within a process group. We recommend enabling it only when the IMS regions are grouped by their subsystem.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MainframeTransactionMonitoringArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a MainframeTransactionMonitoring resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param MainframeTransactionMonitoringArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MainframeTransactionMonitoringArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_cics_regions: Optional[pulumi.Input[builtins.bool]] = None,
                 group_ims_regions: Optional[pulumi.Input[builtins.bool]] = None,
                 monitor_all_ctg_protocols: Optional[pulumi.Input[builtins.bool]] = None,
                 monitor_all_incoming_web_requests: Optional[pulumi.Input[builtins.bool]] = None,
                 node_limit: Optional[pulumi.Input[builtins.int]] = None,
                 zos_cics_service_detection_uses_transaction_id: Optional[pulumi.Input[builtins.bool]] = None,
                 zos_ims_service_detection_uses_transaction_id: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MainframeTransactionMonitoringArgs.__new__(MainframeTransactionMonitoringArgs)

            if group_cics_regions is None and not opts.urn:
                raise TypeError("Missing required property 'group_cics_regions'")
            __props__.__dict__["group_cics_regions"] = group_cics_regions
            if group_ims_regions is None and not opts.urn:
                raise TypeError("Missing required property 'group_ims_regions'")
            __props__.__dict__["group_ims_regions"] = group_ims_regions
            if monitor_all_ctg_protocols is None and not opts.urn:
                raise TypeError("Missing required property 'monitor_all_ctg_protocols'")
            __props__.__dict__["monitor_all_ctg_protocols"] = monitor_all_ctg_protocols
            if monitor_all_incoming_web_requests is None and not opts.urn:
                raise TypeError("Missing required property 'monitor_all_incoming_web_requests'")
            __props__.__dict__["monitor_all_incoming_web_requests"] = monitor_all_incoming_web_requests
            if node_limit is None and not opts.urn:
                raise TypeError("Missing required property 'node_limit'")
            __props__.__dict__["node_limit"] = node_limit
            if zos_cics_service_detection_uses_transaction_id is None and not opts.urn:
                raise TypeError("Missing required property 'zos_cics_service_detection_uses_transaction_id'")
            __props__.__dict__["zos_cics_service_detection_uses_transaction_id"] = zos_cics_service_detection_uses_transaction_id
            if zos_ims_service_detection_uses_transaction_id is None and not opts.urn:
                raise TypeError("Missing required property 'zos_ims_service_detection_uses_transaction_id'")
            __props__.__dict__["zos_ims_service_detection_uses_transaction_id"] = zos_ims_service_detection_uses_transaction_id
        super(MainframeTransactionMonitoring, __self__).__init__(
            'dynatrace:index/mainframeTransactionMonitoring:MainframeTransactionMonitoring',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group_cics_regions: Optional[pulumi.Input[builtins.bool]] = None,
            group_ims_regions: Optional[pulumi.Input[builtins.bool]] = None,
            monitor_all_ctg_protocols: Optional[pulumi.Input[builtins.bool]] = None,
            monitor_all_incoming_web_requests: Optional[pulumi.Input[builtins.bool]] = None,
            node_limit: Optional[pulumi.Input[builtins.int]] = None,
            zos_cics_service_detection_uses_transaction_id: Optional[pulumi.Input[builtins.bool]] = None,
            zos_ims_service_detection_uses_transaction_id: Optional[pulumi.Input[builtins.bool]] = None) -> 'MainframeTransactionMonitoring':
        """
        Get an existing MainframeTransactionMonitoring resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] group_cics_regions: If enabled, CICS regions belonging to the same CICSPlex will be grouped into a single process group. If disabled, a process group will be created for each CICS region.
        :param pulumi.Input[builtins.bool] group_ims_regions: If enabled, IMS regions belonging to the same subsystem will be grouped into a single process group. If disabled, a process group will be created for each IMS region.
        :param pulumi.Input[builtins.bool] monitor_all_ctg_protocols: If enabled, the CICS Transaction Gateway sensor will trace all EXCI requests including those that are using the TCP/IP or SNA protocol.
        :param pulumi.Input[builtins.bool] monitor_all_incoming_web_requests: Dynatrace automatically traces incoming web requests when they are called by already-monitored services. Enable this setting to monitor all incoming web requests. We recommend enabling it only over a short period of time.
        :param pulumi.Input[builtins.int] node_limit: We recommend the default limit of 500 nodes. The value 0 means unlimited number of nodes.
        :param pulumi.Input[builtins.bool] zos_cics_service_detection_uses_transaction_id: If enabled, a CICS service will be created for each monitored transaction ID within a process group. If disabled, a CICS service will be created for each monitored CICS region within a process group. We recommend enabling it only when the CICS regions are grouped by their CICSPlex.
        :param pulumi.Input[builtins.bool] zos_ims_service_detection_uses_transaction_id: If enabled, an IMS service will be created for each monitored transaction ID within a process group. If disabled, an IMS service will be created for each monitored IMS region within a process group. We recommend enabling it only when the IMS regions are grouped by their subsystem.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MainframeTransactionMonitoringState.__new__(_MainframeTransactionMonitoringState)

        __props__.__dict__["group_cics_regions"] = group_cics_regions
        __props__.__dict__["group_ims_regions"] = group_ims_regions
        __props__.__dict__["monitor_all_ctg_protocols"] = monitor_all_ctg_protocols
        __props__.__dict__["monitor_all_incoming_web_requests"] = monitor_all_incoming_web_requests
        __props__.__dict__["node_limit"] = node_limit
        __props__.__dict__["zos_cics_service_detection_uses_transaction_id"] = zos_cics_service_detection_uses_transaction_id
        __props__.__dict__["zos_ims_service_detection_uses_transaction_id"] = zos_ims_service_detection_uses_transaction_id
        return MainframeTransactionMonitoring(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="groupCicsRegions")
    def group_cics_regions(self) -> pulumi.Output[builtins.bool]:
        """
        If enabled, CICS regions belonging to the same CICSPlex will be grouped into a single process group. If disabled, a process group will be created for each CICS region.
        """
        return pulumi.get(self, "group_cics_regions")

    @property
    @pulumi.getter(name="groupImsRegions")
    def group_ims_regions(self) -> pulumi.Output[builtins.bool]:
        """
        If enabled, IMS regions belonging to the same subsystem will be grouped into a single process group. If disabled, a process group will be created for each IMS region.
        """
        return pulumi.get(self, "group_ims_regions")

    @property
    @pulumi.getter(name="monitorAllCtgProtocols")
    def monitor_all_ctg_protocols(self) -> pulumi.Output[builtins.bool]:
        """
        If enabled, the CICS Transaction Gateway sensor will trace all EXCI requests including those that are using the TCP/IP or SNA protocol.
        """
        return pulumi.get(self, "monitor_all_ctg_protocols")

    @property
    @pulumi.getter(name="monitorAllIncomingWebRequests")
    def monitor_all_incoming_web_requests(self) -> pulumi.Output[builtins.bool]:
        """
        Dynatrace automatically traces incoming web requests when they are called by already-monitored services. Enable this setting to monitor all incoming web requests. We recommend enabling it only over a short period of time.
        """
        return pulumi.get(self, "monitor_all_incoming_web_requests")

    @property
    @pulumi.getter(name="nodeLimit")
    def node_limit(self) -> pulumi.Output[builtins.int]:
        """
        We recommend the default limit of 500 nodes. The value 0 means unlimited number of nodes.
        """
        return pulumi.get(self, "node_limit")

    @property
    @pulumi.getter(name="zosCicsServiceDetectionUsesTransactionId")
    def zos_cics_service_detection_uses_transaction_id(self) -> pulumi.Output[builtins.bool]:
        """
        If enabled, a CICS service will be created for each monitored transaction ID within a process group. If disabled, a CICS service will be created for each monitored CICS region within a process group. We recommend enabling it only when the CICS regions are grouped by their CICSPlex.
        """
        return pulumi.get(self, "zos_cics_service_detection_uses_transaction_id")

    @property
    @pulumi.getter(name="zosImsServiceDetectionUsesTransactionId")
    def zos_ims_service_detection_uses_transaction_id(self) -> pulumi.Output[builtins.bool]:
        """
        If enabled, an IMS service will be created for each monitored transaction ID within a process group. If disabled, an IMS service will be created for each monitored IMS region within a process group. We recommend enabling it only when the IMS regions are grouped by their subsystem.
        """
        return pulumi.get(self, "zos_ims_service_detection_uses_transaction_id")

