# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MaintenanceArgs', 'Maintenance']

@pulumi.input_type
class MaintenanceArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool],
                 general_properties: pulumi.Input['MaintenanceGeneralPropertiesArgs'],
                 schedule: pulumi.Input['MaintenanceScheduleArgs'],
                 filters: Optional[pulumi.Input['MaintenanceFiltersArgs']] = None,
                 legacy_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Maintenance resource.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input['MaintenanceGeneralPropertiesArgs'] general_properties: The general properties of the maintenance window
        :param pulumi.Input['MaintenanceScheduleArgs'] schedule: The schedule of the maintenance window
        :param pulumi.Input['MaintenanceFiltersArgs'] filters: ## Filters
               Add filters to limit the scope of maintenance to only select matching entities. If no filter is defined, the maintenance window is valid for the whole environment. Each filter is evaluated separately (**OR**).
        :param pulumi.Input[builtins.str] legacy_id: The ID of this setting when referred to by the Config REST API V1
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "general_properties", general_properties)
        pulumi.set(__self__, "schedule", schedule)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if legacy_id is not None:
            pulumi.set(__self__, "legacy_id", legacy_id)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="generalProperties")
    def general_properties(self) -> pulumi.Input['MaintenanceGeneralPropertiesArgs']:
        """
        The general properties of the maintenance window
        """
        return pulumi.get(self, "general_properties")

    @general_properties.setter
    def general_properties(self, value: pulumi.Input['MaintenanceGeneralPropertiesArgs']):
        pulumi.set(self, "general_properties", value)

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Input['MaintenanceScheduleArgs']:
        """
        The schedule of the maintenance window
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: pulumi.Input['MaintenanceScheduleArgs']):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input['MaintenanceFiltersArgs']]:
        """
        ## Filters
        Add filters to limit the scope of maintenance to only select matching entities. If no filter is defined, the maintenance window is valid for the whole environment. Each filter is evaluated separately (**OR**).
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input['MaintenanceFiltersArgs']]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter(name="legacyId")
    def legacy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of this setting when referred to by the Config REST API V1
        """
        return pulumi.get(self, "legacy_id")

    @legacy_id.setter
    def legacy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "legacy_id", value)


@pulumi.input_type
class _MaintenanceState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 filters: Optional[pulumi.Input['MaintenanceFiltersArgs']] = None,
                 general_properties: Optional[pulumi.Input['MaintenanceGeneralPropertiesArgs']] = None,
                 legacy_id: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input['MaintenanceScheduleArgs']] = None):
        """
        Input properties used for looking up and filtering Maintenance resources.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input['MaintenanceFiltersArgs'] filters: ## Filters
               Add filters to limit the scope of maintenance to only select matching entities. If no filter is defined, the maintenance window is valid for the whole environment. Each filter is evaluated separately (**OR**).
        :param pulumi.Input['MaintenanceGeneralPropertiesArgs'] general_properties: The general properties of the maintenance window
        :param pulumi.Input[builtins.str] legacy_id: The ID of this setting when referred to by the Config REST API V1
        :param pulumi.Input['MaintenanceScheduleArgs'] schedule: The schedule of the maintenance window
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if general_properties is not None:
            pulumi.set(__self__, "general_properties", general_properties)
        if legacy_id is not None:
            pulumi.set(__self__, "legacy_id", legacy_id)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input['MaintenanceFiltersArgs']]:
        """
        ## Filters
        Add filters to limit the scope of maintenance to only select matching entities. If no filter is defined, the maintenance window is valid for the whole environment. Each filter is evaluated separately (**OR**).
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input['MaintenanceFiltersArgs']]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter(name="generalProperties")
    def general_properties(self) -> Optional[pulumi.Input['MaintenanceGeneralPropertiesArgs']]:
        """
        The general properties of the maintenance window
        """
        return pulumi.get(self, "general_properties")

    @general_properties.setter
    def general_properties(self, value: Optional[pulumi.Input['MaintenanceGeneralPropertiesArgs']]):
        pulumi.set(self, "general_properties", value)

    @property
    @pulumi.getter(name="legacyId")
    def legacy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of this setting when referred to by the Config REST API V1
        """
        return pulumi.get(self, "legacy_id")

    @legacy_id.setter
    def legacy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "legacy_id", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['MaintenanceScheduleArgs']]:
        """
        The schedule of the maintenance window
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['MaintenanceScheduleArgs']]):
        pulumi.set(self, "schedule", value)


@pulumi.type_token("dynatrace:index/maintenance:Maintenance")
class Maintenance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 filters: Optional[pulumi.Input[Union['MaintenanceFiltersArgs', 'MaintenanceFiltersArgsDict']]] = None,
                 general_properties: Optional[pulumi.Input[Union['MaintenanceGeneralPropertiesArgs', 'MaintenanceGeneralPropertiesArgsDict']]] = None,
                 legacy_id: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input[Union['MaintenanceScheduleArgs', 'MaintenanceScheduleArgsDict']]] = None,
                 __props__=None):
        """
        Create a Maintenance resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[Union['MaintenanceFiltersArgs', 'MaintenanceFiltersArgsDict']] filters: ## Filters
               Add filters to limit the scope of maintenance to only select matching entities. If no filter is defined, the maintenance window is valid for the whole environment. Each filter is evaluated separately (**OR**).
        :param pulumi.Input[Union['MaintenanceGeneralPropertiesArgs', 'MaintenanceGeneralPropertiesArgsDict']] general_properties: The general properties of the maintenance window
        :param pulumi.Input[builtins.str] legacy_id: The ID of this setting when referred to by the Config REST API V1
        :param pulumi.Input[Union['MaintenanceScheduleArgs', 'MaintenanceScheduleArgsDict']] schedule: The schedule of the maintenance window
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MaintenanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Maintenance resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param MaintenanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MaintenanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 filters: Optional[pulumi.Input[Union['MaintenanceFiltersArgs', 'MaintenanceFiltersArgsDict']]] = None,
                 general_properties: Optional[pulumi.Input[Union['MaintenanceGeneralPropertiesArgs', 'MaintenanceGeneralPropertiesArgsDict']]] = None,
                 legacy_id: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input[Union['MaintenanceScheduleArgs', 'MaintenanceScheduleArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MaintenanceArgs.__new__(MaintenanceArgs)

            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["filters"] = filters
            if general_properties is None and not opts.urn:
                raise TypeError("Missing required property 'general_properties'")
            __props__.__dict__["general_properties"] = general_properties
            __props__.__dict__["legacy_id"] = legacy_id
            if schedule is None and not opts.urn:
                raise TypeError("Missing required property 'schedule'")
            __props__.__dict__["schedule"] = schedule
        super(Maintenance, __self__).__init__(
            'dynatrace:index/maintenance:Maintenance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            filters: Optional[pulumi.Input[Union['MaintenanceFiltersArgs', 'MaintenanceFiltersArgsDict']]] = None,
            general_properties: Optional[pulumi.Input[Union['MaintenanceGeneralPropertiesArgs', 'MaintenanceGeneralPropertiesArgsDict']]] = None,
            legacy_id: Optional[pulumi.Input[builtins.str]] = None,
            schedule: Optional[pulumi.Input[Union['MaintenanceScheduleArgs', 'MaintenanceScheduleArgsDict']]] = None) -> 'Maintenance':
        """
        Get an existing Maintenance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[Union['MaintenanceFiltersArgs', 'MaintenanceFiltersArgsDict']] filters: ## Filters
               Add filters to limit the scope of maintenance to only select matching entities. If no filter is defined, the maintenance window is valid for the whole environment. Each filter is evaluated separately (**OR**).
        :param pulumi.Input[Union['MaintenanceGeneralPropertiesArgs', 'MaintenanceGeneralPropertiesArgsDict']] general_properties: The general properties of the maintenance window
        :param pulumi.Input[builtins.str] legacy_id: The ID of this setting when referred to by the Config REST API V1
        :param pulumi.Input[Union['MaintenanceScheduleArgs', 'MaintenanceScheduleArgsDict']] schedule: The schedule of the maintenance window
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MaintenanceState.__new__(_MaintenanceState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["filters"] = filters
        __props__.__dict__["general_properties"] = general_properties
        __props__.__dict__["legacy_id"] = legacy_id
        __props__.__dict__["schedule"] = schedule
        return Maintenance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def filters(self) -> pulumi.Output[Optional['outputs.MaintenanceFilters']]:
        """
        ## Filters
        Add filters to limit the scope of maintenance to only select matching entities. If no filter is defined, the maintenance window is valid for the whole environment. Each filter is evaluated separately (**OR**).
        """
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="generalProperties")
    def general_properties(self) -> pulumi.Output['outputs.MaintenanceGeneralProperties']:
        """
        The general properties of the maintenance window
        """
        return pulumi.get(self, "general_properties")

    @property
    @pulumi.getter(name="legacyId")
    def legacy_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of this setting when referred to by the Config REST API V1
        """
        return pulumi.get(self, "legacy_id")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output['outputs.MaintenanceSchedule']:
        """
        The schedule of the maintenance window
        """
        return pulumi.get(self, "schedule")

