# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ManagedInternetProxyArgs', 'ManagedInternetProxy']

@pulumi.input_type
class ManagedInternetProxyArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[builtins.int],
                 scheme: pulumi.Input[builtins.str],
                 server: pulumi.Input[builtins.str],
                 non_proxy_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ManagedInternetProxy resource.
        :param pulumi.Input[builtins.int] port: Port of proxy server
        :param pulumi.Input[builtins.str] scheme: Protocol which proxy server uses
        :param pulumi.Input[builtins.str] server: Address (either IP or Hostname) of proxy server
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] non_proxy_hosts: Definition of hosts for which proxy won't be used. You can define multiple hosts. Each host can start or end with wildcard '*' for instance to match whole domain.
        :param pulumi.Input[builtins.str] password: Password of proxy server, null means do not change previous value
        :param pulumi.Input[builtins.str] user: User of proxy server, null means do not change previous value
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "scheme", scheme)
        pulumi.set(__self__, "server", server)
        if non_proxy_hosts is not None:
            pulumi.set(__self__, "non_proxy_hosts", non_proxy_hosts)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[builtins.int]:
        """
        Port of proxy server
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def scheme(self) -> pulumi.Input[builtins.str]:
        """
        Protocol which proxy server uses
        """
        return pulumi.get(self, "scheme")

    @scheme.setter
    def scheme(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "scheme", value)

    @property
    @pulumi.getter
    def server(self) -> pulumi.Input[builtins.str]:
        """
        Address (either IP or Hostname) of proxy server
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter(name="nonProxyHosts")
    def non_proxy_hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Definition of hosts for which proxy won't be used. You can define multiple hosts. Each host can start or end with wildcard '*' for instance to match whole domain.
        """
        return pulumi.get(self, "non_proxy_hosts")

    @non_proxy_hosts.setter
    def non_proxy_hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "non_proxy_hosts", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Password of proxy server, null means do not change previous value
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User of proxy server, null means do not change previous value
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class _ManagedInternetProxyState:
    def __init__(__self__, *,
                 non_proxy_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 scheme: Optional[pulumi.Input[builtins.str]] = None,
                 server: Optional[pulumi.Input[builtins.str]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedInternetProxy resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] non_proxy_hosts: Definition of hosts for which proxy won't be used. You can define multiple hosts. Each host can start or end with wildcard '*' for instance to match whole domain.
        :param pulumi.Input[builtins.str] password: Password of proxy server, null means do not change previous value
        :param pulumi.Input[builtins.int] port: Port of proxy server
        :param pulumi.Input[builtins.str] scheme: Protocol which proxy server uses
        :param pulumi.Input[builtins.str] server: Address (either IP or Hostname) of proxy server
        :param pulumi.Input[builtins.str] user: User of proxy server, null means do not change previous value
        """
        if non_proxy_hosts is not None:
            pulumi.set(__self__, "non_proxy_hosts", non_proxy_hosts)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter(name="nonProxyHosts")
    def non_proxy_hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Definition of hosts for which proxy won't be used. You can define multiple hosts. Each host can start or end with wildcard '*' for instance to match whole domain.
        """
        return pulumi.get(self, "non_proxy_hosts")

    @non_proxy_hosts.setter
    def non_proxy_hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "non_proxy_hosts", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Password of proxy server, null means do not change previous value
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Port of proxy server
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def scheme(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Protocol which proxy server uses
        """
        return pulumi.get(self, "scheme")

    @scheme.setter
    def scheme(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scheme", value)

    @property
    @pulumi.getter
    def server(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Address (either IP or Hostname) of proxy server
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User of proxy server, null means do not change previous value
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user", value)


@pulumi.type_token("dynatrace:index/managedInternetProxy:ManagedInternetProxy")
class ManagedInternetProxy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 non_proxy_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 scheme: Optional[pulumi.Input[builtins.str]] = None,
                 server: Optional[pulumi.Input[builtins.str]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        > This resource requires one of the cluster API token scopes **Control Management** (`ControlManagement`), **Service Provider API** (`ServiceProviderAPI`), or **Unattended Install** (`UnattendedInstall`)

        ## Dynatrace Documentation

        - Can I use a proxy for internet access? - https://www.dynatrace.com/support/help/managed-cluster/configuration/can-i-use-a-proxy-for-internet-access

        - Cluster API v1 - https://www.dynatrace.com/support/help/managed-cluster/cluster-api/cluster-api-v1

        ## Resource Example Usage

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        test = dynatrace.ManagedInternetProxy("test",
            non_proxy_hosts=["string"],
            password="string",
            port=65535,
            scheme="http",
            server="zAOE-GV81/65oVgaIlPYTCADGSPFJ9ZqXYNGbxn97dbq:flAI2E8e8bfOvlmaGu",
            user="string")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] non_proxy_hosts: Definition of hosts for which proxy won't be used. You can define multiple hosts. Each host can start or end with wildcard '*' for instance to match whole domain.
        :param pulumi.Input[builtins.str] password: Password of proxy server, null means do not change previous value
        :param pulumi.Input[builtins.int] port: Port of proxy server
        :param pulumi.Input[builtins.str] scheme: Protocol which proxy server uses
        :param pulumi.Input[builtins.str] server: Address (either IP or Hostname) of proxy server
        :param pulumi.Input[builtins.str] user: User of proxy server, null means do not change previous value
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedInternetProxyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > This resource requires one of the cluster API token scopes **Control Management** (`ControlManagement`), **Service Provider API** (`ServiceProviderAPI`), or **Unattended Install** (`UnattendedInstall`)

        ## Dynatrace Documentation

        - Can I use a proxy for internet access? - https://www.dynatrace.com/support/help/managed-cluster/configuration/can-i-use-a-proxy-for-internet-access

        - Cluster API v1 - https://www.dynatrace.com/support/help/managed-cluster/cluster-api/cluster-api-v1

        ## Resource Example Usage

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        test = dynatrace.ManagedInternetProxy("test",
            non_proxy_hosts=["string"],
            password="string",
            port=65535,
            scheme="http",
            server="zAOE-GV81/65oVgaIlPYTCADGSPFJ9ZqXYNGbxn97dbq:flAI2E8e8bfOvlmaGu",
            user="string")
        ```

        :param str resource_name: The name of the resource.
        :param ManagedInternetProxyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedInternetProxyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 non_proxy_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 scheme: Optional[pulumi.Input[builtins.str]] = None,
                 server: Optional[pulumi.Input[builtins.str]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedInternetProxyArgs.__new__(ManagedInternetProxyArgs)

            __props__.__dict__["non_proxy_hosts"] = non_proxy_hosts
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if port is None and not opts.urn:
                raise TypeError("Missing required property 'port'")
            __props__.__dict__["port"] = port
            if scheme is None and not opts.urn:
                raise TypeError("Missing required property 'scheme'")
            __props__.__dict__["scheme"] = scheme
            if server is None and not opts.urn:
                raise TypeError("Missing required property 'server'")
            __props__.__dict__["server"] = server
            __props__.__dict__["user"] = user
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ManagedInternetProxy, __self__).__init__(
            'dynatrace:index/managedInternetProxy:ManagedInternetProxy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            non_proxy_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            port: Optional[pulumi.Input[builtins.int]] = None,
            scheme: Optional[pulumi.Input[builtins.str]] = None,
            server: Optional[pulumi.Input[builtins.str]] = None,
            user: Optional[pulumi.Input[builtins.str]] = None) -> 'ManagedInternetProxy':
        """
        Get an existing ManagedInternetProxy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] non_proxy_hosts: Definition of hosts for which proxy won't be used. You can define multiple hosts. Each host can start or end with wildcard '*' for instance to match whole domain.
        :param pulumi.Input[builtins.str] password: Password of proxy server, null means do not change previous value
        :param pulumi.Input[builtins.int] port: Port of proxy server
        :param pulumi.Input[builtins.str] scheme: Protocol which proxy server uses
        :param pulumi.Input[builtins.str] server: Address (either IP or Hostname) of proxy server
        :param pulumi.Input[builtins.str] user: User of proxy server, null means do not change previous value
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedInternetProxyState.__new__(_ManagedInternetProxyState)

        __props__.__dict__["non_proxy_hosts"] = non_proxy_hosts
        __props__.__dict__["password"] = password
        __props__.__dict__["port"] = port
        __props__.__dict__["scheme"] = scheme
        __props__.__dict__["server"] = server
        __props__.__dict__["user"] = user
        return ManagedInternetProxy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="nonProxyHosts")
    def non_proxy_hosts(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Definition of hosts for which proxy won't be used. You can define multiple hosts. Each host can start or end with wildcard '*' for instance to match whole domain.
        """
        return pulumi.get(self, "non_proxy_hosts")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Password of proxy server, null means do not change previous value
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[builtins.int]:
        """
        Port of proxy server
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def scheme(self) -> pulumi.Output[builtins.str]:
        """
        Protocol which proxy server uses
        """
        return pulumi.get(self, "scheme")

    @property
    @pulumi.getter
    def server(self) -> pulumi.Output[builtins.str]:
        """
        Address (either IP or Hostname) of proxy server
        """
        return pulumi.get(self, "server")

    @property
    @pulumi.getter
    def user(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User of proxy server, null means do not change previous value
        """
        return pulumi.get(self, "user")

