# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MetricEventsArgs', 'MetricEvents']

@pulumi.input_type
class MetricEventsArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool],
                 event_template: pulumi.Input['MetricEventsEventTemplateArgs'],
                 model_properties: pulumi.Input['MetricEventsModelPropertiesArgs'],
                 query_definition: pulumi.Input['MetricEventsQueryDefinitionArgs'],
                 summary: pulumi.Input[builtins.str],
                 event_entity_dimension_key: Optional[pulumi.Input[builtins.str]] = None,
                 legacy_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a MetricEvents resource.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input['MetricEventsEventTemplateArgs'] event_template: Event template
        :param pulumi.Input['MetricEventsModelPropertiesArgs'] model_properties: Monitoring strategy
        :param pulumi.Input['MetricEventsQueryDefinitionArgs'] query_definition: Query definition
        :param pulumi.Input[builtins.str] summary: The textual summary of the metric event entry
        :param pulumi.Input[builtins.str] event_entity_dimension_key: Controls the preferred entity type used for triggered events.
        :param pulumi.Input[builtins.str] legacy_id: Config id
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "event_template", event_template)
        pulumi.set(__self__, "model_properties", model_properties)
        pulumi.set(__self__, "query_definition", query_definition)
        pulumi.set(__self__, "summary", summary)
        if event_entity_dimension_key is not None:
            pulumi.set(__self__, "event_entity_dimension_key", event_entity_dimension_key)
        if legacy_id is not None:
            pulumi.set(__self__, "legacy_id", legacy_id)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="eventTemplate")
    def event_template(self) -> pulumi.Input['MetricEventsEventTemplateArgs']:
        """
        Event template
        """
        return pulumi.get(self, "event_template")

    @event_template.setter
    def event_template(self, value: pulumi.Input['MetricEventsEventTemplateArgs']):
        pulumi.set(self, "event_template", value)

    @property
    @pulumi.getter(name="modelProperties")
    def model_properties(self) -> pulumi.Input['MetricEventsModelPropertiesArgs']:
        """
        Monitoring strategy
        """
        return pulumi.get(self, "model_properties")

    @model_properties.setter
    def model_properties(self, value: pulumi.Input['MetricEventsModelPropertiesArgs']):
        pulumi.set(self, "model_properties", value)

    @property
    @pulumi.getter(name="queryDefinition")
    def query_definition(self) -> pulumi.Input['MetricEventsQueryDefinitionArgs']:
        """
        Query definition
        """
        return pulumi.get(self, "query_definition")

    @query_definition.setter
    def query_definition(self, value: pulumi.Input['MetricEventsQueryDefinitionArgs']):
        pulumi.set(self, "query_definition", value)

    @property
    @pulumi.getter
    def summary(self) -> pulumi.Input[builtins.str]:
        """
        The textual summary of the metric event entry
        """
        return pulumi.get(self, "summary")

    @summary.setter
    def summary(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "summary", value)

    @property
    @pulumi.getter(name="eventEntityDimensionKey")
    def event_entity_dimension_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Controls the preferred entity type used for triggered events.
        """
        return pulumi.get(self, "event_entity_dimension_key")

    @event_entity_dimension_key.setter
    def event_entity_dimension_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "event_entity_dimension_key", value)

    @property
    @pulumi.getter(name="legacyId")
    def legacy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Config id
        """
        return pulumi.get(self, "legacy_id")

    @legacy_id.setter
    def legacy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "legacy_id", value)


@pulumi.input_type
class _MetricEventsState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 event_entity_dimension_key: Optional[pulumi.Input[builtins.str]] = None,
                 event_template: Optional[pulumi.Input['MetricEventsEventTemplateArgs']] = None,
                 legacy_id: Optional[pulumi.Input[builtins.str]] = None,
                 model_properties: Optional[pulumi.Input['MetricEventsModelPropertiesArgs']] = None,
                 query_definition: Optional[pulumi.Input['MetricEventsQueryDefinitionArgs']] = None,
                 summary: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering MetricEvents resources.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] event_entity_dimension_key: Controls the preferred entity type used for triggered events.
        :param pulumi.Input['MetricEventsEventTemplateArgs'] event_template: Event template
        :param pulumi.Input[builtins.str] legacy_id: Config id
        :param pulumi.Input['MetricEventsModelPropertiesArgs'] model_properties: Monitoring strategy
        :param pulumi.Input['MetricEventsQueryDefinitionArgs'] query_definition: Query definition
        :param pulumi.Input[builtins.str] summary: The textual summary of the metric event entry
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if event_entity_dimension_key is not None:
            pulumi.set(__self__, "event_entity_dimension_key", event_entity_dimension_key)
        if event_template is not None:
            pulumi.set(__self__, "event_template", event_template)
        if legacy_id is not None:
            pulumi.set(__self__, "legacy_id", legacy_id)
        if model_properties is not None:
            pulumi.set(__self__, "model_properties", model_properties)
        if query_definition is not None:
            pulumi.set(__self__, "query_definition", query_definition)
        if summary is not None:
            pulumi.set(__self__, "summary", summary)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="eventEntityDimensionKey")
    def event_entity_dimension_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Controls the preferred entity type used for triggered events.
        """
        return pulumi.get(self, "event_entity_dimension_key")

    @event_entity_dimension_key.setter
    def event_entity_dimension_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "event_entity_dimension_key", value)

    @property
    @pulumi.getter(name="eventTemplate")
    def event_template(self) -> Optional[pulumi.Input['MetricEventsEventTemplateArgs']]:
        """
        Event template
        """
        return pulumi.get(self, "event_template")

    @event_template.setter
    def event_template(self, value: Optional[pulumi.Input['MetricEventsEventTemplateArgs']]):
        pulumi.set(self, "event_template", value)

    @property
    @pulumi.getter(name="legacyId")
    def legacy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Config id
        """
        return pulumi.get(self, "legacy_id")

    @legacy_id.setter
    def legacy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "legacy_id", value)

    @property
    @pulumi.getter(name="modelProperties")
    def model_properties(self) -> Optional[pulumi.Input['MetricEventsModelPropertiesArgs']]:
        """
        Monitoring strategy
        """
        return pulumi.get(self, "model_properties")

    @model_properties.setter
    def model_properties(self, value: Optional[pulumi.Input['MetricEventsModelPropertiesArgs']]):
        pulumi.set(self, "model_properties", value)

    @property
    @pulumi.getter(name="queryDefinition")
    def query_definition(self) -> Optional[pulumi.Input['MetricEventsQueryDefinitionArgs']]:
        """
        Query definition
        """
        return pulumi.get(self, "query_definition")

    @query_definition.setter
    def query_definition(self, value: Optional[pulumi.Input['MetricEventsQueryDefinitionArgs']]):
        pulumi.set(self, "query_definition", value)

    @property
    @pulumi.getter
    def summary(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The textual summary of the metric event entry
        """
        return pulumi.get(self, "summary")

    @summary.setter
    def summary(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "summary", value)


@pulumi.type_token("dynatrace:index/metricEvents:MetricEvents")
class MetricEvents(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 event_entity_dimension_key: Optional[pulumi.Input[builtins.str]] = None,
                 event_template: Optional[pulumi.Input[Union['MetricEventsEventTemplateArgs', 'MetricEventsEventTemplateArgsDict']]] = None,
                 legacy_id: Optional[pulumi.Input[builtins.str]] = None,
                 model_properties: Optional[pulumi.Input[Union['MetricEventsModelPropertiesArgs', 'MetricEventsModelPropertiesArgsDict']]] = None,
                 query_definition: Optional[pulumi.Input[Union['MetricEventsQueryDefinitionArgs', 'MetricEventsQueryDefinitionArgsDict']]] = None,
                 summary: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a MetricEvents resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] event_entity_dimension_key: Controls the preferred entity type used for triggered events.
        :param pulumi.Input[Union['MetricEventsEventTemplateArgs', 'MetricEventsEventTemplateArgsDict']] event_template: Event template
        :param pulumi.Input[builtins.str] legacy_id: Config id
        :param pulumi.Input[Union['MetricEventsModelPropertiesArgs', 'MetricEventsModelPropertiesArgsDict']] model_properties: Monitoring strategy
        :param pulumi.Input[Union['MetricEventsQueryDefinitionArgs', 'MetricEventsQueryDefinitionArgsDict']] query_definition: Query definition
        :param pulumi.Input[builtins.str] summary: The textual summary of the metric event entry
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MetricEventsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a MetricEvents resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param MetricEventsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetricEventsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 event_entity_dimension_key: Optional[pulumi.Input[builtins.str]] = None,
                 event_template: Optional[pulumi.Input[Union['MetricEventsEventTemplateArgs', 'MetricEventsEventTemplateArgsDict']]] = None,
                 legacy_id: Optional[pulumi.Input[builtins.str]] = None,
                 model_properties: Optional[pulumi.Input[Union['MetricEventsModelPropertiesArgs', 'MetricEventsModelPropertiesArgsDict']]] = None,
                 query_definition: Optional[pulumi.Input[Union['MetricEventsQueryDefinitionArgs', 'MetricEventsQueryDefinitionArgsDict']]] = None,
                 summary: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetricEventsArgs.__new__(MetricEventsArgs)

            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["event_entity_dimension_key"] = event_entity_dimension_key
            if event_template is None and not opts.urn:
                raise TypeError("Missing required property 'event_template'")
            __props__.__dict__["event_template"] = event_template
            __props__.__dict__["legacy_id"] = legacy_id
            if model_properties is None and not opts.urn:
                raise TypeError("Missing required property 'model_properties'")
            __props__.__dict__["model_properties"] = model_properties
            if query_definition is None and not opts.urn:
                raise TypeError("Missing required property 'query_definition'")
            __props__.__dict__["query_definition"] = query_definition
            if summary is None and not opts.urn:
                raise TypeError("Missing required property 'summary'")
            __props__.__dict__["summary"] = summary
        super(MetricEvents, __self__).__init__(
            'dynatrace:index/metricEvents:MetricEvents',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            event_entity_dimension_key: Optional[pulumi.Input[builtins.str]] = None,
            event_template: Optional[pulumi.Input[Union['MetricEventsEventTemplateArgs', 'MetricEventsEventTemplateArgsDict']]] = None,
            legacy_id: Optional[pulumi.Input[builtins.str]] = None,
            model_properties: Optional[pulumi.Input[Union['MetricEventsModelPropertiesArgs', 'MetricEventsModelPropertiesArgsDict']]] = None,
            query_definition: Optional[pulumi.Input[Union['MetricEventsQueryDefinitionArgs', 'MetricEventsQueryDefinitionArgsDict']]] = None,
            summary: Optional[pulumi.Input[builtins.str]] = None) -> 'MetricEvents':
        """
        Get an existing MetricEvents resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] event_entity_dimension_key: Controls the preferred entity type used for triggered events.
        :param pulumi.Input[Union['MetricEventsEventTemplateArgs', 'MetricEventsEventTemplateArgsDict']] event_template: Event template
        :param pulumi.Input[builtins.str] legacy_id: Config id
        :param pulumi.Input[Union['MetricEventsModelPropertiesArgs', 'MetricEventsModelPropertiesArgsDict']] model_properties: Monitoring strategy
        :param pulumi.Input[Union['MetricEventsQueryDefinitionArgs', 'MetricEventsQueryDefinitionArgsDict']] query_definition: Query definition
        :param pulumi.Input[builtins.str] summary: The textual summary of the metric event entry
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MetricEventsState.__new__(_MetricEventsState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["event_entity_dimension_key"] = event_entity_dimension_key
        __props__.__dict__["event_template"] = event_template
        __props__.__dict__["legacy_id"] = legacy_id
        __props__.__dict__["model_properties"] = model_properties
        __props__.__dict__["query_definition"] = query_definition
        __props__.__dict__["summary"] = summary
        return MetricEvents(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="eventEntityDimensionKey")
    def event_entity_dimension_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Controls the preferred entity type used for triggered events.
        """
        return pulumi.get(self, "event_entity_dimension_key")

    @property
    @pulumi.getter(name="eventTemplate")
    def event_template(self) -> pulumi.Output['outputs.MetricEventsEventTemplate']:
        """
        Event template
        """
        return pulumi.get(self, "event_template")

    @property
    @pulumi.getter(name="legacyId")
    def legacy_id(self) -> pulumi.Output[builtins.str]:
        """
        Config id
        """
        return pulumi.get(self, "legacy_id")

    @property
    @pulumi.getter(name="modelProperties")
    def model_properties(self) -> pulumi.Output['outputs.MetricEventsModelProperties']:
        """
        Monitoring strategy
        """
        return pulumi.get(self, "model_properties")

    @property
    @pulumi.getter(name="queryDefinition")
    def query_definition(self) -> pulumi.Output['outputs.MetricEventsQueryDefinition']:
        """
        Query definition
        """
        return pulumi.get(self, "query_definition")

    @property
    @pulumi.getter
    def summary(self) -> pulumi.Output[builtins.str]:
        """
        The textual summary of the metric event entry
        """
        return pulumi.get(self, "summary")

