# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MobileAppEnablementArgs', 'MobileAppEnablement']

@pulumi.input_type
class MobileAppEnablementArgs:
    def __init__(__self__, *,
                 rum: pulumi.Input['MobileAppEnablementRumArgs'],
                 session_replay: pulumi.Input['MobileAppEnablementSessionReplayArgs'],
                 application_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a MobileAppEnablement resource.
        :param pulumi.Input['MobileAppEnablementRumArgs'] rum: (Field has overlap with `MobileApplication`) Capture and analyze all user actions within your application. Enable [Real User Monitoring (RUM)](https://dt-url.net/1n2b0prq) to monitor and improve your application's performance, identify errors, and gain insight into your user's behavior and experience.
        :param pulumi.Input['MobileAppEnablementSessionReplayArgs'] session_replay: (Field has overlap with `MobileApplication`) [Session Replay on crashes](https://dt-url.net/session-replay) gives you additional context for crash analysis in the form of video-like screen recordings that replay user actions immediately preceding a detected crash, while providing [best-in-class security and data protection](https://dt-url.net/b303zxj).
        :param pulumi.Input[builtins.str] application_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        pulumi.set(__self__, "rum", rum)
        pulumi.set(__self__, "session_replay", session_replay)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)

    @property
    @pulumi.getter
    def rum(self) -> pulumi.Input['MobileAppEnablementRumArgs']:
        """
        (Field has overlap with `MobileApplication`) Capture and analyze all user actions within your application. Enable [Real User Monitoring (RUM)](https://dt-url.net/1n2b0prq) to monitor and improve your application's performance, identify errors, and gain insight into your user's behavior and experience.
        """
        return pulumi.get(self, "rum")

    @rum.setter
    def rum(self, value: pulumi.Input['MobileAppEnablementRumArgs']):
        pulumi.set(self, "rum", value)

    @property
    @pulumi.getter(name="sessionReplay")
    def session_replay(self) -> pulumi.Input['MobileAppEnablementSessionReplayArgs']:
        """
        (Field has overlap with `MobileApplication`) [Session Replay on crashes](https://dt-url.net/session-replay) gives you additional context for crash analysis in the form of video-like screen recordings that replay user actions immediately preceding a detected crash, while providing [best-in-class security and data protection](https://dt-url.net/b303zxj).
        """
        return pulumi.get(self, "session_replay")

    @session_replay.setter
    def session_replay(self, value: pulumi.Input['MobileAppEnablementSessionReplayArgs']):
        pulumi.set(self, "session_replay", value)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_id", value)


@pulumi.input_type
class _MobileAppEnablementState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 rum: Optional[pulumi.Input['MobileAppEnablementRumArgs']] = None,
                 session_replay: Optional[pulumi.Input['MobileAppEnablementSessionReplayArgs']] = None):
        """
        Input properties used for looking up and filtering MobileAppEnablement resources.
        :param pulumi.Input[builtins.str] application_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        :param pulumi.Input['MobileAppEnablementRumArgs'] rum: (Field has overlap with `MobileApplication`) Capture and analyze all user actions within your application. Enable [Real User Monitoring (RUM)](https://dt-url.net/1n2b0prq) to monitor and improve your application's performance, identify errors, and gain insight into your user's behavior and experience.
        :param pulumi.Input['MobileAppEnablementSessionReplayArgs'] session_replay: (Field has overlap with `MobileApplication`) [Session Replay on crashes](https://dt-url.net/session-replay) gives you additional context for crash analysis in the form of video-like screen recordings that replay user actions immediately preceding a detected crash, while providing [best-in-class security and data protection](https://dt-url.net/b303zxj).
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if rum is not None:
            pulumi.set(__self__, "rum", rum)
        if session_replay is not None:
            pulumi.set(__self__, "session_replay", session_replay)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter
    def rum(self) -> Optional[pulumi.Input['MobileAppEnablementRumArgs']]:
        """
        (Field has overlap with `MobileApplication`) Capture and analyze all user actions within your application. Enable [Real User Monitoring (RUM)](https://dt-url.net/1n2b0prq) to monitor and improve your application's performance, identify errors, and gain insight into your user's behavior and experience.
        """
        return pulumi.get(self, "rum")

    @rum.setter
    def rum(self, value: Optional[pulumi.Input['MobileAppEnablementRumArgs']]):
        pulumi.set(self, "rum", value)

    @property
    @pulumi.getter(name="sessionReplay")
    def session_replay(self) -> Optional[pulumi.Input['MobileAppEnablementSessionReplayArgs']]:
        """
        (Field has overlap with `MobileApplication`) [Session Replay on crashes](https://dt-url.net/session-replay) gives you additional context for crash analysis in the form of video-like screen recordings that replay user actions immediately preceding a detected crash, while providing [best-in-class security and data protection](https://dt-url.net/b303zxj).
        """
        return pulumi.get(self, "session_replay")

    @session_replay.setter
    def session_replay(self, value: Optional[pulumi.Input['MobileAppEnablementSessionReplayArgs']]):
        pulumi.set(self, "session_replay", value)


@pulumi.type_token("dynatrace:index/mobileAppEnablement:MobileAppEnablement")
class MobileAppEnablement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 rum: Optional[pulumi.Input[Union['MobileAppEnablementRumArgs', 'MobileAppEnablementRumArgsDict']]] = None,
                 session_replay: Optional[pulumi.Input[Union['MobileAppEnablementSessionReplayArgs', 'MobileAppEnablementSessionReplayArgsDict']]] = None,
                 __props__=None):
        """
        Create a MobileAppEnablement resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        :param pulumi.Input[Union['MobileAppEnablementRumArgs', 'MobileAppEnablementRumArgsDict']] rum: (Field has overlap with `MobileApplication`) Capture and analyze all user actions within your application. Enable [Real User Monitoring (RUM)](https://dt-url.net/1n2b0prq) to monitor and improve your application's performance, identify errors, and gain insight into your user's behavior and experience.
        :param pulumi.Input[Union['MobileAppEnablementSessionReplayArgs', 'MobileAppEnablementSessionReplayArgsDict']] session_replay: (Field has overlap with `MobileApplication`) [Session Replay on crashes](https://dt-url.net/session-replay) gives you additional context for crash analysis in the form of video-like screen recordings that replay user actions immediately preceding a detected crash, while providing [best-in-class security and data protection](https://dt-url.net/b303zxj).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MobileAppEnablementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a MobileAppEnablement resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param MobileAppEnablementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MobileAppEnablementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 rum: Optional[pulumi.Input[Union['MobileAppEnablementRumArgs', 'MobileAppEnablementRumArgsDict']]] = None,
                 session_replay: Optional[pulumi.Input[Union['MobileAppEnablementSessionReplayArgs', 'MobileAppEnablementSessionReplayArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MobileAppEnablementArgs.__new__(MobileAppEnablementArgs)

            __props__.__dict__["application_id"] = application_id
            if rum is None and not opts.urn:
                raise TypeError("Missing required property 'rum'")
            __props__.__dict__["rum"] = rum
            if session_replay is None and not opts.urn:
                raise TypeError("Missing required property 'session_replay'")
            __props__.__dict__["session_replay"] = session_replay
        super(MobileAppEnablement, __self__).__init__(
            'dynatrace:index/mobileAppEnablement:MobileAppEnablement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[builtins.str]] = None,
            rum: Optional[pulumi.Input[Union['MobileAppEnablementRumArgs', 'MobileAppEnablementRumArgsDict']]] = None,
            session_replay: Optional[pulumi.Input[Union['MobileAppEnablementSessionReplayArgs', 'MobileAppEnablementSessionReplayArgsDict']]] = None) -> 'MobileAppEnablement':
        """
        Get an existing MobileAppEnablement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        :param pulumi.Input[Union['MobileAppEnablementRumArgs', 'MobileAppEnablementRumArgsDict']] rum: (Field has overlap with `MobileApplication`) Capture and analyze all user actions within your application. Enable [Real User Monitoring (RUM)](https://dt-url.net/1n2b0prq) to monitor and improve your application's performance, identify errors, and gain insight into your user's behavior and experience.
        :param pulumi.Input[Union['MobileAppEnablementSessionReplayArgs', 'MobileAppEnablementSessionReplayArgsDict']] session_replay: (Field has overlap with `MobileApplication`) [Session Replay on crashes](https://dt-url.net/session-replay) gives you additional context for crash analysis in the form of video-like screen recordings that replay user actions immediately preceding a detected crash, while providing [best-in-class security and data protection](https://dt-url.net/b303zxj).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MobileAppEnablementState.__new__(_MobileAppEnablementState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["rum"] = rum
        __props__.__dict__["session_replay"] = session_replay
        return MobileAppEnablement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter
    def rum(self) -> pulumi.Output['outputs.MobileAppEnablementRum']:
        """
        (Field has overlap with `MobileApplication`) Capture and analyze all user actions within your application. Enable [Real User Monitoring (RUM)](https://dt-url.net/1n2b0prq) to monitor and improve your application's performance, identify errors, and gain insight into your user's behavior and experience.
        """
        return pulumi.get(self, "rum")

    @property
    @pulumi.getter(name="sessionReplay")
    def session_replay(self) -> pulumi.Output['outputs.MobileAppEnablementSessionReplay']:
        """
        (Field has overlap with `MobileApplication`) [Session Replay on crashes](https://dt-url.net/session-replay) gives you additional context for crash analysis in the form of video-like screen recordings that replay user actions immediately preceding a detected crash, while providing [best-in-class security and data protection](https://dt-url.net/b303zxj).
        """
        return pulumi.get(self, "session_replay")

