# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['Ms365EmailConnectionArgs', 'Ms365EmailConnection']

@pulumi.input_type
class Ms365EmailConnectionArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[builtins.str],
                 from_address: pulumi.Input[builtins.str],
                 tenant_id: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Ms365EmailConnection resource.
        :param pulumi.Input[builtins.str] client_id: Application (client) ID of your app registered in Microsoft Azure App registrations
        :param pulumi.Input[builtins.str] from_address: The email address from which the messages will be sent
        :param pulumi.Input[builtins.str] tenant_id: Directory (tenant) ID of your Azure Active Directory
        :param pulumi.Input[builtins.str] type: Possible Values: `client_secret`
        :param pulumi.Input[builtins.str] client_secret: Client secret of your app registered in Microsoft Azure App registrations
        :param pulumi.Input[builtins.str] name: A unique name for the Microsoft 365 email connection
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "from_address", from_address)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[builtins.str]:
        """
        Application (client) ID of your app registered in Microsoft Azure App registrations
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="fromAddress")
    def from_address(self) -> pulumi.Input[builtins.str]:
        """
        The email address from which the messages will be sent
        """
        return pulumi.get(self, "from_address")

    @from_address.setter
    def from_address(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "from_address", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[builtins.str]:
        """
        Directory (tenant) ID of your Azure Active Directory
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Possible Values: `client_secret`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Client secret of your app registered in Microsoft Azure App registrations
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique name for the Microsoft 365 email connection
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _Ms365EmailConnectionState:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 from_address: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Ms365EmailConnection resources.
        :param pulumi.Input[builtins.str] client_id: Application (client) ID of your app registered in Microsoft Azure App registrations
        :param pulumi.Input[builtins.str] client_secret: Client secret of your app registered in Microsoft Azure App registrations
        :param pulumi.Input[builtins.str] from_address: The email address from which the messages will be sent
        :param pulumi.Input[builtins.str] name: A unique name for the Microsoft 365 email connection
        :param pulumi.Input[builtins.str] tenant_id: Directory (tenant) ID of your Azure Active Directory
        :param pulumi.Input[builtins.str] type: Possible Values: `client_secret`
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if from_address is not None:
            pulumi.set(__self__, "from_address", from_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Application (client) ID of your app registered in Microsoft Azure App registrations
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Client secret of your app registered in Microsoft Azure App registrations
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="fromAddress")
    def from_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The email address from which the messages will be sent
        """
        return pulumi.get(self, "from_address")

    @from_address.setter
    def from_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "from_address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique name for the Microsoft 365 email connection
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Directory (tenant) ID of your Azure Active Directory
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Possible Values: `client_secret`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("dynatrace:index/ms365EmailConnection:Ms365EmailConnection")
class Ms365EmailConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 from_address: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a Ms365EmailConnection resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] client_id: Application (client) ID of your app registered in Microsoft Azure App registrations
        :param pulumi.Input[builtins.str] client_secret: Client secret of your app registered in Microsoft Azure App registrations
        :param pulumi.Input[builtins.str] from_address: The email address from which the messages will be sent
        :param pulumi.Input[builtins.str] name: A unique name for the Microsoft 365 email connection
        :param pulumi.Input[builtins.str] tenant_id: Directory (tenant) ID of your Azure Active Directory
        :param pulumi.Input[builtins.str] type: Possible Values: `client_secret`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Ms365EmailConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Ms365EmailConnection resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param Ms365EmailConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(Ms365EmailConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 from_address: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = Ms365EmailConnectionArgs.__new__(Ms365EmailConnectionArgs)

            if client_id is None and not opts.urn:
                raise TypeError("Missing required property 'client_id'")
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["client_secret"] = None if client_secret is None else pulumi.Output.secret(client_secret)
            if from_address is None and not opts.urn:
                raise TypeError("Missing required property 'from_address'")
            __props__.__dict__["from_address"] = from_address
            __props__.__dict__["name"] = name
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clientSecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Ms365EmailConnection, __self__).__init__(
            'dynatrace:index/ms365EmailConnection:Ms365EmailConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_id: Optional[pulumi.Input[builtins.str]] = None,
            client_secret: Optional[pulumi.Input[builtins.str]] = None,
            from_address: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'Ms365EmailConnection':
        """
        Get an existing Ms365EmailConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] client_id: Application (client) ID of your app registered in Microsoft Azure App registrations
        :param pulumi.Input[builtins.str] client_secret: Client secret of your app registered in Microsoft Azure App registrations
        :param pulumi.Input[builtins.str] from_address: The email address from which the messages will be sent
        :param pulumi.Input[builtins.str] name: A unique name for the Microsoft 365 email connection
        :param pulumi.Input[builtins.str] tenant_id: Directory (tenant) ID of your Azure Active Directory
        :param pulumi.Input[builtins.str] type: Possible Values: `client_secret`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _Ms365EmailConnectionState.__new__(_Ms365EmailConnectionState)

        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["from_address"] = from_address
        __props__.__dict__["name"] = name
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["type"] = type
        return Ms365EmailConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[builtins.str]:
        """
        Application (client) ID of your app registered in Microsoft Azure App registrations
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Client secret of your app registered in Microsoft Azure App registrations
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="fromAddress")
    def from_address(self) -> pulumi.Output[builtins.str]:
        """
        The email address from which the messages will be sent
        """
        return pulumi.get(self, "from_address")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A unique name for the Microsoft 365 email connection
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[builtins.str]:
        """
        Directory (tenant) ID of your Azure Active Directory
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Possible Values: `client_secret`
        """
        return pulumi.get(self, "type")

