# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['MsentraidConnectionArgs', 'MsentraidConnection']

@pulumi.input_type
class MsentraidConnectionArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[builtins.str],
                 client_secret: pulumi.Input[builtins.str],
                 directory_id: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a MsentraidConnection resource.
        :param pulumi.Input[builtins.str] application_id: Application (client) ID of your app registered in Microsoft Azure App registrations
        :param pulumi.Input[builtins.str] client_secret: Client secret of your app registered in Microsoft Azure App registrations
        :param pulumi.Input[builtins.str] directory_id: Directory (tenant) ID of Microsoft Entra Identity Developer
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] name: The name of the Microsoft Entra Identity Developer connection
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "directory_id", directory_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[builtins.str]:
        """
        Application (client) ID of your app registered in Microsoft Azure App registrations
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Input[builtins.str]:
        """
        Client secret of your app registered in Microsoft Azure App registrations
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Input[builtins.str]:
        """
        Directory (tenant) ID of Microsoft Entra Identity Developer
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "directory_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Microsoft Entra Identity Developer connection
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _MsentraidConnectionState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 directory_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering MsentraidConnection resources.
        :param pulumi.Input[builtins.str] application_id: Application (client) ID of your app registered in Microsoft Azure App registrations
        :param pulumi.Input[builtins.str] client_secret: Client secret of your app registered in Microsoft Azure App registrations
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] directory_id: Directory (tenant) ID of Microsoft Entra Identity Developer
        :param pulumi.Input[builtins.str] name: The name of the Microsoft Entra Identity Developer connection
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if directory_id is not None:
            pulumi.set(__self__, "directory_id", directory_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Application (client) ID of your app registered in Microsoft Azure App registrations
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Client secret of your app registered in Microsoft Azure App registrations
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Directory (tenant) ID of Microsoft Entra Identity Developer
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "directory_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Microsoft Entra Identity Developer connection
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("dynatrace:index/msentraidConnection:MsentraidConnection")
class MsentraidConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 directory_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a MsentraidConnection resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_id: Application (client) ID of your app registered in Microsoft Azure App registrations
        :param pulumi.Input[builtins.str] client_secret: Client secret of your app registered in Microsoft Azure App registrations
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] directory_id: Directory (tenant) ID of Microsoft Entra Identity Developer
        :param pulumi.Input[builtins.str] name: The name of the Microsoft Entra Identity Developer connection
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MsentraidConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a MsentraidConnection resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param MsentraidConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MsentraidConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 directory_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MsentraidConnectionArgs.__new__(MsentraidConnectionArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = None if application_id is None else pulumi.Output.secret(application_id)
            if client_secret is None and not opts.urn:
                raise TypeError("Missing required property 'client_secret'")
            __props__.__dict__["client_secret"] = None if client_secret is None else pulumi.Output.secret(client_secret)
            __props__.__dict__["description"] = description
            if directory_id is None and not opts.urn:
                raise TypeError("Missing required property 'directory_id'")
            __props__.__dict__["directory_id"] = None if directory_id is None else pulumi.Output.secret(directory_id)
            __props__.__dict__["name"] = name
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["applicationId", "clientSecret", "directoryId"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(MsentraidConnection, __self__).__init__(
            'dynatrace:index/msentraidConnection:MsentraidConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[builtins.str]] = None,
            client_secret: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            directory_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None) -> 'MsentraidConnection':
        """
        Get an existing MsentraidConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_id: Application (client) ID of your app registered in Microsoft Azure App registrations
        :param pulumi.Input[builtins.str] client_secret: Client secret of your app registered in Microsoft Azure App registrations
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] directory_id: Directory (tenant) ID of Microsoft Entra Identity Developer
        :param pulumi.Input[builtins.str] name: The name of the Microsoft Entra Identity Developer connection
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MsentraidConnectionState.__new__(_MsentraidConnectionState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["description"] = description
        __props__.__dict__["directory_id"] = directory_id
        __props__.__dict__["name"] = name
        return MsentraidConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[builtins.str]:
        """
        Application (client) ID of your app registered in Microsoft Azure App registrations
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[builtins.str]:
        """
        Client secret of your app registered in Microsoft Azure App registrations
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Output[builtins.str]:
        """
        Directory (tenant) ID of Microsoft Entra Identity Developer
        """
        return pulumi.get(self, "directory_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Microsoft Entra Identity Developer connection
        """
        return pulumi.get(self, "name")

