# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['MsteamsConnectionArgs', 'MsteamsConnection']

@pulumi.input_type
class MsteamsConnectionArgs:
    def __init__(__self__, *,
                 webhook: pulumi.Input[builtins.str],
                 channel_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 team_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a MsteamsConnection resource.
        :param pulumi.Input[builtins.str] webhook: The Webhook URL that links to the channel
        :param pulumi.Input[builtins.str] channel_name: Optional
        :param pulumi.Input[builtins.str] name: The name of the Microsoft Teams connection
        :param pulumi.Input[builtins.str] team_name: Optional
        """
        pulumi.set(__self__, "webhook", webhook)
        if channel_name is not None:
            pulumi.set(__self__, "channel_name", channel_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if team_name is not None:
            pulumi.set(__self__, "team_name", team_name)

    @property
    @pulumi.getter
    def webhook(self) -> pulumi.Input[builtins.str]:
        """
        The Webhook URL that links to the channel
        """
        return pulumi.get(self, "webhook")

    @webhook.setter
    def webhook(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "webhook", value)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Microsoft Teams connection
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="teamName")
    def team_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional
        """
        return pulumi.get(self, "team_name")

    @team_name.setter
    def team_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "team_name", value)


@pulumi.input_type
class _MsteamsConnectionState:
    def __init__(__self__, *,
                 channel_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 team_name: Optional[pulumi.Input[builtins.str]] = None,
                 webhook: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering MsteamsConnection resources.
        :param pulumi.Input[builtins.str] channel_name: Optional
        :param pulumi.Input[builtins.str] name: The name of the Microsoft Teams connection
        :param pulumi.Input[builtins.str] team_name: Optional
        :param pulumi.Input[builtins.str] webhook: The Webhook URL that links to the channel
        """
        if channel_name is not None:
            pulumi.set(__self__, "channel_name", channel_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if team_name is not None:
            pulumi.set(__self__, "team_name", team_name)
        if webhook is not None:
            pulumi.set(__self__, "webhook", webhook)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Microsoft Teams connection
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="teamName")
    def team_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional
        """
        return pulumi.get(self, "team_name")

    @team_name.setter
    def team_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "team_name", value)

    @property
    @pulumi.getter
    def webhook(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Webhook URL that links to the channel
        """
        return pulumi.get(self, "webhook")

    @webhook.setter
    def webhook(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "webhook", value)


@pulumi.type_token("dynatrace:index/msteamsConnection:MsteamsConnection")
class MsteamsConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 channel_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 team_name: Optional[pulumi.Input[builtins.str]] = None,
                 webhook: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a MsteamsConnection resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] channel_name: Optional
        :param pulumi.Input[builtins.str] name: The name of the Microsoft Teams connection
        :param pulumi.Input[builtins.str] team_name: Optional
        :param pulumi.Input[builtins.str] webhook: The Webhook URL that links to the channel
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MsteamsConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a MsteamsConnection resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param MsteamsConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MsteamsConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 channel_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 team_name: Optional[pulumi.Input[builtins.str]] = None,
                 webhook: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MsteamsConnectionArgs.__new__(MsteamsConnectionArgs)

            __props__.__dict__["channel_name"] = channel_name
            __props__.__dict__["name"] = name
            __props__.__dict__["team_name"] = team_name
            if webhook is None and not opts.urn:
                raise TypeError("Missing required property 'webhook'")
            __props__.__dict__["webhook"] = None if webhook is None else pulumi.Output.secret(webhook)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["webhook"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(MsteamsConnection, __self__).__init__(
            'dynatrace:index/msteamsConnection:MsteamsConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            channel_name: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            team_name: Optional[pulumi.Input[builtins.str]] = None,
            webhook: Optional[pulumi.Input[builtins.str]] = None) -> 'MsteamsConnection':
        """
        Get an existing MsteamsConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] channel_name: Optional
        :param pulumi.Input[builtins.str] name: The name of the Microsoft Teams connection
        :param pulumi.Input[builtins.str] team_name: Optional
        :param pulumi.Input[builtins.str] webhook: The Webhook URL that links to the channel
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MsteamsConnectionState.__new__(_MsteamsConnectionState)

        __props__.__dict__["channel_name"] = channel_name
        __props__.__dict__["name"] = name
        __props__.__dict__["team_name"] = team_name
        __props__.__dict__["webhook"] = webhook
        return MsteamsConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Optional
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Microsoft Teams connection
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="teamName")
    def team_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Optional
        """
        return pulumi.get(self, "team_name")

    @property
    @pulumi.getter
    def webhook(self) -> pulumi.Output[builtins.str]:
        """
        The Webhook URL that links to the channel
        """
        return pulumi.get(self, "webhook")

