# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['NetworkMonitorOutageArgs', 'NetworkMonitorOutage']

@pulumi.input_type
class NetworkMonitorOutageArgs:
    def __init__(__self__, *,
                 global_outages: pulumi.Input[builtins.bool],
                 local_outages: pulumi.Input[builtins.bool],
                 global_consecutive_outage_count_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 local_consecutive_outage_count_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 local_location_outage_count_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkMonitorOutage resource.
        :param pulumi.Input[builtins.bool] global_outages: Generate a problem and send an alert when the monitor is unavailable at all configured locations.
        :param pulumi.Input[builtins.bool] local_outages: Generate a problem and send an alert when the monitor is unavailable for one or more consecutive runs at any location.
        :param pulumi.Input[builtins.int] global_consecutive_outage_count_threshold: Alert if all locations are unable to access my target address
        :param pulumi.Input[builtins.int] local_consecutive_outage_count_threshold: are unable to access my target address
        :param pulumi.Input[builtins.int] local_location_outage_count_threshold: Alert if at least
        :param pulumi.Input[builtins.str] scope: The scope of this setting (MULTIPROTOCOL_MONITOR). Omit this property if you want to cover the whole environment.
        """
        pulumi.set(__self__, "global_outages", global_outages)
        pulumi.set(__self__, "local_outages", local_outages)
        if global_consecutive_outage_count_threshold is not None:
            pulumi.set(__self__, "global_consecutive_outage_count_threshold", global_consecutive_outage_count_threshold)
        if local_consecutive_outage_count_threshold is not None:
            pulumi.set(__self__, "local_consecutive_outage_count_threshold", local_consecutive_outage_count_threshold)
        if local_location_outage_count_threshold is not None:
            pulumi.set(__self__, "local_location_outage_count_threshold", local_location_outage_count_threshold)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="globalOutages")
    def global_outages(self) -> pulumi.Input[builtins.bool]:
        """
        Generate a problem and send an alert when the monitor is unavailable at all configured locations.
        """
        return pulumi.get(self, "global_outages")

    @global_outages.setter
    def global_outages(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "global_outages", value)

    @property
    @pulumi.getter(name="localOutages")
    def local_outages(self) -> pulumi.Input[builtins.bool]:
        """
        Generate a problem and send an alert when the monitor is unavailable for one or more consecutive runs at any location.
        """
        return pulumi.get(self, "local_outages")

    @local_outages.setter
    def local_outages(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "local_outages", value)

    @property
    @pulumi.getter(name="globalConsecutiveOutageCountThreshold")
    def global_consecutive_outage_count_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Alert if all locations are unable to access my target address
        """
        return pulumi.get(self, "global_consecutive_outage_count_threshold")

    @global_consecutive_outage_count_threshold.setter
    def global_consecutive_outage_count_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "global_consecutive_outage_count_threshold", value)

    @property
    @pulumi.getter(name="localConsecutiveOutageCountThreshold")
    def local_consecutive_outage_count_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        are unable to access my target address
        """
        return pulumi.get(self, "local_consecutive_outage_count_threshold")

    @local_consecutive_outage_count_threshold.setter
    def local_consecutive_outage_count_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "local_consecutive_outage_count_threshold", value)

    @property
    @pulumi.getter(name="localLocationOutageCountThreshold")
    def local_location_outage_count_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Alert if at least
        """
        return pulumi.get(self, "local_location_outage_count_threshold")

    @local_location_outage_count_threshold.setter
    def local_location_outage_count_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "local_location_outage_count_threshold", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of this setting (MULTIPROTOCOL_MONITOR). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class _NetworkMonitorOutageState:
    def __init__(__self__, *,
                 global_consecutive_outage_count_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 global_outages: Optional[pulumi.Input[builtins.bool]] = None,
                 local_consecutive_outage_count_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 local_location_outage_count_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 local_outages: Optional[pulumi.Input[builtins.bool]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkMonitorOutage resources.
        :param pulumi.Input[builtins.int] global_consecutive_outage_count_threshold: Alert if all locations are unable to access my target address
        :param pulumi.Input[builtins.bool] global_outages: Generate a problem and send an alert when the monitor is unavailable at all configured locations.
        :param pulumi.Input[builtins.int] local_consecutive_outage_count_threshold: are unable to access my target address
        :param pulumi.Input[builtins.int] local_location_outage_count_threshold: Alert if at least
        :param pulumi.Input[builtins.bool] local_outages: Generate a problem and send an alert when the monitor is unavailable for one or more consecutive runs at any location.
        :param pulumi.Input[builtins.str] scope: The scope of this setting (MULTIPROTOCOL_MONITOR). Omit this property if you want to cover the whole environment.
        """
        if global_consecutive_outage_count_threshold is not None:
            pulumi.set(__self__, "global_consecutive_outage_count_threshold", global_consecutive_outage_count_threshold)
        if global_outages is not None:
            pulumi.set(__self__, "global_outages", global_outages)
        if local_consecutive_outage_count_threshold is not None:
            pulumi.set(__self__, "local_consecutive_outage_count_threshold", local_consecutive_outage_count_threshold)
        if local_location_outage_count_threshold is not None:
            pulumi.set(__self__, "local_location_outage_count_threshold", local_location_outage_count_threshold)
        if local_outages is not None:
            pulumi.set(__self__, "local_outages", local_outages)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="globalConsecutiveOutageCountThreshold")
    def global_consecutive_outage_count_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Alert if all locations are unable to access my target address
        """
        return pulumi.get(self, "global_consecutive_outage_count_threshold")

    @global_consecutive_outage_count_threshold.setter
    def global_consecutive_outage_count_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "global_consecutive_outage_count_threshold", value)

    @property
    @pulumi.getter(name="globalOutages")
    def global_outages(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Generate a problem and send an alert when the monitor is unavailable at all configured locations.
        """
        return pulumi.get(self, "global_outages")

    @global_outages.setter
    def global_outages(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "global_outages", value)

    @property
    @pulumi.getter(name="localConsecutiveOutageCountThreshold")
    def local_consecutive_outage_count_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        are unable to access my target address
        """
        return pulumi.get(self, "local_consecutive_outage_count_threshold")

    @local_consecutive_outage_count_threshold.setter
    def local_consecutive_outage_count_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "local_consecutive_outage_count_threshold", value)

    @property
    @pulumi.getter(name="localLocationOutageCountThreshold")
    def local_location_outage_count_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Alert if at least
        """
        return pulumi.get(self, "local_location_outage_count_threshold")

    @local_location_outage_count_threshold.setter
    def local_location_outage_count_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "local_location_outage_count_threshold", value)

    @property
    @pulumi.getter(name="localOutages")
    def local_outages(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Generate a problem and send an alert when the monitor is unavailable for one or more consecutive runs at any location.
        """
        return pulumi.get(self, "local_outages")

    @local_outages.setter
    def local_outages(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "local_outages", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of this setting (MULTIPROTOCOL_MONITOR). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)


@pulumi.type_token("dynatrace:index/networkMonitorOutage:NetworkMonitorOutage")
class NetworkMonitorOutage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 global_consecutive_outage_count_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 global_outages: Optional[pulumi.Input[builtins.bool]] = None,
                 local_consecutive_outage_count_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 local_location_outage_count_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 local_outages: Optional[pulumi.Input[builtins.bool]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a NetworkMonitorOutage resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] global_consecutive_outage_count_threshold: Alert if all locations are unable to access my target address
        :param pulumi.Input[builtins.bool] global_outages: Generate a problem and send an alert when the monitor is unavailable at all configured locations.
        :param pulumi.Input[builtins.int] local_consecutive_outage_count_threshold: are unable to access my target address
        :param pulumi.Input[builtins.int] local_location_outage_count_threshold: Alert if at least
        :param pulumi.Input[builtins.bool] local_outages: Generate a problem and send an alert when the monitor is unavailable for one or more consecutive runs at any location.
        :param pulumi.Input[builtins.str] scope: The scope of this setting (MULTIPROTOCOL_MONITOR). Omit this property if you want to cover the whole environment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkMonitorOutageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a NetworkMonitorOutage resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param NetworkMonitorOutageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkMonitorOutageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 global_consecutive_outage_count_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 global_outages: Optional[pulumi.Input[builtins.bool]] = None,
                 local_consecutive_outage_count_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 local_location_outage_count_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 local_outages: Optional[pulumi.Input[builtins.bool]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkMonitorOutageArgs.__new__(NetworkMonitorOutageArgs)

            __props__.__dict__["global_consecutive_outage_count_threshold"] = global_consecutive_outage_count_threshold
            if global_outages is None and not opts.urn:
                raise TypeError("Missing required property 'global_outages'")
            __props__.__dict__["global_outages"] = global_outages
            __props__.__dict__["local_consecutive_outage_count_threshold"] = local_consecutive_outage_count_threshold
            __props__.__dict__["local_location_outage_count_threshold"] = local_location_outage_count_threshold
            if local_outages is None and not opts.urn:
                raise TypeError("Missing required property 'local_outages'")
            __props__.__dict__["local_outages"] = local_outages
            __props__.__dict__["scope"] = scope
        super(NetworkMonitorOutage, __self__).__init__(
            'dynatrace:index/networkMonitorOutage:NetworkMonitorOutage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            global_consecutive_outage_count_threshold: Optional[pulumi.Input[builtins.int]] = None,
            global_outages: Optional[pulumi.Input[builtins.bool]] = None,
            local_consecutive_outage_count_threshold: Optional[pulumi.Input[builtins.int]] = None,
            local_location_outage_count_threshold: Optional[pulumi.Input[builtins.int]] = None,
            local_outages: Optional[pulumi.Input[builtins.bool]] = None,
            scope: Optional[pulumi.Input[builtins.str]] = None) -> 'NetworkMonitorOutage':
        """
        Get an existing NetworkMonitorOutage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] global_consecutive_outage_count_threshold: Alert if all locations are unable to access my target address
        :param pulumi.Input[builtins.bool] global_outages: Generate a problem and send an alert when the monitor is unavailable at all configured locations.
        :param pulumi.Input[builtins.int] local_consecutive_outage_count_threshold: are unable to access my target address
        :param pulumi.Input[builtins.int] local_location_outage_count_threshold: Alert if at least
        :param pulumi.Input[builtins.bool] local_outages: Generate a problem and send an alert when the monitor is unavailable for one or more consecutive runs at any location.
        :param pulumi.Input[builtins.str] scope: The scope of this setting (MULTIPROTOCOL_MONITOR). Omit this property if you want to cover the whole environment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkMonitorOutageState.__new__(_NetworkMonitorOutageState)

        __props__.__dict__["global_consecutive_outage_count_threshold"] = global_consecutive_outage_count_threshold
        __props__.__dict__["global_outages"] = global_outages
        __props__.__dict__["local_consecutive_outage_count_threshold"] = local_consecutive_outage_count_threshold
        __props__.__dict__["local_location_outage_count_threshold"] = local_location_outage_count_threshold
        __props__.__dict__["local_outages"] = local_outages
        __props__.__dict__["scope"] = scope
        return NetworkMonitorOutage(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="globalConsecutiveOutageCountThreshold")
    def global_consecutive_outage_count_threshold(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Alert if all locations are unable to access my target address
        """
        return pulumi.get(self, "global_consecutive_outage_count_threshold")

    @property
    @pulumi.getter(name="globalOutages")
    def global_outages(self) -> pulumi.Output[builtins.bool]:
        """
        Generate a problem and send an alert when the monitor is unavailable at all configured locations.
        """
        return pulumi.get(self, "global_outages")

    @property
    @pulumi.getter(name="localConsecutiveOutageCountThreshold")
    def local_consecutive_outage_count_threshold(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        are unable to access my target address
        """
        return pulumi.get(self, "local_consecutive_outage_count_threshold")

    @property
    @pulumi.getter(name="localLocationOutageCountThreshold")
    def local_location_outage_count_threshold(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Alert if at least
        """
        return pulumi.get(self, "local_location_outage_count_threshold")

    @property
    @pulumi.getter(name="localOutages")
    def local_outages(self) -> pulumi.Output[builtins.bool]:
        """
        Generate a problem and send an alert when the monitor is unavailable for one or more consecutive runs at any location.
        """
        return pulumi.get(self, "local_outages")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The scope of this setting (MULTIPROTOCOL_MONITOR). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

