# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkTrafficArgs', 'NetworkTraffic']

@pulumi.input_type
class NetworkTrafficArgs:
    def __init__(__self__, *,
                 host_id: pulumi.Input[builtins.str],
                 exclude_ip: Optional[pulumi.Input['NetworkTrafficExcludeIpArgs']] = None,
                 exclude_nic: Optional[pulumi.Input['NetworkTrafficExcludeNicArgs']] = None):
        """
        The set of arguments for constructing a NetworkTraffic resource.
        :param pulumi.Input[builtins.str] host_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        :param pulumi.Input['NetworkTrafficExcludeIpArgs'] exclude_ip: Providing a host IP address, you will exclude network traffic only in calculating connectivity (other metrics will still be calculated).
        :param pulumi.Input['NetworkTrafficExcludeNicArgs'] exclude_nic: Selecting a network interface, you will exclude all network traffic on that interface from being monitored. You can select from the list below what to not monitor, or input it manually using the "other one" option.
        """
        pulumi.set(__self__, "host_id", host_id)
        if exclude_ip is not None:
            pulumi.set(__self__, "exclude_ip", exclude_ip)
        if exclude_nic is not None:
            pulumi.set(__self__, "exclude_nic", exclude_nic)

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> pulumi.Input[builtins.str]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "host_id")

    @host_id.setter
    def host_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "host_id", value)

    @property
    @pulumi.getter(name="excludeIp")
    def exclude_ip(self) -> Optional[pulumi.Input['NetworkTrafficExcludeIpArgs']]:
        """
        Providing a host IP address, you will exclude network traffic only in calculating connectivity (other metrics will still be calculated).
        """
        return pulumi.get(self, "exclude_ip")

    @exclude_ip.setter
    def exclude_ip(self, value: Optional[pulumi.Input['NetworkTrafficExcludeIpArgs']]):
        pulumi.set(self, "exclude_ip", value)

    @property
    @pulumi.getter(name="excludeNic")
    def exclude_nic(self) -> Optional[pulumi.Input['NetworkTrafficExcludeNicArgs']]:
        """
        Selecting a network interface, you will exclude all network traffic on that interface from being monitored. You can select from the list below what to not monitor, or input it manually using the "other one" option.
        """
        return pulumi.get(self, "exclude_nic")

    @exclude_nic.setter
    def exclude_nic(self, value: Optional[pulumi.Input['NetworkTrafficExcludeNicArgs']]):
        pulumi.set(self, "exclude_nic", value)


@pulumi.input_type
class _NetworkTrafficState:
    def __init__(__self__, *,
                 exclude_ip: Optional[pulumi.Input['NetworkTrafficExcludeIpArgs']] = None,
                 exclude_nic: Optional[pulumi.Input['NetworkTrafficExcludeNicArgs']] = None,
                 host_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkTraffic resources.
        :param pulumi.Input['NetworkTrafficExcludeIpArgs'] exclude_ip: Providing a host IP address, you will exclude network traffic only in calculating connectivity (other metrics will still be calculated).
        :param pulumi.Input['NetworkTrafficExcludeNicArgs'] exclude_nic: Selecting a network interface, you will exclude all network traffic on that interface from being monitored. You can select from the list below what to not monitor, or input it manually using the "other one" option.
        :param pulumi.Input[builtins.str] host_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        if exclude_ip is not None:
            pulumi.set(__self__, "exclude_ip", exclude_ip)
        if exclude_nic is not None:
            pulumi.set(__self__, "exclude_nic", exclude_nic)
        if host_id is not None:
            pulumi.set(__self__, "host_id", host_id)

    @property
    @pulumi.getter(name="excludeIp")
    def exclude_ip(self) -> Optional[pulumi.Input['NetworkTrafficExcludeIpArgs']]:
        """
        Providing a host IP address, you will exclude network traffic only in calculating connectivity (other metrics will still be calculated).
        """
        return pulumi.get(self, "exclude_ip")

    @exclude_ip.setter
    def exclude_ip(self, value: Optional[pulumi.Input['NetworkTrafficExcludeIpArgs']]):
        pulumi.set(self, "exclude_ip", value)

    @property
    @pulumi.getter(name="excludeNic")
    def exclude_nic(self) -> Optional[pulumi.Input['NetworkTrafficExcludeNicArgs']]:
        """
        Selecting a network interface, you will exclude all network traffic on that interface from being monitored. You can select from the list below what to not monitor, or input it manually using the "other one" option.
        """
        return pulumi.get(self, "exclude_nic")

    @exclude_nic.setter
    def exclude_nic(self, value: Optional[pulumi.Input['NetworkTrafficExcludeNicArgs']]):
        pulumi.set(self, "exclude_nic", value)

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "host_id")

    @host_id.setter
    def host_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_id", value)


@pulumi.type_token("dynatrace:index/networkTraffic:NetworkTraffic")
class NetworkTraffic(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 exclude_ip: Optional[pulumi.Input[Union['NetworkTrafficExcludeIpArgs', 'NetworkTrafficExcludeIpArgsDict']]] = None,
                 exclude_nic: Optional[pulumi.Input[Union['NetworkTrafficExcludeNicArgs', 'NetworkTrafficExcludeNicArgsDict']]] = None,
                 host_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a NetworkTraffic resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['NetworkTrafficExcludeIpArgs', 'NetworkTrafficExcludeIpArgsDict']] exclude_ip: Providing a host IP address, you will exclude network traffic only in calculating connectivity (other metrics will still be calculated).
        :param pulumi.Input[Union['NetworkTrafficExcludeNicArgs', 'NetworkTrafficExcludeNicArgsDict']] exclude_nic: Selecting a network interface, you will exclude all network traffic on that interface from being monitored. You can select from the list below what to not monitor, or input it manually using the "other one" option.
        :param pulumi.Input[builtins.str] host_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkTrafficArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a NetworkTraffic resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param NetworkTrafficArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkTrafficArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 exclude_ip: Optional[pulumi.Input[Union['NetworkTrafficExcludeIpArgs', 'NetworkTrafficExcludeIpArgsDict']]] = None,
                 exclude_nic: Optional[pulumi.Input[Union['NetworkTrafficExcludeNicArgs', 'NetworkTrafficExcludeNicArgsDict']]] = None,
                 host_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkTrafficArgs.__new__(NetworkTrafficArgs)

            __props__.__dict__["exclude_ip"] = exclude_ip
            __props__.__dict__["exclude_nic"] = exclude_nic
            if host_id is None and not opts.urn:
                raise TypeError("Missing required property 'host_id'")
            __props__.__dict__["host_id"] = host_id
        super(NetworkTraffic, __self__).__init__(
            'dynatrace:index/networkTraffic:NetworkTraffic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            exclude_ip: Optional[pulumi.Input[Union['NetworkTrafficExcludeIpArgs', 'NetworkTrafficExcludeIpArgsDict']]] = None,
            exclude_nic: Optional[pulumi.Input[Union['NetworkTrafficExcludeNicArgs', 'NetworkTrafficExcludeNicArgsDict']]] = None,
            host_id: Optional[pulumi.Input[builtins.str]] = None) -> 'NetworkTraffic':
        """
        Get an existing NetworkTraffic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['NetworkTrafficExcludeIpArgs', 'NetworkTrafficExcludeIpArgsDict']] exclude_ip: Providing a host IP address, you will exclude network traffic only in calculating connectivity (other metrics will still be calculated).
        :param pulumi.Input[Union['NetworkTrafficExcludeNicArgs', 'NetworkTrafficExcludeNicArgsDict']] exclude_nic: Selecting a network interface, you will exclude all network traffic on that interface from being monitored. You can select from the list below what to not monitor, or input it manually using the "other one" option.
        :param pulumi.Input[builtins.str] host_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkTrafficState.__new__(_NetworkTrafficState)

        __props__.__dict__["exclude_ip"] = exclude_ip
        __props__.__dict__["exclude_nic"] = exclude_nic
        __props__.__dict__["host_id"] = host_id
        return NetworkTraffic(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="excludeIp")
    def exclude_ip(self) -> pulumi.Output[Optional['outputs.NetworkTrafficExcludeIp']]:
        """
        Providing a host IP address, you will exclude network traffic only in calculating connectivity (other metrics will still be calculated).
        """
        return pulumi.get(self, "exclude_ip")

    @property
    @pulumi.getter(name="excludeNic")
    def exclude_nic(self) -> pulumi.Output[Optional['outputs.NetworkTrafficExcludeNic']]:
        """
        Selecting a network interface, you will exclude all network traffic on that interface from being monitored. You can select from the list below what to not monitor, or input it manually using the "other one" option.
        """
        return pulumi.get(self, "exclude_nic")

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> pulumi.Output[builtins.str]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "host_id")

