# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['NetworkZoneArgs', 'NetworkZone']

@pulumi.input_type
class NetworkZoneArgs:
    def __init__(__self__, *,
                 alternative_zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 fallback_mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 num_of_configured_activegates: Optional[pulumi.Input[builtins.int]] = None,
                 num_of_configured_oneagents: Optional[pulumi.Input[builtins.int]] = None,
                 num_of_oneagents_from_other_zones: Optional[pulumi.Input[builtins.int]] = None,
                 num_of_oneagents_using: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a NetworkZone resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] alternative_zones: A list of alternative network zones.
        :param pulumi.Input[builtins.str] description: A short description of the network zone
        :param pulumi.Input[builtins.str] fallback_mode: The fallback mode of the network zone. Possible values: `ANY_ACTIVE_GATE`, `NONE`, `ONLY_DEFAULT_ZONE`
        :param pulumi.Input[builtins.str] name: Name of the network zone cannot be modified once created. Dynatrace stores the field in lowercase, allowed characters: alphanumeric, hyphen, underscore, dot
        :param pulumi.Input[builtins.int] num_of_configured_activegates: The number of ActiveGates in the network zone.
        :param pulumi.Input[builtins.int] num_of_configured_oneagents: The number of OneAgents that are configured to use the network zone as primary.
        :param pulumi.Input[builtins.int] num_of_oneagents_from_other_zones: The number of OneAgents from other network zones that are using ActiveGates in the network zone.
        :param pulumi.Input[builtins.int] num_of_oneagents_using: The number of OneAgents that are using ActiveGates in the network zone.
        """
        if alternative_zones is not None:
            pulumi.set(__self__, "alternative_zones", alternative_zones)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fallback_mode is not None:
            pulumi.set(__self__, "fallback_mode", fallback_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if num_of_configured_activegates is not None:
            pulumi.set(__self__, "num_of_configured_activegates", num_of_configured_activegates)
        if num_of_configured_oneagents is not None:
            pulumi.set(__self__, "num_of_configured_oneagents", num_of_configured_oneagents)
        if num_of_oneagents_from_other_zones is not None:
            pulumi.set(__self__, "num_of_oneagents_from_other_zones", num_of_oneagents_from_other_zones)
        if num_of_oneagents_using is not None:
            pulumi.set(__self__, "num_of_oneagents_using", num_of_oneagents_using)

    @property
    @pulumi.getter(name="alternativeZones")
    def alternative_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of alternative network zones.
        """
        return pulumi.get(self, "alternative_zones")

    @alternative_zones.setter
    def alternative_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "alternative_zones", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A short description of the network zone
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fallbackMode")
    def fallback_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The fallback mode of the network zone. Possible values: `ANY_ACTIVE_GATE`, `NONE`, `ONLY_DEFAULT_ZONE`
        """
        return pulumi.get(self, "fallback_mode")

    @fallback_mode.setter
    def fallback_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fallback_mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the network zone cannot be modified once created. Dynatrace stores the field in lowercase, allowed characters: alphanumeric, hyphen, underscore, dot
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numOfConfiguredActivegates")
    def num_of_configured_activegates(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of ActiveGates in the network zone.
        """
        return pulumi.get(self, "num_of_configured_activegates")

    @num_of_configured_activegates.setter
    def num_of_configured_activegates(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "num_of_configured_activegates", value)

    @property
    @pulumi.getter(name="numOfConfiguredOneagents")
    def num_of_configured_oneagents(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of OneAgents that are configured to use the network zone as primary.
        """
        return pulumi.get(self, "num_of_configured_oneagents")

    @num_of_configured_oneagents.setter
    def num_of_configured_oneagents(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "num_of_configured_oneagents", value)

    @property
    @pulumi.getter(name="numOfOneagentsFromOtherZones")
    def num_of_oneagents_from_other_zones(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of OneAgents from other network zones that are using ActiveGates in the network zone.
        """
        return pulumi.get(self, "num_of_oneagents_from_other_zones")

    @num_of_oneagents_from_other_zones.setter
    def num_of_oneagents_from_other_zones(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "num_of_oneagents_from_other_zones", value)

    @property
    @pulumi.getter(name="numOfOneagentsUsing")
    def num_of_oneagents_using(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of OneAgents that are using ActiveGates in the network zone.
        """
        return pulumi.get(self, "num_of_oneagents_using")

    @num_of_oneagents_using.setter
    def num_of_oneagents_using(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "num_of_oneagents_using", value)


@pulumi.input_type
class _NetworkZoneState:
    def __init__(__self__, *,
                 alternative_zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 fallback_mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 num_of_configured_activegates: Optional[pulumi.Input[builtins.int]] = None,
                 num_of_configured_oneagents: Optional[pulumi.Input[builtins.int]] = None,
                 num_of_oneagents_from_other_zones: Optional[pulumi.Input[builtins.int]] = None,
                 num_of_oneagents_using: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering NetworkZone resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] alternative_zones: A list of alternative network zones.
        :param pulumi.Input[builtins.str] description: A short description of the network zone
        :param pulumi.Input[builtins.str] fallback_mode: The fallback mode of the network zone. Possible values: `ANY_ACTIVE_GATE`, `NONE`, `ONLY_DEFAULT_ZONE`
        :param pulumi.Input[builtins.str] name: Name of the network zone cannot be modified once created. Dynatrace stores the field in lowercase, allowed characters: alphanumeric, hyphen, underscore, dot
        :param pulumi.Input[builtins.int] num_of_configured_activegates: The number of ActiveGates in the network zone.
        :param pulumi.Input[builtins.int] num_of_configured_oneagents: The number of OneAgents that are configured to use the network zone as primary.
        :param pulumi.Input[builtins.int] num_of_oneagents_from_other_zones: The number of OneAgents from other network zones that are using ActiveGates in the network zone.
        :param pulumi.Input[builtins.int] num_of_oneagents_using: The number of OneAgents that are using ActiveGates in the network zone.
        """
        if alternative_zones is not None:
            pulumi.set(__self__, "alternative_zones", alternative_zones)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fallback_mode is not None:
            pulumi.set(__self__, "fallback_mode", fallback_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if num_of_configured_activegates is not None:
            pulumi.set(__self__, "num_of_configured_activegates", num_of_configured_activegates)
        if num_of_configured_oneagents is not None:
            pulumi.set(__self__, "num_of_configured_oneagents", num_of_configured_oneagents)
        if num_of_oneagents_from_other_zones is not None:
            pulumi.set(__self__, "num_of_oneagents_from_other_zones", num_of_oneagents_from_other_zones)
        if num_of_oneagents_using is not None:
            pulumi.set(__self__, "num_of_oneagents_using", num_of_oneagents_using)

    @property
    @pulumi.getter(name="alternativeZones")
    def alternative_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of alternative network zones.
        """
        return pulumi.get(self, "alternative_zones")

    @alternative_zones.setter
    def alternative_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "alternative_zones", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A short description of the network zone
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fallbackMode")
    def fallback_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The fallback mode of the network zone. Possible values: `ANY_ACTIVE_GATE`, `NONE`, `ONLY_DEFAULT_ZONE`
        """
        return pulumi.get(self, "fallback_mode")

    @fallback_mode.setter
    def fallback_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fallback_mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the network zone cannot be modified once created. Dynatrace stores the field in lowercase, allowed characters: alphanumeric, hyphen, underscore, dot
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numOfConfiguredActivegates")
    def num_of_configured_activegates(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of ActiveGates in the network zone.
        """
        return pulumi.get(self, "num_of_configured_activegates")

    @num_of_configured_activegates.setter
    def num_of_configured_activegates(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "num_of_configured_activegates", value)

    @property
    @pulumi.getter(name="numOfConfiguredOneagents")
    def num_of_configured_oneagents(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of OneAgents that are configured to use the network zone as primary.
        """
        return pulumi.get(self, "num_of_configured_oneagents")

    @num_of_configured_oneagents.setter
    def num_of_configured_oneagents(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "num_of_configured_oneagents", value)

    @property
    @pulumi.getter(name="numOfOneagentsFromOtherZones")
    def num_of_oneagents_from_other_zones(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of OneAgents from other network zones that are using ActiveGates in the network zone.
        """
        return pulumi.get(self, "num_of_oneagents_from_other_zones")

    @num_of_oneagents_from_other_zones.setter
    def num_of_oneagents_from_other_zones(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "num_of_oneagents_from_other_zones", value)

    @property
    @pulumi.getter(name="numOfOneagentsUsing")
    def num_of_oneagents_using(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of OneAgents that are using ActiveGates in the network zone.
        """
        return pulumi.get(self, "num_of_oneagents_using")

    @num_of_oneagents_using.setter
    def num_of_oneagents_using(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "num_of_oneagents_using", value)


@pulumi.type_token("dynatrace:index/networkZone:NetworkZone")
class NetworkZone(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alternative_zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 fallback_mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 num_of_configured_activegates: Optional[pulumi.Input[builtins.int]] = None,
                 num_of_configured_oneagents: Optional[pulumi.Input[builtins.int]] = None,
                 num_of_oneagents_from_other_zones: Optional[pulumi.Input[builtins.int]] = None,
                 num_of_oneagents_using: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        Create a NetworkZone resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] alternative_zones: A list of alternative network zones.
        :param pulumi.Input[builtins.str] description: A short description of the network zone
        :param pulumi.Input[builtins.str] fallback_mode: The fallback mode of the network zone. Possible values: `ANY_ACTIVE_GATE`, `NONE`, `ONLY_DEFAULT_ZONE`
        :param pulumi.Input[builtins.str] name: Name of the network zone cannot be modified once created. Dynatrace stores the field in lowercase, allowed characters: alphanumeric, hyphen, underscore, dot
        :param pulumi.Input[builtins.int] num_of_configured_activegates: The number of ActiveGates in the network zone.
        :param pulumi.Input[builtins.int] num_of_configured_oneagents: The number of OneAgents that are configured to use the network zone as primary.
        :param pulumi.Input[builtins.int] num_of_oneagents_from_other_zones: The number of OneAgents from other network zones that are using ActiveGates in the network zone.
        :param pulumi.Input[builtins.int] num_of_oneagents_using: The number of OneAgents that are using ActiveGates in the network zone.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[NetworkZoneArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a NetworkZone resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param NetworkZoneArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkZoneArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alternative_zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 fallback_mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 num_of_configured_activegates: Optional[pulumi.Input[builtins.int]] = None,
                 num_of_configured_oneagents: Optional[pulumi.Input[builtins.int]] = None,
                 num_of_oneagents_from_other_zones: Optional[pulumi.Input[builtins.int]] = None,
                 num_of_oneagents_using: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkZoneArgs.__new__(NetworkZoneArgs)

            __props__.__dict__["alternative_zones"] = alternative_zones
            __props__.__dict__["description"] = description
            __props__.__dict__["fallback_mode"] = fallback_mode
            __props__.__dict__["name"] = name
            __props__.__dict__["num_of_configured_activegates"] = num_of_configured_activegates
            __props__.__dict__["num_of_configured_oneagents"] = num_of_configured_oneagents
            __props__.__dict__["num_of_oneagents_from_other_zones"] = num_of_oneagents_from_other_zones
            __props__.__dict__["num_of_oneagents_using"] = num_of_oneagents_using
        super(NetworkZone, __self__).__init__(
            'dynatrace:index/networkZone:NetworkZone',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alternative_zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            fallback_mode: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            num_of_configured_activegates: Optional[pulumi.Input[builtins.int]] = None,
            num_of_configured_oneagents: Optional[pulumi.Input[builtins.int]] = None,
            num_of_oneagents_from_other_zones: Optional[pulumi.Input[builtins.int]] = None,
            num_of_oneagents_using: Optional[pulumi.Input[builtins.int]] = None) -> 'NetworkZone':
        """
        Get an existing NetworkZone resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] alternative_zones: A list of alternative network zones.
        :param pulumi.Input[builtins.str] description: A short description of the network zone
        :param pulumi.Input[builtins.str] fallback_mode: The fallback mode of the network zone. Possible values: `ANY_ACTIVE_GATE`, `NONE`, `ONLY_DEFAULT_ZONE`
        :param pulumi.Input[builtins.str] name: Name of the network zone cannot be modified once created. Dynatrace stores the field in lowercase, allowed characters: alphanumeric, hyphen, underscore, dot
        :param pulumi.Input[builtins.int] num_of_configured_activegates: The number of ActiveGates in the network zone.
        :param pulumi.Input[builtins.int] num_of_configured_oneagents: The number of OneAgents that are configured to use the network zone as primary.
        :param pulumi.Input[builtins.int] num_of_oneagents_from_other_zones: The number of OneAgents from other network zones that are using ActiveGates in the network zone.
        :param pulumi.Input[builtins.int] num_of_oneagents_using: The number of OneAgents that are using ActiveGates in the network zone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkZoneState.__new__(_NetworkZoneState)

        __props__.__dict__["alternative_zones"] = alternative_zones
        __props__.__dict__["description"] = description
        __props__.__dict__["fallback_mode"] = fallback_mode
        __props__.__dict__["name"] = name
        __props__.__dict__["num_of_configured_activegates"] = num_of_configured_activegates
        __props__.__dict__["num_of_configured_oneagents"] = num_of_configured_oneagents
        __props__.__dict__["num_of_oneagents_from_other_zones"] = num_of_oneagents_from_other_zones
        __props__.__dict__["num_of_oneagents_using"] = num_of_oneagents_using
        return NetworkZone(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alternativeZones")
    def alternative_zones(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of alternative network zones.
        """
        return pulumi.get(self, "alternative_zones")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A short description of the network zone
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fallbackMode")
    def fallback_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The fallback mode of the network zone. Possible values: `ANY_ACTIVE_GATE`, `NONE`, `ONLY_DEFAULT_ZONE`
        """
        return pulumi.get(self, "fallback_mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the network zone cannot be modified once created. Dynatrace stores the field in lowercase, allowed characters: alphanumeric, hyphen, underscore, dot
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numOfConfiguredActivegates")
    def num_of_configured_activegates(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of ActiveGates in the network zone.
        """
        return pulumi.get(self, "num_of_configured_activegates")

    @property
    @pulumi.getter(name="numOfConfiguredOneagents")
    def num_of_configured_oneagents(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of OneAgents that are configured to use the network zone as primary.
        """
        return pulumi.get(self, "num_of_configured_oneagents")

    @property
    @pulumi.getter(name="numOfOneagentsFromOtherZones")
    def num_of_oneagents_from_other_zones(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of OneAgents from other network zones that are using ActiveGates in the network zone.
        """
        return pulumi.get(self, "num_of_oneagents_from_other_zones")

    @property
    @pulumi.getter(name="numOfOneagentsUsing")
    def num_of_oneagents_using(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of OneAgents that are using ActiveGates in the network zone.
        """
        return pulumi.get(self, "num_of_oneagents_using")

