# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OsServicesArgs', 'OsServices']

@pulumi.input_type
class OsServicesArgs:
    def __init__(__self__, *,
                 alerting: pulumi.Input[builtins.bool],
                 enabled: pulumi.Input[builtins.bool],
                 monitoring: pulumi.Input[builtins.bool],
                 system: pulumi.Input[builtins.str],
                 alert_activation_duration: Optional[pulumi.Input[builtins.int]] = None,
                 detection_conditions_linux: Optional[pulumi.Input['OsServicesDetectionConditionsLinuxArgs']] = None,
                 detection_conditions_windows: Optional[pulumi.Input['OsServicesDetectionConditionsWindowsArgs']] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input['OsServicesMetadataArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 not_installed_alerting: Optional[pulumi.Input[builtins.bool]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 status_condition_linux: Optional[pulumi.Input[builtins.str]] = None,
                 status_condition_windows: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a OsServices resource.
        :param pulumi.Input[builtins.bool] alerting: Toggle the switch in order to enable or disable alerting for this policy
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.bool] monitoring: Toggle the switch in order to enable or disable availability metric monitoring for this policy. Availability metrics produce custom metrics. Refer to [documentation](https://dt-url.net/vl03xzk) for consumption examples. Each monitored service consumes one custom metric.
        :param pulumi.Input[builtins.str] system: Possible Values: `LINUX`, `WINDOWS`
        :param pulumi.Input[builtins.int] alert_activation_duration: The number of **10-second measurement cycles** before alerting is triggered
        :param pulumi.Input['OsServicesDetectionConditionsLinuxArgs'] detection_conditions_linux: Detection rules
        :param pulumi.Input['OsServicesDetectionConditionsWindowsArgs'] detection_conditions_windows: Detection rules
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input['OsServicesMetadataArgs'] metadata: Set of additional key-value properties to be attached to the triggered event.
        :param pulumi.Input[builtins.str] name: Rule name
        :param pulumi.Input[builtins.bool] not_installed_alerting: By default, Dynatrace does not alert if the service is not installed. Toggle the switch to enable or disable this feature
        :param pulumi.Input[builtins.str] scope: The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        :param pulumi.Input[builtins.str] status_condition_linux: This string has to match a required format. See [OS services monitoring](https://dt-url.net/vl03xzk).
        :param pulumi.Input[builtins.str] status_condition_windows: This string has to match a required format. See [OS services monitoring](https://dt-url.net/vl03xzk). - `$eq(paused)`
               – Matches services that are in paused state. Available logic operations: - `$not($eq(paused))` – Matches services
               that are in state different from paused. - `$or($eq(paused),$eq(running))` – Matches services that are either in
               paused or running state. Use one of the following values as a parameter for this condition: - `running` - `stopped` -
               `start_pending` - `stop_pending` - `continue_pending` - `pause_pending` - `paused`
        """
        pulumi.set(__self__, "alerting", alerting)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "monitoring", monitoring)
        pulumi.set(__self__, "system", system)
        if alert_activation_duration is not None:
            pulumi.set(__self__, "alert_activation_duration", alert_activation_duration)
        if detection_conditions_linux is not None:
            pulumi.set(__self__, "detection_conditions_linux", detection_conditions_linux)
        if detection_conditions_windows is not None:
            pulumi.set(__self__, "detection_conditions_windows", detection_conditions_windows)
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if not_installed_alerting is not None:
            pulumi.set(__self__, "not_installed_alerting", not_installed_alerting)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if status_condition_linux is not None:
            pulumi.set(__self__, "status_condition_linux", status_condition_linux)
        if status_condition_windows is not None:
            pulumi.set(__self__, "status_condition_windows", status_condition_windows)

    @property
    @pulumi.getter
    def alerting(self) -> pulumi.Input[builtins.bool]:
        """
        Toggle the switch in order to enable or disable alerting for this policy
        """
        return pulumi.get(self, "alerting")

    @alerting.setter
    def alerting(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "alerting", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def monitoring(self) -> pulumi.Input[builtins.bool]:
        """
        Toggle the switch in order to enable or disable availability metric monitoring for this policy. Availability metrics produce custom metrics. Refer to [documentation](https://dt-url.net/vl03xzk) for consumption examples. Each monitored service consumes one custom metric.
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "monitoring", value)

    @property
    @pulumi.getter
    def system(self) -> pulumi.Input[builtins.str]:
        """
        Possible Values: `LINUX`, `WINDOWS`
        """
        return pulumi.get(self, "system")

    @system.setter
    def system(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "system", value)

    @property
    @pulumi.getter(name="alertActivationDuration")
    def alert_activation_duration(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of **10-second measurement cycles** before alerting is triggered
        """
        return pulumi.get(self, "alert_activation_duration")

    @alert_activation_duration.setter
    def alert_activation_duration(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "alert_activation_duration", value)

    @property
    @pulumi.getter(name="detectionConditionsLinux")
    def detection_conditions_linux(self) -> Optional[pulumi.Input['OsServicesDetectionConditionsLinuxArgs']]:
        """
        Detection rules
        """
        return pulumi.get(self, "detection_conditions_linux")

    @detection_conditions_linux.setter
    def detection_conditions_linux(self, value: Optional[pulumi.Input['OsServicesDetectionConditionsLinuxArgs']]):
        pulumi.set(self, "detection_conditions_linux", value)

    @property
    @pulumi.getter(name="detectionConditionsWindows")
    def detection_conditions_windows(self) -> Optional[pulumi.Input['OsServicesDetectionConditionsWindowsArgs']]:
        """
        Detection rules
        """
        return pulumi.get(self, "detection_conditions_windows")

    @detection_conditions_windows.setter
    def detection_conditions_windows(self, value: Optional[pulumi.Input['OsServicesDetectionConditionsWindowsArgs']]):
        pulumi.set(self, "detection_conditions_windows", value)

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "insert_after", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['OsServicesMetadataArgs']]:
        """
        Set of additional key-value properties to be attached to the triggered event.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['OsServicesMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Rule name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notInstalledAlerting")
    def not_installed_alerting(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        By default, Dynatrace does not alert if the service is not installed. Toggle the switch to enable or disable this feature
        """
        return pulumi.get(self, "not_installed_alerting")

    @not_installed_alerting.setter
    def not_installed_alerting(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "not_installed_alerting", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="statusConditionLinux")
    def status_condition_linux(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This string has to match a required format. See [OS services monitoring](https://dt-url.net/vl03xzk).
        """
        return pulumi.get(self, "status_condition_linux")

    @status_condition_linux.setter
    def status_condition_linux(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status_condition_linux", value)

    @property
    @pulumi.getter(name="statusConditionWindows")
    def status_condition_windows(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This string has to match a required format. See [OS services monitoring](https://dt-url.net/vl03xzk). - `$eq(paused)`
        – Matches services that are in paused state. Available logic operations: - `$not($eq(paused))` – Matches services
        that are in state different from paused. - `$or($eq(paused),$eq(running))` – Matches services that are either in
        paused or running state. Use one of the following values as a parameter for this condition: - `running` - `stopped` -
        `start_pending` - `stop_pending` - `continue_pending` - `pause_pending` - `paused`
        """
        return pulumi.get(self, "status_condition_windows")

    @status_condition_windows.setter
    def status_condition_windows(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status_condition_windows", value)


@pulumi.input_type
class _OsServicesState:
    def __init__(__self__, *,
                 alert_activation_duration: Optional[pulumi.Input[builtins.int]] = None,
                 alerting: Optional[pulumi.Input[builtins.bool]] = None,
                 detection_conditions_linux: Optional[pulumi.Input['OsServicesDetectionConditionsLinuxArgs']] = None,
                 detection_conditions_windows: Optional[pulumi.Input['OsServicesDetectionConditionsWindowsArgs']] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input['OsServicesMetadataArgs']] = None,
                 monitoring: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 not_installed_alerting: Optional[pulumi.Input[builtins.bool]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 status_condition_linux: Optional[pulumi.Input[builtins.str]] = None,
                 status_condition_windows: Optional[pulumi.Input[builtins.str]] = None,
                 system: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering OsServices resources.
        :param pulumi.Input[builtins.int] alert_activation_duration: The number of **10-second measurement cycles** before alerting is triggered
        :param pulumi.Input[builtins.bool] alerting: Toggle the switch in order to enable or disable alerting for this policy
        :param pulumi.Input['OsServicesDetectionConditionsLinuxArgs'] detection_conditions_linux: Detection rules
        :param pulumi.Input['OsServicesDetectionConditionsWindowsArgs'] detection_conditions_windows: Detection rules
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input['OsServicesMetadataArgs'] metadata: Set of additional key-value properties to be attached to the triggered event.
        :param pulumi.Input[builtins.bool] monitoring: Toggle the switch in order to enable or disable availability metric monitoring for this policy. Availability metrics produce custom metrics. Refer to [documentation](https://dt-url.net/vl03xzk) for consumption examples. Each monitored service consumes one custom metric.
        :param pulumi.Input[builtins.str] name: Rule name
        :param pulumi.Input[builtins.bool] not_installed_alerting: By default, Dynatrace does not alert if the service is not installed. Toggle the switch to enable or disable this feature
        :param pulumi.Input[builtins.str] scope: The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        :param pulumi.Input[builtins.str] status_condition_linux: This string has to match a required format. See [OS services monitoring](https://dt-url.net/vl03xzk).
        :param pulumi.Input[builtins.str] status_condition_windows: This string has to match a required format. See [OS services monitoring](https://dt-url.net/vl03xzk). - `$eq(paused)`
               – Matches services that are in paused state. Available logic operations: - `$not($eq(paused))` – Matches services
               that are in state different from paused. - `$or($eq(paused),$eq(running))` – Matches services that are either in
               paused or running state. Use one of the following values as a parameter for this condition: - `running` - `stopped` -
               `start_pending` - `stop_pending` - `continue_pending` - `pause_pending` - `paused`
        :param pulumi.Input[builtins.str] system: Possible Values: `LINUX`, `WINDOWS`
        """
        if alert_activation_duration is not None:
            pulumi.set(__self__, "alert_activation_duration", alert_activation_duration)
        if alerting is not None:
            pulumi.set(__self__, "alerting", alerting)
        if detection_conditions_linux is not None:
            pulumi.set(__self__, "detection_conditions_linux", detection_conditions_linux)
        if detection_conditions_windows is not None:
            pulumi.set(__self__, "detection_conditions_windows", detection_conditions_windows)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if not_installed_alerting is not None:
            pulumi.set(__self__, "not_installed_alerting", not_installed_alerting)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if status_condition_linux is not None:
            pulumi.set(__self__, "status_condition_linux", status_condition_linux)
        if status_condition_windows is not None:
            pulumi.set(__self__, "status_condition_windows", status_condition_windows)
        if system is not None:
            pulumi.set(__self__, "system", system)

    @property
    @pulumi.getter(name="alertActivationDuration")
    def alert_activation_duration(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of **10-second measurement cycles** before alerting is triggered
        """
        return pulumi.get(self, "alert_activation_duration")

    @alert_activation_duration.setter
    def alert_activation_duration(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "alert_activation_duration", value)

    @property
    @pulumi.getter
    def alerting(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Toggle the switch in order to enable or disable alerting for this policy
        """
        return pulumi.get(self, "alerting")

    @alerting.setter
    def alerting(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "alerting", value)

    @property
    @pulumi.getter(name="detectionConditionsLinux")
    def detection_conditions_linux(self) -> Optional[pulumi.Input['OsServicesDetectionConditionsLinuxArgs']]:
        """
        Detection rules
        """
        return pulumi.get(self, "detection_conditions_linux")

    @detection_conditions_linux.setter
    def detection_conditions_linux(self, value: Optional[pulumi.Input['OsServicesDetectionConditionsLinuxArgs']]):
        pulumi.set(self, "detection_conditions_linux", value)

    @property
    @pulumi.getter(name="detectionConditionsWindows")
    def detection_conditions_windows(self) -> Optional[pulumi.Input['OsServicesDetectionConditionsWindowsArgs']]:
        """
        Detection rules
        """
        return pulumi.get(self, "detection_conditions_windows")

    @detection_conditions_windows.setter
    def detection_conditions_windows(self, value: Optional[pulumi.Input['OsServicesDetectionConditionsWindowsArgs']]):
        pulumi.set(self, "detection_conditions_windows", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "insert_after", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['OsServicesMetadataArgs']]:
        """
        Set of additional key-value properties to be attached to the triggered event.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['OsServicesMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Toggle the switch in order to enable or disable availability metric monitoring for this policy. Availability metrics produce custom metrics. Refer to [documentation](https://dt-url.net/vl03xzk) for consumption examples. Each monitored service consumes one custom metric.
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "monitoring", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Rule name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notInstalledAlerting")
    def not_installed_alerting(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        By default, Dynatrace does not alert if the service is not installed. Toggle the switch to enable or disable this feature
        """
        return pulumi.get(self, "not_installed_alerting")

    @not_installed_alerting.setter
    def not_installed_alerting(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "not_installed_alerting", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="statusConditionLinux")
    def status_condition_linux(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This string has to match a required format. See [OS services monitoring](https://dt-url.net/vl03xzk).
        """
        return pulumi.get(self, "status_condition_linux")

    @status_condition_linux.setter
    def status_condition_linux(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status_condition_linux", value)

    @property
    @pulumi.getter(name="statusConditionWindows")
    def status_condition_windows(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This string has to match a required format. See [OS services monitoring](https://dt-url.net/vl03xzk). - `$eq(paused)`
        – Matches services that are in paused state. Available logic operations: - `$not($eq(paused))` – Matches services
        that are in state different from paused. - `$or($eq(paused),$eq(running))` – Matches services that are either in
        paused or running state. Use one of the following values as a parameter for this condition: - `running` - `stopped` -
        `start_pending` - `stop_pending` - `continue_pending` - `pause_pending` - `paused`
        """
        return pulumi.get(self, "status_condition_windows")

    @status_condition_windows.setter
    def status_condition_windows(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status_condition_windows", value)

    @property
    @pulumi.getter
    def system(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Possible Values: `LINUX`, `WINDOWS`
        """
        return pulumi.get(self, "system")

    @system.setter
    def system(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "system", value)


@pulumi.type_token("dynatrace:index/osServices:OsServices")
class OsServices(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_activation_duration: Optional[pulumi.Input[builtins.int]] = None,
                 alerting: Optional[pulumi.Input[builtins.bool]] = None,
                 detection_conditions_linux: Optional[pulumi.Input[Union['OsServicesDetectionConditionsLinuxArgs', 'OsServicesDetectionConditionsLinuxArgsDict']]] = None,
                 detection_conditions_windows: Optional[pulumi.Input[Union['OsServicesDetectionConditionsWindowsArgs', 'OsServicesDetectionConditionsWindowsArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Union['OsServicesMetadataArgs', 'OsServicesMetadataArgsDict']]] = None,
                 monitoring: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 not_installed_alerting: Optional[pulumi.Input[builtins.bool]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 status_condition_linux: Optional[pulumi.Input[builtins.str]] = None,
                 status_condition_windows: Optional[pulumi.Input[builtins.str]] = None,
                 system: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a OsServices resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] alert_activation_duration: The number of **10-second measurement cycles** before alerting is triggered
        :param pulumi.Input[builtins.bool] alerting: Toggle the switch in order to enable or disable alerting for this policy
        :param pulumi.Input[Union['OsServicesDetectionConditionsLinuxArgs', 'OsServicesDetectionConditionsLinuxArgsDict']] detection_conditions_linux: Detection rules
        :param pulumi.Input[Union['OsServicesDetectionConditionsWindowsArgs', 'OsServicesDetectionConditionsWindowsArgsDict']] detection_conditions_windows: Detection rules
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[Union['OsServicesMetadataArgs', 'OsServicesMetadataArgsDict']] metadata: Set of additional key-value properties to be attached to the triggered event.
        :param pulumi.Input[builtins.bool] monitoring: Toggle the switch in order to enable or disable availability metric monitoring for this policy. Availability metrics produce custom metrics. Refer to [documentation](https://dt-url.net/vl03xzk) for consumption examples. Each monitored service consumes one custom metric.
        :param pulumi.Input[builtins.str] name: Rule name
        :param pulumi.Input[builtins.bool] not_installed_alerting: By default, Dynatrace does not alert if the service is not installed. Toggle the switch to enable or disable this feature
        :param pulumi.Input[builtins.str] scope: The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        :param pulumi.Input[builtins.str] status_condition_linux: This string has to match a required format. See [OS services monitoring](https://dt-url.net/vl03xzk).
        :param pulumi.Input[builtins.str] status_condition_windows: This string has to match a required format. See [OS services monitoring](https://dt-url.net/vl03xzk). - `$eq(paused)`
               – Matches services that are in paused state. Available logic operations: - `$not($eq(paused))` – Matches services
               that are in state different from paused. - `$or($eq(paused),$eq(running))` – Matches services that are either in
               paused or running state. Use one of the following values as a parameter for this condition: - `running` - `stopped` -
               `start_pending` - `stop_pending` - `continue_pending` - `pause_pending` - `paused`
        :param pulumi.Input[builtins.str] system: Possible Values: `LINUX`, `WINDOWS`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OsServicesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a OsServices resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param OsServicesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OsServicesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_activation_duration: Optional[pulumi.Input[builtins.int]] = None,
                 alerting: Optional[pulumi.Input[builtins.bool]] = None,
                 detection_conditions_linux: Optional[pulumi.Input[Union['OsServicesDetectionConditionsLinuxArgs', 'OsServicesDetectionConditionsLinuxArgsDict']]] = None,
                 detection_conditions_windows: Optional[pulumi.Input[Union['OsServicesDetectionConditionsWindowsArgs', 'OsServicesDetectionConditionsWindowsArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Union['OsServicesMetadataArgs', 'OsServicesMetadataArgsDict']]] = None,
                 monitoring: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 not_installed_alerting: Optional[pulumi.Input[builtins.bool]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 status_condition_linux: Optional[pulumi.Input[builtins.str]] = None,
                 status_condition_windows: Optional[pulumi.Input[builtins.str]] = None,
                 system: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OsServicesArgs.__new__(OsServicesArgs)

            __props__.__dict__["alert_activation_duration"] = alert_activation_duration
            if alerting is None and not opts.urn:
                raise TypeError("Missing required property 'alerting'")
            __props__.__dict__["alerting"] = alerting
            __props__.__dict__["detection_conditions_linux"] = detection_conditions_linux
            __props__.__dict__["detection_conditions_windows"] = detection_conditions_windows
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["insert_after"] = insert_after
            __props__.__dict__["metadata"] = metadata
            if monitoring is None and not opts.urn:
                raise TypeError("Missing required property 'monitoring'")
            __props__.__dict__["monitoring"] = monitoring
            __props__.__dict__["name"] = name
            __props__.__dict__["not_installed_alerting"] = not_installed_alerting
            __props__.__dict__["scope"] = scope
            __props__.__dict__["status_condition_linux"] = status_condition_linux
            __props__.__dict__["status_condition_windows"] = status_condition_windows
            if system is None and not opts.urn:
                raise TypeError("Missing required property 'system'")
            __props__.__dict__["system"] = system
        super(OsServices, __self__).__init__(
            'dynatrace:index/osServices:OsServices',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alert_activation_duration: Optional[pulumi.Input[builtins.int]] = None,
            alerting: Optional[pulumi.Input[builtins.bool]] = None,
            detection_conditions_linux: Optional[pulumi.Input[Union['OsServicesDetectionConditionsLinuxArgs', 'OsServicesDetectionConditionsLinuxArgsDict']]] = None,
            detection_conditions_windows: Optional[pulumi.Input[Union['OsServicesDetectionConditionsWindowsArgs', 'OsServicesDetectionConditionsWindowsArgsDict']]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            insert_after: Optional[pulumi.Input[builtins.str]] = None,
            metadata: Optional[pulumi.Input[Union['OsServicesMetadataArgs', 'OsServicesMetadataArgsDict']]] = None,
            monitoring: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            not_installed_alerting: Optional[pulumi.Input[builtins.bool]] = None,
            scope: Optional[pulumi.Input[builtins.str]] = None,
            status_condition_linux: Optional[pulumi.Input[builtins.str]] = None,
            status_condition_windows: Optional[pulumi.Input[builtins.str]] = None,
            system: Optional[pulumi.Input[builtins.str]] = None) -> 'OsServices':
        """
        Get an existing OsServices resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] alert_activation_duration: The number of **10-second measurement cycles** before alerting is triggered
        :param pulumi.Input[builtins.bool] alerting: Toggle the switch in order to enable or disable alerting for this policy
        :param pulumi.Input[Union['OsServicesDetectionConditionsLinuxArgs', 'OsServicesDetectionConditionsLinuxArgsDict']] detection_conditions_linux: Detection rules
        :param pulumi.Input[Union['OsServicesDetectionConditionsWindowsArgs', 'OsServicesDetectionConditionsWindowsArgsDict']] detection_conditions_windows: Detection rules
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[Union['OsServicesMetadataArgs', 'OsServicesMetadataArgsDict']] metadata: Set of additional key-value properties to be attached to the triggered event.
        :param pulumi.Input[builtins.bool] monitoring: Toggle the switch in order to enable or disable availability metric monitoring for this policy. Availability metrics produce custom metrics. Refer to [documentation](https://dt-url.net/vl03xzk) for consumption examples. Each monitored service consumes one custom metric.
        :param pulumi.Input[builtins.str] name: Rule name
        :param pulumi.Input[builtins.bool] not_installed_alerting: By default, Dynatrace does not alert if the service is not installed. Toggle the switch to enable or disable this feature
        :param pulumi.Input[builtins.str] scope: The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        :param pulumi.Input[builtins.str] status_condition_linux: This string has to match a required format. See [OS services monitoring](https://dt-url.net/vl03xzk).
        :param pulumi.Input[builtins.str] status_condition_windows: This string has to match a required format. See [OS services monitoring](https://dt-url.net/vl03xzk). - `$eq(paused)`
               – Matches services that are in paused state. Available logic operations: - `$not($eq(paused))` – Matches services
               that are in state different from paused. - `$or($eq(paused),$eq(running))` – Matches services that are either in
               paused or running state. Use one of the following values as a parameter for this condition: - `running` - `stopped` -
               `start_pending` - `stop_pending` - `continue_pending` - `pause_pending` - `paused`
        :param pulumi.Input[builtins.str] system: Possible Values: `LINUX`, `WINDOWS`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OsServicesState.__new__(_OsServicesState)

        __props__.__dict__["alert_activation_duration"] = alert_activation_duration
        __props__.__dict__["alerting"] = alerting
        __props__.__dict__["detection_conditions_linux"] = detection_conditions_linux
        __props__.__dict__["detection_conditions_windows"] = detection_conditions_windows
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["insert_after"] = insert_after
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["monitoring"] = monitoring
        __props__.__dict__["name"] = name
        __props__.__dict__["not_installed_alerting"] = not_installed_alerting
        __props__.__dict__["scope"] = scope
        __props__.__dict__["status_condition_linux"] = status_condition_linux
        __props__.__dict__["status_condition_windows"] = status_condition_windows
        __props__.__dict__["system"] = system
        return OsServices(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alertActivationDuration")
    def alert_activation_duration(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of **10-second measurement cycles** before alerting is triggered
        """
        return pulumi.get(self, "alert_activation_duration")

    @property
    @pulumi.getter
    def alerting(self) -> pulumi.Output[builtins.bool]:
        """
        Toggle the switch in order to enable or disable alerting for this policy
        """
        return pulumi.get(self, "alerting")

    @property
    @pulumi.getter(name="detectionConditionsLinux")
    def detection_conditions_linux(self) -> pulumi.Output[Optional['outputs.OsServicesDetectionConditionsLinux']]:
        """
        Detection rules
        """
        return pulumi.get(self, "detection_conditions_linux")

    @property
    @pulumi.getter(name="detectionConditionsWindows")
    def detection_conditions_windows(self) -> pulumi.Output[Optional['outputs.OsServicesDetectionConditionsWindows']]:
        """
        Detection rules
        """
        return pulumi.get(self, "detection_conditions_windows")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> pulumi.Output[builtins.str]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional['outputs.OsServicesMetadata']]:
        """
        Set of additional key-value properties to be attached to the triggered event.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def monitoring(self) -> pulumi.Output[builtins.bool]:
        """
        Toggle the switch in order to enable or disable availability metric monitoring for this policy. Availability metrics produce custom metrics. Refer to [documentation](https://dt-url.net/vl03xzk) for consumption examples. Each monitored service consumes one custom metric.
        """
        return pulumi.get(self, "monitoring")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Rule name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notInstalledAlerting")
    def not_installed_alerting(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        By default, Dynatrace does not alert if the service is not installed. Toggle the switch to enable or disable this feature
        """
        return pulumi.get(self, "not_installed_alerting")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="statusConditionLinux")
    def status_condition_linux(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        This string has to match a required format. See [OS services monitoring](https://dt-url.net/vl03xzk).
        """
        return pulumi.get(self, "status_condition_linux")

    @property
    @pulumi.getter(name="statusConditionWindows")
    def status_condition_windows(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        This string has to match a required format. See [OS services monitoring](https://dt-url.net/vl03xzk). - `$eq(paused)`
        – Matches services that are in paused state. Available logic operations: - `$not($eq(paused))` – Matches services
        that are in state different from paused. - `$or($eq(paused),$eq(running))` – Matches services that are either in
        paused or running state. Use one of the following values as a parameter for this condition: - `running` - `stopped` -
        `start_pending` - `stop_pending` - `continue_pending` - `pause_pending` - `paused`
        """
        return pulumi.get(self, "status_condition_windows")

    @property
    @pulumi.getter
    def system(self) -> pulumi.Output[builtins.str]:
        """
        Possible Values: `LINUX`, `WINDOWS`
        """
        return pulumi.get(self, "system")

