# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OwnershipTeamsArgs', 'OwnershipTeams']

@pulumi.input_type
class OwnershipTeamsArgs:
    def __init__(__self__, *,
                 identifier: pulumi.Input[builtins.str],
                 responsibilities: pulumi.Input['OwnershipTeamsResponsibilitiesArgs'],
                 additional_information: Optional[pulumi.Input['OwnershipTeamsAdditionalInformationArgs']] = None,
                 contact_details: Optional[pulumi.Input['OwnershipTeamsContactDetailsArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 links: Optional[pulumi.Input['OwnershipTeamsLinksArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 supplementary_identifiers: Optional[pulumi.Input['OwnershipTeamsSupplementaryIdentifiersArgs']] = None):
        """
        The set of arguments for constructing a OwnershipTeams resource.
        :param pulumi.Input[builtins.str] identifier: The team identifier is used to reference the team from any entity in Dynatrace. If you are using Kubernetes labels, keep in mind the 63 character limit that they enforce.
        :param pulumi.Input['OwnershipTeamsResponsibilitiesArgs'] responsibilities: Turn on all responsibility assignments that apply to this team.
        :param pulumi.Input['OwnershipTeamsAdditionalInformationArgs'] additional_information: Define key/value pairs that further describe this team — for example, cost center, solution type, or business unit assignments.
        :param pulumi.Input['OwnershipTeamsContactDetailsArgs'] contact_details: Define options for messaging integration or other means of contacting this team.
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] external_id: This field should only be used for the automation purpose when importing team information.
        :param pulumi.Input['OwnershipTeamsLinksArgs'] links: Include links to online resources where information relevant to this team’s responsibilities can be found.
        :param pulumi.Input[builtins.str] name: Team name
        :param pulumi.Input['OwnershipTeamsSupplementaryIdentifiersArgs'] supplementary_identifiers: The supplementary team identifiers can be optionally used in addition to the main team identifier to reference this team from any entity in Dynatrace. Up to 3 supplementary identifiers are supported.
        """
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "responsibilities", responsibilities)
        if additional_information is not None:
            pulumi.set(__self__, "additional_information", additional_information)
        if contact_details is not None:
            pulumi.set(__self__, "contact_details", contact_details)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if supplementary_identifiers is not None:
            pulumi.set(__self__, "supplementary_identifiers", supplementary_identifiers)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[builtins.str]:
        """
        The team identifier is used to reference the team from any entity in Dynatrace. If you are using Kubernetes labels, keep in mind the 63 character limit that they enforce.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def responsibilities(self) -> pulumi.Input['OwnershipTeamsResponsibilitiesArgs']:
        """
        Turn on all responsibility assignments that apply to this team.
        """
        return pulumi.get(self, "responsibilities")

    @responsibilities.setter
    def responsibilities(self, value: pulumi.Input['OwnershipTeamsResponsibilitiesArgs']):
        pulumi.set(self, "responsibilities", value)

    @property
    @pulumi.getter(name="additionalInformation")
    def additional_information(self) -> Optional[pulumi.Input['OwnershipTeamsAdditionalInformationArgs']]:
        """
        Define key/value pairs that further describe this team — for example, cost center, solution type, or business unit assignments.
        """
        return pulumi.get(self, "additional_information")

    @additional_information.setter
    def additional_information(self, value: Optional[pulumi.Input['OwnershipTeamsAdditionalInformationArgs']]):
        pulumi.set(self, "additional_information", value)

    @property
    @pulumi.getter(name="contactDetails")
    def contact_details(self) -> Optional[pulumi.Input['OwnershipTeamsContactDetailsArgs']]:
        """
        Define options for messaging integration or other means of contacting this team.
        """
        return pulumi.get(self, "contact_details")

    @contact_details.setter
    def contact_details(self, value: Optional[pulumi.Input['OwnershipTeamsContactDetailsArgs']]):
        pulumi.set(self, "contact_details", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This field should only be used for the automation purpose when importing team information.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input['OwnershipTeamsLinksArgs']]:
        """
        Include links to online resources where information relevant to this team’s responsibilities can be found.
        """
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input['OwnershipTeamsLinksArgs']]):
        pulumi.set(self, "links", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Team name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="supplementaryIdentifiers")
    def supplementary_identifiers(self) -> Optional[pulumi.Input['OwnershipTeamsSupplementaryIdentifiersArgs']]:
        """
        The supplementary team identifiers can be optionally used in addition to the main team identifier to reference this team from any entity in Dynatrace. Up to 3 supplementary identifiers are supported.
        """
        return pulumi.get(self, "supplementary_identifiers")

    @supplementary_identifiers.setter
    def supplementary_identifiers(self, value: Optional[pulumi.Input['OwnershipTeamsSupplementaryIdentifiersArgs']]):
        pulumi.set(self, "supplementary_identifiers", value)


@pulumi.input_type
class _OwnershipTeamsState:
    def __init__(__self__, *,
                 additional_information: Optional[pulumi.Input['OwnershipTeamsAdditionalInformationArgs']] = None,
                 contact_details: Optional[pulumi.Input['OwnershipTeamsContactDetailsArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 links: Optional[pulumi.Input['OwnershipTeamsLinksArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 responsibilities: Optional[pulumi.Input['OwnershipTeamsResponsibilitiesArgs']] = None,
                 supplementary_identifiers: Optional[pulumi.Input['OwnershipTeamsSupplementaryIdentifiersArgs']] = None):
        """
        Input properties used for looking up and filtering OwnershipTeams resources.
        :param pulumi.Input['OwnershipTeamsAdditionalInformationArgs'] additional_information: Define key/value pairs that further describe this team — for example, cost center, solution type, or business unit assignments.
        :param pulumi.Input['OwnershipTeamsContactDetailsArgs'] contact_details: Define options for messaging integration or other means of contacting this team.
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] external_id: This field should only be used for the automation purpose when importing team information.
        :param pulumi.Input[builtins.str] identifier: The team identifier is used to reference the team from any entity in Dynatrace. If you are using Kubernetes labels, keep in mind the 63 character limit that they enforce.
        :param pulumi.Input['OwnershipTeamsLinksArgs'] links: Include links to online resources where information relevant to this team’s responsibilities can be found.
        :param pulumi.Input[builtins.str] name: Team name
        :param pulumi.Input['OwnershipTeamsResponsibilitiesArgs'] responsibilities: Turn on all responsibility assignments that apply to this team.
        :param pulumi.Input['OwnershipTeamsSupplementaryIdentifiersArgs'] supplementary_identifiers: The supplementary team identifiers can be optionally used in addition to the main team identifier to reference this team from any entity in Dynatrace. Up to 3 supplementary identifiers are supported.
        """
        if additional_information is not None:
            pulumi.set(__self__, "additional_information", additional_information)
        if contact_details is not None:
            pulumi.set(__self__, "contact_details", contact_details)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if responsibilities is not None:
            pulumi.set(__self__, "responsibilities", responsibilities)
        if supplementary_identifiers is not None:
            pulumi.set(__self__, "supplementary_identifiers", supplementary_identifiers)

    @property
    @pulumi.getter(name="additionalInformation")
    def additional_information(self) -> Optional[pulumi.Input['OwnershipTeamsAdditionalInformationArgs']]:
        """
        Define key/value pairs that further describe this team — for example, cost center, solution type, or business unit assignments.
        """
        return pulumi.get(self, "additional_information")

    @additional_information.setter
    def additional_information(self, value: Optional[pulumi.Input['OwnershipTeamsAdditionalInformationArgs']]):
        pulumi.set(self, "additional_information", value)

    @property
    @pulumi.getter(name="contactDetails")
    def contact_details(self) -> Optional[pulumi.Input['OwnershipTeamsContactDetailsArgs']]:
        """
        Define options for messaging integration or other means of contacting this team.
        """
        return pulumi.get(self, "contact_details")

    @contact_details.setter
    def contact_details(self, value: Optional[pulumi.Input['OwnershipTeamsContactDetailsArgs']]):
        pulumi.set(self, "contact_details", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This field should only be used for the automation purpose when importing team information.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The team identifier is used to reference the team from any entity in Dynatrace. If you are using Kubernetes labels, keep in mind the 63 character limit that they enforce.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input['OwnershipTeamsLinksArgs']]:
        """
        Include links to online resources where information relevant to this team’s responsibilities can be found.
        """
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input['OwnershipTeamsLinksArgs']]):
        pulumi.set(self, "links", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Team name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def responsibilities(self) -> Optional[pulumi.Input['OwnershipTeamsResponsibilitiesArgs']]:
        """
        Turn on all responsibility assignments that apply to this team.
        """
        return pulumi.get(self, "responsibilities")

    @responsibilities.setter
    def responsibilities(self, value: Optional[pulumi.Input['OwnershipTeamsResponsibilitiesArgs']]):
        pulumi.set(self, "responsibilities", value)

    @property
    @pulumi.getter(name="supplementaryIdentifiers")
    def supplementary_identifiers(self) -> Optional[pulumi.Input['OwnershipTeamsSupplementaryIdentifiersArgs']]:
        """
        The supplementary team identifiers can be optionally used in addition to the main team identifier to reference this team from any entity in Dynatrace. Up to 3 supplementary identifiers are supported.
        """
        return pulumi.get(self, "supplementary_identifiers")

    @supplementary_identifiers.setter
    def supplementary_identifiers(self, value: Optional[pulumi.Input['OwnershipTeamsSupplementaryIdentifiersArgs']]):
        pulumi.set(self, "supplementary_identifiers", value)


@pulumi.type_token("dynatrace:index/ownershipTeams:OwnershipTeams")
class OwnershipTeams(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_information: Optional[pulumi.Input[Union['OwnershipTeamsAdditionalInformationArgs', 'OwnershipTeamsAdditionalInformationArgsDict']]] = None,
                 contact_details: Optional[pulumi.Input[Union['OwnershipTeamsContactDetailsArgs', 'OwnershipTeamsContactDetailsArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 links: Optional[pulumi.Input[Union['OwnershipTeamsLinksArgs', 'OwnershipTeamsLinksArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 responsibilities: Optional[pulumi.Input[Union['OwnershipTeamsResponsibilitiesArgs', 'OwnershipTeamsResponsibilitiesArgsDict']]] = None,
                 supplementary_identifiers: Optional[pulumi.Input[Union['OwnershipTeamsSupplementaryIdentifiersArgs', 'OwnershipTeamsSupplementaryIdentifiersArgsDict']]] = None,
                 __props__=None):
        """
        Create a OwnershipTeams resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['OwnershipTeamsAdditionalInformationArgs', 'OwnershipTeamsAdditionalInformationArgsDict']] additional_information: Define key/value pairs that further describe this team — for example, cost center, solution type, or business unit assignments.
        :param pulumi.Input[Union['OwnershipTeamsContactDetailsArgs', 'OwnershipTeamsContactDetailsArgsDict']] contact_details: Define options for messaging integration or other means of contacting this team.
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] external_id: This field should only be used for the automation purpose when importing team information.
        :param pulumi.Input[builtins.str] identifier: The team identifier is used to reference the team from any entity in Dynatrace. If you are using Kubernetes labels, keep in mind the 63 character limit that they enforce.
        :param pulumi.Input[Union['OwnershipTeamsLinksArgs', 'OwnershipTeamsLinksArgsDict']] links: Include links to online resources where information relevant to this team’s responsibilities can be found.
        :param pulumi.Input[builtins.str] name: Team name
        :param pulumi.Input[Union['OwnershipTeamsResponsibilitiesArgs', 'OwnershipTeamsResponsibilitiesArgsDict']] responsibilities: Turn on all responsibility assignments that apply to this team.
        :param pulumi.Input[Union['OwnershipTeamsSupplementaryIdentifiersArgs', 'OwnershipTeamsSupplementaryIdentifiersArgsDict']] supplementary_identifiers: The supplementary team identifiers can be optionally used in addition to the main team identifier to reference this team from any entity in Dynatrace. Up to 3 supplementary identifiers are supported.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OwnershipTeamsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a OwnershipTeams resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param OwnershipTeamsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OwnershipTeamsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_information: Optional[pulumi.Input[Union['OwnershipTeamsAdditionalInformationArgs', 'OwnershipTeamsAdditionalInformationArgsDict']]] = None,
                 contact_details: Optional[pulumi.Input[Union['OwnershipTeamsContactDetailsArgs', 'OwnershipTeamsContactDetailsArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 links: Optional[pulumi.Input[Union['OwnershipTeamsLinksArgs', 'OwnershipTeamsLinksArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 responsibilities: Optional[pulumi.Input[Union['OwnershipTeamsResponsibilitiesArgs', 'OwnershipTeamsResponsibilitiesArgsDict']]] = None,
                 supplementary_identifiers: Optional[pulumi.Input[Union['OwnershipTeamsSupplementaryIdentifiersArgs', 'OwnershipTeamsSupplementaryIdentifiersArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OwnershipTeamsArgs.__new__(OwnershipTeamsArgs)

            __props__.__dict__["additional_information"] = additional_information
            __props__.__dict__["contact_details"] = contact_details
            __props__.__dict__["description"] = description
            __props__.__dict__["external_id"] = external_id
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["links"] = links
            __props__.__dict__["name"] = name
            if responsibilities is None and not opts.urn:
                raise TypeError("Missing required property 'responsibilities'")
            __props__.__dict__["responsibilities"] = responsibilities
            __props__.__dict__["supplementary_identifiers"] = supplementary_identifiers
        super(OwnershipTeams, __self__).__init__(
            'dynatrace:index/ownershipTeams:OwnershipTeams',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_information: Optional[pulumi.Input[Union['OwnershipTeamsAdditionalInformationArgs', 'OwnershipTeamsAdditionalInformationArgsDict']]] = None,
            contact_details: Optional[pulumi.Input[Union['OwnershipTeamsContactDetailsArgs', 'OwnershipTeamsContactDetailsArgsDict']]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            external_id: Optional[pulumi.Input[builtins.str]] = None,
            identifier: Optional[pulumi.Input[builtins.str]] = None,
            links: Optional[pulumi.Input[Union['OwnershipTeamsLinksArgs', 'OwnershipTeamsLinksArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            responsibilities: Optional[pulumi.Input[Union['OwnershipTeamsResponsibilitiesArgs', 'OwnershipTeamsResponsibilitiesArgsDict']]] = None,
            supplementary_identifiers: Optional[pulumi.Input[Union['OwnershipTeamsSupplementaryIdentifiersArgs', 'OwnershipTeamsSupplementaryIdentifiersArgsDict']]] = None) -> 'OwnershipTeams':
        """
        Get an existing OwnershipTeams resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['OwnershipTeamsAdditionalInformationArgs', 'OwnershipTeamsAdditionalInformationArgsDict']] additional_information: Define key/value pairs that further describe this team — for example, cost center, solution type, or business unit assignments.
        :param pulumi.Input[Union['OwnershipTeamsContactDetailsArgs', 'OwnershipTeamsContactDetailsArgsDict']] contact_details: Define options for messaging integration or other means of contacting this team.
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] external_id: This field should only be used for the automation purpose when importing team information.
        :param pulumi.Input[builtins.str] identifier: The team identifier is used to reference the team from any entity in Dynatrace. If you are using Kubernetes labels, keep in mind the 63 character limit that they enforce.
        :param pulumi.Input[Union['OwnershipTeamsLinksArgs', 'OwnershipTeamsLinksArgsDict']] links: Include links to online resources where information relevant to this team’s responsibilities can be found.
        :param pulumi.Input[builtins.str] name: Team name
        :param pulumi.Input[Union['OwnershipTeamsResponsibilitiesArgs', 'OwnershipTeamsResponsibilitiesArgsDict']] responsibilities: Turn on all responsibility assignments that apply to this team.
        :param pulumi.Input[Union['OwnershipTeamsSupplementaryIdentifiersArgs', 'OwnershipTeamsSupplementaryIdentifiersArgsDict']] supplementary_identifiers: The supplementary team identifiers can be optionally used in addition to the main team identifier to reference this team from any entity in Dynatrace. Up to 3 supplementary identifiers are supported.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OwnershipTeamsState.__new__(_OwnershipTeamsState)

        __props__.__dict__["additional_information"] = additional_information
        __props__.__dict__["contact_details"] = contact_details
        __props__.__dict__["description"] = description
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["links"] = links
        __props__.__dict__["name"] = name
        __props__.__dict__["responsibilities"] = responsibilities
        __props__.__dict__["supplementary_identifiers"] = supplementary_identifiers
        return OwnershipTeams(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalInformation")
    def additional_information(self) -> pulumi.Output[Optional['outputs.OwnershipTeamsAdditionalInformation']]:
        """
        Define key/value pairs that further describe this team — for example, cost center, solution type, or business unit assignments.
        """
        return pulumi.get(self, "additional_information")

    @property
    @pulumi.getter(name="contactDetails")
    def contact_details(self) -> pulumi.Output[Optional['outputs.OwnershipTeamsContactDetails']]:
        """
        Define options for messaging integration or other means of contacting this team.
        """
        return pulumi.get(self, "contact_details")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        This field should only be used for the automation purpose when importing team information.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[builtins.str]:
        """
        The team identifier is used to reference the team from any entity in Dynatrace. If you are using Kubernetes labels, keep in mind the 63 character limit that they enforce.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def links(self) -> pulumi.Output[Optional['outputs.OwnershipTeamsLinks']]:
        """
        Include links to online resources where information relevant to this team’s responsibilities can be found.
        """
        return pulumi.get(self, "links")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Team name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def responsibilities(self) -> pulumi.Output['outputs.OwnershipTeamsResponsibilities']:
        """
        Turn on all responsibility assignments that apply to this team.
        """
        return pulumi.get(self, "responsibilities")

    @property
    @pulumi.getter(name="supplementaryIdentifiers")
    def supplementary_identifiers(self) -> pulumi.Output[Optional['outputs.OwnershipTeamsSupplementaryIdentifiers']]:
        """
        The supplementary team identifiers can be optionally used in addition to the main team identifier to reference this team from any entity in Dynatrace. Up to 3 supplementary identifiers are supported.
        """
        return pulumi.get(self, "supplementary_identifiers")

