# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PgAlertingArgs', 'PgAlerting']

@pulumi.input_type
class PgAlertingArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool],
                 process_group: pulumi.Input[builtins.str],
                 alerting_mode: Optional[pulumi.Input[builtins.str]] = None,
                 minimum_instance_threshold: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a PgAlerting resource.
        :param pulumi.Input[builtins.bool] enabled: Enable (`true`) or disable (`false`) process group availability monitoring
        :param pulumi.Input[builtins.str] process_group: The process group ID for availability monitoring
        :param pulumi.Input[builtins.str] alerting_mode: Possible Values: `ON_INSTANCE_COUNT_VIOLATION`, `ON_PGI_UNAVAILABILITY`
        :param pulumi.Input[builtins.int] minimum_instance_threshold: Open a new problem if the number of active process instances in the group is fewer than X
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "process_group", process_group)
        if alerting_mode is not None:
            pulumi.set(__self__, "alerting_mode", alerting_mode)
        if minimum_instance_threshold is not None:
            pulumi.set(__self__, "minimum_instance_threshold", minimum_instance_threshold)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Enable (`true`) or disable (`false`) process group availability monitoring
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="processGroup")
    def process_group(self) -> pulumi.Input[builtins.str]:
        """
        The process group ID for availability monitoring
        """
        return pulumi.get(self, "process_group")

    @process_group.setter
    def process_group(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "process_group", value)

    @property
    @pulumi.getter(name="alertingMode")
    def alerting_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Possible Values: `ON_INSTANCE_COUNT_VIOLATION`, `ON_PGI_UNAVAILABILITY`
        """
        return pulumi.get(self, "alerting_mode")

    @alerting_mode.setter
    def alerting_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alerting_mode", value)

    @property
    @pulumi.getter(name="minimumInstanceThreshold")
    def minimum_instance_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Open a new problem if the number of active process instances in the group is fewer than X
        """
        return pulumi.get(self, "minimum_instance_threshold")

    @minimum_instance_threshold.setter
    def minimum_instance_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "minimum_instance_threshold", value)


@pulumi.input_type
class _PgAlertingState:
    def __init__(__self__, *,
                 alerting_mode: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 minimum_instance_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 process_group: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering PgAlerting resources.
        :param pulumi.Input[builtins.str] alerting_mode: Possible Values: `ON_INSTANCE_COUNT_VIOLATION`, `ON_PGI_UNAVAILABILITY`
        :param pulumi.Input[builtins.bool] enabled: Enable (`true`) or disable (`false`) process group availability monitoring
        :param pulumi.Input[builtins.int] minimum_instance_threshold: Open a new problem if the number of active process instances in the group is fewer than X
        :param pulumi.Input[builtins.str] process_group: The process group ID for availability monitoring
        """
        if alerting_mode is not None:
            pulumi.set(__self__, "alerting_mode", alerting_mode)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if minimum_instance_threshold is not None:
            pulumi.set(__self__, "minimum_instance_threshold", minimum_instance_threshold)
        if process_group is not None:
            pulumi.set(__self__, "process_group", process_group)

    @property
    @pulumi.getter(name="alertingMode")
    def alerting_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Possible Values: `ON_INSTANCE_COUNT_VIOLATION`, `ON_PGI_UNAVAILABILITY`
        """
        return pulumi.get(self, "alerting_mode")

    @alerting_mode.setter
    def alerting_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alerting_mode", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable (`true`) or disable (`false`) process group availability monitoring
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="minimumInstanceThreshold")
    def minimum_instance_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Open a new problem if the number of active process instances in the group is fewer than X
        """
        return pulumi.get(self, "minimum_instance_threshold")

    @minimum_instance_threshold.setter
    def minimum_instance_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "minimum_instance_threshold", value)

    @property
    @pulumi.getter(name="processGroup")
    def process_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The process group ID for availability monitoring
        """
        return pulumi.get(self, "process_group")

    @process_group.setter
    def process_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "process_group", value)


@pulumi.type_token("dynatrace:index/pgAlerting:PgAlerting")
class PgAlerting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alerting_mode: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 minimum_instance_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 process_group: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a PgAlerting resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] alerting_mode: Possible Values: `ON_INSTANCE_COUNT_VIOLATION`, `ON_PGI_UNAVAILABILITY`
        :param pulumi.Input[builtins.bool] enabled: Enable (`true`) or disable (`false`) process group availability monitoring
        :param pulumi.Input[builtins.int] minimum_instance_threshold: Open a new problem if the number of active process instances in the group is fewer than X
        :param pulumi.Input[builtins.str] process_group: The process group ID for availability monitoring
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PgAlertingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a PgAlerting resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param PgAlertingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PgAlertingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alerting_mode: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 minimum_instance_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 process_group: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PgAlertingArgs.__new__(PgAlertingArgs)

            __props__.__dict__["alerting_mode"] = alerting_mode
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["minimum_instance_threshold"] = minimum_instance_threshold
            if process_group is None and not opts.urn:
                raise TypeError("Missing required property 'process_group'")
            __props__.__dict__["process_group"] = process_group
        super(PgAlerting, __self__).__init__(
            'dynatrace:index/pgAlerting:PgAlerting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alerting_mode: Optional[pulumi.Input[builtins.str]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            minimum_instance_threshold: Optional[pulumi.Input[builtins.int]] = None,
            process_group: Optional[pulumi.Input[builtins.str]] = None) -> 'PgAlerting':
        """
        Get an existing PgAlerting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] alerting_mode: Possible Values: `ON_INSTANCE_COUNT_VIOLATION`, `ON_PGI_UNAVAILABILITY`
        :param pulumi.Input[builtins.bool] enabled: Enable (`true`) or disable (`false`) process group availability monitoring
        :param pulumi.Input[builtins.int] minimum_instance_threshold: Open a new problem if the number of active process instances in the group is fewer than X
        :param pulumi.Input[builtins.str] process_group: The process group ID for availability monitoring
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PgAlertingState.__new__(_PgAlertingState)

        __props__.__dict__["alerting_mode"] = alerting_mode
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["minimum_instance_threshold"] = minimum_instance_threshold
        __props__.__dict__["process_group"] = process_group
        return PgAlerting(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alertingMode")
    def alerting_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Possible Values: `ON_INSTANCE_COUNT_VIOLATION`, `ON_PGI_UNAVAILABILITY`
        """
        return pulumi.get(self, "alerting_mode")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Enable (`true`) or disable (`false`) process group availability monitoring
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="minimumInstanceThreshold")
    def minimum_instance_threshold(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Open a new problem if the number of active process instances in the group is fewer than X
        """
        return pulumi.get(self, "minimum_instance_threshold")

    @property
    @pulumi.getter(name="processGroup")
    def process_group(self) -> pulumi.Output[builtins.str]:
        """
        The process group ID for availability monitoring
        """
        return pulumi.get(self, "process_group")

