# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PlatformSloArgs', 'PlatformSlo']

@pulumi.input_type
class PlatformSloArgs:
    def __init__(__self__, *,
                 criteria: pulumi.Input['PlatformSloCriteriaArgs'],
                 custom_sli: Optional[pulumi.Input['PlatformSloCustomSliArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 sli_reference: Optional[pulumi.Input['PlatformSloSliReferenceArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a PlatformSlo resource.
        :param pulumi.Input['PlatformSloCriteriaArgs'] criteria: Criteria of the SLO
        :param pulumi.Input['PlatformSloCustomSliArgs'] custom_sli: Custom SLI of the SLO
        :param pulumi.Input[builtins.str] description: Description of the SLO
        :param pulumi.Input[builtins.str] name: Name of the SLO
        :param pulumi.Input['PlatformSloSliReferenceArgs'] sli_reference: SLI reference of the SLO
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags of the SLO. Example: `Stage:DEV`
        """
        pulumi.set(__self__, "criteria", criteria)
        if custom_sli is not None:
            pulumi.set(__self__, "custom_sli", custom_sli)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sli_reference is not None:
            pulumi.set(__self__, "sli_reference", sli_reference)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def criteria(self) -> pulumi.Input['PlatformSloCriteriaArgs']:
        """
        Criteria of the SLO
        """
        return pulumi.get(self, "criteria")

    @criteria.setter
    def criteria(self, value: pulumi.Input['PlatformSloCriteriaArgs']):
        pulumi.set(self, "criteria", value)

    @property
    @pulumi.getter(name="customSli")
    def custom_sli(self) -> Optional[pulumi.Input['PlatformSloCustomSliArgs']]:
        """
        Custom SLI of the SLO
        """
        return pulumi.get(self, "custom_sli")

    @custom_sli.setter
    def custom_sli(self, value: Optional[pulumi.Input['PlatformSloCustomSliArgs']]):
        pulumi.set(self, "custom_sli", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the SLO
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the SLO
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sliReference")
    def sli_reference(self) -> Optional[pulumi.Input['PlatformSloSliReferenceArgs']]:
        """
        SLI reference of the SLO
        """
        return pulumi.get(self, "sli_reference")

    @sli_reference.setter
    def sli_reference(self, value: Optional[pulumi.Input['PlatformSloSliReferenceArgs']]):
        pulumi.set(self, "sli_reference", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Tags of the SLO. Example: `Stage:DEV`
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _PlatformSloState:
    def __init__(__self__, *,
                 criteria: Optional[pulumi.Input['PlatformSloCriteriaArgs']] = None,
                 custom_sli: Optional[pulumi.Input['PlatformSloCustomSliArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 sli_reference: Optional[pulumi.Input['PlatformSloSliReferenceArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering PlatformSlo resources.
        :param pulumi.Input['PlatformSloCriteriaArgs'] criteria: Criteria of the SLO
        :param pulumi.Input['PlatformSloCustomSliArgs'] custom_sli: Custom SLI of the SLO
        :param pulumi.Input[builtins.str] description: Description of the SLO
        :param pulumi.Input[builtins.str] name: Name of the SLO
        :param pulumi.Input['PlatformSloSliReferenceArgs'] sli_reference: SLI reference of the SLO
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags of the SLO. Example: `Stage:DEV`
        """
        if criteria is not None:
            pulumi.set(__self__, "criteria", criteria)
        if custom_sli is not None:
            pulumi.set(__self__, "custom_sli", custom_sli)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sli_reference is not None:
            pulumi.set(__self__, "sli_reference", sli_reference)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def criteria(self) -> Optional[pulumi.Input['PlatformSloCriteriaArgs']]:
        """
        Criteria of the SLO
        """
        return pulumi.get(self, "criteria")

    @criteria.setter
    def criteria(self, value: Optional[pulumi.Input['PlatformSloCriteriaArgs']]):
        pulumi.set(self, "criteria", value)

    @property
    @pulumi.getter(name="customSli")
    def custom_sli(self) -> Optional[pulumi.Input['PlatformSloCustomSliArgs']]:
        """
        Custom SLI of the SLO
        """
        return pulumi.get(self, "custom_sli")

    @custom_sli.setter
    def custom_sli(self, value: Optional[pulumi.Input['PlatformSloCustomSliArgs']]):
        pulumi.set(self, "custom_sli", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the SLO
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the SLO
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sliReference")
    def sli_reference(self) -> Optional[pulumi.Input['PlatformSloSliReferenceArgs']]:
        """
        SLI reference of the SLO
        """
        return pulumi.get(self, "sli_reference")

    @sli_reference.setter
    def sli_reference(self, value: Optional[pulumi.Input['PlatformSloSliReferenceArgs']]):
        pulumi.set(self, "sli_reference", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Tags of the SLO. Example: `Stage:DEV`
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("dynatrace:index/platformSlo:PlatformSlo")
class PlatformSlo(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 criteria: Optional[pulumi.Input[Union['PlatformSloCriteriaArgs', 'PlatformSloCriteriaArgsDict']]] = None,
                 custom_sli: Optional[pulumi.Input[Union['PlatformSloCustomSliArgs', 'PlatformSloCustomSliArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 sli_reference: Optional[pulumi.Input[Union['PlatformSloSliReferenceArgs', 'PlatformSloSliReferenceArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        > **Dynatrace SaaS only**

        > To utilize this resource, please define the environment variables `DT_CLIENT_ID`, `DT_CLIENT_SECRET`, `DT_ACCOUNT_ID` with an OAuth client including the following permissions: **View SLOs** (`slo:slos:read`) and **Create and edit SLOs** (`slo:slos:write`).

        > This resource is excluded by default in the export utility, please explicitly specify the resource to retrieve existing configuration.

        ## Dynatrace Documentation

        - Service-Level Objectives overview - hhttps://docs.dynatrace.com/docs/deliver/service-level-objectives

        - SLO Service Public API - https://########.apps.dynatrace.com/platform/swagger-ui/index.html?urls.primaryName=Service-Level+Objectives

        ## Resource Example Usage

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        _name_ = dynatrace.PlatformSlo("#name#",
            criteria={
                "criteria_details": [{
                    "target": 96,
                    "timeframe_from": "now-30d",
                    "timeframe_to": "now",
                    "warning": 99,
                }],
            },
            custom_sli={
                "indicator": \"\"\"  timeseries { total=sum(dt.service.request.count) ,failures=sum(dt.service.request.failure_count) }, by: { dt.entity.service }
          | fieldsAdd tags=entityAttr(dt.entity.service, "tags")
          | filter in(tags, "criticality:Gold")
          | fieldsAdd entityName = entityName(dt.entity.service)
          | fieldsAdd sli=(((total[]-failures[])/total[])*(100))
          | fieldsRemove total, failures, tags

        \"\"\",
            },
            description="Sample custom SLO",
            tags=["ExampleKey:ExampleValue"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PlatformSloCriteriaArgs', 'PlatformSloCriteriaArgsDict']] criteria: Criteria of the SLO
        :param pulumi.Input[Union['PlatformSloCustomSliArgs', 'PlatformSloCustomSliArgsDict']] custom_sli: Custom SLI of the SLO
        :param pulumi.Input[builtins.str] description: Description of the SLO
        :param pulumi.Input[builtins.str] name: Name of the SLO
        :param pulumi.Input[Union['PlatformSloSliReferenceArgs', 'PlatformSloSliReferenceArgsDict']] sli_reference: SLI reference of the SLO
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags of the SLO. Example: `Stage:DEV`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PlatformSloArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **Dynatrace SaaS only**

        > To utilize this resource, please define the environment variables `DT_CLIENT_ID`, `DT_CLIENT_SECRET`, `DT_ACCOUNT_ID` with an OAuth client including the following permissions: **View SLOs** (`slo:slos:read`) and **Create and edit SLOs** (`slo:slos:write`).

        > This resource is excluded by default in the export utility, please explicitly specify the resource to retrieve existing configuration.

        ## Dynatrace Documentation

        - Service-Level Objectives overview - hhttps://docs.dynatrace.com/docs/deliver/service-level-objectives

        - SLO Service Public API - https://########.apps.dynatrace.com/platform/swagger-ui/index.html?urls.primaryName=Service-Level+Objectives

        ## Resource Example Usage

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        _name_ = dynatrace.PlatformSlo("#name#",
            criteria={
                "criteria_details": [{
                    "target": 96,
                    "timeframe_from": "now-30d",
                    "timeframe_to": "now",
                    "warning": 99,
                }],
            },
            custom_sli={
                "indicator": \"\"\"  timeseries { total=sum(dt.service.request.count) ,failures=sum(dt.service.request.failure_count) }, by: { dt.entity.service }
          | fieldsAdd tags=entityAttr(dt.entity.service, "tags")
          | filter in(tags, "criticality:Gold")
          | fieldsAdd entityName = entityName(dt.entity.service)
          | fieldsAdd sli=(((total[]-failures[])/total[])*(100))
          | fieldsRemove total, failures, tags

        \"\"\",
            },
            description="Sample custom SLO",
            tags=["ExampleKey:ExampleValue"])
        ```

        :param str resource_name: The name of the resource.
        :param PlatformSloArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PlatformSloArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 criteria: Optional[pulumi.Input[Union['PlatformSloCriteriaArgs', 'PlatformSloCriteriaArgsDict']]] = None,
                 custom_sli: Optional[pulumi.Input[Union['PlatformSloCustomSliArgs', 'PlatformSloCustomSliArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 sli_reference: Optional[pulumi.Input[Union['PlatformSloSliReferenceArgs', 'PlatformSloSliReferenceArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PlatformSloArgs.__new__(PlatformSloArgs)

            if criteria is None and not opts.urn:
                raise TypeError("Missing required property 'criteria'")
            __props__.__dict__["criteria"] = criteria
            __props__.__dict__["custom_sli"] = custom_sli
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["sli_reference"] = sli_reference
            __props__.__dict__["tags"] = tags
        super(PlatformSlo, __self__).__init__(
            'dynatrace:index/platformSlo:PlatformSlo',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            criteria: Optional[pulumi.Input[Union['PlatformSloCriteriaArgs', 'PlatformSloCriteriaArgsDict']]] = None,
            custom_sli: Optional[pulumi.Input[Union['PlatformSloCustomSliArgs', 'PlatformSloCustomSliArgsDict']]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            sli_reference: Optional[pulumi.Input[Union['PlatformSloSliReferenceArgs', 'PlatformSloSliReferenceArgsDict']]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'PlatformSlo':
        """
        Get an existing PlatformSlo resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PlatformSloCriteriaArgs', 'PlatformSloCriteriaArgsDict']] criteria: Criteria of the SLO
        :param pulumi.Input[Union['PlatformSloCustomSliArgs', 'PlatformSloCustomSliArgsDict']] custom_sli: Custom SLI of the SLO
        :param pulumi.Input[builtins.str] description: Description of the SLO
        :param pulumi.Input[builtins.str] name: Name of the SLO
        :param pulumi.Input[Union['PlatformSloSliReferenceArgs', 'PlatformSloSliReferenceArgsDict']] sli_reference: SLI reference of the SLO
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags of the SLO. Example: `Stage:DEV`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PlatformSloState.__new__(_PlatformSloState)

        __props__.__dict__["criteria"] = criteria
        __props__.__dict__["custom_sli"] = custom_sli
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["sli_reference"] = sli_reference
        __props__.__dict__["tags"] = tags
        return PlatformSlo(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def criteria(self) -> pulumi.Output['outputs.PlatformSloCriteria']:
        """
        Criteria of the SLO
        """
        return pulumi.get(self, "criteria")

    @property
    @pulumi.getter(name="customSli")
    def custom_sli(self) -> pulumi.Output[Optional['outputs.PlatformSloCustomSli']]:
        """
        Custom SLI of the SLO
        """
        return pulumi.get(self, "custom_sli")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the SLO
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the SLO
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sliReference")
    def sli_reference(self) -> pulumi.Output[Optional['outputs.PlatformSloSliReference']]:
        """
        SLI reference of the SLO
        """
        return pulumi.get(self, "sli_reference")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Tags of the SLO. Example: `Stage:DEV`
        """
        return pulumi.get(self, "tags")

