# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PolicyArgs', 'Policy']

@pulumi.input_type
class PolicyArgs:
    def __init__(__self__, *,
                 statement_query: pulumi.Input[builtins.str],
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Policy resource.
        :param pulumi.Input[builtins.str] statement_query: The Statement Query of the policy
        :param pulumi.Input[builtins.str] cluster: The UUID of the cluster in case the policy should be applied to all environments of this cluster.
        :param pulumi.Input[builtins.str] description: An optional description text for the policy
        :param pulumi.Input[builtins.str] environment: The ID of the environment if the policy should be applied to a specific environment
        :param pulumi.Input[builtins.str] name: The name of the policy
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags for this policy
        """
        pulumi.set(__self__, "statement_query", statement_query)
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="statementQuery")
    def statement_query(self) -> pulumi.Input[builtins.str]:
        """
        The Statement Query of the policy
        """
        return pulumi.get(self, "statement_query")

    @statement_query.setter
    def statement_query(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "statement_query", value)

    @property
    @pulumi.getter
    def cluster(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The UUID of the cluster in case the policy should be applied to all environments of this cluster.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description text for the policy
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the environment if the policy should be applied to a specific environment
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Tags for this policy
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _PolicyState:
    def __init__(__self__, *,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 statement_query: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Policy resources.
        :param pulumi.Input[builtins.str] cluster: The UUID of the cluster in case the policy should be applied to all environments of this cluster.
        :param pulumi.Input[builtins.str] description: An optional description text for the policy
        :param pulumi.Input[builtins.str] environment: The ID of the environment if the policy should be applied to a specific environment
        :param pulumi.Input[builtins.str] name: The name of the policy
        :param pulumi.Input[builtins.str] statement_query: The Statement Query of the policy
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags for this policy
        """
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if statement_query is not None:
            pulumi.set(__self__, "statement_query", statement_query)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def cluster(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The UUID of the cluster in case the policy should be applied to all environments of this cluster.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description text for the policy
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the environment if the policy should be applied to a specific environment
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="statementQuery")
    def statement_query(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Statement Query of the policy
        """
        return pulumi.get(self, "statement_query")

    @statement_query.setter
    def statement_query(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "statement_query", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Tags for this policy
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("dynatrace:index/policy:Policy")
class Policy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 statement_query: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Create a Policy resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cluster: The UUID of the cluster in case the policy should be applied to all environments of this cluster.
        :param pulumi.Input[builtins.str] description: An optional description text for the policy
        :param pulumi.Input[builtins.str] environment: The ID of the environment if the policy should be applied to a specific environment
        :param pulumi.Input[builtins.str] name: The name of the policy
        :param pulumi.Input[builtins.str] statement_query: The Statement Query of the policy
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags for this policy
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Policy resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param PolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 statement_query: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyArgs.__new__(PolicyArgs)

            __props__.__dict__["cluster"] = cluster
            __props__.__dict__["description"] = description
            __props__.__dict__["environment"] = environment
            __props__.__dict__["name"] = name
            if statement_query is None and not opts.urn:
                raise TypeError("Missing required property 'statement_query'")
            __props__.__dict__["statement_query"] = statement_query
            __props__.__dict__["tags"] = tags
        super(Policy, __self__).__init__(
            'dynatrace:index/policy:Policy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            environment: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            statement_query: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'Policy':
        """
        Get an existing Policy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cluster: The UUID of the cluster in case the policy should be applied to all environments of this cluster.
        :param pulumi.Input[builtins.str] description: An optional description text for the policy
        :param pulumi.Input[builtins.str] environment: The ID of the environment if the policy should be applied to a specific environment
        :param pulumi.Input[builtins.str] name: The name of the policy
        :param pulumi.Input[builtins.str] statement_query: The Statement Query of the policy
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags for this policy
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyState.__new__(_PolicyState)

        __props__.__dict__["cluster"] = cluster
        __props__.__dict__["description"] = description
        __props__.__dict__["environment"] = environment
        __props__.__dict__["name"] = name
        __props__.__dict__["statement_query"] = statement_query
        __props__.__dict__["tags"] = tags
        return Policy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The UUID of the cluster in case the policy should be applied to all environments of this cluster.
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional description text for the policy
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the environment if the policy should be applied to a specific environment
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the policy
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="statementQuery")
    def statement_query(self) -> pulumi.Output[builtins.str]:
        """
        The Statement Query of the policy
        """
        return pulumi.get(self, "statement_query")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Tags for this policy
        """
        return pulumi.get(self, "tags")

