# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PolicyBindingsArgs', 'PolicyBindings']

@pulumi.input_type
class PolicyBindingsArgs:
    def __init__(__self__, *,
                 group: pulumi.Input[builtins.str],
                 policies: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a PolicyBindings resource.
        :param pulumi.Input[builtins.str] group: The name of the policy
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] policies: A list of IDs referring to policies bound to that group. It's not possible to mix policies here that are defined for
               different scopes (different clusters or environments) than specified via attributes `cluster` or `environment`.
        :param pulumi.Input[builtins.str] cluster: The UUID of the cluster. The attribute `policies` must contain ONLY policies defined for that cluster.
        :param pulumi.Input[builtins.str] environment: The ID of the environment (https://<environmentid>.live.dynatrace.com). The attribute `policies` must contain ONLY
               policies defined for that environment.
        """
        pulumi.set(__self__, "group", group)
        pulumi.set(__self__, "policies", policies)
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)

    @property
    @pulumi.getter
    def group(self) -> pulumi.Input[builtins.str]:
        """
        The name of the policy
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter
    def policies(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of IDs referring to policies bound to that group. It's not possible to mix policies here that are defined for
        different scopes (different clusters or environments) than specified via attributes `cluster` or `environment`.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter
    def cluster(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The UUID of the cluster. The attribute `policies` must contain ONLY policies defined for that cluster.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the environment (https://<environmentid>.live.dynatrace.com). The attribute `policies` must contain ONLY
        policies defined for that environment.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "environment", value)


@pulumi.input_type
class _PolicyBindingsState:
    def __init__(__self__, *,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input[builtins.str]] = None,
                 group: Optional[pulumi.Input[builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering PolicyBindings resources.
        :param pulumi.Input[builtins.str] cluster: The UUID of the cluster. The attribute `policies` must contain ONLY policies defined for that cluster.
        :param pulumi.Input[builtins.str] environment: The ID of the environment (https://<environmentid>.live.dynatrace.com). The attribute `policies` must contain ONLY
               policies defined for that environment.
        :param pulumi.Input[builtins.str] group: The name of the policy
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] policies: A list of IDs referring to policies bound to that group. It's not possible to mix policies here that are defined for
               different scopes (different clusters or environments) than specified via attributes `cluster` or `environment`.
        """
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)

    @property
    @pulumi.getter
    def cluster(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The UUID of the cluster. The attribute `policies` must contain ONLY policies defined for that cluster.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the environment (https://<environmentid>.live.dynatrace.com). The attribute `policies` must contain ONLY
        policies defined for that environment.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the policy
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of IDs referring to policies bound to that group. It's not possible to mix policies here that are defined for
        different scopes (different clusters or environments) than specified via attributes `cluster` or `environment`.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "policies", value)


@pulumi.type_token("dynatrace:index/policyBindings:PolicyBindings")
class PolicyBindings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input[builtins.str]] = None,
                 group: Optional[pulumi.Input[builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Create a PolicyBindings resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cluster: The UUID of the cluster. The attribute `policies` must contain ONLY policies defined for that cluster.
        :param pulumi.Input[builtins.str] environment: The ID of the environment (https://<environmentid>.live.dynatrace.com). The attribute `policies` must contain ONLY
               policies defined for that environment.
        :param pulumi.Input[builtins.str] group: The name of the policy
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] policies: A list of IDs referring to policies bound to that group. It's not possible to mix policies here that are defined for
               different scopes (different clusters or environments) than specified via attributes `cluster` or `environment`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyBindingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a PolicyBindings resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param PolicyBindingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyBindingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input[builtins.str]] = None,
                 group: Optional[pulumi.Input[builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyBindingsArgs.__new__(PolicyBindingsArgs)

            __props__.__dict__["cluster"] = cluster
            __props__.__dict__["environment"] = environment
            if group is None and not opts.urn:
                raise TypeError("Missing required property 'group'")
            __props__.__dict__["group"] = group
            if policies is None and not opts.urn:
                raise TypeError("Missing required property 'policies'")
            __props__.__dict__["policies"] = policies
        super(PolicyBindings, __self__).__init__(
            'dynatrace:index/policyBindings:PolicyBindings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster: Optional[pulumi.Input[builtins.str]] = None,
            environment: Optional[pulumi.Input[builtins.str]] = None,
            group: Optional[pulumi.Input[builtins.str]] = None,
            policies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'PolicyBindings':
        """
        Get an existing PolicyBindings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cluster: The UUID of the cluster. The attribute `policies` must contain ONLY policies defined for that cluster.
        :param pulumi.Input[builtins.str] environment: The ID of the environment (https://<environmentid>.live.dynatrace.com). The attribute `policies` must contain ONLY
               policies defined for that environment.
        :param pulumi.Input[builtins.str] group: The name of the policy
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] policies: A list of IDs referring to policies bound to that group. It's not possible to mix policies here that are defined for
               different scopes (different clusters or environments) than specified via attributes `cluster` or `environment`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyBindingsState.__new__(_PolicyBindingsState)

        __props__.__dict__["cluster"] = cluster
        __props__.__dict__["environment"] = environment
        __props__.__dict__["group"] = group
        __props__.__dict__["policies"] = policies
        return PolicyBindings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The UUID of the cluster. The attribute `policies` must contain ONLY policies defined for that cluster.
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the environment (https://<environmentid>.live.dynatrace.com). The attribute `policies` must contain ONLY
        policies defined for that environment.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def group(self) -> pulumi.Output[builtins.str]:
        """
        The name of the policy
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def policies(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of IDs referring to policies bound to that group. It's not possible to mix policies here that are defined for
        different scopes (different clusters or environments) than specified via attributes `cluster` or `environment`.
        """
        return pulumi.get(self, "policies")

