# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProblemFieldsArgs', 'ProblemFields']

@pulumi.input_type
class ProblemFieldsArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool],
                 event_field: pulumi.Input[builtins.str],
                 problem_field: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a ProblemFields resource.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] event_field: Field from the event that will be extracted.
        :param pulumi.Input[builtins.str] problem_field: Field under which the extracted event data will be stored on the problem.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "event_field", event_field)
        pulumi.set(__self__, "problem_field", problem_field)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="eventField")
    def event_field(self) -> pulumi.Input[builtins.str]:
        """
        Field from the event that will be extracted.
        """
        return pulumi.get(self, "event_field")

    @event_field.setter
    def event_field(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "event_field", value)

    @property
    @pulumi.getter(name="problemField")
    def problem_field(self) -> pulumi.Input[builtins.str]:
        """
        Field under which the extracted event data will be stored on the problem.
        """
        return pulumi.get(self, "problem_field")

    @problem_field.setter
    def problem_field(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "problem_field", value)


@pulumi.input_type
class _ProblemFieldsState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 event_field: Optional[pulumi.Input[builtins.str]] = None,
                 problem_field: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProblemFields resources.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] event_field: Field from the event that will be extracted.
        :param pulumi.Input[builtins.str] problem_field: Field under which the extracted event data will be stored on the problem.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if event_field is not None:
            pulumi.set(__self__, "event_field", event_field)
        if problem_field is not None:
            pulumi.set(__self__, "problem_field", problem_field)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="eventField")
    def event_field(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Field from the event that will be extracted.
        """
        return pulumi.get(self, "event_field")

    @event_field.setter
    def event_field(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "event_field", value)

    @property
    @pulumi.getter(name="problemField")
    def problem_field(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Field under which the extracted event data will be stored on the problem.
        """
        return pulumi.get(self, "problem_field")

    @problem_field.setter
    def problem_field(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "problem_field", value)


@pulumi.type_token("dynatrace:index/problemFields:ProblemFields")
class ProblemFields(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 event_field: Optional[pulumi.Input[builtins.str]] = None,
                 problem_field: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a ProblemFields resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] event_field: Field from the event that will be extracted.
        :param pulumi.Input[builtins.str] problem_field: Field under which the extracted event data will be stored on the problem.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProblemFieldsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ProblemFields resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ProblemFieldsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProblemFieldsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 event_field: Optional[pulumi.Input[builtins.str]] = None,
                 problem_field: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProblemFieldsArgs.__new__(ProblemFieldsArgs)

            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if event_field is None and not opts.urn:
                raise TypeError("Missing required property 'event_field'")
            __props__.__dict__["event_field"] = event_field
            if problem_field is None and not opts.urn:
                raise TypeError("Missing required property 'problem_field'")
            __props__.__dict__["problem_field"] = problem_field
        super(ProblemFields, __self__).__init__(
            'dynatrace:index/problemFields:ProblemFields',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            event_field: Optional[pulumi.Input[builtins.str]] = None,
            problem_field: Optional[pulumi.Input[builtins.str]] = None) -> 'ProblemFields':
        """
        Get an existing ProblemFields resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] event_field: Field from the event that will be extracted.
        :param pulumi.Input[builtins.str] problem_field: Field under which the extracted event data will be stored on the problem.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProblemFieldsState.__new__(_ProblemFieldsState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["event_field"] = event_field
        __props__.__dict__["problem_field"] = problem_field
        return ProblemFields(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="eventField")
    def event_field(self) -> pulumi.Output[builtins.str]:
        """
        Field from the event that will be extracted.
        """
        return pulumi.get(self, "event_field")

    @property
    @pulumi.getter(name="problemField")
    def problem_field(self) -> pulumi.Output[builtins.str]:
        """
        Field under which the extracted event data will be stored on the problem.
        """
        return pulumi.get(self, "problem_field")

