# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProcessGroupDetectionArgs', 'ProcessGroupDetection']

@pulumi.input_type
class ProcessGroupDetectionArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool],
                 group_extraction: pulumi.Input['ProcessGroupDetectionGroupExtractionArgs'],
                 process_detection: pulumi.Input['ProcessGroupDetectionProcessDetectionArgs'],
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 instance_extraction: Optional[pulumi.Input['ProcessGroupDetectionInstanceExtractionArgs']] = None):
        """
        The set of arguments for constructing a ProcessGroupDetection resource.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input['ProcessGroupDetectionGroupExtractionArgs'] group_extraction: You can define the properties that should be used to identify your process groups.
        :param pulumi.Input['ProcessGroupDetectionProcessDetectionArgs'] process_detection: Apply this rule to processes where the selected property contains the specified string.
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input['ProcessGroupDetectionInstanceExtractionArgs'] instance_extraction: You can define the properties that should be used to identify your process instances.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "group_extraction", group_extraction)
        pulumi.set(__self__, "process_detection", process_detection)
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)
        if instance_extraction is not None:
            pulumi.set(__self__, "instance_extraction", instance_extraction)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="groupExtraction")
    def group_extraction(self) -> pulumi.Input['ProcessGroupDetectionGroupExtractionArgs']:
        """
        You can define the properties that should be used to identify your process groups.
        """
        return pulumi.get(self, "group_extraction")

    @group_extraction.setter
    def group_extraction(self, value: pulumi.Input['ProcessGroupDetectionGroupExtractionArgs']):
        pulumi.set(self, "group_extraction", value)

    @property
    @pulumi.getter(name="processDetection")
    def process_detection(self) -> pulumi.Input['ProcessGroupDetectionProcessDetectionArgs']:
        """
        Apply this rule to processes where the selected property contains the specified string.
        """
        return pulumi.get(self, "process_detection")

    @process_detection.setter
    def process_detection(self, value: pulumi.Input['ProcessGroupDetectionProcessDetectionArgs']):
        pulumi.set(self, "process_detection", value)

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "insert_after", value)

    @property
    @pulumi.getter(name="instanceExtraction")
    def instance_extraction(self) -> Optional[pulumi.Input['ProcessGroupDetectionInstanceExtractionArgs']]:
        """
        You can define the properties that should be used to identify your process instances.
        """
        return pulumi.get(self, "instance_extraction")

    @instance_extraction.setter
    def instance_extraction(self, value: Optional[pulumi.Input['ProcessGroupDetectionInstanceExtractionArgs']]):
        pulumi.set(self, "instance_extraction", value)


@pulumi.input_type
class _ProcessGroupDetectionState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 group_extraction: Optional[pulumi.Input['ProcessGroupDetectionGroupExtractionArgs']] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 instance_extraction: Optional[pulumi.Input['ProcessGroupDetectionInstanceExtractionArgs']] = None,
                 process_detection: Optional[pulumi.Input['ProcessGroupDetectionProcessDetectionArgs']] = None):
        """
        Input properties used for looking up and filtering ProcessGroupDetection resources.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input['ProcessGroupDetectionGroupExtractionArgs'] group_extraction: You can define the properties that should be used to identify your process groups.
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input['ProcessGroupDetectionInstanceExtractionArgs'] instance_extraction: You can define the properties that should be used to identify your process instances.
        :param pulumi.Input['ProcessGroupDetectionProcessDetectionArgs'] process_detection: Apply this rule to processes where the selected property contains the specified string.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if group_extraction is not None:
            pulumi.set(__self__, "group_extraction", group_extraction)
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)
        if instance_extraction is not None:
            pulumi.set(__self__, "instance_extraction", instance_extraction)
        if process_detection is not None:
            pulumi.set(__self__, "process_detection", process_detection)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="groupExtraction")
    def group_extraction(self) -> Optional[pulumi.Input['ProcessGroupDetectionGroupExtractionArgs']]:
        """
        You can define the properties that should be used to identify your process groups.
        """
        return pulumi.get(self, "group_extraction")

    @group_extraction.setter
    def group_extraction(self, value: Optional[pulumi.Input['ProcessGroupDetectionGroupExtractionArgs']]):
        pulumi.set(self, "group_extraction", value)

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "insert_after", value)

    @property
    @pulumi.getter(name="instanceExtraction")
    def instance_extraction(self) -> Optional[pulumi.Input['ProcessGroupDetectionInstanceExtractionArgs']]:
        """
        You can define the properties that should be used to identify your process instances.
        """
        return pulumi.get(self, "instance_extraction")

    @instance_extraction.setter
    def instance_extraction(self, value: Optional[pulumi.Input['ProcessGroupDetectionInstanceExtractionArgs']]):
        pulumi.set(self, "instance_extraction", value)

    @property
    @pulumi.getter(name="processDetection")
    def process_detection(self) -> Optional[pulumi.Input['ProcessGroupDetectionProcessDetectionArgs']]:
        """
        Apply this rule to processes where the selected property contains the specified string.
        """
        return pulumi.get(self, "process_detection")

    @process_detection.setter
    def process_detection(self, value: Optional[pulumi.Input['ProcessGroupDetectionProcessDetectionArgs']]):
        pulumi.set(self, "process_detection", value)


@pulumi.type_token("dynatrace:index/processGroupDetection:ProcessGroupDetection")
class ProcessGroupDetection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 group_extraction: Optional[pulumi.Input[Union['ProcessGroupDetectionGroupExtractionArgs', 'ProcessGroupDetectionGroupExtractionArgsDict']]] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 instance_extraction: Optional[pulumi.Input[Union['ProcessGroupDetectionInstanceExtractionArgs', 'ProcessGroupDetectionInstanceExtractionArgsDict']]] = None,
                 process_detection: Optional[pulumi.Input[Union['ProcessGroupDetectionProcessDetectionArgs', 'ProcessGroupDetectionProcessDetectionArgsDict']]] = None,
                 __props__=None):
        """
        Create a ProcessGroupDetection resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[Union['ProcessGroupDetectionGroupExtractionArgs', 'ProcessGroupDetectionGroupExtractionArgsDict']] group_extraction: You can define the properties that should be used to identify your process groups.
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[Union['ProcessGroupDetectionInstanceExtractionArgs', 'ProcessGroupDetectionInstanceExtractionArgsDict']] instance_extraction: You can define the properties that should be used to identify your process instances.
        :param pulumi.Input[Union['ProcessGroupDetectionProcessDetectionArgs', 'ProcessGroupDetectionProcessDetectionArgsDict']] process_detection: Apply this rule to processes where the selected property contains the specified string.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProcessGroupDetectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ProcessGroupDetection resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ProcessGroupDetectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProcessGroupDetectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 group_extraction: Optional[pulumi.Input[Union['ProcessGroupDetectionGroupExtractionArgs', 'ProcessGroupDetectionGroupExtractionArgsDict']]] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 instance_extraction: Optional[pulumi.Input[Union['ProcessGroupDetectionInstanceExtractionArgs', 'ProcessGroupDetectionInstanceExtractionArgsDict']]] = None,
                 process_detection: Optional[pulumi.Input[Union['ProcessGroupDetectionProcessDetectionArgs', 'ProcessGroupDetectionProcessDetectionArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProcessGroupDetectionArgs.__new__(ProcessGroupDetectionArgs)

            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if group_extraction is None and not opts.urn:
                raise TypeError("Missing required property 'group_extraction'")
            __props__.__dict__["group_extraction"] = group_extraction
            __props__.__dict__["insert_after"] = insert_after
            __props__.__dict__["instance_extraction"] = instance_extraction
            if process_detection is None and not opts.urn:
                raise TypeError("Missing required property 'process_detection'")
            __props__.__dict__["process_detection"] = process_detection
        super(ProcessGroupDetection, __self__).__init__(
            'dynatrace:index/processGroupDetection:ProcessGroupDetection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            group_extraction: Optional[pulumi.Input[Union['ProcessGroupDetectionGroupExtractionArgs', 'ProcessGroupDetectionGroupExtractionArgsDict']]] = None,
            insert_after: Optional[pulumi.Input[builtins.str]] = None,
            instance_extraction: Optional[pulumi.Input[Union['ProcessGroupDetectionInstanceExtractionArgs', 'ProcessGroupDetectionInstanceExtractionArgsDict']]] = None,
            process_detection: Optional[pulumi.Input[Union['ProcessGroupDetectionProcessDetectionArgs', 'ProcessGroupDetectionProcessDetectionArgsDict']]] = None) -> 'ProcessGroupDetection':
        """
        Get an existing ProcessGroupDetection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[Union['ProcessGroupDetectionGroupExtractionArgs', 'ProcessGroupDetectionGroupExtractionArgsDict']] group_extraction: You can define the properties that should be used to identify your process groups.
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[Union['ProcessGroupDetectionInstanceExtractionArgs', 'ProcessGroupDetectionInstanceExtractionArgsDict']] instance_extraction: You can define the properties that should be used to identify your process instances.
        :param pulumi.Input[Union['ProcessGroupDetectionProcessDetectionArgs', 'ProcessGroupDetectionProcessDetectionArgsDict']] process_detection: Apply this rule to processes where the selected property contains the specified string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProcessGroupDetectionState.__new__(_ProcessGroupDetectionState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["group_extraction"] = group_extraction
        __props__.__dict__["insert_after"] = insert_after
        __props__.__dict__["instance_extraction"] = instance_extraction
        __props__.__dict__["process_detection"] = process_detection
        return ProcessGroupDetection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="groupExtraction")
    def group_extraction(self) -> pulumi.Output['outputs.ProcessGroupDetectionGroupExtraction']:
        """
        You can define the properties that should be used to identify your process groups.
        """
        return pulumi.get(self, "group_extraction")

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> pulumi.Output[builtins.str]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @property
    @pulumi.getter(name="instanceExtraction")
    def instance_extraction(self) -> pulumi.Output[Optional['outputs.ProcessGroupDetectionInstanceExtraction']]:
        """
        You can define the properties that should be used to identify your process instances.
        """
        return pulumi.get(self, "instance_extraction")

    @property
    @pulumi.getter(name="processDetection")
    def process_detection(self) -> pulumi.Output['outputs.ProcessGroupDetectionProcessDetection']:
        """
        Apply this rule to processes where the selected property contains the specified string.
        """
        return pulumi.get(self, "process_detection")

