# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProcessGroupRumArgs', 'ProcessGroupRum']

@pulumi.input_type
class ProcessGroupRumArgs:
    def __init__(__self__, *,
                 enable: pulumi.Input[builtins.bool],
                 process_group_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a ProcessGroupRum resource.
        :param pulumi.Input[builtins.bool] enable: Allows OneAgent to: * automatically inject the RUM JavaScript tag into each page delivered by this process group *
               provide the necessary info to correlate RUM data with server-side PurePaths * forward beacons to the cluster * deliver
               the monitoring code
        :param pulumi.Input[builtins.str] process_group_id: The scope of this setting - PROCESS_GROUP-XXXXXXXXXXXXXXXX
        """
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "process_group_id", process_group_id)

    @property
    @pulumi.getter
    def enable(self) -> pulumi.Input[builtins.bool]:
        """
        Allows OneAgent to: * automatically inject the RUM JavaScript tag into each page delivered by this process group *
        provide the necessary info to correlate RUM data with server-side PurePaths * forward beacons to the cluster * deliver
        the monitoring code
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="processGroupId")
    def process_group_id(self) -> pulumi.Input[builtins.str]:
        """
        The scope of this setting - PROCESS_GROUP-XXXXXXXXXXXXXXXX
        """
        return pulumi.get(self, "process_group_id")

    @process_group_id.setter
    def process_group_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "process_group_id", value)


@pulumi.input_type
class _ProcessGroupRumState:
    def __init__(__self__, *,
                 enable: Optional[pulumi.Input[builtins.bool]] = None,
                 process_group_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProcessGroupRum resources.
        :param pulumi.Input[builtins.bool] enable: Allows OneAgent to: * automatically inject the RUM JavaScript tag into each page delivered by this process group *
               provide the necessary info to correlate RUM data with server-side PurePaths * forward beacons to the cluster * deliver
               the monitoring code
        :param pulumi.Input[builtins.str] process_group_id: The scope of this setting - PROCESS_GROUP-XXXXXXXXXXXXXXXX
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if process_group_id is not None:
            pulumi.set(__self__, "process_group_id", process_group_id)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allows OneAgent to: * automatically inject the RUM JavaScript tag into each page delivered by this process group *
        provide the necessary info to correlate RUM data with server-side PurePaths * forward beacons to the cluster * deliver
        the monitoring code
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="processGroupId")
    def process_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of this setting - PROCESS_GROUP-XXXXXXXXXXXXXXXX
        """
        return pulumi.get(self, "process_group_id")

    @process_group_id.setter
    def process_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "process_group_id", value)


@pulumi.type_token("dynatrace:index/processGroupRum:ProcessGroupRum")
class ProcessGroupRum(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable: Optional[pulumi.Input[builtins.bool]] = None,
                 process_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a ProcessGroupRum resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enable: Allows OneAgent to: * automatically inject the RUM JavaScript tag into each page delivered by this process group *
               provide the necessary info to correlate RUM data with server-side PurePaths * forward beacons to the cluster * deliver
               the monitoring code
        :param pulumi.Input[builtins.str] process_group_id: The scope of this setting - PROCESS_GROUP-XXXXXXXXXXXXXXXX
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProcessGroupRumArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ProcessGroupRum resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ProcessGroupRumArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProcessGroupRumArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable: Optional[pulumi.Input[builtins.bool]] = None,
                 process_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProcessGroupRumArgs.__new__(ProcessGroupRumArgs)

            if enable is None and not opts.urn:
                raise TypeError("Missing required property 'enable'")
            __props__.__dict__["enable"] = enable
            if process_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'process_group_id'")
            __props__.__dict__["process_group_id"] = process_group_id
        super(ProcessGroupRum, __self__).__init__(
            'dynatrace:index/processGroupRum:ProcessGroupRum',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable: Optional[pulumi.Input[builtins.bool]] = None,
            process_group_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ProcessGroupRum':
        """
        Get an existing ProcessGroupRum resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enable: Allows OneAgent to: * automatically inject the RUM JavaScript tag into each page delivered by this process group *
               provide the necessary info to correlate RUM data with server-side PurePaths * forward beacons to the cluster * deliver
               the monitoring code
        :param pulumi.Input[builtins.str] process_group_id: The scope of this setting - PROCESS_GROUP-XXXXXXXXXXXXXXXX
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProcessGroupRumState.__new__(_ProcessGroupRumState)

        __props__.__dict__["enable"] = enable
        __props__.__dict__["process_group_id"] = process_group_id
        return ProcessGroupRum(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enable(self) -> pulumi.Output[builtins.bool]:
        """
        Allows OneAgent to: * automatically inject the RUM JavaScript tag into each page delivered by this process group *
        provide the necessary info to correlate RUM data with server-side PurePaths * forward beacons to the cluster * deliver
        the monitoring code
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="processGroupId")
    def process_group_id(self) -> pulumi.Output[builtins.str]:
        """
        The scope of this setting - PROCESS_GROUP-XXXXXXXXXXXXXXXX
        """
        return pulumi.get(self, "process_group_id")

