# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProcessMonitoringArgs', 'ProcessMonitoring']

@pulumi.input_type
class ProcessMonitoringArgs:
    def __init__(__self__, *,
                 auto_monitoring: pulumi.Input[builtins.bool],
                 host_group_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ProcessMonitoring resource.
        :param pulumi.Input[builtins.bool] auto_monitoring: By disabling automatic deep monitoring the Dynatrace OneAgent will only deep monitor processes that are covered by a respective deep monitoring rule or where monitoring is enabled explicitly.
               Disabling only works if all installed Agents have version 1.123 or higher.
        :param pulumi.Input[builtins.str] host_group_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        pulumi.set(__self__, "auto_monitoring", auto_monitoring)
        if host_group_id is not None:
            pulumi.set(__self__, "host_group_id", host_group_id)

    @property
    @pulumi.getter(name="autoMonitoring")
    def auto_monitoring(self) -> pulumi.Input[builtins.bool]:
        """
        By disabling automatic deep monitoring the Dynatrace OneAgent will only deep monitor processes that are covered by a respective deep monitoring rule or where monitoring is enabled explicitly.
        Disabling only works if all installed Agents have version 1.123 or higher.
        """
        return pulumi.get(self, "auto_monitoring")

    @auto_monitoring.setter
    def auto_monitoring(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "auto_monitoring", value)

    @property
    @pulumi.getter(name="hostGroupId")
    def host_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "host_group_id")

    @host_group_id.setter
    def host_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_group_id", value)


@pulumi.input_type
class _ProcessMonitoringState:
    def __init__(__self__, *,
                 auto_monitoring: Optional[pulumi.Input[builtins.bool]] = None,
                 host_group_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProcessMonitoring resources.
        :param pulumi.Input[builtins.bool] auto_monitoring: By disabling automatic deep monitoring the Dynatrace OneAgent will only deep monitor processes that are covered by a respective deep monitoring rule or where monitoring is enabled explicitly.
               Disabling only works if all installed Agents have version 1.123 or higher.
        :param pulumi.Input[builtins.str] host_group_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        if auto_monitoring is not None:
            pulumi.set(__self__, "auto_monitoring", auto_monitoring)
        if host_group_id is not None:
            pulumi.set(__self__, "host_group_id", host_group_id)

    @property
    @pulumi.getter(name="autoMonitoring")
    def auto_monitoring(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        By disabling automatic deep monitoring the Dynatrace OneAgent will only deep monitor processes that are covered by a respective deep monitoring rule or where monitoring is enabled explicitly.
        Disabling only works if all installed Agents have version 1.123 or higher.
        """
        return pulumi.get(self, "auto_monitoring")

    @auto_monitoring.setter
    def auto_monitoring(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_monitoring", value)

    @property
    @pulumi.getter(name="hostGroupId")
    def host_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "host_group_id")

    @host_group_id.setter
    def host_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_group_id", value)


@pulumi.type_token("dynatrace:index/processMonitoring:ProcessMonitoring")
class ProcessMonitoring(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_monitoring: Optional[pulumi.Input[builtins.bool]] = None,
                 host_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a ProcessMonitoring resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] auto_monitoring: By disabling automatic deep monitoring the Dynatrace OneAgent will only deep monitor processes that are covered by a respective deep monitoring rule or where monitoring is enabled explicitly.
               Disabling only works if all installed Agents have version 1.123 or higher.
        :param pulumi.Input[builtins.str] host_group_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProcessMonitoringArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ProcessMonitoring resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ProcessMonitoringArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProcessMonitoringArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_monitoring: Optional[pulumi.Input[builtins.bool]] = None,
                 host_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProcessMonitoringArgs.__new__(ProcessMonitoringArgs)

            if auto_monitoring is None and not opts.urn:
                raise TypeError("Missing required property 'auto_monitoring'")
            __props__.__dict__["auto_monitoring"] = auto_monitoring
            __props__.__dict__["host_group_id"] = host_group_id
        super(ProcessMonitoring, __self__).__init__(
            'dynatrace:index/processMonitoring:ProcessMonitoring',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_monitoring: Optional[pulumi.Input[builtins.bool]] = None,
            host_group_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ProcessMonitoring':
        """
        Get an existing ProcessMonitoring resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] auto_monitoring: By disabling automatic deep monitoring the Dynatrace OneAgent will only deep monitor processes that are covered by a respective deep monitoring rule or where monitoring is enabled explicitly.
               Disabling only works if all installed Agents have version 1.123 or higher.
        :param pulumi.Input[builtins.str] host_group_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProcessMonitoringState.__new__(_ProcessMonitoringState)

        __props__.__dict__["auto_monitoring"] = auto_monitoring
        __props__.__dict__["host_group_id"] = host_group_id
        return ProcessMonitoring(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoMonitoring")
    def auto_monitoring(self) -> pulumi.Output[builtins.bool]:
        """
        By disabling automatic deep monitoring the Dynatrace OneAgent will only deep monitor processes that are covered by a respective deep monitoring rule or where monitoring is enabled explicitly.
        Disabling only works if all installed Agents have version 1.123 or higher.
        """
        return pulumi.get(self, "auto_monitoring")

    @property
    @pulumi.getter(name="hostGroupId")
    def host_group_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "host_group_id")

