# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReportArgs', 'Report']

@pulumi.input_type
class ReportArgs:
    def __init__(__self__, *,
                 dashboard_id: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 email_notifications: Optional[pulumi.Input[builtins.bool]] = None,
                 subscriptions: Optional[pulumi.Input['ReportSubscriptionsArgs']] = None):
        """
        The set of arguments for constructing a Report resource.
        :param pulumi.Input[builtins.str] dashboard_id: The ID of the associated dashboard
        :param pulumi.Input[builtins.str] type: The type of report
        :param pulumi.Input[builtins.bool] email_notifications: The email notifications for the dashboard report are enabled (true) or disabled (false).
        :param pulumi.Input['ReportSubscriptionsArgs'] subscriptions: A list of the report subscribers
        """
        pulumi.set(__self__, "dashboard_id", dashboard_id)
        pulumi.set(__self__, "type", type)
        if email_notifications is not None:
            pulumi.set(__self__, "email_notifications", email_notifications)
        if subscriptions is not None:
            pulumi.set(__self__, "subscriptions", subscriptions)

    @property
    @pulumi.getter(name="dashboardId")
    def dashboard_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the associated dashboard
        """
        return pulumi.get(self, "dashboard_id")

    @dashboard_id.setter
    def dashboard_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "dashboard_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of report
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="emailNotifications")
    def email_notifications(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The email notifications for the dashboard report are enabled (true) or disabled (false).
        """
        return pulumi.get(self, "email_notifications")

    @email_notifications.setter
    def email_notifications(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "email_notifications", value)

    @property
    @pulumi.getter
    def subscriptions(self) -> Optional[pulumi.Input['ReportSubscriptionsArgs']]:
        """
        A list of the report subscribers
        """
        return pulumi.get(self, "subscriptions")

    @subscriptions.setter
    def subscriptions(self, value: Optional[pulumi.Input['ReportSubscriptionsArgs']]):
        pulumi.set(self, "subscriptions", value)


@pulumi.input_type
class _ReportState:
    def __init__(__self__, *,
                 dashboard_id: Optional[pulumi.Input[builtins.str]] = None,
                 email_notifications: Optional[pulumi.Input[builtins.bool]] = None,
                 subscriptions: Optional[pulumi.Input['ReportSubscriptionsArgs']] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Report resources.
        :param pulumi.Input[builtins.str] dashboard_id: The ID of the associated dashboard
        :param pulumi.Input[builtins.bool] email_notifications: The email notifications for the dashboard report are enabled (true) or disabled (false).
        :param pulumi.Input['ReportSubscriptionsArgs'] subscriptions: A list of the report subscribers
        :param pulumi.Input[builtins.str] type: The type of report
        """
        if dashboard_id is not None:
            pulumi.set(__self__, "dashboard_id", dashboard_id)
        if email_notifications is not None:
            pulumi.set(__self__, "email_notifications", email_notifications)
        if subscriptions is not None:
            pulumi.set(__self__, "subscriptions", subscriptions)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="dashboardId")
    def dashboard_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the associated dashboard
        """
        return pulumi.get(self, "dashboard_id")

    @dashboard_id.setter
    def dashboard_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dashboard_id", value)

    @property
    @pulumi.getter(name="emailNotifications")
    def email_notifications(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The email notifications for the dashboard report are enabled (true) or disabled (false).
        """
        return pulumi.get(self, "email_notifications")

    @email_notifications.setter
    def email_notifications(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "email_notifications", value)

    @property
    @pulumi.getter
    def subscriptions(self) -> Optional[pulumi.Input['ReportSubscriptionsArgs']]:
        """
        A list of the report subscribers
        """
        return pulumi.get(self, "subscriptions")

    @subscriptions.setter
    def subscriptions(self, value: Optional[pulumi.Input['ReportSubscriptionsArgs']]):
        pulumi.set(self, "subscriptions", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of report
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("dynatrace:index/report:Report")
class Report(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dashboard_id: Optional[pulumi.Input[builtins.str]] = None,
                 email_notifications: Optional[pulumi.Input[builtins.bool]] = None,
                 subscriptions: Optional[pulumi.Input[Union['ReportSubscriptionsArgs', 'ReportSubscriptionsArgsDict']]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        > This resource requires the API token scopes **Read configuration** (`ReadConfig`) and **Write configuration** (`WriteConfig`)

        ## Dynatrace Documentation

        - Subscribe to Dynatrace dashboard reports - https://docs.dynatrace.com/docs/observe-and-explore/dashboards-classic/dashboards/subscribe-to-dashboard-reports

        - Reports API - https://docs.dynatrace.com/docs/dynatrace-api/configuration-api/reports-api

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] dashboard_id: The ID of the associated dashboard
        :param pulumi.Input[builtins.bool] email_notifications: The email notifications for the dashboard report are enabled (true) or disabled (false).
        :param pulumi.Input[Union['ReportSubscriptionsArgs', 'ReportSubscriptionsArgsDict']] subscriptions: A list of the report subscribers
        :param pulumi.Input[builtins.str] type: The type of report
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReportArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > This resource requires the API token scopes **Read configuration** (`ReadConfig`) and **Write configuration** (`WriteConfig`)

        ## Dynatrace Documentation

        - Subscribe to Dynatrace dashboard reports - https://docs.dynatrace.com/docs/observe-and-explore/dashboards-classic/dashboards/subscribe-to-dashboard-reports

        - Reports API - https://docs.dynatrace.com/docs/dynatrace-api/configuration-api/reports-api

        :param str resource_name: The name of the resource.
        :param ReportArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReportArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dashboard_id: Optional[pulumi.Input[builtins.str]] = None,
                 email_notifications: Optional[pulumi.Input[builtins.bool]] = None,
                 subscriptions: Optional[pulumi.Input[Union['ReportSubscriptionsArgs', 'ReportSubscriptionsArgsDict']]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReportArgs.__new__(ReportArgs)

            if dashboard_id is None and not opts.urn:
                raise TypeError("Missing required property 'dashboard_id'")
            __props__.__dict__["dashboard_id"] = dashboard_id
            __props__.__dict__["email_notifications"] = email_notifications
            __props__.__dict__["subscriptions"] = subscriptions
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(Report, __self__).__init__(
            'dynatrace:index/report:Report',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dashboard_id: Optional[pulumi.Input[builtins.str]] = None,
            email_notifications: Optional[pulumi.Input[builtins.bool]] = None,
            subscriptions: Optional[pulumi.Input[Union['ReportSubscriptionsArgs', 'ReportSubscriptionsArgsDict']]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'Report':
        """
        Get an existing Report resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] dashboard_id: The ID of the associated dashboard
        :param pulumi.Input[builtins.bool] email_notifications: The email notifications for the dashboard report are enabled (true) or disabled (false).
        :param pulumi.Input[Union['ReportSubscriptionsArgs', 'ReportSubscriptionsArgsDict']] subscriptions: A list of the report subscribers
        :param pulumi.Input[builtins.str] type: The type of report
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReportState.__new__(_ReportState)

        __props__.__dict__["dashboard_id"] = dashboard_id
        __props__.__dict__["email_notifications"] = email_notifications
        __props__.__dict__["subscriptions"] = subscriptions
        __props__.__dict__["type"] = type
        return Report(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dashboardId")
    def dashboard_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the associated dashboard
        """
        return pulumi.get(self, "dashboard_id")

    @property
    @pulumi.getter(name="emailNotifications")
    def email_notifications(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        The email notifications for the dashboard report are enabled (true) or disabled (false).
        """
        return pulumi.get(self, "email_notifications")

    @property
    @pulumi.getter
    def subscriptions(self) -> pulumi.Output[Optional['outputs.ReportSubscriptions']]:
        """
        A list of the report subscribers
        """
        return pulumi.get(self, "subscriptions")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The type of report
        """
        return pulumi.get(self, "type")

