# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['RpcBasedSamplingArgs', 'RpcBasedSampling']

@pulumi.input_type
class RpcBasedSamplingArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool],
                 endpoint_name_comparison_type: pulumi.Input[builtins.str],
                 ignore: pulumi.Input[builtins.bool],
                 remote_operation_name_comparison_type: pulumi.Input[builtins.str],
                 remote_service_name_comparison_type: pulumi.Input[builtins.str],
                 wire_protocol_type: pulumi.Input[builtins.str],
                 endpoint_name: Optional[pulumi.Input[builtins.str]] = None,
                 factor: Optional[pulumi.Input[builtins.str]] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 remote_operation_name: Optional[pulumi.Input[builtins.str]] = None,
                 remote_service_name: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a RpcBasedSampling resource.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] endpoint_name_comparison_type: Possible Values: `CONTAINS`, `DOES_NOT_CONTAIN`, `DOES_NOT_END_WITH`, `DOES_NOT_EQUAL`, `DOES_NOT_START_WITH`,
               `ENDS_WITH`, `EQUALS`, `STARTS_WITH`
        :param pulumi.Input[builtins.bool] ignore: No Traces will be captured for matching RPC requests. This applies always, even if Adaptive Traffic Management is
               inactive.
        :param pulumi.Input[builtins.str] remote_operation_name_comparison_type: Possible Values: `CONTAINS`, `DOES_NOT_CONTAIN`, `DOES_NOT_END_WITH`, `DOES_NOT_EQUAL`, `DOES_NOT_START_WITH`,
               `ENDS_WITH`, `EQUALS`, `STARTS_WITH`
        :param pulumi.Input[builtins.str] remote_service_name_comparison_type: Possible Values: `CONTAINS`, `DOES_NOT_CONTAIN`, `DOES_NOT_END_WITH`, `DOES_NOT_EQUAL`, `DOES_NOT_START_WITH`,
               `ENDS_WITH`, `EQUALS`, `STARTS_WITH`
        :param pulumi.Input[builtins.str] wire_protocol_type: Possible Values: `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `10` - `1`: ADK - `2`: DOTNET_REMOTING - `3`:
               DOTNET_REMOTING_TCP - `4`: DOTNET_REMOTING_HTTP - `5`: DOTNET_REMOTING_XMLRPC - `6`: GRPC - `7`: GRPC_BIDI - `8`:
               GRPC_UNARY - `9`: GRPC_SERVERSTREAM - `10`: GRPC_CLIENTSTREAM
        :param pulumi.Input[builtins.str] endpoint_name: Specify the RPC endpoint name. If the endpoint name is empty, either remote operation name or remote service name must
               be specified that can be used for RPC matching.
        :param pulumi.Input[builtins.str] factor: Possible Values: `0`, `1`, `2`, `3`, `4`, `5`, `6`, `8`, `9`, `10`, `11`, `12`, `13`, `14` - `0`: Increase capturing 128
               times - `1`: Increase capturing 64 times - `2`: Increase capturing 32 times - `3`: Increase capturing 16 times - `4`:
               Increase capturing 8 times - `5`: Increase capturing 4 times - `6`: Increase capturing 2 times - `8`: Reduce capturing
               by factor 2 - `9`: Reduce capturing by factor 4 - `10`: Reduce capturing by factor 8 - `11`: Reduce capturing by factor
               16 - `12`: Reduce capturing by factor 32 - `13`: Reduce capturing by factor 64 - `14`: Reduce capturing by factor 128
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this
               instance regarding order. If not specified when creating the setting will be added to the end of the list. If not
               specified during update the order will remain untouched
        :param pulumi.Input[builtins.str] remote_operation_name: Specify the RPC operation name. If the remote operation name is empty, either remote service name or endpoint name must
               be specified that can be used for RPC matching.
        :param pulumi.Input[builtins.str] remote_service_name: Specify the RPC remote service name. If the remote service name is empty, either remote operation name or endpoint name
               must be specified that can be used for RPC matching.
        :param pulumi.Input[builtins.str] scope: The scope of this setting (PROCESS_GROUP_INSTANCE, PROCESS_GROUP, CLOUD_APPLICATION, CLOUD_APPLICATION_NAMESPACE,
               KUBERNETES_CLUSTER, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "endpoint_name_comparison_type", endpoint_name_comparison_type)
        pulumi.set(__self__, "ignore", ignore)
        pulumi.set(__self__, "remote_operation_name_comparison_type", remote_operation_name_comparison_type)
        pulumi.set(__self__, "remote_service_name_comparison_type", remote_service_name_comparison_type)
        pulumi.set(__self__, "wire_protocol_type", wire_protocol_type)
        if endpoint_name is not None:
            pulumi.set(__self__, "endpoint_name", endpoint_name)
        if factor is not None:
            pulumi.set(__self__, "factor", factor)
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)
        if remote_operation_name is not None:
            pulumi.set(__self__, "remote_operation_name", remote_operation_name)
        if remote_service_name is not None:
            pulumi.set(__self__, "remote_service_name", remote_service_name)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="endpointNameComparisonType")
    def endpoint_name_comparison_type(self) -> pulumi.Input[builtins.str]:
        """
        Possible Values: `CONTAINS`, `DOES_NOT_CONTAIN`, `DOES_NOT_END_WITH`, `DOES_NOT_EQUAL`, `DOES_NOT_START_WITH`,
        `ENDS_WITH`, `EQUALS`, `STARTS_WITH`
        """
        return pulumi.get(self, "endpoint_name_comparison_type")

    @endpoint_name_comparison_type.setter
    def endpoint_name_comparison_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "endpoint_name_comparison_type", value)

    @property
    @pulumi.getter
    def ignore(self) -> pulumi.Input[builtins.bool]:
        """
        No Traces will be captured for matching RPC requests. This applies always, even if Adaptive Traffic Management is
        inactive.
        """
        return pulumi.get(self, "ignore")

    @ignore.setter
    def ignore(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "ignore", value)

    @property
    @pulumi.getter(name="remoteOperationNameComparisonType")
    def remote_operation_name_comparison_type(self) -> pulumi.Input[builtins.str]:
        """
        Possible Values: `CONTAINS`, `DOES_NOT_CONTAIN`, `DOES_NOT_END_WITH`, `DOES_NOT_EQUAL`, `DOES_NOT_START_WITH`,
        `ENDS_WITH`, `EQUALS`, `STARTS_WITH`
        """
        return pulumi.get(self, "remote_operation_name_comparison_type")

    @remote_operation_name_comparison_type.setter
    def remote_operation_name_comparison_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "remote_operation_name_comparison_type", value)

    @property
    @pulumi.getter(name="remoteServiceNameComparisonType")
    def remote_service_name_comparison_type(self) -> pulumi.Input[builtins.str]:
        """
        Possible Values: `CONTAINS`, `DOES_NOT_CONTAIN`, `DOES_NOT_END_WITH`, `DOES_NOT_EQUAL`, `DOES_NOT_START_WITH`,
        `ENDS_WITH`, `EQUALS`, `STARTS_WITH`
        """
        return pulumi.get(self, "remote_service_name_comparison_type")

    @remote_service_name_comparison_type.setter
    def remote_service_name_comparison_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "remote_service_name_comparison_type", value)

    @property
    @pulumi.getter(name="wireProtocolType")
    def wire_protocol_type(self) -> pulumi.Input[builtins.str]:
        """
        Possible Values: `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `10` - `1`: ADK - `2`: DOTNET_REMOTING - `3`:
        DOTNET_REMOTING_TCP - `4`: DOTNET_REMOTING_HTTP - `5`: DOTNET_REMOTING_XMLRPC - `6`: GRPC - `7`: GRPC_BIDI - `8`:
        GRPC_UNARY - `9`: GRPC_SERVERSTREAM - `10`: GRPC_CLIENTSTREAM
        """
        return pulumi.get(self, "wire_protocol_type")

    @wire_protocol_type.setter
    def wire_protocol_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "wire_protocol_type", value)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specify the RPC endpoint name. If the endpoint name is empty, either remote operation name or remote service name must
        be specified that can be used for RPC matching.
        """
        return pulumi.get(self, "endpoint_name")

    @endpoint_name.setter
    def endpoint_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_name", value)

    @property
    @pulumi.getter
    def factor(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Possible Values: `0`, `1`, `2`, `3`, `4`, `5`, `6`, `8`, `9`, `10`, `11`, `12`, `13`, `14` - `0`: Increase capturing 128
        times - `1`: Increase capturing 64 times - `2`: Increase capturing 32 times - `3`: Increase capturing 16 times - `4`:
        Increase capturing 8 times - `5`: Increase capturing 4 times - `6`: Increase capturing 2 times - `8`: Reduce capturing
        by factor 2 - `9`: Reduce capturing by factor 4 - `10`: Reduce capturing by factor 8 - `11`: Reduce capturing by factor
        16 - `12`: Reduce capturing by factor 32 - `13`: Reduce capturing by factor 64 - `14`: Reduce capturing by factor 128
        """
        return pulumi.get(self, "factor")

    @factor.setter
    def factor(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "factor", value)

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this
        instance regarding order. If not specified when creating the setting will be added to the end of the list. If not
        specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "insert_after", value)

    @property
    @pulumi.getter(name="remoteOperationName")
    def remote_operation_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specify the RPC operation name. If the remote operation name is empty, either remote service name or endpoint name must
        be specified that can be used for RPC matching.
        """
        return pulumi.get(self, "remote_operation_name")

    @remote_operation_name.setter
    def remote_operation_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "remote_operation_name", value)

    @property
    @pulumi.getter(name="remoteServiceName")
    def remote_service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specify the RPC remote service name. If the remote service name is empty, either remote operation name or endpoint name
        must be specified that can be used for RPC matching.
        """
        return pulumi.get(self, "remote_service_name")

    @remote_service_name.setter
    def remote_service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "remote_service_name", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of this setting (PROCESS_GROUP_INSTANCE, PROCESS_GROUP, CLOUD_APPLICATION, CLOUD_APPLICATION_NAMESPACE,
        KUBERNETES_CLUSTER, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class _RpcBasedSamplingState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 endpoint_name: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_name_comparison_type: Optional[pulumi.Input[builtins.str]] = None,
                 factor: Optional[pulumi.Input[builtins.str]] = None,
                 ignore: Optional[pulumi.Input[builtins.bool]] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 remote_operation_name: Optional[pulumi.Input[builtins.str]] = None,
                 remote_operation_name_comparison_type: Optional[pulumi.Input[builtins.str]] = None,
                 remote_service_name: Optional[pulumi.Input[builtins.str]] = None,
                 remote_service_name_comparison_type: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 wire_protocol_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering RpcBasedSampling resources.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] endpoint_name: Specify the RPC endpoint name. If the endpoint name is empty, either remote operation name or remote service name must
               be specified that can be used for RPC matching.
        :param pulumi.Input[builtins.str] endpoint_name_comparison_type: Possible Values: `CONTAINS`, `DOES_NOT_CONTAIN`, `DOES_NOT_END_WITH`, `DOES_NOT_EQUAL`, `DOES_NOT_START_WITH`,
               `ENDS_WITH`, `EQUALS`, `STARTS_WITH`
        :param pulumi.Input[builtins.str] factor: Possible Values: `0`, `1`, `2`, `3`, `4`, `5`, `6`, `8`, `9`, `10`, `11`, `12`, `13`, `14` - `0`: Increase capturing 128
               times - `1`: Increase capturing 64 times - `2`: Increase capturing 32 times - `3`: Increase capturing 16 times - `4`:
               Increase capturing 8 times - `5`: Increase capturing 4 times - `6`: Increase capturing 2 times - `8`: Reduce capturing
               by factor 2 - `9`: Reduce capturing by factor 4 - `10`: Reduce capturing by factor 8 - `11`: Reduce capturing by factor
               16 - `12`: Reduce capturing by factor 32 - `13`: Reduce capturing by factor 64 - `14`: Reduce capturing by factor 128
        :param pulumi.Input[builtins.bool] ignore: No Traces will be captured for matching RPC requests. This applies always, even if Adaptive Traffic Management is
               inactive.
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this
               instance regarding order. If not specified when creating the setting will be added to the end of the list. If not
               specified during update the order will remain untouched
        :param pulumi.Input[builtins.str] remote_operation_name: Specify the RPC operation name. If the remote operation name is empty, either remote service name or endpoint name must
               be specified that can be used for RPC matching.
        :param pulumi.Input[builtins.str] remote_operation_name_comparison_type: Possible Values: `CONTAINS`, `DOES_NOT_CONTAIN`, `DOES_NOT_END_WITH`, `DOES_NOT_EQUAL`, `DOES_NOT_START_WITH`,
               `ENDS_WITH`, `EQUALS`, `STARTS_WITH`
        :param pulumi.Input[builtins.str] remote_service_name: Specify the RPC remote service name. If the remote service name is empty, either remote operation name or endpoint name
               must be specified that can be used for RPC matching.
        :param pulumi.Input[builtins.str] remote_service_name_comparison_type: Possible Values: `CONTAINS`, `DOES_NOT_CONTAIN`, `DOES_NOT_END_WITH`, `DOES_NOT_EQUAL`, `DOES_NOT_START_WITH`,
               `ENDS_WITH`, `EQUALS`, `STARTS_WITH`
        :param pulumi.Input[builtins.str] scope: The scope of this setting (PROCESS_GROUP_INSTANCE, PROCESS_GROUP, CLOUD_APPLICATION, CLOUD_APPLICATION_NAMESPACE,
               KUBERNETES_CLUSTER, HOST_GROUP). Omit this property if you want to cover the whole environment.
        :param pulumi.Input[builtins.str] wire_protocol_type: Possible Values: `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `10` - `1`: ADK - `2`: DOTNET_REMOTING - `3`:
               DOTNET_REMOTING_TCP - `4`: DOTNET_REMOTING_HTTP - `5`: DOTNET_REMOTING_XMLRPC - `6`: GRPC - `7`: GRPC_BIDI - `8`:
               GRPC_UNARY - `9`: GRPC_SERVERSTREAM - `10`: GRPC_CLIENTSTREAM
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if endpoint_name is not None:
            pulumi.set(__self__, "endpoint_name", endpoint_name)
        if endpoint_name_comparison_type is not None:
            pulumi.set(__self__, "endpoint_name_comparison_type", endpoint_name_comparison_type)
        if factor is not None:
            pulumi.set(__self__, "factor", factor)
        if ignore is not None:
            pulumi.set(__self__, "ignore", ignore)
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)
        if remote_operation_name is not None:
            pulumi.set(__self__, "remote_operation_name", remote_operation_name)
        if remote_operation_name_comparison_type is not None:
            pulumi.set(__self__, "remote_operation_name_comparison_type", remote_operation_name_comparison_type)
        if remote_service_name is not None:
            pulumi.set(__self__, "remote_service_name", remote_service_name)
        if remote_service_name_comparison_type is not None:
            pulumi.set(__self__, "remote_service_name_comparison_type", remote_service_name_comparison_type)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if wire_protocol_type is not None:
            pulumi.set(__self__, "wire_protocol_type", wire_protocol_type)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specify the RPC endpoint name. If the endpoint name is empty, either remote operation name or remote service name must
        be specified that can be used for RPC matching.
        """
        return pulumi.get(self, "endpoint_name")

    @endpoint_name.setter
    def endpoint_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_name", value)

    @property
    @pulumi.getter(name="endpointNameComparisonType")
    def endpoint_name_comparison_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Possible Values: `CONTAINS`, `DOES_NOT_CONTAIN`, `DOES_NOT_END_WITH`, `DOES_NOT_EQUAL`, `DOES_NOT_START_WITH`,
        `ENDS_WITH`, `EQUALS`, `STARTS_WITH`
        """
        return pulumi.get(self, "endpoint_name_comparison_type")

    @endpoint_name_comparison_type.setter
    def endpoint_name_comparison_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_name_comparison_type", value)

    @property
    @pulumi.getter
    def factor(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Possible Values: `0`, `1`, `2`, `3`, `4`, `5`, `6`, `8`, `9`, `10`, `11`, `12`, `13`, `14` - `0`: Increase capturing 128
        times - `1`: Increase capturing 64 times - `2`: Increase capturing 32 times - `3`: Increase capturing 16 times - `4`:
        Increase capturing 8 times - `5`: Increase capturing 4 times - `6`: Increase capturing 2 times - `8`: Reduce capturing
        by factor 2 - `9`: Reduce capturing by factor 4 - `10`: Reduce capturing by factor 8 - `11`: Reduce capturing by factor
        16 - `12`: Reduce capturing by factor 32 - `13`: Reduce capturing by factor 64 - `14`: Reduce capturing by factor 128
        """
        return pulumi.get(self, "factor")

    @factor.setter
    def factor(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "factor", value)

    @property
    @pulumi.getter
    def ignore(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        No Traces will be captured for matching RPC requests. This applies always, even if Adaptive Traffic Management is
        inactive.
        """
        return pulumi.get(self, "ignore")

    @ignore.setter
    def ignore(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ignore", value)

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this
        instance regarding order. If not specified when creating the setting will be added to the end of the list. If not
        specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "insert_after", value)

    @property
    @pulumi.getter(name="remoteOperationName")
    def remote_operation_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specify the RPC operation name. If the remote operation name is empty, either remote service name or endpoint name must
        be specified that can be used for RPC matching.
        """
        return pulumi.get(self, "remote_operation_name")

    @remote_operation_name.setter
    def remote_operation_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "remote_operation_name", value)

    @property
    @pulumi.getter(name="remoteOperationNameComparisonType")
    def remote_operation_name_comparison_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Possible Values: `CONTAINS`, `DOES_NOT_CONTAIN`, `DOES_NOT_END_WITH`, `DOES_NOT_EQUAL`, `DOES_NOT_START_WITH`,
        `ENDS_WITH`, `EQUALS`, `STARTS_WITH`
        """
        return pulumi.get(self, "remote_operation_name_comparison_type")

    @remote_operation_name_comparison_type.setter
    def remote_operation_name_comparison_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "remote_operation_name_comparison_type", value)

    @property
    @pulumi.getter(name="remoteServiceName")
    def remote_service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specify the RPC remote service name. If the remote service name is empty, either remote operation name or endpoint name
        must be specified that can be used for RPC matching.
        """
        return pulumi.get(self, "remote_service_name")

    @remote_service_name.setter
    def remote_service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "remote_service_name", value)

    @property
    @pulumi.getter(name="remoteServiceNameComparisonType")
    def remote_service_name_comparison_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Possible Values: `CONTAINS`, `DOES_NOT_CONTAIN`, `DOES_NOT_END_WITH`, `DOES_NOT_EQUAL`, `DOES_NOT_START_WITH`,
        `ENDS_WITH`, `EQUALS`, `STARTS_WITH`
        """
        return pulumi.get(self, "remote_service_name_comparison_type")

    @remote_service_name_comparison_type.setter
    def remote_service_name_comparison_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "remote_service_name_comparison_type", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of this setting (PROCESS_GROUP_INSTANCE, PROCESS_GROUP, CLOUD_APPLICATION, CLOUD_APPLICATION_NAMESPACE,
        KUBERNETES_CLUSTER, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="wireProtocolType")
    def wire_protocol_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Possible Values: `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `10` - `1`: ADK - `2`: DOTNET_REMOTING - `3`:
        DOTNET_REMOTING_TCP - `4`: DOTNET_REMOTING_HTTP - `5`: DOTNET_REMOTING_XMLRPC - `6`: GRPC - `7`: GRPC_BIDI - `8`:
        GRPC_UNARY - `9`: GRPC_SERVERSTREAM - `10`: GRPC_CLIENTSTREAM
        """
        return pulumi.get(self, "wire_protocol_type")

    @wire_protocol_type.setter
    def wire_protocol_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "wire_protocol_type", value)


@pulumi.type_token("dynatrace:index/rpcBasedSampling:RpcBasedSampling")
class RpcBasedSampling(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 endpoint_name: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_name_comparison_type: Optional[pulumi.Input[builtins.str]] = None,
                 factor: Optional[pulumi.Input[builtins.str]] = None,
                 ignore: Optional[pulumi.Input[builtins.bool]] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 remote_operation_name: Optional[pulumi.Input[builtins.str]] = None,
                 remote_operation_name_comparison_type: Optional[pulumi.Input[builtins.str]] = None,
                 remote_service_name: Optional[pulumi.Input[builtins.str]] = None,
                 remote_service_name_comparison_type: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 wire_protocol_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        > This resource requires the API token scopes **Read settings** (`settings.read`) and **Write settings** (`settings.write`)

        ## Dynatrace Documentation

        - Trace sampling - https://docs.dynatrace.com/docs/shortlink/url-sampling

        - Settings API - https://www.dynatrace.com/support/help/dynatrace-api/environment-api/settings (schemaId: `builtin:rpc-based-sampling`)

        ## Resource Example Usage

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        _name_ = dynatrace.RpcBasedSampling("#name#",
            enabled=False,
            endpoint_name="#name#-endpoint",
            endpoint_name_comparison_type="DOES_NOT_END_WITH",
            ignore=True,
            remote_operation_name="#name#-operation",
            remote_operation_name_comparison_type="CONTAINS",
            remote_service_name="#name#-service",
            remote_service_name_comparison_type="STARTS_WITH",
            scope="environment",
            wire_protocol_type="8")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] endpoint_name: Specify the RPC endpoint name. If the endpoint name is empty, either remote operation name or remote service name must
               be specified that can be used for RPC matching.
        :param pulumi.Input[builtins.str] endpoint_name_comparison_type: Possible Values: `CONTAINS`, `DOES_NOT_CONTAIN`, `DOES_NOT_END_WITH`, `DOES_NOT_EQUAL`, `DOES_NOT_START_WITH`,
               `ENDS_WITH`, `EQUALS`, `STARTS_WITH`
        :param pulumi.Input[builtins.str] factor: Possible Values: `0`, `1`, `2`, `3`, `4`, `5`, `6`, `8`, `9`, `10`, `11`, `12`, `13`, `14` - `0`: Increase capturing 128
               times - `1`: Increase capturing 64 times - `2`: Increase capturing 32 times - `3`: Increase capturing 16 times - `4`:
               Increase capturing 8 times - `5`: Increase capturing 4 times - `6`: Increase capturing 2 times - `8`: Reduce capturing
               by factor 2 - `9`: Reduce capturing by factor 4 - `10`: Reduce capturing by factor 8 - `11`: Reduce capturing by factor
               16 - `12`: Reduce capturing by factor 32 - `13`: Reduce capturing by factor 64 - `14`: Reduce capturing by factor 128
        :param pulumi.Input[builtins.bool] ignore: No Traces will be captured for matching RPC requests. This applies always, even if Adaptive Traffic Management is
               inactive.
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this
               instance regarding order. If not specified when creating the setting will be added to the end of the list. If not
               specified during update the order will remain untouched
        :param pulumi.Input[builtins.str] remote_operation_name: Specify the RPC operation name. If the remote operation name is empty, either remote service name or endpoint name must
               be specified that can be used for RPC matching.
        :param pulumi.Input[builtins.str] remote_operation_name_comparison_type: Possible Values: `CONTAINS`, `DOES_NOT_CONTAIN`, `DOES_NOT_END_WITH`, `DOES_NOT_EQUAL`, `DOES_NOT_START_WITH`,
               `ENDS_WITH`, `EQUALS`, `STARTS_WITH`
        :param pulumi.Input[builtins.str] remote_service_name: Specify the RPC remote service name. If the remote service name is empty, either remote operation name or endpoint name
               must be specified that can be used for RPC matching.
        :param pulumi.Input[builtins.str] remote_service_name_comparison_type: Possible Values: `CONTAINS`, `DOES_NOT_CONTAIN`, `DOES_NOT_END_WITH`, `DOES_NOT_EQUAL`, `DOES_NOT_START_WITH`,
               `ENDS_WITH`, `EQUALS`, `STARTS_WITH`
        :param pulumi.Input[builtins.str] scope: The scope of this setting (PROCESS_GROUP_INSTANCE, PROCESS_GROUP, CLOUD_APPLICATION, CLOUD_APPLICATION_NAMESPACE,
               KUBERNETES_CLUSTER, HOST_GROUP). Omit this property if you want to cover the whole environment.
        :param pulumi.Input[builtins.str] wire_protocol_type: Possible Values: `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `10` - `1`: ADK - `2`: DOTNET_REMOTING - `3`:
               DOTNET_REMOTING_TCP - `4`: DOTNET_REMOTING_HTTP - `5`: DOTNET_REMOTING_XMLRPC - `6`: GRPC - `7`: GRPC_BIDI - `8`:
               GRPC_UNARY - `9`: GRPC_SERVERSTREAM - `10`: GRPC_CLIENTSTREAM
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RpcBasedSamplingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > This resource requires the API token scopes **Read settings** (`settings.read`) and **Write settings** (`settings.write`)

        ## Dynatrace Documentation

        - Trace sampling - https://docs.dynatrace.com/docs/shortlink/url-sampling

        - Settings API - https://www.dynatrace.com/support/help/dynatrace-api/environment-api/settings (schemaId: `builtin:rpc-based-sampling`)

        ## Resource Example Usage

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        _name_ = dynatrace.RpcBasedSampling("#name#",
            enabled=False,
            endpoint_name="#name#-endpoint",
            endpoint_name_comparison_type="DOES_NOT_END_WITH",
            ignore=True,
            remote_operation_name="#name#-operation",
            remote_operation_name_comparison_type="CONTAINS",
            remote_service_name="#name#-service",
            remote_service_name_comparison_type="STARTS_WITH",
            scope="environment",
            wire_protocol_type="8")
        ```

        :param str resource_name: The name of the resource.
        :param RpcBasedSamplingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RpcBasedSamplingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 endpoint_name: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_name_comparison_type: Optional[pulumi.Input[builtins.str]] = None,
                 factor: Optional[pulumi.Input[builtins.str]] = None,
                 ignore: Optional[pulumi.Input[builtins.bool]] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 remote_operation_name: Optional[pulumi.Input[builtins.str]] = None,
                 remote_operation_name_comparison_type: Optional[pulumi.Input[builtins.str]] = None,
                 remote_service_name: Optional[pulumi.Input[builtins.str]] = None,
                 remote_service_name_comparison_type: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 wire_protocol_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RpcBasedSamplingArgs.__new__(RpcBasedSamplingArgs)

            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["endpoint_name"] = endpoint_name
            if endpoint_name_comparison_type is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_name_comparison_type'")
            __props__.__dict__["endpoint_name_comparison_type"] = endpoint_name_comparison_type
            __props__.__dict__["factor"] = factor
            if ignore is None and not opts.urn:
                raise TypeError("Missing required property 'ignore'")
            __props__.__dict__["ignore"] = ignore
            __props__.__dict__["insert_after"] = insert_after
            __props__.__dict__["remote_operation_name"] = remote_operation_name
            if remote_operation_name_comparison_type is None and not opts.urn:
                raise TypeError("Missing required property 'remote_operation_name_comparison_type'")
            __props__.__dict__["remote_operation_name_comparison_type"] = remote_operation_name_comparison_type
            __props__.__dict__["remote_service_name"] = remote_service_name
            if remote_service_name_comparison_type is None and not opts.urn:
                raise TypeError("Missing required property 'remote_service_name_comparison_type'")
            __props__.__dict__["remote_service_name_comparison_type"] = remote_service_name_comparison_type
            __props__.__dict__["scope"] = scope
            if wire_protocol_type is None and not opts.urn:
                raise TypeError("Missing required property 'wire_protocol_type'")
            __props__.__dict__["wire_protocol_type"] = wire_protocol_type
        super(RpcBasedSampling, __self__).__init__(
            'dynatrace:index/rpcBasedSampling:RpcBasedSampling',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            endpoint_name: Optional[pulumi.Input[builtins.str]] = None,
            endpoint_name_comparison_type: Optional[pulumi.Input[builtins.str]] = None,
            factor: Optional[pulumi.Input[builtins.str]] = None,
            ignore: Optional[pulumi.Input[builtins.bool]] = None,
            insert_after: Optional[pulumi.Input[builtins.str]] = None,
            remote_operation_name: Optional[pulumi.Input[builtins.str]] = None,
            remote_operation_name_comparison_type: Optional[pulumi.Input[builtins.str]] = None,
            remote_service_name: Optional[pulumi.Input[builtins.str]] = None,
            remote_service_name_comparison_type: Optional[pulumi.Input[builtins.str]] = None,
            scope: Optional[pulumi.Input[builtins.str]] = None,
            wire_protocol_type: Optional[pulumi.Input[builtins.str]] = None) -> 'RpcBasedSampling':
        """
        Get an existing RpcBasedSampling resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] endpoint_name: Specify the RPC endpoint name. If the endpoint name is empty, either remote operation name or remote service name must
               be specified that can be used for RPC matching.
        :param pulumi.Input[builtins.str] endpoint_name_comparison_type: Possible Values: `CONTAINS`, `DOES_NOT_CONTAIN`, `DOES_NOT_END_WITH`, `DOES_NOT_EQUAL`, `DOES_NOT_START_WITH`,
               `ENDS_WITH`, `EQUALS`, `STARTS_WITH`
        :param pulumi.Input[builtins.str] factor: Possible Values: `0`, `1`, `2`, `3`, `4`, `5`, `6`, `8`, `9`, `10`, `11`, `12`, `13`, `14` - `0`: Increase capturing 128
               times - `1`: Increase capturing 64 times - `2`: Increase capturing 32 times - `3`: Increase capturing 16 times - `4`:
               Increase capturing 8 times - `5`: Increase capturing 4 times - `6`: Increase capturing 2 times - `8`: Reduce capturing
               by factor 2 - `9`: Reduce capturing by factor 4 - `10`: Reduce capturing by factor 8 - `11`: Reduce capturing by factor
               16 - `12`: Reduce capturing by factor 32 - `13`: Reduce capturing by factor 64 - `14`: Reduce capturing by factor 128
        :param pulumi.Input[builtins.bool] ignore: No Traces will be captured for matching RPC requests. This applies always, even if Adaptive Traffic Management is
               inactive.
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this
               instance regarding order. If not specified when creating the setting will be added to the end of the list. If not
               specified during update the order will remain untouched
        :param pulumi.Input[builtins.str] remote_operation_name: Specify the RPC operation name. If the remote operation name is empty, either remote service name or endpoint name must
               be specified that can be used for RPC matching.
        :param pulumi.Input[builtins.str] remote_operation_name_comparison_type: Possible Values: `CONTAINS`, `DOES_NOT_CONTAIN`, `DOES_NOT_END_WITH`, `DOES_NOT_EQUAL`, `DOES_NOT_START_WITH`,
               `ENDS_WITH`, `EQUALS`, `STARTS_WITH`
        :param pulumi.Input[builtins.str] remote_service_name: Specify the RPC remote service name. If the remote service name is empty, either remote operation name or endpoint name
               must be specified that can be used for RPC matching.
        :param pulumi.Input[builtins.str] remote_service_name_comparison_type: Possible Values: `CONTAINS`, `DOES_NOT_CONTAIN`, `DOES_NOT_END_WITH`, `DOES_NOT_EQUAL`, `DOES_NOT_START_WITH`,
               `ENDS_WITH`, `EQUALS`, `STARTS_WITH`
        :param pulumi.Input[builtins.str] scope: The scope of this setting (PROCESS_GROUP_INSTANCE, PROCESS_GROUP, CLOUD_APPLICATION, CLOUD_APPLICATION_NAMESPACE,
               KUBERNETES_CLUSTER, HOST_GROUP). Omit this property if you want to cover the whole environment.
        :param pulumi.Input[builtins.str] wire_protocol_type: Possible Values: `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `10` - `1`: ADK - `2`: DOTNET_REMOTING - `3`:
               DOTNET_REMOTING_TCP - `4`: DOTNET_REMOTING_HTTP - `5`: DOTNET_REMOTING_XMLRPC - `6`: GRPC - `7`: GRPC_BIDI - `8`:
               GRPC_UNARY - `9`: GRPC_SERVERSTREAM - `10`: GRPC_CLIENTSTREAM
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RpcBasedSamplingState.__new__(_RpcBasedSamplingState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["endpoint_name"] = endpoint_name
        __props__.__dict__["endpoint_name_comparison_type"] = endpoint_name_comparison_type
        __props__.__dict__["factor"] = factor
        __props__.__dict__["ignore"] = ignore
        __props__.__dict__["insert_after"] = insert_after
        __props__.__dict__["remote_operation_name"] = remote_operation_name
        __props__.__dict__["remote_operation_name_comparison_type"] = remote_operation_name_comparison_type
        __props__.__dict__["remote_service_name"] = remote_service_name
        __props__.__dict__["remote_service_name_comparison_type"] = remote_service_name_comparison_type
        __props__.__dict__["scope"] = scope
        __props__.__dict__["wire_protocol_type"] = wire_protocol_type
        return RpcBasedSampling(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specify the RPC endpoint name. If the endpoint name is empty, either remote operation name or remote service name must
        be specified that can be used for RPC matching.
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="endpointNameComparisonType")
    def endpoint_name_comparison_type(self) -> pulumi.Output[builtins.str]:
        """
        Possible Values: `CONTAINS`, `DOES_NOT_CONTAIN`, `DOES_NOT_END_WITH`, `DOES_NOT_EQUAL`, `DOES_NOT_START_WITH`,
        `ENDS_WITH`, `EQUALS`, `STARTS_WITH`
        """
        return pulumi.get(self, "endpoint_name_comparison_type")

    @property
    @pulumi.getter
    def factor(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Possible Values: `0`, `1`, `2`, `3`, `4`, `5`, `6`, `8`, `9`, `10`, `11`, `12`, `13`, `14` - `0`: Increase capturing 128
        times - `1`: Increase capturing 64 times - `2`: Increase capturing 32 times - `3`: Increase capturing 16 times - `4`:
        Increase capturing 8 times - `5`: Increase capturing 4 times - `6`: Increase capturing 2 times - `8`: Reduce capturing
        by factor 2 - `9`: Reduce capturing by factor 4 - `10`: Reduce capturing by factor 8 - `11`: Reduce capturing by factor
        16 - `12`: Reduce capturing by factor 32 - `13`: Reduce capturing by factor 64 - `14`: Reduce capturing by factor 128
        """
        return pulumi.get(self, "factor")

    @property
    @pulumi.getter
    def ignore(self) -> pulumi.Output[builtins.bool]:
        """
        No Traces will be captured for matching RPC requests. This applies always, even if Adaptive Traffic Management is
        inactive.
        """
        return pulumi.get(self, "ignore")

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> pulumi.Output[builtins.str]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this
        instance regarding order. If not specified when creating the setting will be added to the end of the list. If not
        specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @property
    @pulumi.getter(name="remoteOperationName")
    def remote_operation_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specify the RPC operation name. If the remote operation name is empty, either remote service name or endpoint name must
        be specified that can be used for RPC matching.
        """
        return pulumi.get(self, "remote_operation_name")

    @property
    @pulumi.getter(name="remoteOperationNameComparisonType")
    def remote_operation_name_comparison_type(self) -> pulumi.Output[builtins.str]:
        """
        Possible Values: `CONTAINS`, `DOES_NOT_CONTAIN`, `DOES_NOT_END_WITH`, `DOES_NOT_EQUAL`, `DOES_NOT_START_WITH`,
        `ENDS_WITH`, `EQUALS`, `STARTS_WITH`
        """
        return pulumi.get(self, "remote_operation_name_comparison_type")

    @property
    @pulumi.getter(name="remoteServiceName")
    def remote_service_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specify the RPC remote service name. If the remote service name is empty, either remote operation name or endpoint name
        must be specified that can be used for RPC matching.
        """
        return pulumi.get(self, "remote_service_name")

    @property
    @pulumi.getter(name="remoteServiceNameComparisonType")
    def remote_service_name_comparison_type(self) -> pulumi.Output[builtins.str]:
        """
        Possible Values: `CONTAINS`, `DOES_NOT_CONTAIN`, `DOES_NOT_END_WITH`, `DOES_NOT_EQUAL`, `DOES_NOT_START_WITH`,
        `ENDS_WITH`, `EQUALS`, `STARTS_WITH`
        """
        return pulumi.get(self, "remote_service_name_comparison_type")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The scope of this setting (PROCESS_GROUP_INSTANCE, PROCESS_GROUP, CLOUD_APPLICATION, CLOUD_APPLICATION_NAMESPACE,
        KUBERNETES_CLUSTER, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="wireProtocolType")
    def wire_protocol_type(self) -> pulumi.Output[builtins.str]:
        """
        Possible Values: `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `10` - `1`: ADK - `2`: DOTNET_REMOTING - `3`:
        DOTNET_REMOTING_TCP - `4`: DOTNET_REMOTING_HTTP - `5`: DOTNET_REMOTING_XMLRPC - `6`: GRPC - `7`: GRPC_BIDI - `8`:
        GRPC_UNARY - `9`: GRPC_SERVERSTREAM - `10`: GRPC_CLIENTSTREAM
        """
        return pulumi.get(self, "wire_protocol_type")

