# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceHttpFailureArgs', 'ServiceHttpFailure']

@pulumi.input_type
class ServiceHttpFailureArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool],
                 service_id: pulumi.Input[builtins.str],
                 broken_links: Optional[pulumi.Input['ServiceHttpFailureBrokenLinksArgs']] = None,
                 http_response_codes: Optional[pulumi.Input['ServiceHttpFailureHttpResponseCodesArgs']] = None):
        """
        The set of arguments for constructing a ServiceHttpFailure resource.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] service_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        :param pulumi.Input['ServiceHttpFailureBrokenLinksArgs'] broken_links: HTTP 404 response codes are thrown when a web server can't find a certain page. 404s are classified as broken links on the client side and therefore aren't considered to be service failures. By enabling this setting, you can have 404s treated as server-side service failures.
        :param pulumi.Input['ServiceHttpFailureHttpResponseCodesArgs'] http_response_codes: HTTP response codes
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "service_id", service_id)
        if broken_links is not None:
            pulumi.set(__self__, "broken_links", broken_links)
        if http_response_codes is not None:
            pulumi.set(__self__, "http_response_codes", http_response_codes)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Input[builtins.str]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter(name="brokenLinks")
    def broken_links(self) -> Optional[pulumi.Input['ServiceHttpFailureBrokenLinksArgs']]:
        """
        HTTP 404 response codes are thrown when a web server can't find a certain page. 404s are classified as broken links on the client side and therefore aren't considered to be service failures. By enabling this setting, you can have 404s treated as server-side service failures.
        """
        return pulumi.get(self, "broken_links")

    @broken_links.setter
    def broken_links(self, value: Optional[pulumi.Input['ServiceHttpFailureBrokenLinksArgs']]):
        pulumi.set(self, "broken_links", value)

    @property
    @pulumi.getter(name="httpResponseCodes")
    def http_response_codes(self) -> Optional[pulumi.Input['ServiceHttpFailureHttpResponseCodesArgs']]:
        """
        HTTP response codes
        """
        return pulumi.get(self, "http_response_codes")

    @http_response_codes.setter
    def http_response_codes(self, value: Optional[pulumi.Input['ServiceHttpFailureHttpResponseCodesArgs']]):
        pulumi.set(self, "http_response_codes", value)


@pulumi.input_type
class _ServiceHttpFailureState:
    def __init__(__self__, *,
                 broken_links: Optional[pulumi.Input['ServiceHttpFailureBrokenLinksArgs']] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 http_response_codes: Optional[pulumi.Input['ServiceHttpFailureHttpResponseCodesArgs']] = None,
                 service_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceHttpFailure resources.
        :param pulumi.Input['ServiceHttpFailureBrokenLinksArgs'] broken_links: HTTP 404 response codes are thrown when a web server can't find a certain page. 404s are classified as broken links on the client side and therefore aren't considered to be service failures. By enabling this setting, you can have 404s treated as server-side service failures.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input['ServiceHttpFailureHttpResponseCodesArgs'] http_response_codes: HTTP response codes
        :param pulumi.Input[builtins.str] service_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        if broken_links is not None:
            pulumi.set(__self__, "broken_links", broken_links)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if http_response_codes is not None:
            pulumi.set(__self__, "http_response_codes", http_response_codes)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)

    @property
    @pulumi.getter(name="brokenLinks")
    def broken_links(self) -> Optional[pulumi.Input['ServiceHttpFailureBrokenLinksArgs']]:
        """
        HTTP 404 response codes are thrown when a web server can't find a certain page. 404s are classified as broken links on the client side and therefore aren't considered to be service failures. By enabling this setting, you can have 404s treated as server-side service failures.
        """
        return pulumi.get(self, "broken_links")

    @broken_links.setter
    def broken_links(self, value: Optional[pulumi.Input['ServiceHttpFailureBrokenLinksArgs']]):
        pulumi.set(self, "broken_links", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="httpResponseCodes")
    def http_response_codes(self) -> Optional[pulumi.Input['ServiceHttpFailureHttpResponseCodesArgs']]:
        """
        HTTP response codes
        """
        return pulumi.get(self, "http_response_codes")

    @http_response_codes.setter
    def http_response_codes(self, value: Optional[pulumi.Input['ServiceHttpFailureHttpResponseCodesArgs']]):
        pulumi.set(self, "http_response_codes", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_id", value)


@pulumi.type_token("dynatrace:index/serviceHttpFailure:ServiceHttpFailure")
class ServiceHttpFailure(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 broken_links: Optional[pulumi.Input[Union['ServiceHttpFailureBrokenLinksArgs', 'ServiceHttpFailureBrokenLinksArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 http_response_codes: Optional[pulumi.Input[Union['ServiceHttpFailureHttpResponseCodesArgs', 'ServiceHttpFailureHttpResponseCodesArgsDict']]] = None,
                 service_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a ServiceHttpFailure resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServiceHttpFailureBrokenLinksArgs', 'ServiceHttpFailureBrokenLinksArgsDict']] broken_links: HTTP 404 response codes are thrown when a web server can't find a certain page. 404s are classified as broken links on the client side and therefore aren't considered to be service failures. By enabling this setting, you can have 404s treated as server-side service failures.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[Union['ServiceHttpFailureHttpResponseCodesArgs', 'ServiceHttpFailureHttpResponseCodesArgsDict']] http_response_codes: HTTP response codes
        :param pulumi.Input[builtins.str] service_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceHttpFailureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ServiceHttpFailure resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ServiceHttpFailureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceHttpFailureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 broken_links: Optional[pulumi.Input[Union['ServiceHttpFailureBrokenLinksArgs', 'ServiceHttpFailureBrokenLinksArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 http_response_codes: Optional[pulumi.Input[Union['ServiceHttpFailureHttpResponseCodesArgs', 'ServiceHttpFailureHttpResponseCodesArgsDict']]] = None,
                 service_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceHttpFailureArgs.__new__(ServiceHttpFailureArgs)

            __props__.__dict__["broken_links"] = broken_links
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["http_response_codes"] = http_response_codes
            if service_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_id'")
            __props__.__dict__["service_id"] = service_id
        super(ServiceHttpFailure, __self__).__init__(
            'dynatrace:index/serviceHttpFailure:ServiceHttpFailure',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            broken_links: Optional[pulumi.Input[Union['ServiceHttpFailureBrokenLinksArgs', 'ServiceHttpFailureBrokenLinksArgsDict']]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            http_response_codes: Optional[pulumi.Input[Union['ServiceHttpFailureHttpResponseCodesArgs', 'ServiceHttpFailureHttpResponseCodesArgsDict']]] = None,
            service_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ServiceHttpFailure':
        """
        Get an existing ServiceHttpFailure resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServiceHttpFailureBrokenLinksArgs', 'ServiceHttpFailureBrokenLinksArgsDict']] broken_links: HTTP 404 response codes are thrown when a web server can't find a certain page. 404s are classified as broken links on the client side and therefore aren't considered to be service failures. By enabling this setting, you can have 404s treated as server-side service failures.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[Union['ServiceHttpFailureHttpResponseCodesArgs', 'ServiceHttpFailureHttpResponseCodesArgsDict']] http_response_codes: HTTP response codes
        :param pulumi.Input[builtins.str] service_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceHttpFailureState.__new__(_ServiceHttpFailureState)

        __props__.__dict__["broken_links"] = broken_links
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["http_response_codes"] = http_response_codes
        __props__.__dict__["service_id"] = service_id
        return ServiceHttpFailure(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="brokenLinks")
    def broken_links(self) -> pulumi.Output[Optional['outputs.ServiceHttpFailureBrokenLinks']]:
        """
        HTTP 404 response codes are thrown when a web server can't find a certain page. 404s are classified as broken links on the client side and therefore aren't considered to be service failures. By enabling this setting, you can have 404s treated as server-side service failures.
        """
        return pulumi.get(self, "broken_links")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="httpResponseCodes")
    def http_response_codes(self) -> pulumi.Output[Optional['outputs.ServiceHttpFailureHttpResponseCodes']]:
        """
        HTTP response codes
        """
        return pulumi.get(self, "http_response_codes")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[builtins.str]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "service_id")

