# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SpanEntryPointArgs', 'SpanEntryPoint']

@pulumi.input_type
class SpanEntryPointArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[builtins.str],
                 matches: pulumi.Input['SpanEntryPointMatchesArgs'],
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a SpanEntryPoint resource.
        :param pulumi.Input[builtins.str] action: Whether to create an entry point or not
        :param pulumi.Input['SpanEntryPointMatchesArgs'] matches: Matching strategies for the Span
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[builtins.str] name: The name of the rule
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "matches", matches)
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[builtins.str]:
        """
        Whether to create an entry point or not
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def matches(self) -> pulumi.Input['SpanEntryPointMatchesArgs']:
        """
        Matching strategies for the Span
        """
        return pulumi.get(self, "matches")

    @matches.setter
    def matches(self, value: pulumi.Input['SpanEntryPointMatchesArgs']):
        pulumi.set(self, "matches", value)

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "insert_after", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _SpanEntryPointState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 matches: Optional[pulumi.Input['SpanEntryPointMatchesArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SpanEntryPoint resources.
        :param pulumi.Input[builtins.str] action: Whether to create an entry point or not
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input['SpanEntryPointMatchesArgs'] matches: Matching strategies for the Span
        :param pulumi.Input[builtins.str] name: The name of the rule
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)
        if matches is not None:
            pulumi.set(__self__, "matches", matches)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether to create an entry point or not
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "insert_after", value)

    @property
    @pulumi.getter
    def matches(self) -> Optional[pulumi.Input['SpanEntryPointMatchesArgs']]:
        """
        Matching strategies for the Span
        """
        return pulumi.get(self, "matches")

    @matches.setter
    def matches(self, value: Optional[pulumi.Input['SpanEntryPointMatchesArgs']]):
        pulumi.set(self, "matches", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("dynatrace:index/spanEntryPoint:SpanEntryPoint")
class SpanEntryPoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 matches: Optional[pulumi.Input[Union['SpanEntryPointMatchesArgs', 'SpanEntryPointMatchesArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a SpanEntryPoint resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] action: Whether to create an entry point or not
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[Union['SpanEntryPointMatchesArgs', 'SpanEntryPointMatchesArgsDict']] matches: Matching strategies for the Span
        :param pulumi.Input[builtins.str] name: The name of the rule
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpanEntryPointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a SpanEntryPoint resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param SpanEntryPointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpanEntryPointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 matches: Optional[pulumi.Input[Union['SpanEntryPointMatchesArgs', 'SpanEntryPointMatchesArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpanEntryPointArgs.__new__(SpanEntryPointArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            __props__.__dict__["insert_after"] = insert_after
            if matches is None and not opts.urn:
                raise TypeError("Missing required property 'matches'")
            __props__.__dict__["matches"] = matches
            __props__.__dict__["name"] = name
        super(SpanEntryPoint, __self__).__init__(
            'dynatrace:index/spanEntryPoint:SpanEntryPoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[builtins.str]] = None,
            insert_after: Optional[pulumi.Input[builtins.str]] = None,
            matches: Optional[pulumi.Input[Union['SpanEntryPointMatchesArgs', 'SpanEntryPointMatchesArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None) -> 'SpanEntryPoint':
        """
        Get an existing SpanEntryPoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] action: Whether to create an entry point or not
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[Union['SpanEntryPointMatchesArgs', 'SpanEntryPointMatchesArgsDict']] matches: Matching strategies for the Span
        :param pulumi.Input[builtins.str] name: The name of the rule
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpanEntryPointState.__new__(_SpanEntryPointState)

        __props__.__dict__["action"] = action
        __props__.__dict__["insert_after"] = insert_after
        __props__.__dict__["matches"] = matches
        __props__.__dict__["name"] = name
        return SpanEntryPoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[builtins.str]:
        """
        Whether to create an entry point or not
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> pulumi.Output[builtins.str]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @property
    @pulumi.getter
    def matches(self) -> pulumi.Output['outputs.SpanEntryPointMatches']:
        """
        Matching strategies for the Span
        """
        return pulumi.get(self, "matches")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the rule
        """
        return pulumi.get(self, "name")

