# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SyntheticLocationArgs', 'SyntheticLocation']

@pulumi.input_type
class SyntheticLocationArgs:
    def __init__(__self__, *,
                 latitude: pulumi.Input[builtins.float],
                 longitude: pulumi.Input[builtins.float],
                 auto_update_chromium: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_location_outage: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_node_outage: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_notifications_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 city: Optional[pulumi.Input[builtins.str]] = None,
                 country_code: Optional[pulumi.Input[builtins.str]] = None,
                 deployment_type: Optional[pulumi.Input[builtins.str]] = None,
                 location_node_outage_delay_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 max_active_gate_count: Optional[pulumi.Input[builtins.int]] = None,
                 min_active_gate_count: Optional[pulumi.Input[builtins.int]] = None,
                 nam_execution_supported: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_size: Optional[pulumi.Input[builtins.str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 region_code: Optional[pulumi.Input[builtins.str]] = None,
                 use_new_kubernetes_version: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a SyntheticLocation resource.
        :param pulumi.Input[builtins.float] latitude: The latitude of the location in `DDD.dddd` format
        :param pulumi.Input[builtins.float] longitude: The longitude of the location in `DDD.dddd` format
        :param pulumi.Input[builtins.bool] auto_update_chromium: Auto upgrade of Chromium is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.bool] availability_location_outage: The alerting of location outage is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.bool] availability_node_outage: The alerting of node outage is enabled (`true`) or disabled (`false`).
        :param pulumi.Input[builtins.bool] availability_notifications_enabled: The notifications of location and node outage is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] city: The city of the location
        :param pulumi.Input[builtins.str] country_code: The country code of the location. To fetch the list of available country codes, use the [GET all
               countries](https://dt-url.net/37030go) request
        :param pulumi.Input[builtins.str] deployment_type: The deployment type of the location: * `STANDARD`: The location is deployed on Windows or Linux. * `KUBERNETES`: The
               location is deployed on Kubernetes
        :param pulumi.Input[builtins.int] location_node_outage_delay_in_minutes: Alert if the location or node outage lasts longer than *X* minutes. Only applicable when
               **availability_location_outage** or **availability_node_outage** is set to `true`
        :param pulumi.Input[builtins.int] max_active_gate_count: The maximum number of Active Gates required for that location. Not required when `deployment_type` is set to `STANDARD`
        :param pulumi.Input[builtins.int] min_active_gate_count: The minimum number of Active Gates required for that location. Not required when `deployment_type` is set to `STANDARD`
        :param pulumi.Input[builtins.bool] nam_execution_supported: Boolean value describes if icmp monitors will be executed on this location
        :param pulumi.Input[builtins.str] name: The name of the location
        :param pulumi.Input[builtins.str] node_size: Possible values: `UNSUPPORTED`, `XS`, `S` and `M`. Not required when `deployment_type` is set to `STANDARD`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nodes: A list of synthetic nodes belonging to the location. You can retrieve the list of available nodes with the [GET all
               nodes](https://dt-url.net/miy3rpl) call
        :param pulumi.Input[builtins.str] region_code: The region code of the location. To fetch the list of available region codes, use the [GET regions of the
               country](https://dt-url.net/az230x0) request
        :param pulumi.Input[builtins.bool] use_new_kubernetes_version: Boolean value describes which kubernetes version will be used
        """
        pulumi.set(__self__, "latitude", latitude)
        pulumi.set(__self__, "longitude", longitude)
        if auto_update_chromium is not None:
            pulumi.set(__self__, "auto_update_chromium", auto_update_chromium)
        if availability_location_outage is not None:
            pulumi.set(__self__, "availability_location_outage", availability_location_outage)
        if availability_node_outage is not None:
            pulumi.set(__self__, "availability_node_outage", availability_node_outage)
        if availability_notifications_enabled is not None:
            pulumi.set(__self__, "availability_notifications_enabled", availability_notifications_enabled)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if location_node_outage_delay_in_minutes is not None:
            pulumi.set(__self__, "location_node_outage_delay_in_minutes", location_node_outage_delay_in_minutes)
        if max_active_gate_count is not None:
            pulumi.set(__self__, "max_active_gate_count", max_active_gate_count)
        if min_active_gate_count is not None:
            pulumi.set(__self__, "min_active_gate_count", min_active_gate_count)
        if nam_execution_supported is not None:
            pulumi.set(__self__, "nam_execution_supported", nam_execution_supported)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_size is not None:
            pulumi.set(__self__, "node_size", node_size)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if region_code is not None:
            pulumi.set(__self__, "region_code", region_code)
        if use_new_kubernetes_version is not None:
            pulumi.set(__self__, "use_new_kubernetes_version", use_new_kubernetes_version)

    @property
    @pulumi.getter
    def latitude(self) -> pulumi.Input[builtins.float]:
        """
        The latitude of the location in `DDD.dddd` format
        """
        return pulumi.get(self, "latitude")

    @latitude.setter
    def latitude(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "latitude", value)

    @property
    @pulumi.getter
    def longitude(self) -> pulumi.Input[builtins.float]:
        """
        The longitude of the location in `DDD.dddd` format
        """
        return pulumi.get(self, "longitude")

    @longitude.setter
    def longitude(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "longitude", value)

    @property
    @pulumi.getter(name="autoUpdateChromium")
    def auto_update_chromium(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Auto upgrade of Chromium is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "auto_update_chromium")

    @auto_update_chromium.setter
    def auto_update_chromium(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_update_chromium", value)

    @property
    @pulumi.getter(name="availabilityLocationOutage")
    def availability_location_outage(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The alerting of location outage is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "availability_location_outage")

    @availability_location_outage.setter
    def availability_location_outage(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "availability_location_outage", value)

    @property
    @pulumi.getter(name="availabilityNodeOutage")
    def availability_node_outage(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The alerting of node outage is enabled (`true`) or disabled (`false`).
        """
        return pulumi.get(self, "availability_node_outage")

    @availability_node_outage.setter
    def availability_node_outage(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "availability_node_outage", value)

    @property
    @pulumi.getter(name="availabilityNotificationsEnabled")
    def availability_notifications_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The notifications of location and node outage is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "availability_notifications_enabled")

    @availability_notifications_enabled.setter
    def availability_notifications_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "availability_notifications_enabled", value)

    @property
    @pulumi.getter
    def city(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The city of the location
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "city", value)

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The country code of the location. To fetch the list of available country codes, use the [GET all
        countries](https://dt-url.net/37030go) request
        """
        return pulumi.get(self, "country_code")

    @country_code.setter
    def country_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "country_code", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The deployment type of the location: * `STANDARD`: The location is deployed on Windows or Linux. * `KUBERNETES`: The
        location is deployed on Kubernetes
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="locationNodeOutageDelayInMinutes")
    def location_node_outage_delay_in_minutes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Alert if the location or node outage lasts longer than *X* minutes. Only applicable when
        **availability_location_outage** or **availability_node_outage** is set to `true`
        """
        return pulumi.get(self, "location_node_outage_delay_in_minutes")

    @location_node_outage_delay_in_minutes.setter
    def location_node_outage_delay_in_minutes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "location_node_outage_delay_in_minutes", value)

    @property
    @pulumi.getter(name="maxActiveGateCount")
    def max_active_gate_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of Active Gates required for that location. Not required when `deployment_type` is set to `STANDARD`
        """
        return pulumi.get(self, "max_active_gate_count")

    @max_active_gate_count.setter
    def max_active_gate_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_active_gate_count", value)

    @property
    @pulumi.getter(name="minActiveGateCount")
    def min_active_gate_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum number of Active Gates required for that location. Not required when `deployment_type` is set to `STANDARD`
        """
        return pulumi.get(self, "min_active_gate_count")

    @min_active_gate_count.setter
    def min_active_gate_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_active_gate_count", value)

    @property
    @pulumi.getter(name="namExecutionSupported")
    def nam_execution_supported(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean value describes if icmp monitors will be executed on this location
        """
        return pulumi.get(self, "nam_execution_supported")

    @nam_execution_supported.setter
    def nam_execution_supported(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "nam_execution_supported", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the location
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeSize")
    def node_size(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Possible values: `UNSUPPORTED`, `XS`, `S` and `M`. Not required when `deployment_type` is set to `STANDARD`.
        """
        return pulumi.get(self, "node_size")

    @node_size.setter
    def node_size(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_size", value)

    @property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of synthetic nodes belonging to the location. You can retrieve the list of available nodes with the [GET all
        nodes](https://dt-url.net/miy3rpl) call
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "nodes", value)

    @property
    @pulumi.getter(name="regionCode")
    def region_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region code of the location. To fetch the list of available region codes, use the [GET regions of the
        country](https://dt-url.net/az230x0) request
        """
        return pulumi.get(self, "region_code")

    @region_code.setter
    def region_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region_code", value)

    @property
    @pulumi.getter(name="useNewKubernetesVersion")
    def use_new_kubernetes_version(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean value describes which kubernetes version will be used
        """
        return pulumi.get(self, "use_new_kubernetes_version")

    @use_new_kubernetes_version.setter
    def use_new_kubernetes_version(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_new_kubernetes_version", value)


@pulumi.input_type
class _SyntheticLocationState:
    def __init__(__self__, *,
                 auto_update_chromium: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_location_outage: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_node_outage: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_notifications_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 city: Optional[pulumi.Input[builtins.str]] = None,
                 country_code: Optional[pulumi.Input[builtins.str]] = None,
                 deployment_type: Optional[pulumi.Input[builtins.str]] = None,
                 latitude: Optional[pulumi.Input[builtins.float]] = None,
                 location_node_outage_delay_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 longitude: Optional[pulumi.Input[builtins.float]] = None,
                 max_active_gate_count: Optional[pulumi.Input[builtins.int]] = None,
                 min_active_gate_count: Optional[pulumi.Input[builtins.int]] = None,
                 nam_execution_supported: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_size: Optional[pulumi.Input[builtins.str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 region_code: Optional[pulumi.Input[builtins.str]] = None,
                 use_new_kubernetes_version: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering SyntheticLocation resources.
        :param pulumi.Input[builtins.bool] auto_update_chromium: Auto upgrade of Chromium is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.bool] availability_location_outage: The alerting of location outage is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.bool] availability_node_outage: The alerting of node outage is enabled (`true`) or disabled (`false`).
        :param pulumi.Input[builtins.bool] availability_notifications_enabled: The notifications of location and node outage is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] city: The city of the location
        :param pulumi.Input[builtins.str] country_code: The country code of the location. To fetch the list of available country codes, use the [GET all
               countries](https://dt-url.net/37030go) request
        :param pulumi.Input[builtins.str] deployment_type: The deployment type of the location: * `STANDARD`: The location is deployed on Windows or Linux. * `KUBERNETES`: The
               location is deployed on Kubernetes
        :param pulumi.Input[builtins.float] latitude: The latitude of the location in `DDD.dddd` format
        :param pulumi.Input[builtins.int] location_node_outage_delay_in_minutes: Alert if the location or node outage lasts longer than *X* minutes. Only applicable when
               **availability_location_outage** or **availability_node_outage** is set to `true`
        :param pulumi.Input[builtins.float] longitude: The longitude of the location in `DDD.dddd` format
        :param pulumi.Input[builtins.int] max_active_gate_count: The maximum number of Active Gates required for that location. Not required when `deployment_type` is set to `STANDARD`
        :param pulumi.Input[builtins.int] min_active_gate_count: The minimum number of Active Gates required for that location. Not required when `deployment_type` is set to `STANDARD`
        :param pulumi.Input[builtins.bool] nam_execution_supported: Boolean value describes if icmp monitors will be executed on this location
        :param pulumi.Input[builtins.str] name: The name of the location
        :param pulumi.Input[builtins.str] node_size: Possible values: `UNSUPPORTED`, `XS`, `S` and `M`. Not required when `deployment_type` is set to `STANDARD`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nodes: A list of synthetic nodes belonging to the location. You can retrieve the list of available nodes with the [GET all
               nodes](https://dt-url.net/miy3rpl) call
        :param pulumi.Input[builtins.str] region_code: The region code of the location. To fetch the list of available region codes, use the [GET regions of the
               country](https://dt-url.net/az230x0) request
        :param pulumi.Input[builtins.bool] use_new_kubernetes_version: Boolean value describes which kubernetes version will be used
        """
        if auto_update_chromium is not None:
            pulumi.set(__self__, "auto_update_chromium", auto_update_chromium)
        if availability_location_outage is not None:
            pulumi.set(__self__, "availability_location_outage", availability_location_outage)
        if availability_node_outage is not None:
            pulumi.set(__self__, "availability_node_outage", availability_node_outage)
        if availability_notifications_enabled is not None:
            pulumi.set(__self__, "availability_notifications_enabled", availability_notifications_enabled)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if latitude is not None:
            pulumi.set(__self__, "latitude", latitude)
        if location_node_outage_delay_in_minutes is not None:
            pulumi.set(__self__, "location_node_outage_delay_in_minutes", location_node_outage_delay_in_minutes)
        if longitude is not None:
            pulumi.set(__self__, "longitude", longitude)
        if max_active_gate_count is not None:
            pulumi.set(__self__, "max_active_gate_count", max_active_gate_count)
        if min_active_gate_count is not None:
            pulumi.set(__self__, "min_active_gate_count", min_active_gate_count)
        if nam_execution_supported is not None:
            pulumi.set(__self__, "nam_execution_supported", nam_execution_supported)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_size is not None:
            pulumi.set(__self__, "node_size", node_size)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if region_code is not None:
            pulumi.set(__self__, "region_code", region_code)
        if use_new_kubernetes_version is not None:
            pulumi.set(__self__, "use_new_kubernetes_version", use_new_kubernetes_version)

    @property
    @pulumi.getter(name="autoUpdateChromium")
    def auto_update_chromium(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Auto upgrade of Chromium is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "auto_update_chromium")

    @auto_update_chromium.setter
    def auto_update_chromium(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_update_chromium", value)

    @property
    @pulumi.getter(name="availabilityLocationOutage")
    def availability_location_outage(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The alerting of location outage is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "availability_location_outage")

    @availability_location_outage.setter
    def availability_location_outage(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "availability_location_outage", value)

    @property
    @pulumi.getter(name="availabilityNodeOutage")
    def availability_node_outage(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The alerting of node outage is enabled (`true`) or disabled (`false`).
        """
        return pulumi.get(self, "availability_node_outage")

    @availability_node_outage.setter
    def availability_node_outage(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "availability_node_outage", value)

    @property
    @pulumi.getter(name="availabilityNotificationsEnabled")
    def availability_notifications_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The notifications of location and node outage is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "availability_notifications_enabled")

    @availability_notifications_enabled.setter
    def availability_notifications_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "availability_notifications_enabled", value)

    @property
    @pulumi.getter
    def city(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The city of the location
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "city", value)

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The country code of the location. To fetch the list of available country codes, use the [GET all
        countries](https://dt-url.net/37030go) request
        """
        return pulumi.get(self, "country_code")

    @country_code.setter
    def country_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "country_code", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The deployment type of the location: * `STANDARD`: The location is deployed on Windows or Linux. * `KUBERNETES`: The
        location is deployed on Kubernetes
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter
    def latitude(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The latitude of the location in `DDD.dddd` format
        """
        return pulumi.get(self, "latitude")

    @latitude.setter
    def latitude(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "latitude", value)

    @property
    @pulumi.getter(name="locationNodeOutageDelayInMinutes")
    def location_node_outage_delay_in_minutes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Alert if the location or node outage lasts longer than *X* minutes. Only applicable when
        **availability_location_outage** or **availability_node_outage** is set to `true`
        """
        return pulumi.get(self, "location_node_outage_delay_in_minutes")

    @location_node_outage_delay_in_minutes.setter
    def location_node_outage_delay_in_minutes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "location_node_outage_delay_in_minutes", value)

    @property
    @pulumi.getter
    def longitude(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The longitude of the location in `DDD.dddd` format
        """
        return pulumi.get(self, "longitude")

    @longitude.setter
    def longitude(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "longitude", value)

    @property
    @pulumi.getter(name="maxActiveGateCount")
    def max_active_gate_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of Active Gates required for that location. Not required when `deployment_type` is set to `STANDARD`
        """
        return pulumi.get(self, "max_active_gate_count")

    @max_active_gate_count.setter
    def max_active_gate_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_active_gate_count", value)

    @property
    @pulumi.getter(name="minActiveGateCount")
    def min_active_gate_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum number of Active Gates required for that location. Not required when `deployment_type` is set to `STANDARD`
        """
        return pulumi.get(self, "min_active_gate_count")

    @min_active_gate_count.setter
    def min_active_gate_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_active_gate_count", value)

    @property
    @pulumi.getter(name="namExecutionSupported")
    def nam_execution_supported(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean value describes if icmp monitors will be executed on this location
        """
        return pulumi.get(self, "nam_execution_supported")

    @nam_execution_supported.setter
    def nam_execution_supported(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "nam_execution_supported", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the location
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeSize")
    def node_size(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Possible values: `UNSUPPORTED`, `XS`, `S` and `M`. Not required when `deployment_type` is set to `STANDARD`.
        """
        return pulumi.get(self, "node_size")

    @node_size.setter
    def node_size(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_size", value)

    @property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of synthetic nodes belonging to the location. You can retrieve the list of available nodes with the [GET all
        nodes](https://dt-url.net/miy3rpl) call
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "nodes", value)

    @property
    @pulumi.getter(name="regionCode")
    def region_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region code of the location. To fetch the list of available region codes, use the [GET regions of the
        country](https://dt-url.net/az230x0) request
        """
        return pulumi.get(self, "region_code")

    @region_code.setter
    def region_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region_code", value)

    @property
    @pulumi.getter(name="useNewKubernetesVersion")
    def use_new_kubernetes_version(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean value describes which kubernetes version will be used
        """
        return pulumi.get(self, "use_new_kubernetes_version")

    @use_new_kubernetes_version.setter
    def use_new_kubernetes_version(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_new_kubernetes_version", value)


@pulumi.type_token("dynatrace:index/syntheticLocation:SyntheticLocation")
class SyntheticLocation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_update_chromium: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_location_outage: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_node_outage: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_notifications_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 city: Optional[pulumi.Input[builtins.str]] = None,
                 country_code: Optional[pulumi.Input[builtins.str]] = None,
                 deployment_type: Optional[pulumi.Input[builtins.str]] = None,
                 latitude: Optional[pulumi.Input[builtins.float]] = None,
                 location_node_outage_delay_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 longitude: Optional[pulumi.Input[builtins.float]] = None,
                 max_active_gate_count: Optional[pulumi.Input[builtins.int]] = None,
                 min_active_gate_count: Optional[pulumi.Input[builtins.int]] = None,
                 nam_execution_supported: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_size: Optional[pulumi.Input[builtins.str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 region_code: Optional[pulumi.Input[builtins.str]] = None,
                 use_new_kubernetes_version: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        Create a SyntheticLocation resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] auto_update_chromium: Auto upgrade of Chromium is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.bool] availability_location_outage: The alerting of location outage is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.bool] availability_node_outage: The alerting of node outage is enabled (`true`) or disabled (`false`).
        :param pulumi.Input[builtins.bool] availability_notifications_enabled: The notifications of location and node outage is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] city: The city of the location
        :param pulumi.Input[builtins.str] country_code: The country code of the location. To fetch the list of available country codes, use the [GET all
               countries](https://dt-url.net/37030go) request
        :param pulumi.Input[builtins.str] deployment_type: The deployment type of the location: * `STANDARD`: The location is deployed on Windows or Linux. * `KUBERNETES`: The
               location is deployed on Kubernetes
        :param pulumi.Input[builtins.float] latitude: The latitude of the location in `DDD.dddd` format
        :param pulumi.Input[builtins.int] location_node_outage_delay_in_minutes: Alert if the location or node outage lasts longer than *X* minutes. Only applicable when
               **availability_location_outage** or **availability_node_outage** is set to `true`
        :param pulumi.Input[builtins.float] longitude: The longitude of the location in `DDD.dddd` format
        :param pulumi.Input[builtins.int] max_active_gate_count: The maximum number of Active Gates required for that location. Not required when `deployment_type` is set to `STANDARD`
        :param pulumi.Input[builtins.int] min_active_gate_count: The minimum number of Active Gates required for that location. Not required when `deployment_type` is set to `STANDARD`
        :param pulumi.Input[builtins.bool] nam_execution_supported: Boolean value describes if icmp monitors will be executed on this location
        :param pulumi.Input[builtins.str] name: The name of the location
        :param pulumi.Input[builtins.str] node_size: Possible values: `UNSUPPORTED`, `XS`, `S` and `M`. Not required when `deployment_type` is set to `STANDARD`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nodes: A list of synthetic nodes belonging to the location. You can retrieve the list of available nodes with the [GET all
               nodes](https://dt-url.net/miy3rpl) call
        :param pulumi.Input[builtins.str] region_code: The region code of the location. To fetch the list of available region codes, use the [GET regions of the
               country](https://dt-url.net/az230x0) request
        :param pulumi.Input[builtins.bool] use_new_kubernetes_version: Boolean value describes which kubernetes version will be used
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SyntheticLocationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a SyntheticLocation resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param SyntheticLocationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SyntheticLocationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_update_chromium: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_location_outage: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_node_outage: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_notifications_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 city: Optional[pulumi.Input[builtins.str]] = None,
                 country_code: Optional[pulumi.Input[builtins.str]] = None,
                 deployment_type: Optional[pulumi.Input[builtins.str]] = None,
                 latitude: Optional[pulumi.Input[builtins.float]] = None,
                 location_node_outage_delay_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 longitude: Optional[pulumi.Input[builtins.float]] = None,
                 max_active_gate_count: Optional[pulumi.Input[builtins.int]] = None,
                 min_active_gate_count: Optional[pulumi.Input[builtins.int]] = None,
                 nam_execution_supported: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_size: Optional[pulumi.Input[builtins.str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 region_code: Optional[pulumi.Input[builtins.str]] = None,
                 use_new_kubernetes_version: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SyntheticLocationArgs.__new__(SyntheticLocationArgs)

            __props__.__dict__["auto_update_chromium"] = auto_update_chromium
            __props__.__dict__["availability_location_outage"] = availability_location_outage
            __props__.__dict__["availability_node_outage"] = availability_node_outage
            __props__.__dict__["availability_notifications_enabled"] = availability_notifications_enabled
            __props__.__dict__["city"] = city
            __props__.__dict__["country_code"] = country_code
            __props__.__dict__["deployment_type"] = deployment_type
            if latitude is None and not opts.urn:
                raise TypeError("Missing required property 'latitude'")
            __props__.__dict__["latitude"] = latitude
            __props__.__dict__["location_node_outage_delay_in_minutes"] = location_node_outage_delay_in_minutes
            if longitude is None and not opts.urn:
                raise TypeError("Missing required property 'longitude'")
            __props__.__dict__["longitude"] = longitude
            __props__.__dict__["max_active_gate_count"] = max_active_gate_count
            __props__.__dict__["min_active_gate_count"] = min_active_gate_count
            __props__.__dict__["nam_execution_supported"] = nam_execution_supported
            __props__.__dict__["name"] = name
            __props__.__dict__["node_size"] = node_size
            __props__.__dict__["nodes"] = nodes
            __props__.__dict__["region_code"] = region_code
            __props__.__dict__["use_new_kubernetes_version"] = use_new_kubernetes_version
        super(SyntheticLocation, __self__).__init__(
            'dynatrace:index/syntheticLocation:SyntheticLocation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_update_chromium: Optional[pulumi.Input[builtins.bool]] = None,
            availability_location_outage: Optional[pulumi.Input[builtins.bool]] = None,
            availability_node_outage: Optional[pulumi.Input[builtins.bool]] = None,
            availability_notifications_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            city: Optional[pulumi.Input[builtins.str]] = None,
            country_code: Optional[pulumi.Input[builtins.str]] = None,
            deployment_type: Optional[pulumi.Input[builtins.str]] = None,
            latitude: Optional[pulumi.Input[builtins.float]] = None,
            location_node_outage_delay_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
            longitude: Optional[pulumi.Input[builtins.float]] = None,
            max_active_gate_count: Optional[pulumi.Input[builtins.int]] = None,
            min_active_gate_count: Optional[pulumi.Input[builtins.int]] = None,
            nam_execution_supported: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            node_size: Optional[pulumi.Input[builtins.str]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            region_code: Optional[pulumi.Input[builtins.str]] = None,
            use_new_kubernetes_version: Optional[pulumi.Input[builtins.bool]] = None) -> 'SyntheticLocation':
        """
        Get an existing SyntheticLocation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] auto_update_chromium: Auto upgrade of Chromium is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.bool] availability_location_outage: The alerting of location outage is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.bool] availability_node_outage: The alerting of node outage is enabled (`true`) or disabled (`false`).
        :param pulumi.Input[builtins.bool] availability_notifications_enabled: The notifications of location and node outage is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] city: The city of the location
        :param pulumi.Input[builtins.str] country_code: The country code of the location. To fetch the list of available country codes, use the [GET all
               countries](https://dt-url.net/37030go) request
        :param pulumi.Input[builtins.str] deployment_type: The deployment type of the location: * `STANDARD`: The location is deployed on Windows or Linux. * `KUBERNETES`: The
               location is deployed on Kubernetes
        :param pulumi.Input[builtins.float] latitude: The latitude of the location in `DDD.dddd` format
        :param pulumi.Input[builtins.int] location_node_outage_delay_in_minutes: Alert if the location or node outage lasts longer than *X* minutes. Only applicable when
               **availability_location_outage** or **availability_node_outage** is set to `true`
        :param pulumi.Input[builtins.float] longitude: The longitude of the location in `DDD.dddd` format
        :param pulumi.Input[builtins.int] max_active_gate_count: The maximum number of Active Gates required for that location. Not required when `deployment_type` is set to `STANDARD`
        :param pulumi.Input[builtins.int] min_active_gate_count: The minimum number of Active Gates required for that location. Not required when `deployment_type` is set to `STANDARD`
        :param pulumi.Input[builtins.bool] nam_execution_supported: Boolean value describes if icmp monitors will be executed on this location
        :param pulumi.Input[builtins.str] name: The name of the location
        :param pulumi.Input[builtins.str] node_size: Possible values: `UNSUPPORTED`, `XS`, `S` and `M`. Not required when `deployment_type` is set to `STANDARD`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nodes: A list of synthetic nodes belonging to the location. You can retrieve the list of available nodes with the [GET all
               nodes](https://dt-url.net/miy3rpl) call
        :param pulumi.Input[builtins.str] region_code: The region code of the location. To fetch the list of available region codes, use the [GET regions of the
               country](https://dt-url.net/az230x0) request
        :param pulumi.Input[builtins.bool] use_new_kubernetes_version: Boolean value describes which kubernetes version will be used
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SyntheticLocationState.__new__(_SyntheticLocationState)

        __props__.__dict__["auto_update_chromium"] = auto_update_chromium
        __props__.__dict__["availability_location_outage"] = availability_location_outage
        __props__.__dict__["availability_node_outage"] = availability_node_outage
        __props__.__dict__["availability_notifications_enabled"] = availability_notifications_enabled
        __props__.__dict__["city"] = city
        __props__.__dict__["country_code"] = country_code
        __props__.__dict__["deployment_type"] = deployment_type
        __props__.__dict__["latitude"] = latitude
        __props__.__dict__["location_node_outage_delay_in_minutes"] = location_node_outage_delay_in_minutes
        __props__.__dict__["longitude"] = longitude
        __props__.__dict__["max_active_gate_count"] = max_active_gate_count
        __props__.__dict__["min_active_gate_count"] = min_active_gate_count
        __props__.__dict__["nam_execution_supported"] = nam_execution_supported
        __props__.__dict__["name"] = name
        __props__.__dict__["node_size"] = node_size
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["region_code"] = region_code
        __props__.__dict__["use_new_kubernetes_version"] = use_new_kubernetes_version
        return SyntheticLocation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoUpdateChromium")
    def auto_update_chromium(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Auto upgrade of Chromium is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "auto_update_chromium")

    @property
    @pulumi.getter(name="availabilityLocationOutage")
    def availability_location_outage(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        The alerting of location outage is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "availability_location_outage")

    @property
    @pulumi.getter(name="availabilityNodeOutage")
    def availability_node_outage(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        The alerting of node outage is enabled (`true`) or disabled (`false`).
        """
        return pulumi.get(self, "availability_node_outage")

    @property
    @pulumi.getter(name="availabilityNotificationsEnabled")
    def availability_notifications_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        The notifications of location and node outage is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "availability_notifications_enabled")

    @property
    @pulumi.getter
    def city(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The city of the location
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The country code of the location. To fetch the list of available country codes, use the [GET all
        countries](https://dt-url.net/37030go) request
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The deployment type of the location: * `STANDARD`: The location is deployed on Windows or Linux. * `KUBERNETES`: The
        location is deployed on Kubernetes
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter
    def latitude(self) -> pulumi.Output[builtins.float]:
        """
        The latitude of the location in `DDD.dddd` format
        """
        return pulumi.get(self, "latitude")

    @property
    @pulumi.getter(name="locationNodeOutageDelayInMinutes")
    def location_node_outage_delay_in_minutes(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Alert if the location or node outage lasts longer than *X* minutes. Only applicable when
        **availability_location_outage** or **availability_node_outage** is set to `true`
        """
        return pulumi.get(self, "location_node_outage_delay_in_minutes")

    @property
    @pulumi.getter
    def longitude(self) -> pulumi.Output[builtins.float]:
        """
        The longitude of the location in `DDD.dddd` format
        """
        return pulumi.get(self, "longitude")

    @property
    @pulumi.getter(name="maxActiveGateCount")
    def max_active_gate_count(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The maximum number of Active Gates required for that location. Not required when `deployment_type` is set to `STANDARD`
        """
        return pulumi.get(self, "max_active_gate_count")

    @property
    @pulumi.getter(name="minActiveGateCount")
    def min_active_gate_count(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The minimum number of Active Gates required for that location. Not required when `deployment_type` is set to `STANDARD`
        """
        return pulumi.get(self, "min_active_gate_count")

    @property
    @pulumi.getter(name="namExecutionSupported")
    def nam_execution_supported(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Boolean value describes if icmp monitors will be executed on this location
        """
        return pulumi.get(self, "nam_execution_supported")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the location
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeSize")
    def node_size(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Possible values: `UNSUPPORTED`, `XS`, `S` and `M`. Not required when `deployment_type` is set to `STANDARD`.
        """
        return pulumi.get(self, "node_size")

    @property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of synthetic nodes belonging to the location. You can retrieve the list of available nodes with the [GET all
        nodes](https://dt-url.net/miy3rpl) call
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter(name="regionCode")
    def region_code(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The region code of the location. To fetch the list of available region codes, use the [GET regions of the
        country](https://dt-url.net/az230x0) request
        """
        return pulumi.get(self, "region_code")

    @property
    @pulumi.getter(name="useNewKubernetesVersion")
    def use_new_kubernetes_version(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Boolean value describes which kubernetes version will be used
        """
        return pulumi.get(self, "use_new_kubernetes_version")

