# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['TokenSettingsArgs', 'TokenSettings']

@pulumi.input_type
class TokenSettingsArgs:
    def __init__(__self__, *,
                 new_token_format: pulumi.Input[builtins.bool],
                 personal_tokens: pulumi.Input[builtins.bool]):
        """
        The set of arguments for constructing a TokenSettings resource.
        :param pulumi.Input[builtins.bool] new_token_format: Check out this [blog post](http://www.dynatrace.com/blog/further-increased-security-of-your-api-tokens-by-automating-token-protection/) to find out more about the new Dynatrace API token format.
        :param pulumi.Input[builtins.bool] personal_tokens: Allow users of this environment to generate personal access tokens based on user permissions.
               Note that existing personal access tokens will become unusable while this setting is disabled.
        """
        pulumi.set(__self__, "new_token_format", new_token_format)
        pulumi.set(__self__, "personal_tokens", personal_tokens)

    @property
    @pulumi.getter(name="newTokenFormat")
    def new_token_format(self) -> pulumi.Input[builtins.bool]:
        """
        Check out this [blog post](http://www.dynatrace.com/blog/further-increased-security-of-your-api-tokens-by-automating-token-protection/) to find out more about the new Dynatrace API token format.
        """
        return pulumi.get(self, "new_token_format")

    @new_token_format.setter
    def new_token_format(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "new_token_format", value)

    @property
    @pulumi.getter(name="personalTokens")
    def personal_tokens(self) -> pulumi.Input[builtins.bool]:
        """
        Allow users of this environment to generate personal access tokens based on user permissions.
        Note that existing personal access tokens will become unusable while this setting is disabled.
        """
        return pulumi.get(self, "personal_tokens")

    @personal_tokens.setter
    def personal_tokens(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "personal_tokens", value)


@pulumi.input_type
class _TokenSettingsState:
    def __init__(__self__, *,
                 new_token_format: Optional[pulumi.Input[builtins.bool]] = None,
                 personal_tokens: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering TokenSettings resources.
        :param pulumi.Input[builtins.bool] new_token_format: Check out this [blog post](http://www.dynatrace.com/blog/further-increased-security-of-your-api-tokens-by-automating-token-protection/) to find out more about the new Dynatrace API token format.
        :param pulumi.Input[builtins.bool] personal_tokens: Allow users of this environment to generate personal access tokens based on user permissions.
               Note that existing personal access tokens will become unusable while this setting is disabled.
        """
        if new_token_format is not None:
            pulumi.set(__self__, "new_token_format", new_token_format)
        if personal_tokens is not None:
            pulumi.set(__self__, "personal_tokens", personal_tokens)

    @property
    @pulumi.getter(name="newTokenFormat")
    def new_token_format(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Check out this [blog post](http://www.dynatrace.com/blog/further-increased-security-of-your-api-tokens-by-automating-token-protection/) to find out more about the new Dynatrace API token format.
        """
        return pulumi.get(self, "new_token_format")

    @new_token_format.setter
    def new_token_format(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "new_token_format", value)

    @property
    @pulumi.getter(name="personalTokens")
    def personal_tokens(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow users of this environment to generate personal access tokens based on user permissions.
        Note that existing personal access tokens will become unusable while this setting is disabled.
        """
        return pulumi.get(self, "personal_tokens")

    @personal_tokens.setter
    def personal_tokens(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "personal_tokens", value)


@pulumi.type_token("dynatrace:index/tokenSettings:TokenSettings")
class TokenSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 new_token_format: Optional[pulumi.Input[builtins.bool]] = None,
                 personal_tokens: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        Create a TokenSettings resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] new_token_format: Check out this [blog post](http://www.dynatrace.com/blog/further-increased-security-of-your-api-tokens-by-automating-token-protection/) to find out more about the new Dynatrace API token format.
        :param pulumi.Input[builtins.bool] personal_tokens: Allow users of this environment to generate personal access tokens based on user permissions.
               Note that existing personal access tokens will become unusable while this setting is disabled.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TokenSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a TokenSettings resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param TokenSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TokenSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 new_token_format: Optional[pulumi.Input[builtins.bool]] = None,
                 personal_tokens: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TokenSettingsArgs.__new__(TokenSettingsArgs)

            if new_token_format is None and not opts.urn:
                raise TypeError("Missing required property 'new_token_format'")
            __props__.__dict__["new_token_format"] = new_token_format
            if personal_tokens is None and not opts.urn:
                raise TypeError("Missing required property 'personal_tokens'")
            __props__.__dict__["personal_tokens"] = personal_tokens
        super(TokenSettings, __self__).__init__(
            'dynatrace:index/tokenSettings:TokenSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            new_token_format: Optional[pulumi.Input[builtins.bool]] = None,
            personal_tokens: Optional[pulumi.Input[builtins.bool]] = None) -> 'TokenSettings':
        """
        Get an existing TokenSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] new_token_format: Check out this [blog post](http://www.dynatrace.com/blog/further-increased-security-of-your-api-tokens-by-automating-token-protection/) to find out more about the new Dynatrace API token format.
        :param pulumi.Input[builtins.bool] personal_tokens: Allow users of this environment to generate personal access tokens based on user permissions.
               Note that existing personal access tokens will become unusable while this setting is disabled.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TokenSettingsState.__new__(_TokenSettingsState)

        __props__.__dict__["new_token_format"] = new_token_format
        __props__.__dict__["personal_tokens"] = personal_tokens
        return TokenSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="newTokenFormat")
    def new_token_format(self) -> pulumi.Output[builtins.bool]:
        """
        Check out this [blog post](http://www.dynatrace.com/blog/further-increased-security-of-your-api-tokens-by-automating-token-protection/) to find out more about the new Dynatrace API token format.
        """
        return pulumi.get(self, "new_token_format")

    @property
    @pulumi.getter(name="personalTokens")
    def personal_tokens(self) -> pulumi.Output[builtins.bool]:
        """
        Allow users of this environment to generate personal access tokens based on user permissions.
        Note that existing personal access tokens will become unusable while this setting is disabled.
        """
        return pulumi.get(self, "personal_tokens")

