# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['TrelloNotificationArgs', 'TrelloNotification']

@pulumi.input_type
class TrelloNotificationArgs:
    def __init__(__self__, *,
                 active: pulumi.Input[builtins.bool],
                 application_key: pulumi.Input[builtins.str],
                 board_id: pulumi.Input[builtins.str],
                 description: pulumi.Input[builtins.str],
                 list_id: pulumi.Input[builtins.str],
                 profile: pulumi.Input[builtins.str],
                 resolved_list_id: pulumi.Input[builtins.str],
                 text: pulumi.Input[builtins.str],
                 authorization_token: Optional[pulumi.Input[builtins.str]] = None,
                 legacy_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a TrelloNotification resource.
        :param pulumi.Input[builtins.bool] active: The configuration is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] application_key: The application key for the Trello account
        :param pulumi.Input[builtins.str] board_id: The Trello board to which the card should be assigned
        :param pulumi.Input[builtins.str] description: The description of the Trello card.   You can use same placeholders as in card text
        :param pulumi.Input[builtins.str] list_id: The Trello list to which the card should be assigned
        :param pulumi.Input[builtins.str] profile: The ID of the associated alerting profile
        :param pulumi.Input[builtins.str] resolved_list_id: The Trello list to which the card of the resolved problem should be assigned
        :param pulumi.Input[builtins.str] text: The text of the generated Trello card.  You can use the following placeholders:  * `{ImpactedEntity}`: The entity impacted by the problem or *X* impacted entities.  * `{PID}`: The ID of the reported problem.  * `{ProblemDetailsMarkdown}`: All problem event details, including root cause, as a [Markdown-formatted](https://www.markdownguide.org/cheat-sheet/) string.  * `{ProblemID}`: The display number of the reported problem.  * `{ProblemImpact}`: The [impact level](https://www.dynatrace.com/support/help/shortlink/impact-analysis) of the problem. Possible values are `APPLICATION`, `SERVICE`, and `INFRASTRUCTURE`.  * `{ProblemSeverity}`: The [severity level](https://www.dynatrace.com/support/help/shortlink/event-types) of the problem. Possible values are `AVAILABILITY`, `ERROR`, `PERFORMANCE`, `RESOURCE_CONTENTION`, and `CUSTOM_ALERT`.  * `{ProblemTitle}`: A short description of the problem.  * `{ProblemURL}`: The URL of the problem within Dynatrace.  * `{State}`: The state of the problem. Possible values are `OPEN` and `RESOLVED`.  * `{Tags}`: The list of tags that are defined for all impacted entities, separated by commas
        :param pulumi.Input[builtins.str] authorization_token: The application token for the Trello account
        :param pulumi.Input[builtins.str] legacy_id: The ID of these settings when referred to from resources requiring the REST API V1 keys
        :param pulumi.Input[builtins.str] name: The name of the notification configuration
        """
        pulumi.set(__self__, "active", active)
        pulumi.set(__self__, "application_key", application_key)
        pulumi.set(__self__, "board_id", board_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "list_id", list_id)
        pulumi.set(__self__, "profile", profile)
        pulumi.set(__self__, "resolved_list_id", resolved_list_id)
        pulumi.set(__self__, "text", text)
        if authorization_token is not None:
            pulumi.set(__self__, "authorization_token", authorization_token)
        if legacy_id is not None:
            pulumi.set(__self__, "legacy_id", legacy_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Input[builtins.bool]:
        """
        The configuration is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="applicationKey")
    def application_key(self) -> pulumi.Input[builtins.str]:
        """
        The application key for the Trello account
        """
        return pulumi.get(self, "application_key")

    @application_key.setter
    def application_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "application_key", value)

    @property
    @pulumi.getter(name="boardId")
    def board_id(self) -> pulumi.Input[builtins.str]:
        """
        The Trello board to which the card should be assigned
        """
        return pulumi.get(self, "board_id")

    @board_id.setter
    def board_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "board_id", value)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        The description of the Trello card.   You can use same placeholders as in card text
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="listId")
    def list_id(self) -> pulumi.Input[builtins.str]:
        """
        The Trello list to which the card should be assigned
        """
        return pulumi.get(self, "list_id")

    @list_id.setter
    def list_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "list_id", value)

    @property
    @pulumi.getter
    def profile(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the associated alerting profile
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="resolvedListId")
    def resolved_list_id(self) -> pulumi.Input[builtins.str]:
        """
        The Trello list to which the card of the resolved problem should be assigned
        """
        return pulumi.get(self, "resolved_list_id")

    @resolved_list_id.setter
    def resolved_list_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resolved_list_id", value)

    @property
    @pulumi.getter
    def text(self) -> pulumi.Input[builtins.str]:
        """
        The text of the generated Trello card.  You can use the following placeholders:  * `{ImpactedEntity}`: The entity impacted by the problem or *X* impacted entities.  * `{PID}`: The ID of the reported problem.  * `{ProblemDetailsMarkdown}`: All problem event details, including root cause, as a [Markdown-formatted](https://www.markdownguide.org/cheat-sheet/) string.  * `{ProblemID}`: The display number of the reported problem.  * `{ProblemImpact}`: The [impact level](https://www.dynatrace.com/support/help/shortlink/impact-analysis) of the problem. Possible values are `APPLICATION`, `SERVICE`, and `INFRASTRUCTURE`.  * `{ProblemSeverity}`: The [severity level](https://www.dynatrace.com/support/help/shortlink/event-types) of the problem. Possible values are `AVAILABILITY`, `ERROR`, `PERFORMANCE`, `RESOURCE_CONTENTION`, and `CUSTOM_ALERT`.  * `{ProblemTitle}`: A short description of the problem.  * `{ProblemURL}`: The URL of the problem within Dynatrace.  * `{State}`: The state of the problem. Possible values are `OPEN` and `RESOLVED`.  * `{Tags}`: The list of tags that are defined for all impacted entities, separated by commas
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "text", value)

    @property
    @pulumi.getter(name="authorizationToken")
    def authorization_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The application token for the Trello account
        """
        return pulumi.get(self, "authorization_token")

    @authorization_token.setter
    def authorization_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization_token", value)

    @property
    @pulumi.getter(name="legacyId")
    def legacy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of these settings when referred to from resources requiring the REST API V1 keys
        """
        return pulumi.get(self, "legacy_id")

    @legacy_id.setter
    def legacy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "legacy_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the notification configuration
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _TrelloNotificationState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 application_key: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_token: Optional[pulumi.Input[builtins.str]] = None,
                 board_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 legacy_id: Optional[pulumi.Input[builtins.str]] = None,
                 list_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 profile: Optional[pulumi.Input[builtins.str]] = None,
                 resolved_list_id: Optional[pulumi.Input[builtins.str]] = None,
                 text: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering TrelloNotification resources.
        :param pulumi.Input[builtins.bool] active: The configuration is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] application_key: The application key for the Trello account
        :param pulumi.Input[builtins.str] authorization_token: The application token for the Trello account
        :param pulumi.Input[builtins.str] board_id: The Trello board to which the card should be assigned
        :param pulumi.Input[builtins.str] description: The description of the Trello card.   You can use same placeholders as in card text
        :param pulumi.Input[builtins.str] legacy_id: The ID of these settings when referred to from resources requiring the REST API V1 keys
        :param pulumi.Input[builtins.str] list_id: The Trello list to which the card should be assigned
        :param pulumi.Input[builtins.str] name: The name of the notification configuration
        :param pulumi.Input[builtins.str] profile: The ID of the associated alerting profile
        :param pulumi.Input[builtins.str] resolved_list_id: The Trello list to which the card of the resolved problem should be assigned
        :param pulumi.Input[builtins.str] text: The text of the generated Trello card.  You can use the following placeholders:  * `{ImpactedEntity}`: The entity impacted by the problem or *X* impacted entities.  * `{PID}`: The ID of the reported problem.  * `{ProblemDetailsMarkdown}`: All problem event details, including root cause, as a [Markdown-formatted](https://www.markdownguide.org/cheat-sheet/) string.  * `{ProblemID}`: The display number of the reported problem.  * `{ProblemImpact}`: The [impact level](https://www.dynatrace.com/support/help/shortlink/impact-analysis) of the problem. Possible values are `APPLICATION`, `SERVICE`, and `INFRASTRUCTURE`.  * `{ProblemSeverity}`: The [severity level](https://www.dynatrace.com/support/help/shortlink/event-types) of the problem. Possible values are `AVAILABILITY`, `ERROR`, `PERFORMANCE`, `RESOURCE_CONTENTION`, and `CUSTOM_ALERT`.  * `{ProblemTitle}`: A short description of the problem.  * `{ProblemURL}`: The URL of the problem within Dynatrace.  * `{State}`: The state of the problem. Possible values are `OPEN` and `RESOLVED`.  * `{Tags}`: The list of tags that are defined for all impacted entities, separated by commas
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if application_key is not None:
            pulumi.set(__self__, "application_key", application_key)
        if authorization_token is not None:
            pulumi.set(__self__, "authorization_token", authorization_token)
        if board_id is not None:
            pulumi.set(__self__, "board_id", board_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if legacy_id is not None:
            pulumi.set(__self__, "legacy_id", legacy_id)
        if list_id is not None:
            pulumi.set(__self__, "list_id", list_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if resolved_list_id is not None:
            pulumi.set(__self__, "resolved_list_id", resolved_list_id)
        if text is not None:
            pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The configuration is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="applicationKey")
    def application_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The application key for the Trello account
        """
        return pulumi.get(self, "application_key")

    @application_key.setter
    def application_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_key", value)

    @property
    @pulumi.getter(name="authorizationToken")
    def authorization_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The application token for the Trello account
        """
        return pulumi.get(self, "authorization_token")

    @authorization_token.setter
    def authorization_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization_token", value)

    @property
    @pulumi.getter(name="boardId")
    def board_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Trello board to which the card should be assigned
        """
        return pulumi.get(self, "board_id")

    @board_id.setter
    def board_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "board_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Trello card.   You can use same placeholders as in card text
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="legacyId")
    def legacy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of these settings when referred to from resources requiring the REST API V1 keys
        """
        return pulumi.get(self, "legacy_id")

    @legacy_id.setter
    def legacy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "legacy_id", value)

    @property
    @pulumi.getter(name="listId")
    def list_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Trello list to which the card should be assigned
        """
        return pulumi.get(self, "list_id")

    @list_id.setter
    def list_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "list_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the notification configuration
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the associated alerting profile
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="resolvedListId")
    def resolved_list_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Trello list to which the card of the resolved problem should be assigned
        """
        return pulumi.get(self, "resolved_list_id")

    @resolved_list_id.setter
    def resolved_list_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resolved_list_id", value)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The text of the generated Trello card.  You can use the following placeholders:  * `{ImpactedEntity}`: The entity impacted by the problem or *X* impacted entities.  * `{PID}`: The ID of the reported problem.  * `{ProblemDetailsMarkdown}`: All problem event details, including root cause, as a [Markdown-formatted](https://www.markdownguide.org/cheat-sheet/) string.  * `{ProblemID}`: The display number of the reported problem.  * `{ProblemImpact}`: The [impact level](https://www.dynatrace.com/support/help/shortlink/impact-analysis) of the problem. Possible values are `APPLICATION`, `SERVICE`, and `INFRASTRUCTURE`.  * `{ProblemSeverity}`: The [severity level](https://www.dynatrace.com/support/help/shortlink/event-types) of the problem. Possible values are `AVAILABILITY`, `ERROR`, `PERFORMANCE`, `RESOURCE_CONTENTION`, and `CUSTOM_ALERT`.  * `{ProblemTitle}`: A short description of the problem.  * `{ProblemURL}`: The URL of the problem within Dynatrace.  * `{State}`: The state of the problem. Possible values are `OPEN` and `RESOLVED`.  * `{Tags}`: The list of tags that are defined for all impacted entities, separated by commas
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "text", value)


@pulumi.type_token("dynatrace:index/trelloNotification:TrelloNotification")
class TrelloNotification(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 application_key: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_token: Optional[pulumi.Input[builtins.str]] = None,
                 board_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 legacy_id: Optional[pulumi.Input[builtins.str]] = None,
                 list_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 profile: Optional[pulumi.Input[builtins.str]] = None,
                 resolved_list_id: Optional[pulumi.Input[builtins.str]] = None,
                 text: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a TrelloNotification resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] active: The configuration is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] application_key: The application key for the Trello account
        :param pulumi.Input[builtins.str] authorization_token: The application token for the Trello account
        :param pulumi.Input[builtins.str] board_id: The Trello board to which the card should be assigned
        :param pulumi.Input[builtins.str] description: The description of the Trello card.   You can use same placeholders as in card text
        :param pulumi.Input[builtins.str] legacy_id: The ID of these settings when referred to from resources requiring the REST API V1 keys
        :param pulumi.Input[builtins.str] list_id: The Trello list to which the card should be assigned
        :param pulumi.Input[builtins.str] name: The name of the notification configuration
        :param pulumi.Input[builtins.str] profile: The ID of the associated alerting profile
        :param pulumi.Input[builtins.str] resolved_list_id: The Trello list to which the card of the resolved problem should be assigned
        :param pulumi.Input[builtins.str] text: The text of the generated Trello card.  You can use the following placeholders:  * `{ImpactedEntity}`: The entity impacted by the problem or *X* impacted entities.  * `{PID}`: The ID of the reported problem.  * `{ProblemDetailsMarkdown}`: All problem event details, including root cause, as a [Markdown-formatted](https://www.markdownguide.org/cheat-sheet/) string.  * `{ProblemID}`: The display number of the reported problem.  * `{ProblemImpact}`: The [impact level](https://www.dynatrace.com/support/help/shortlink/impact-analysis) of the problem. Possible values are `APPLICATION`, `SERVICE`, and `INFRASTRUCTURE`.  * `{ProblemSeverity}`: The [severity level](https://www.dynatrace.com/support/help/shortlink/event-types) of the problem. Possible values are `AVAILABILITY`, `ERROR`, `PERFORMANCE`, `RESOURCE_CONTENTION`, and `CUSTOM_ALERT`.  * `{ProblemTitle}`: A short description of the problem.  * `{ProblemURL}`: The URL of the problem within Dynatrace.  * `{State}`: The state of the problem. Possible values are `OPEN` and `RESOLVED`.  * `{Tags}`: The list of tags that are defined for all impacted entities, separated by commas
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TrelloNotificationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a TrelloNotification resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param TrelloNotificationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TrelloNotificationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 application_key: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_token: Optional[pulumi.Input[builtins.str]] = None,
                 board_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 legacy_id: Optional[pulumi.Input[builtins.str]] = None,
                 list_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 profile: Optional[pulumi.Input[builtins.str]] = None,
                 resolved_list_id: Optional[pulumi.Input[builtins.str]] = None,
                 text: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TrelloNotificationArgs.__new__(TrelloNotificationArgs)

            if active is None and not opts.urn:
                raise TypeError("Missing required property 'active'")
            __props__.__dict__["active"] = active
            if application_key is None and not opts.urn:
                raise TypeError("Missing required property 'application_key'")
            __props__.__dict__["application_key"] = application_key
            __props__.__dict__["authorization_token"] = None if authorization_token is None else pulumi.Output.secret(authorization_token)
            if board_id is None and not opts.urn:
                raise TypeError("Missing required property 'board_id'")
            __props__.__dict__["board_id"] = board_id
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["legacy_id"] = legacy_id
            if list_id is None and not opts.urn:
                raise TypeError("Missing required property 'list_id'")
            __props__.__dict__["list_id"] = list_id
            __props__.__dict__["name"] = name
            if profile is None and not opts.urn:
                raise TypeError("Missing required property 'profile'")
            __props__.__dict__["profile"] = profile
            if resolved_list_id is None and not opts.urn:
                raise TypeError("Missing required property 'resolved_list_id'")
            __props__.__dict__["resolved_list_id"] = resolved_list_id
            if text is None and not opts.urn:
                raise TypeError("Missing required property 'text'")
            __props__.__dict__["text"] = text
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["authorizationToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(TrelloNotification, __self__).__init__(
            'dynatrace:index/trelloNotification:TrelloNotification',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[builtins.bool]] = None,
            application_key: Optional[pulumi.Input[builtins.str]] = None,
            authorization_token: Optional[pulumi.Input[builtins.str]] = None,
            board_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            legacy_id: Optional[pulumi.Input[builtins.str]] = None,
            list_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            profile: Optional[pulumi.Input[builtins.str]] = None,
            resolved_list_id: Optional[pulumi.Input[builtins.str]] = None,
            text: Optional[pulumi.Input[builtins.str]] = None) -> 'TrelloNotification':
        """
        Get an existing TrelloNotification resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] active: The configuration is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] application_key: The application key for the Trello account
        :param pulumi.Input[builtins.str] authorization_token: The application token for the Trello account
        :param pulumi.Input[builtins.str] board_id: The Trello board to which the card should be assigned
        :param pulumi.Input[builtins.str] description: The description of the Trello card.   You can use same placeholders as in card text
        :param pulumi.Input[builtins.str] legacy_id: The ID of these settings when referred to from resources requiring the REST API V1 keys
        :param pulumi.Input[builtins.str] list_id: The Trello list to which the card should be assigned
        :param pulumi.Input[builtins.str] name: The name of the notification configuration
        :param pulumi.Input[builtins.str] profile: The ID of the associated alerting profile
        :param pulumi.Input[builtins.str] resolved_list_id: The Trello list to which the card of the resolved problem should be assigned
        :param pulumi.Input[builtins.str] text: The text of the generated Trello card.  You can use the following placeholders:  * `{ImpactedEntity}`: The entity impacted by the problem or *X* impacted entities.  * `{PID}`: The ID of the reported problem.  * `{ProblemDetailsMarkdown}`: All problem event details, including root cause, as a [Markdown-formatted](https://www.markdownguide.org/cheat-sheet/) string.  * `{ProblemID}`: The display number of the reported problem.  * `{ProblemImpact}`: The [impact level](https://www.dynatrace.com/support/help/shortlink/impact-analysis) of the problem. Possible values are `APPLICATION`, `SERVICE`, and `INFRASTRUCTURE`.  * `{ProblemSeverity}`: The [severity level](https://www.dynatrace.com/support/help/shortlink/event-types) of the problem. Possible values are `AVAILABILITY`, `ERROR`, `PERFORMANCE`, `RESOURCE_CONTENTION`, and `CUSTOM_ALERT`.  * `{ProblemTitle}`: A short description of the problem.  * `{ProblemURL}`: The URL of the problem within Dynatrace.  * `{State}`: The state of the problem. Possible values are `OPEN` and `RESOLVED`.  * `{Tags}`: The list of tags that are defined for all impacted entities, separated by commas
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TrelloNotificationState.__new__(_TrelloNotificationState)

        __props__.__dict__["active"] = active
        __props__.__dict__["application_key"] = application_key
        __props__.__dict__["authorization_token"] = authorization_token
        __props__.__dict__["board_id"] = board_id
        __props__.__dict__["description"] = description
        __props__.__dict__["legacy_id"] = legacy_id
        __props__.__dict__["list_id"] = list_id
        __props__.__dict__["name"] = name
        __props__.__dict__["profile"] = profile
        __props__.__dict__["resolved_list_id"] = resolved_list_id
        __props__.__dict__["text"] = text
        return TrelloNotification(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[builtins.bool]:
        """
        The configuration is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="applicationKey")
    def application_key(self) -> pulumi.Output[builtins.str]:
        """
        The application key for the Trello account
        """
        return pulumi.get(self, "application_key")

    @property
    @pulumi.getter(name="authorizationToken")
    def authorization_token(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The application token for the Trello account
        """
        return pulumi.get(self, "authorization_token")

    @property
    @pulumi.getter(name="boardId")
    def board_id(self) -> pulumi.Output[builtins.str]:
        """
        The Trello board to which the card should be assigned
        """
        return pulumi.get(self, "board_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The description of the Trello card.   You can use same placeholders as in card text
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="legacyId")
    def legacy_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of these settings when referred to from resources requiring the REST API V1 keys
        """
        return pulumi.get(self, "legacy_id")

    @property
    @pulumi.getter(name="listId")
    def list_id(self) -> pulumi.Output[builtins.str]:
        """
        The Trello list to which the card should be assigned
        """
        return pulumi.get(self, "list_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the notification configuration
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def profile(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the associated alerting profile
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter(name="resolvedListId")
    def resolved_list_id(self) -> pulumi.Output[builtins.str]:
        """
        The Trello list to which the card of the resolved problem should be assigned
        """
        return pulumi.get(self, "resolved_list_id")

    @property
    @pulumi.getter
    def text(self) -> pulumi.Output[builtins.str]:
        """
        The text of the generated Trello card.  You can use the following placeholders:  * `{ImpactedEntity}`: The entity impacted by the problem or *X* impacted entities.  * `{PID}`: The ID of the reported problem.  * `{ProblemDetailsMarkdown}`: All problem event details, including root cause, as a [Markdown-formatted](https://www.markdownguide.org/cheat-sheet/) string.  * `{ProblemID}`: The display number of the reported problem.  * `{ProblemImpact}`: The [impact level](https://www.dynatrace.com/support/help/shortlink/impact-analysis) of the problem. Possible values are `APPLICATION`, `SERVICE`, and `INFRASTRUCTURE`.  * `{ProblemSeverity}`: The [severity level](https://www.dynatrace.com/support/help/shortlink/event-types) of the problem. Possible values are `AVAILABILITY`, `ERROR`, `PERFORMANCE`, `RESOURCE_CONTENTION`, and `CUSTOM_ALERT`.  * `{ProblemTitle}`: A short description of the problem.  * `{ProblemURL}`: The URL of the problem within Dynatrace.  * `{State}`: The state of the problem. Possible values are `OPEN` and `RESOLVED`.  * `{Tags}`: The list of tags that are defined for all impacted entities, separated by commas
        """
        return pulumi.get(self, "text")

