# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UserSettingsArgs', 'UserSettings']

@pulumi.input_type
class UserSettingsArgs:
    def __init__(__self__, *,
                 auto_language: pulumi.Input[builtins.bool],
                 auto_region: pulumi.Input[builtins.bool],
                 auto_theme: pulumi.Input[builtins.bool],
                 auto_timezone: pulumi.Input[builtins.bool],
                 scope: pulumi.Input[builtins.str],
                 language: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 theme: Optional[pulumi.Input[builtins.str]] = None,
                 timezone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a UserSettings resource.
        :param pulumi.Input[builtins.bool] auto_language: Language - use browser default
        :param pulumi.Input[builtins.bool] auto_region: Region - use browser default
        :param pulumi.Input[builtins.bool] auto_theme: Theme - use browser default
        :param pulumi.Input[builtins.bool] auto_timezone: Timezone - use browser default
        :param pulumi.Input[builtins.str] scope: The scope of this setting (user, userdefaults)
        :param pulumi.Input[builtins.str] language: Possible Values: `En`, `Ja`
        :param pulumi.Input[builtins.str] region: Region
        :param pulumi.Input[builtins.str] theme: Possible Values: `Dark`, `Light`
        :param pulumi.Input[builtins.str] timezone: Timezone
        """
        pulumi.set(__self__, "auto_language", auto_language)
        pulumi.set(__self__, "auto_region", auto_region)
        pulumi.set(__self__, "auto_theme", auto_theme)
        pulumi.set(__self__, "auto_timezone", auto_timezone)
        pulumi.set(__self__, "scope", scope)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if theme is not None:
            pulumi.set(__self__, "theme", theme)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter(name="autoLanguage")
    def auto_language(self) -> pulumi.Input[builtins.bool]:
        """
        Language - use browser default
        """
        return pulumi.get(self, "auto_language")

    @auto_language.setter
    def auto_language(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "auto_language", value)

    @property
    @pulumi.getter(name="autoRegion")
    def auto_region(self) -> pulumi.Input[builtins.bool]:
        """
        Region - use browser default
        """
        return pulumi.get(self, "auto_region")

    @auto_region.setter
    def auto_region(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "auto_region", value)

    @property
    @pulumi.getter(name="autoTheme")
    def auto_theme(self) -> pulumi.Input[builtins.bool]:
        """
        Theme - use browser default
        """
        return pulumi.get(self, "auto_theme")

    @auto_theme.setter
    def auto_theme(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "auto_theme", value)

    @property
    @pulumi.getter(name="autoTimezone")
    def auto_timezone(self) -> pulumi.Input[builtins.bool]:
        """
        Timezone - use browser default
        """
        return pulumi.get(self, "auto_timezone")

    @auto_timezone.setter
    def auto_timezone(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "auto_timezone", value)

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Input[builtins.str]:
        """
        The scope of this setting (user, userdefaults)
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Possible Values: `En`, `Ja`
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def theme(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Possible Values: `Dark`, `Light`
        """
        return pulumi.get(self, "theme")

    @theme.setter
    def theme(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "theme", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timezone
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timezone", value)


@pulumi.input_type
class _UserSettingsState:
    def __init__(__self__, *,
                 auto_language: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_region: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_theme: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_timezone: Optional[pulumi.Input[builtins.bool]] = None,
                 language: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 theme: Optional[pulumi.Input[builtins.str]] = None,
                 timezone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserSettings resources.
        :param pulumi.Input[builtins.bool] auto_language: Language - use browser default
        :param pulumi.Input[builtins.bool] auto_region: Region - use browser default
        :param pulumi.Input[builtins.bool] auto_theme: Theme - use browser default
        :param pulumi.Input[builtins.bool] auto_timezone: Timezone - use browser default
        :param pulumi.Input[builtins.str] language: Possible Values: `En`, `Ja`
        :param pulumi.Input[builtins.str] region: Region
        :param pulumi.Input[builtins.str] scope: The scope of this setting (user, userdefaults)
        :param pulumi.Input[builtins.str] theme: Possible Values: `Dark`, `Light`
        :param pulumi.Input[builtins.str] timezone: Timezone
        """
        if auto_language is not None:
            pulumi.set(__self__, "auto_language", auto_language)
        if auto_region is not None:
            pulumi.set(__self__, "auto_region", auto_region)
        if auto_theme is not None:
            pulumi.set(__self__, "auto_theme", auto_theme)
        if auto_timezone is not None:
            pulumi.set(__self__, "auto_timezone", auto_timezone)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if theme is not None:
            pulumi.set(__self__, "theme", theme)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter(name="autoLanguage")
    def auto_language(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Language - use browser default
        """
        return pulumi.get(self, "auto_language")

    @auto_language.setter
    def auto_language(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_language", value)

    @property
    @pulumi.getter(name="autoRegion")
    def auto_region(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Region - use browser default
        """
        return pulumi.get(self, "auto_region")

    @auto_region.setter
    def auto_region(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_region", value)

    @property
    @pulumi.getter(name="autoTheme")
    def auto_theme(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Theme - use browser default
        """
        return pulumi.get(self, "auto_theme")

    @auto_theme.setter
    def auto_theme(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_theme", value)

    @property
    @pulumi.getter(name="autoTimezone")
    def auto_timezone(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Timezone - use browser default
        """
        return pulumi.get(self, "auto_timezone")

    @auto_timezone.setter
    def auto_timezone(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_timezone", value)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Possible Values: `En`, `Ja`
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of this setting (user, userdefaults)
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter
    def theme(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Possible Values: `Dark`, `Light`
        """
        return pulumi.get(self, "theme")

    @theme.setter
    def theme(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "theme", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timezone
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timezone", value)


@pulumi.type_token("dynatrace:index/userSettings:UserSettings")
class UserSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_language: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_region: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_theme: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_timezone: Optional[pulumi.Input[builtins.bool]] = None,
                 language: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 theme: Optional[pulumi.Input[builtins.str]] = None,
                 timezone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a UserSettings resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] auto_language: Language - use browser default
        :param pulumi.Input[builtins.bool] auto_region: Region - use browser default
        :param pulumi.Input[builtins.bool] auto_theme: Theme - use browser default
        :param pulumi.Input[builtins.bool] auto_timezone: Timezone - use browser default
        :param pulumi.Input[builtins.str] language: Possible Values: `En`, `Ja`
        :param pulumi.Input[builtins.str] region: Region
        :param pulumi.Input[builtins.str] scope: The scope of this setting (user, userdefaults)
        :param pulumi.Input[builtins.str] theme: Possible Values: `Dark`, `Light`
        :param pulumi.Input[builtins.str] timezone: Timezone
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a UserSettings resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param UserSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_language: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_region: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_theme: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_timezone: Optional[pulumi.Input[builtins.bool]] = None,
                 language: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 theme: Optional[pulumi.Input[builtins.str]] = None,
                 timezone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserSettingsArgs.__new__(UserSettingsArgs)

            if auto_language is None and not opts.urn:
                raise TypeError("Missing required property 'auto_language'")
            __props__.__dict__["auto_language"] = auto_language
            if auto_region is None and not opts.urn:
                raise TypeError("Missing required property 'auto_region'")
            __props__.__dict__["auto_region"] = auto_region
            if auto_theme is None and not opts.urn:
                raise TypeError("Missing required property 'auto_theme'")
            __props__.__dict__["auto_theme"] = auto_theme
            if auto_timezone is None and not opts.urn:
                raise TypeError("Missing required property 'auto_timezone'")
            __props__.__dict__["auto_timezone"] = auto_timezone
            __props__.__dict__["language"] = language
            __props__.__dict__["region"] = region
            if scope is None and not opts.urn:
                raise TypeError("Missing required property 'scope'")
            __props__.__dict__["scope"] = scope
            __props__.__dict__["theme"] = theme
            __props__.__dict__["timezone"] = timezone
        super(UserSettings, __self__).__init__(
            'dynatrace:index/userSettings:UserSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_language: Optional[pulumi.Input[builtins.bool]] = None,
            auto_region: Optional[pulumi.Input[builtins.bool]] = None,
            auto_theme: Optional[pulumi.Input[builtins.bool]] = None,
            auto_timezone: Optional[pulumi.Input[builtins.bool]] = None,
            language: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            scope: Optional[pulumi.Input[builtins.str]] = None,
            theme: Optional[pulumi.Input[builtins.str]] = None,
            timezone: Optional[pulumi.Input[builtins.str]] = None) -> 'UserSettings':
        """
        Get an existing UserSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] auto_language: Language - use browser default
        :param pulumi.Input[builtins.bool] auto_region: Region - use browser default
        :param pulumi.Input[builtins.bool] auto_theme: Theme - use browser default
        :param pulumi.Input[builtins.bool] auto_timezone: Timezone - use browser default
        :param pulumi.Input[builtins.str] language: Possible Values: `En`, `Ja`
        :param pulumi.Input[builtins.str] region: Region
        :param pulumi.Input[builtins.str] scope: The scope of this setting (user, userdefaults)
        :param pulumi.Input[builtins.str] theme: Possible Values: `Dark`, `Light`
        :param pulumi.Input[builtins.str] timezone: Timezone
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserSettingsState.__new__(_UserSettingsState)

        __props__.__dict__["auto_language"] = auto_language
        __props__.__dict__["auto_region"] = auto_region
        __props__.__dict__["auto_theme"] = auto_theme
        __props__.__dict__["auto_timezone"] = auto_timezone
        __props__.__dict__["language"] = language
        __props__.__dict__["region"] = region
        __props__.__dict__["scope"] = scope
        __props__.__dict__["theme"] = theme
        __props__.__dict__["timezone"] = timezone
        return UserSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoLanguage")
    def auto_language(self) -> pulumi.Output[builtins.bool]:
        """
        Language - use browser default
        """
        return pulumi.get(self, "auto_language")

    @property
    @pulumi.getter(name="autoRegion")
    def auto_region(self) -> pulumi.Output[builtins.bool]:
        """
        Region - use browser default
        """
        return pulumi.get(self, "auto_region")

    @property
    @pulumi.getter(name="autoTheme")
    def auto_theme(self) -> pulumi.Output[builtins.bool]:
        """
        Theme - use browser default
        """
        return pulumi.get(self, "auto_theme")

    @property
    @pulumi.getter(name="autoTimezone")
    def auto_timezone(self) -> pulumi.Output[builtins.bool]:
        """
        Timezone - use browser default
        """
        return pulumi.get(self, "auto_timezone")

    @property
    @pulumi.getter
    def language(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Possible Values: `En`, `Ja`
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Region
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[builtins.str]:
        """
        The scope of this setting (user, userdefaults)
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def theme(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Possible Values: `Dark`, `Light`
        """
        return pulumi.get(self, "theme")

    @property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Timezone
        """
        return pulumi.get(self, "timezone")

