# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VulnerabilityCodeArgs', 'VulnerabilityCode']

@pulumi.input_type
class VulnerabilityCodeArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool],
                 metadata: pulumi.Input['VulnerabilityCodeMetadataArgs'],
                 vulnerability_detection_control: pulumi.Input['VulnerabilityCodeVulnerabilityDetectionControlArgs'],
                 criteria: Optional[pulumi.Input['VulnerabilityCodeCriteriaArgs']] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 resource_attribute_conditions: Optional[pulumi.Input['VulnerabilityCodeResourceAttributeConditionsArgs']] = None,
                 rule_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a VulnerabilityCode resource.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input['VulnerabilityCodeMetadataArgs'] metadata: Step 3: Leave comment (optional)
        :param pulumi.Input['VulnerabilityCodeVulnerabilityDetectionControlArgs'] vulnerability_detection_control: Step 1: Select code-level vulnerability detection behavior
        :param pulumi.Input['VulnerabilityCodeCriteriaArgs'] criteria: Define criteria
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input['VulnerabilityCodeResourceAttributeConditionsArgs'] resource_attribute_conditions: If you add more than one condition, note that all conditions must be true simultaneously for the rule to apply.
        :param pulumi.Input[builtins.str] rule_name: Rule name
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "vulnerability_detection_control", vulnerability_detection_control)
        if criteria is not None:
            warnings.warn("""This field has been deprecated""", DeprecationWarning)
            pulumi.log.warn("""criteria is deprecated: This field has been deprecated""")
        if criteria is not None:
            pulumi.set(__self__, "criteria", criteria)
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)
        if resource_attribute_conditions is not None:
            pulumi.set(__self__, "resource_attribute_conditions", resource_attribute_conditions)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Input['VulnerabilityCodeMetadataArgs']:
        """
        Step 3: Leave comment (optional)
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: pulumi.Input['VulnerabilityCodeMetadataArgs']):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="vulnerabilityDetectionControl")
    def vulnerability_detection_control(self) -> pulumi.Input['VulnerabilityCodeVulnerabilityDetectionControlArgs']:
        """
        Step 1: Select code-level vulnerability detection behavior
        """
        return pulumi.get(self, "vulnerability_detection_control")

    @vulnerability_detection_control.setter
    def vulnerability_detection_control(self, value: pulumi.Input['VulnerabilityCodeVulnerabilityDetectionControlArgs']):
        pulumi.set(self, "vulnerability_detection_control", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""This field has been deprecated""")
    def criteria(self) -> Optional[pulumi.Input['VulnerabilityCodeCriteriaArgs']]:
        """
        Define criteria
        """
        return pulumi.get(self, "criteria")

    @criteria.setter
    def criteria(self, value: Optional[pulumi.Input['VulnerabilityCodeCriteriaArgs']]):
        pulumi.set(self, "criteria", value)

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "insert_after", value)

    @property
    @pulumi.getter(name="resourceAttributeConditions")
    def resource_attribute_conditions(self) -> Optional[pulumi.Input['VulnerabilityCodeResourceAttributeConditionsArgs']]:
        """
        If you add more than one condition, note that all conditions must be true simultaneously for the rule to apply.
        """
        return pulumi.get(self, "resource_attribute_conditions")

    @resource_attribute_conditions.setter
    def resource_attribute_conditions(self, value: Optional[pulumi.Input['VulnerabilityCodeResourceAttributeConditionsArgs']]):
        pulumi.set(self, "resource_attribute_conditions", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Rule name
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rule_name", value)


@pulumi.input_type
class _VulnerabilityCodeState:
    def __init__(__self__, *,
                 criteria: Optional[pulumi.Input['VulnerabilityCodeCriteriaArgs']] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input['VulnerabilityCodeMetadataArgs']] = None,
                 resource_attribute_conditions: Optional[pulumi.Input['VulnerabilityCodeResourceAttributeConditionsArgs']] = None,
                 rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 vulnerability_detection_control: Optional[pulumi.Input['VulnerabilityCodeVulnerabilityDetectionControlArgs']] = None):
        """
        Input properties used for looking up and filtering VulnerabilityCode resources.
        :param pulumi.Input['VulnerabilityCodeCriteriaArgs'] criteria: Define criteria
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input['VulnerabilityCodeMetadataArgs'] metadata: Step 3: Leave comment (optional)
        :param pulumi.Input['VulnerabilityCodeResourceAttributeConditionsArgs'] resource_attribute_conditions: If you add more than one condition, note that all conditions must be true simultaneously for the rule to apply.
        :param pulumi.Input[builtins.str] rule_name: Rule name
        :param pulumi.Input['VulnerabilityCodeVulnerabilityDetectionControlArgs'] vulnerability_detection_control: Step 1: Select code-level vulnerability detection behavior
        """
        if criteria is not None:
            warnings.warn("""This field has been deprecated""", DeprecationWarning)
            pulumi.log.warn("""criteria is deprecated: This field has been deprecated""")
        if criteria is not None:
            pulumi.set(__self__, "criteria", criteria)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if resource_attribute_conditions is not None:
            pulumi.set(__self__, "resource_attribute_conditions", resource_attribute_conditions)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if vulnerability_detection_control is not None:
            pulumi.set(__self__, "vulnerability_detection_control", vulnerability_detection_control)

    @property
    @pulumi.getter
    @_utilities.deprecated("""This field has been deprecated""")
    def criteria(self) -> Optional[pulumi.Input['VulnerabilityCodeCriteriaArgs']]:
        """
        Define criteria
        """
        return pulumi.get(self, "criteria")

    @criteria.setter
    def criteria(self, value: Optional[pulumi.Input['VulnerabilityCodeCriteriaArgs']]):
        pulumi.set(self, "criteria", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "insert_after", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['VulnerabilityCodeMetadataArgs']]:
        """
        Step 3: Leave comment (optional)
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['VulnerabilityCodeMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="resourceAttributeConditions")
    def resource_attribute_conditions(self) -> Optional[pulumi.Input['VulnerabilityCodeResourceAttributeConditionsArgs']]:
        """
        If you add more than one condition, note that all conditions must be true simultaneously for the rule to apply.
        """
        return pulumi.get(self, "resource_attribute_conditions")

    @resource_attribute_conditions.setter
    def resource_attribute_conditions(self, value: Optional[pulumi.Input['VulnerabilityCodeResourceAttributeConditionsArgs']]):
        pulumi.set(self, "resource_attribute_conditions", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Rule name
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter(name="vulnerabilityDetectionControl")
    def vulnerability_detection_control(self) -> Optional[pulumi.Input['VulnerabilityCodeVulnerabilityDetectionControlArgs']]:
        """
        Step 1: Select code-level vulnerability detection behavior
        """
        return pulumi.get(self, "vulnerability_detection_control")

    @vulnerability_detection_control.setter
    def vulnerability_detection_control(self, value: Optional[pulumi.Input['VulnerabilityCodeVulnerabilityDetectionControlArgs']]):
        pulumi.set(self, "vulnerability_detection_control", value)


@pulumi.type_token("dynatrace:index/vulnerabilityCode:VulnerabilityCode")
class VulnerabilityCode(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 criteria: Optional[pulumi.Input[Union['VulnerabilityCodeCriteriaArgs', 'VulnerabilityCodeCriteriaArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Union['VulnerabilityCodeMetadataArgs', 'VulnerabilityCodeMetadataArgsDict']]] = None,
                 resource_attribute_conditions: Optional[pulumi.Input[Union['VulnerabilityCodeResourceAttributeConditionsArgs', 'VulnerabilityCodeResourceAttributeConditionsArgsDict']]] = None,
                 rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 vulnerability_detection_control: Optional[pulumi.Input[Union['VulnerabilityCodeVulnerabilityDetectionControlArgs', 'VulnerabilityCodeVulnerabilityDetectionControlArgsDict']]] = None,
                 __props__=None):
        """
        Create a VulnerabilityCode resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['VulnerabilityCodeCriteriaArgs', 'VulnerabilityCodeCriteriaArgsDict']] criteria: Define criteria
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[Union['VulnerabilityCodeMetadataArgs', 'VulnerabilityCodeMetadataArgsDict']] metadata: Step 3: Leave comment (optional)
        :param pulumi.Input[Union['VulnerabilityCodeResourceAttributeConditionsArgs', 'VulnerabilityCodeResourceAttributeConditionsArgsDict']] resource_attribute_conditions: If you add more than one condition, note that all conditions must be true simultaneously for the rule to apply.
        :param pulumi.Input[builtins.str] rule_name: Rule name
        :param pulumi.Input[Union['VulnerabilityCodeVulnerabilityDetectionControlArgs', 'VulnerabilityCodeVulnerabilityDetectionControlArgsDict']] vulnerability_detection_control: Step 1: Select code-level vulnerability detection behavior
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VulnerabilityCodeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a VulnerabilityCode resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param VulnerabilityCodeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VulnerabilityCodeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 criteria: Optional[pulumi.Input[Union['VulnerabilityCodeCriteriaArgs', 'VulnerabilityCodeCriteriaArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Union['VulnerabilityCodeMetadataArgs', 'VulnerabilityCodeMetadataArgsDict']]] = None,
                 resource_attribute_conditions: Optional[pulumi.Input[Union['VulnerabilityCodeResourceAttributeConditionsArgs', 'VulnerabilityCodeResourceAttributeConditionsArgsDict']]] = None,
                 rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 vulnerability_detection_control: Optional[pulumi.Input[Union['VulnerabilityCodeVulnerabilityDetectionControlArgs', 'VulnerabilityCodeVulnerabilityDetectionControlArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VulnerabilityCodeArgs.__new__(VulnerabilityCodeArgs)

            __props__.__dict__["criteria"] = criteria
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["insert_after"] = insert_after
            if metadata is None and not opts.urn:
                raise TypeError("Missing required property 'metadata'")
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["resource_attribute_conditions"] = resource_attribute_conditions
            __props__.__dict__["rule_name"] = rule_name
            if vulnerability_detection_control is None and not opts.urn:
                raise TypeError("Missing required property 'vulnerability_detection_control'")
            __props__.__dict__["vulnerability_detection_control"] = vulnerability_detection_control
        super(VulnerabilityCode, __self__).__init__(
            'dynatrace:index/vulnerabilityCode:VulnerabilityCode',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            criteria: Optional[pulumi.Input[Union['VulnerabilityCodeCriteriaArgs', 'VulnerabilityCodeCriteriaArgsDict']]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            insert_after: Optional[pulumi.Input[builtins.str]] = None,
            metadata: Optional[pulumi.Input[Union['VulnerabilityCodeMetadataArgs', 'VulnerabilityCodeMetadataArgsDict']]] = None,
            resource_attribute_conditions: Optional[pulumi.Input[Union['VulnerabilityCodeResourceAttributeConditionsArgs', 'VulnerabilityCodeResourceAttributeConditionsArgsDict']]] = None,
            rule_name: Optional[pulumi.Input[builtins.str]] = None,
            vulnerability_detection_control: Optional[pulumi.Input[Union['VulnerabilityCodeVulnerabilityDetectionControlArgs', 'VulnerabilityCodeVulnerabilityDetectionControlArgsDict']]] = None) -> 'VulnerabilityCode':
        """
        Get an existing VulnerabilityCode resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['VulnerabilityCodeCriteriaArgs', 'VulnerabilityCodeCriteriaArgsDict']] criteria: Define criteria
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[Union['VulnerabilityCodeMetadataArgs', 'VulnerabilityCodeMetadataArgsDict']] metadata: Step 3: Leave comment (optional)
        :param pulumi.Input[Union['VulnerabilityCodeResourceAttributeConditionsArgs', 'VulnerabilityCodeResourceAttributeConditionsArgsDict']] resource_attribute_conditions: If you add more than one condition, note that all conditions must be true simultaneously for the rule to apply.
        :param pulumi.Input[builtins.str] rule_name: Rule name
        :param pulumi.Input[Union['VulnerabilityCodeVulnerabilityDetectionControlArgs', 'VulnerabilityCodeVulnerabilityDetectionControlArgsDict']] vulnerability_detection_control: Step 1: Select code-level vulnerability detection behavior
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VulnerabilityCodeState.__new__(_VulnerabilityCodeState)

        __props__.__dict__["criteria"] = criteria
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["insert_after"] = insert_after
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["resource_attribute_conditions"] = resource_attribute_conditions
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["vulnerability_detection_control"] = vulnerability_detection_control
        return VulnerabilityCode(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    @_utilities.deprecated("""This field has been deprecated""")
    def criteria(self) -> pulumi.Output[Optional['outputs.VulnerabilityCodeCriteria']]:
        """
        Define criteria
        """
        return pulumi.get(self, "criteria")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> pulumi.Output[builtins.str]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output['outputs.VulnerabilityCodeMetadata']:
        """
        Step 3: Leave comment (optional)
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="resourceAttributeConditions")
    def resource_attribute_conditions(self) -> pulumi.Output[Optional['outputs.VulnerabilityCodeResourceAttributeConditions']]:
        """
        If you add more than one condition, note that all conditions must be true simultaneously for the rule to apply.
        """
        return pulumi.get(self, "resource_attribute_conditions")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Rule name
        """
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter(name="vulnerabilityDetectionControl")
    def vulnerability_detection_control(self) -> pulumi.Output['outputs.VulnerabilityCodeVulnerabilityDetectionControl']:
        """
        Step 1: Select code-level vulnerability detection behavior
        """
        return pulumi.get(self, "vulnerability_detection_control")

