# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VulnerabilityThirdPartyK8sArgs', 'VulnerabilityThirdPartyK8s']

@pulumi.input_type
class VulnerabilityThirdPartyK8sArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool],
                 metadata: pulumi.Input['VulnerabilityThirdPartyK8sMetadataArgs'],
                 vulnerability_detection_control: pulumi.Input['VulnerabilityThirdPartyK8sVulnerabilityDetectionControlArgs'],
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 kubernetes_label_conditions: Optional[pulumi.Input['VulnerabilityThirdPartyK8sKubernetesLabelConditionsArgs']] = None,
                 rule_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a VulnerabilityThirdPartyK8s resource.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input['VulnerabilityThirdPartyK8sMetadataArgs'] metadata: Step 3: Leave comment (optional)
        :param pulumi.Input['VulnerabilityThirdPartyK8sVulnerabilityDetectionControlArgs'] vulnerability_detection_control: Step 1: Select third-party vulnerability detection behavior
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input['VulnerabilityThirdPartyK8sKubernetesLabelConditionsArgs'] kubernetes_label_conditions: When you add multiple conditions, the rule applies if all conditions apply.
        :param pulumi.Input[builtins.str] rule_name: Rule name
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "vulnerability_detection_control", vulnerability_detection_control)
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)
        if kubernetes_label_conditions is not None:
            pulumi.set(__self__, "kubernetes_label_conditions", kubernetes_label_conditions)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Input['VulnerabilityThirdPartyK8sMetadataArgs']:
        """
        Step 3: Leave comment (optional)
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: pulumi.Input['VulnerabilityThirdPartyK8sMetadataArgs']):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="vulnerabilityDetectionControl")
    def vulnerability_detection_control(self) -> pulumi.Input['VulnerabilityThirdPartyK8sVulnerabilityDetectionControlArgs']:
        """
        Step 1: Select third-party vulnerability detection behavior
        """
        return pulumi.get(self, "vulnerability_detection_control")

    @vulnerability_detection_control.setter
    def vulnerability_detection_control(self, value: pulumi.Input['VulnerabilityThirdPartyK8sVulnerabilityDetectionControlArgs']):
        pulumi.set(self, "vulnerability_detection_control", value)

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "insert_after", value)

    @property
    @pulumi.getter(name="kubernetesLabelConditions")
    def kubernetes_label_conditions(self) -> Optional[pulumi.Input['VulnerabilityThirdPartyK8sKubernetesLabelConditionsArgs']]:
        """
        When you add multiple conditions, the rule applies if all conditions apply.
        """
        return pulumi.get(self, "kubernetes_label_conditions")

    @kubernetes_label_conditions.setter
    def kubernetes_label_conditions(self, value: Optional[pulumi.Input['VulnerabilityThirdPartyK8sKubernetesLabelConditionsArgs']]):
        pulumi.set(self, "kubernetes_label_conditions", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Rule name
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rule_name", value)


@pulumi.input_type
class _VulnerabilityThirdPartyK8sState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 kubernetes_label_conditions: Optional[pulumi.Input['VulnerabilityThirdPartyK8sKubernetesLabelConditionsArgs']] = None,
                 metadata: Optional[pulumi.Input['VulnerabilityThirdPartyK8sMetadataArgs']] = None,
                 rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 vulnerability_detection_control: Optional[pulumi.Input['VulnerabilityThirdPartyK8sVulnerabilityDetectionControlArgs']] = None):
        """
        Input properties used for looking up and filtering VulnerabilityThirdPartyK8s resources.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input['VulnerabilityThirdPartyK8sKubernetesLabelConditionsArgs'] kubernetes_label_conditions: When you add multiple conditions, the rule applies if all conditions apply.
        :param pulumi.Input['VulnerabilityThirdPartyK8sMetadataArgs'] metadata: Step 3: Leave comment (optional)
        :param pulumi.Input[builtins.str] rule_name: Rule name
        :param pulumi.Input['VulnerabilityThirdPartyK8sVulnerabilityDetectionControlArgs'] vulnerability_detection_control: Step 1: Select third-party vulnerability detection behavior
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)
        if kubernetes_label_conditions is not None:
            pulumi.set(__self__, "kubernetes_label_conditions", kubernetes_label_conditions)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if vulnerability_detection_control is not None:
            pulumi.set(__self__, "vulnerability_detection_control", vulnerability_detection_control)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "insert_after", value)

    @property
    @pulumi.getter(name="kubernetesLabelConditions")
    def kubernetes_label_conditions(self) -> Optional[pulumi.Input['VulnerabilityThirdPartyK8sKubernetesLabelConditionsArgs']]:
        """
        When you add multiple conditions, the rule applies if all conditions apply.
        """
        return pulumi.get(self, "kubernetes_label_conditions")

    @kubernetes_label_conditions.setter
    def kubernetes_label_conditions(self, value: Optional[pulumi.Input['VulnerabilityThirdPartyK8sKubernetesLabelConditionsArgs']]):
        pulumi.set(self, "kubernetes_label_conditions", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['VulnerabilityThirdPartyK8sMetadataArgs']]:
        """
        Step 3: Leave comment (optional)
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['VulnerabilityThirdPartyK8sMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Rule name
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter(name="vulnerabilityDetectionControl")
    def vulnerability_detection_control(self) -> Optional[pulumi.Input['VulnerabilityThirdPartyK8sVulnerabilityDetectionControlArgs']]:
        """
        Step 1: Select third-party vulnerability detection behavior
        """
        return pulumi.get(self, "vulnerability_detection_control")

    @vulnerability_detection_control.setter
    def vulnerability_detection_control(self, value: Optional[pulumi.Input['VulnerabilityThirdPartyK8sVulnerabilityDetectionControlArgs']]):
        pulumi.set(self, "vulnerability_detection_control", value)


@pulumi.type_token("dynatrace:index/vulnerabilityThirdPartyK8s:VulnerabilityThirdPartyK8s")
class VulnerabilityThirdPartyK8s(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 kubernetes_label_conditions: Optional[pulumi.Input[Union['VulnerabilityThirdPartyK8sKubernetesLabelConditionsArgs', 'VulnerabilityThirdPartyK8sKubernetesLabelConditionsArgsDict']]] = None,
                 metadata: Optional[pulumi.Input[Union['VulnerabilityThirdPartyK8sMetadataArgs', 'VulnerabilityThirdPartyK8sMetadataArgsDict']]] = None,
                 rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 vulnerability_detection_control: Optional[pulumi.Input[Union['VulnerabilityThirdPartyK8sVulnerabilityDetectionControlArgs', 'VulnerabilityThirdPartyK8sVulnerabilityDetectionControlArgsDict']]] = None,
                 __props__=None):
        """
        > This resource requires the API token scopes **Read security problems** (`securityProblems.read`) and **Write security problems** (`securityProblems.write`)

        > This resource is excluded by default in the export utility, please explicitly specify the resource to retrieve existing configuration.

        ## Dynatrace Documentation

        - Runtime Vulnerability Analytics - https://www.dynatrace.com/support/help/platform-modules/application-security/vulnerability-analytics

        - Settings API - https://www.dynatrace.com/support/help/dynatrace-api/environment-api/settings (schemaId: `builtin:appsec.third-party-vulnerability-kubernetes-label-rule-settings`)

        ## Resource Example Usage

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        _name_ = dynatrace.VulnerabilityThirdPartyK8s("#name#",
            enabled=False,
            kubernetes_label_conditions={
                "kubernetes_label_conditions": [
                    {
                        "kubernetes_label_key": "kubernetes.azure.com/mode",
                        "kubernetes_label_value": "#name#",
                        "matcher": "NOT_EQUALS",
                    },
                    {
                        "kubernetes_label_key": "agentpool",
                        "kubernetes_label_value": "#name#",
                        "matcher": "CONTAINS",
                    },
                ],
            },
            metadata={
                "comment": "#name#",
            },
            rule_name="#name#",
            vulnerability_detection_control={
                "monitoring_mode": "MONITORING_OFF",
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[Union['VulnerabilityThirdPartyK8sKubernetesLabelConditionsArgs', 'VulnerabilityThirdPartyK8sKubernetesLabelConditionsArgsDict']] kubernetes_label_conditions: When you add multiple conditions, the rule applies if all conditions apply.
        :param pulumi.Input[Union['VulnerabilityThirdPartyK8sMetadataArgs', 'VulnerabilityThirdPartyK8sMetadataArgsDict']] metadata: Step 3: Leave comment (optional)
        :param pulumi.Input[builtins.str] rule_name: Rule name
        :param pulumi.Input[Union['VulnerabilityThirdPartyK8sVulnerabilityDetectionControlArgs', 'VulnerabilityThirdPartyK8sVulnerabilityDetectionControlArgsDict']] vulnerability_detection_control: Step 1: Select third-party vulnerability detection behavior
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VulnerabilityThirdPartyK8sArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > This resource requires the API token scopes **Read security problems** (`securityProblems.read`) and **Write security problems** (`securityProblems.write`)

        > This resource is excluded by default in the export utility, please explicitly specify the resource to retrieve existing configuration.

        ## Dynatrace Documentation

        - Runtime Vulnerability Analytics - https://www.dynatrace.com/support/help/platform-modules/application-security/vulnerability-analytics

        - Settings API - https://www.dynatrace.com/support/help/dynatrace-api/environment-api/settings (schemaId: `builtin:appsec.third-party-vulnerability-kubernetes-label-rule-settings`)

        ## Resource Example Usage

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        _name_ = dynatrace.VulnerabilityThirdPartyK8s("#name#",
            enabled=False,
            kubernetes_label_conditions={
                "kubernetes_label_conditions": [
                    {
                        "kubernetes_label_key": "kubernetes.azure.com/mode",
                        "kubernetes_label_value": "#name#",
                        "matcher": "NOT_EQUALS",
                    },
                    {
                        "kubernetes_label_key": "agentpool",
                        "kubernetes_label_value": "#name#",
                        "matcher": "CONTAINS",
                    },
                ],
            },
            metadata={
                "comment": "#name#",
            },
            rule_name="#name#",
            vulnerability_detection_control={
                "monitoring_mode": "MONITORING_OFF",
            })
        ```

        :param str resource_name: The name of the resource.
        :param VulnerabilityThirdPartyK8sArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VulnerabilityThirdPartyK8sArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 insert_after: Optional[pulumi.Input[builtins.str]] = None,
                 kubernetes_label_conditions: Optional[pulumi.Input[Union['VulnerabilityThirdPartyK8sKubernetesLabelConditionsArgs', 'VulnerabilityThirdPartyK8sKubernetesLabelConditionsArgsDict']]] = None,
                 metadata: Optional[pulumi.Input[Union['VulnerabilityThirdPartyK8sMetadataArgs', 'VulnerabilityThirdPartyK8sMetadataArgsDict']]] = None,
                 rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 vulnerability_detection_control: Optional[pulumi.Input[Union['VulnerabilityThirdPartyK8sVulnerabilityDetectionControlArgs', 'VulnerabilityThirdPartyK8sVulnerabilityDetectionControlArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VulnerabilityThirdPartyK8sArgs.__new__(VulnerabilityThirdPartyK8sArgs)

            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["insert_after"] = insert_after
            __props__.__dict__["kubernetes_label_conditions"] = kubernetes_label_conditions
            if metadata is None and not opts.urn:
                raise TypeError("Missing required property 'metadata'")
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["rule_name"] = rule_name
            if vulnerability_detection_control is None and not opts.urn:
                raise TypeError("Missing required property 'vulnerability_detection_control'")
            __props__.__dict__["vulnerability_detection_control"] = vulnerability_detection_control
        super(VulnerabilityThirdPartyK8s, __self__).__init__(
            'dynatrace:index/vulnerabilityThirdPartyK8s:VulnerabilityThirdPartyK8s',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            insert_after: Optional[pulumi.Input[builtins.str]] = None,
            kubernetes_label_conditions: Optional[pulumi.Input[Union['VulnerabilityThirdPartyK8sKubernetesLabelConditionsArgs', 'VulnerabilityThirdPartyK8sKubernetesLabelConditionsArgsDict']]] = None,
            metadata: Optional[pulumi.Input[Union['VulnerabilityThirdPartyK8sMetadataArgs', 'VulnerabilityThirdPartyK8sMetadataArgsDict']]] = None,
            rule_name: Optional[pulumi.Input[builtins.str]] = None,
            vulnerability_detection_control: Optional[pulumi.Input[Union['VulnerabilityThirdPartyK8sVulnerabilityDetectionControlArgs', 'VulnerabilityThirdPartyK8sVulnerabilityDetectionControlArgsDict']]] = None) -> 'VulnerabilityThirdPartyK8s':
        """
        Get an existing VulnerabilityThirdPartyK8s resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[builtins.str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[Union['VulnerabilityThirdPartyK8sKubernetesLabelConditionsArgs', 'VulnerabilityThirdPartyK8sKubernetesLabelConditionsArgsDict']] kubernetes_label_conditions: When you add multiple conditions, the rule applies if all conditions apply.
        :param pulumi.Input[Union['VulnerabilityThirdPartyK8sMetadataArgs', 'VulnerabilityThirdPartyK8sMetadataArgsDict']] metadata: Step 3: Leave comment (optional)
        :param pulumi.Input[builtins.str] rule_name: Rule name
        :param pulumi.Input[Union['VulnerabilityThirdPartyK8sVulnerabilityDetectionControlArgs', 'VulnerabilityThirdPartyK8sVulnerabilityDetectionControlArgsDict']] vulnerability_detection_control: Step 1: Select third-party vulnerability detection behavior
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VulnerabilityThirdPartyK8sState.__new__(_VulnerabilityThirdPartyK8sState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["insert_after"] = insert_after
        __props__.__dict__["kubernetes_label_conditions"] = kubernetes_label_conditions
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["vulnerability_detection_control"] = vulnerability_detection_control
        return VulnerabilityThirdPartyK8s(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> pulumi.Output[builtins.str]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @property
    @pulumi.getter(name="kubernetesLabelConditions")
    def kubernetes_label_conditions(self) -> pulumi.Output[Optional['outputs.VulnerabilityThirdPartyK8sKubernetesLabelConditions']]:
        """
        When you add multiple conditions, the rule applies if all conditions apply.
        """
        return pulumi.get(self, "kubernetes_label_conditions")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output['outputs.VulnerabilityThirdPartyK8sMetadata']:
        """
        Step 3: Leave comment (optional)
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Rule name
        """
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter(name="vulnerabilityDetectionControl")
    def vulnerability_detection_control(self) -> pulumi.Output['outputs.VulnerabilityThirdPartyK8sVulnerabilityDetectionControl']:
        """
        Step 1: Select third-party vulnerability detection behavior
        """
        return pulumi.get(self, "vulnerability_detection_control")

