# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WebAppCustomPropRestrictionsArgs', 'WebAppCustomPropRestrictions']

@pulumi.input_type
class WebAppCustomPropRestrictionsArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[builtins.str],
                 custom_event_properties_allow_list: Optional[pulumi.Input['WebAppCustomPropRestrictionsCustomEventPropertiesAllowListArgs']] = None,
                 custom_session_properties_allow_list: Optional[pulumi.Input['WebAppCustomPropRestrictionsCustomSessionPropertiesAllowListArgs']] = None):
        """
        The set of arguments for constructing a WebAppCustomPropRestrictions resource.
        :param pulumi.Input[builtins.str] application_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        :param pulumi.Input['WebAppCustomPropRestrictionsCustomEventPropertiesAllowListArgs'] custom_event_properties_allow_list: List of allowed custom event properties
        :param pulumi.Input['WebAppCustomPropRestrictionsCustomSessionPropertiesAllowListArgs'] custom_session_properties_allow_list: List of allowed custom session properties
        """
        pulumi.set(__self__, "application_id", application_id)
        if custom_event_properties_allow_list is not None:
            pulumi.set(__self__, "custom_event_properties_allow_list", custom_event_properties_allow_list)
        if custom_session_properties_allow_list is not None:
            pulumi.set(__self__, "custom_session_properties_allow_list", custom_session_properties_allow_list)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[builtins.str]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="customEventPropertiesAllowList")
    def custom_event_properties_allow_list(self) -> Optional[pulumi.Input['WebAppCustomPropRestrictionsCustomEventPropertiesAllowListArgs']]:
        """
        List of allowed custom event properties
        """
        return pulumi.get(self, "custom_event_properties_allow_list")

    @custom_event_properties_allow_list.setter
    def custom_event_properties_allow_list(self, value: Optional[pulumi.Input['WebAppCustomPropRestrictionsCustomEventPropertiesAllowListArgs']]):
        pulumi.set(self, "custom_event_properties_allow_list", value)

    @property
    @pulumi.getter(name="customSessionPropertiesAllowList")
    def custom_session_properties_allow_list(self) -> Optional[pulumi.Input['WebAppCustomPropRestrictionsCustomSessionPropertiesAllowListArgs']]:
        """
        List of allowed custom session properties
        """
        return pulumi.get(self, "custom_session_properties_allow_list")

    @custom_session_properties_allow_list.setter
    def custom_session_properties_allow_list(self, value: Optional[pulumi.Input['WebAppCustomPropRestrictionsCustomSessionPropertiesAllowListArgs']]):
        pulumi.set(self, "custom_session_properties_allow_list", value)


@pulumi.input_type
class _WebAppCustomPropRestrictionsState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 custom_event_properties_allow_list: Optional[pulumi.Input['WebAppCustomPropRestrictionsCustomEventPropertiesAllowListArgs']] = None,
                 custom_session_properties_allow_list: Optional[pulumi.Input['WebAppCustomPropRestrictionsCustomSessionPropertiesAllowListArgs']] = None):
        """
        Input properties used for looking up and filtering WebAppCustomPropRestrictions resources.
        :param pulumi.Input[builtins.str] application_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        :param pulumi.Input['WebAppCustomPropRestrictionsCustomEventPropertiesAllowListArgs'] custom_event_properties_allow_list: List of allowed custom event properties
        :param pulumi.Input['WebAppCustomPropRestrictionsCustomSessionPropertiesAllowListArgs'] custom_session_properties_allow_list: List of allowed custom session properties
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if custom_event_properties_allow_list is not None:
            pulumi.set(__self__, "custom_event_properties_allow_list", custom_event_properties_allow_list)
        if custom_session_properties_allow_list is not None:
            pulumi.set(__self__, "custom_session_properties_allow_list", custom_session_properties_allow_list)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="customEventPropertiesAllowList")
    def custom_event_properties_allow_list(self) -> Optional[pulumi.Input['WebAppCustomPropRestrictionsCustomEventPropertiesAllowListArgs']]:
        """
        List of allowed custom event properties
        """
        return pulumi.get(self, "custom_event_properties_allow_list")

    @custom_event_properties_allow_list.setter
    def custom_event_properties_allow_list(self, value: Optional[pulumi.Input['WebAppCustomPropRestrictionsCustomEventPropertiesAllowListArgs']]):
        pulumi.set(self, "custom_event_properties_allow_list", value)

    @property
    @pulumi.getter(name="customSessionPropertiesAllowList")
    def custom_session_properties_allow_list(self) -> Optional[pulumi.Input['WebAppCustomPropRestrictionsCustomSessionPropertiesAllowListArgs']]:
        """
        List of allowed custom session properties
        """
        return pulumi.get(self, "custom_session_properties_allow_list")

    @custom_session_properties_allow_list.setter
    def custom_session_properties_allow_list(self, value: Optional[pulumi.Input['WebAppCustomPropRestrictionsCustomSessionPropertiesAllowListArgs']]):
        pulumi.set(self, "custom_session_properties_allow_list", value)


@pulumi.type_token("dynatrace:index/webAppCustomPropRestrictions:WebAppCustomPropRestrictions")
class WebAppCustomPropRestrictions(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 custom_event_properties_allow_list: Optional[pulumi.Input[Union['WebAppCustomPropRestrictionsCustomEventPropertiesAllowListArgs', 'WebAppCustomPropRestrictionsCustomEventPropertiesAllowListArgsDict']]] = None,
                 custom_session_properties_allow_list: Optional[pulumi.Input[Union['WebAppCustomPropRestrictionsCustomSessionPropertiesAllowListArgs', 'WebAppCustomPropRestrictionsCustomSessionPropertiesAllowListArgsDict']]] = None,
                 __props__=None):
        """
        > This resource requires the API token scopes **Read settings** (`settings.read`) and **Write settings** (`settings.write`)

        ## Dynatrace Documentation

        - Web applications - https://docs.dynatrace.com/docs/platform-modules/digital-experience/web-applications

        - Settings API - https://www.dynatrace.com/support/help/dynatrace-api/environment-api/settings (schemaId: `builtin:rum.web.capture-custom-properties`)

        ## Resource Example Usage

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        _name_ = dynatrace.WebAppCustomPropRestrictions("#name#",
            application_id="APPLICATION-1234567890000000",
            custom_event_properties_allow_list={
                "custom_session_properties_allows": [
                    {
                        "field_data_type": "STRING",
                        "field_name": "ExampleEvent",
                    },
                    {
                        "field_data_type": "BOOLEAN",
                        "field_name": "ExampleEvent2",
                    },
                ],
            },
            custom_session_properties_allow_list={
                "custom_session_properties_allows": [
                    {
                        "field_data_type": "STRING",
                        "field_name": "ExampleSession",
                    },
                    {
                        "field_data_type": "BOOLEAN",
                        "field_name": "ExampleSession2",
                    },
                ],
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        :param pulumi.Input[Union['WebAppCustomPropRestrictionsCustomEventPropertiesAllowListArgs', 'WebAppCustomPropRestrictionsCustomEventPropertiesAllowListArgsDict']] custom_event_properties_allow_list: List of allowed custom event properties
        :param pulumi.Input[Union['WebAppCustomPropRestrictionsCustomSessionPropertiesAllowListArgs', 'WebAppCustomPropRestrictionsCustomSessionPropertiesAllowListArgsDict']] custom_session_properties_allow_list: List of allowed custom session properties
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WebAppCustomPropRestrictionsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > This resource requires the API token scopes **Read settings** (`settings.read`) and **Write settings** (`settings.write`)

        ## Dynatrace Documentation

        - Web applications - https://docs.dynatrace.com/docs/platform-modules/digital-experience/web-applications

        - Settings API - https://www.dynatrace.com/support/help/dynatrace-api/environment-api/settings (schemaId: `builtin:rum.web.capture-custom-properties`)

        ## Resource Example Usage

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        _name_ = dynatrace.WebAppCustomPropRestrictions("#name#",
            application_id="APPLICATION-1234567890000000",
            custom_event_properties_allow_list={
                "custom_session_properties_allows": [
                    {
                        "field_data_type": "STRING",
                        "field_name": "ExampleEvent",
                    },
                    {
                        "field_data_type": "BOOLEAN",
                        "field_name": "ExampleEvent2",
                    },
                ],
            },
            custom_session_properties_allow_list={
                "custom_session_properties_allows": [
                    {
                        "field_data_type": "STRING",
                        "field_name": "ExampleSession",
                    },
                    {
                        "field_data_type": "BOOLEAN",
                        "field_name": "ExampleSession2",
                    },
                ],
            })
        ```

        :param str resource_name: The name of the resource.
        :param WebAppCustomPropRestrictionsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WebAppCustomPropRestrictionsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 custom_event_properties_allow_list: Optional[pulumi.Input[Union['WebAppCustomPropRestrictionsCustomEventPropertiesAllowListArgs', 'WebAppCustomPropRestrictionsCustomEventPropertiesAllowListArgsDict']]] = None,
                 custom_session_properties_allow_list: Optional[pulumi.Input[Union['WebAppCustomPropRestrictionsCustomSessionPropertiesAllowListArgs', 'WebAppCustomPropRestrictionsCustomSessionPropertiesAllowListArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WebAppCustomPropRestrictionsArgs.__new__(WebAppCustomPropRestrictionsArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            __props__.__dict__["custom_event_properties_allow_list"] = custom_event_properties_allow_list
            __props__.__dict__["custom_session_properties_allow_list"] = custom_session_properties_allow_list
        super(WebAppCustomPropRestrictions, __self__).__init__(
            'dynatrace:index/webAppCustomPropRestrictions:WebAppCustomPropRestrictions',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[builtins.str]] = None,
            custom_event_properties_allow_list: Optional[pulumi.Input[Union['WebAppCustomPropRestrictionsCustomEventPropertiesAllowListArgs', 'WebAppCustomPropRestrictionsCustomEventPropertiesAllowListArgsDict']]] = None,
            custom_session_properties_allow_list: Optional[pulumi.Input[Union['WebAppCustomPropRestrictionsCustomSessionPropertiesAllowListArgs', 'WebAppCustomPropRestrictionsCustomSessionPropertiesAllowListArgsDict']]] = None) -> 'WebAppCustomPropRestrictions':
        """
        Get an existing WebAppCustomPropRestrictions resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        :param pulumi.Input[Union['WebAppCustomPropRestrictionsCustomEventPropertiesAllowListArgs', 'WebAppCustomPropRestrictionsCustomEventPropertiesAllowListArgsDict']] custom_event_properties_allow_list: List of allowed custom event properties
        :param pulumi.Input[Union['WebAppCustomPropRestrictionsCustomSessionPropertiesAllowListArgs', 'WebAppCustomPropRestrictionsCustomSessionPropertiesAllowListArgsDict']] custom_session_properties_allow_list: List of allowed custom session properties
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WebAppCustomPropRestrictionsState.__new__(_WebAppCustomPropRestrictionsState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["custom_event_properties_allow_list"] = custom_event_properties_allow_list
        __props__.__dict__["custom_session_properties_allow_list"] = custom_session_properties_allow_list
        return WebAppCustomPropRestrictions(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[builtins.str]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="customEventPropertiesAllowList")
    def custom_event_properties_allow_list(self) -> pulumi.Output[Optional['outputs.WebAppCustomPropRestrictionsCustomEventPropertiesAllowList']]:
        """
        List of allowed custom event properties
        """
        return pulumi.get(self, "custom_event_properties_allow_list")

    @property
    @pulumi.getter(name="customSessionPropertiesAllowList")
    def custom_session_properties_allow_list(self) -> pulumi.Output[Optional['outputs.WebAppCustomPropRestrictionsCustomSessionPropertiesAllowList']]:
        """
        List of allowed custom session properties
        """
        return pulumi.get(self, "custom_session_properties_allow_list")

