# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['WebAppInjectionCookieArgs', 'WebAppInjectionCookie']

@pulumi.input_type
class WebAppInjectionCookieArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[builtins.str],
                 same_site_cookie_attribute: pulumi.Input[builtins.str],
                 use_secure_cookie_attribute: pulumi.Input[builtins.bool],
                 cookie_placement_domain: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a WebAppInjectionCookie resource.
        :param pulumi.Input[builtins.str] application_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        :param pulumi.Input[builtins.str] same_site_cookie_attribute: Possible Values: `LAX`, `NONE`, `NOTSET`, `STRICT`
        :param pulumi.Input[builtins.bool] use_secure_cookie_attribute: If your application is only accessible via SSL, you can add the Secure attribute to all cookies set by Dynatrace. This setting prevents the display of warnings from PCI-compliance security scanners. Be aware that with this setting enabled Dynatrace correlation of user actions with server-side web requests is only possible over SSL connections.
        :param pulumi.Input[builtins.str] cookie_placement_domain: Specify an alternative domain for cookies set by Dynatrace. Keep in mind that your browser may not allow placement of cookies on certain domains (for example, top-level domains). Before typing a domain name here, confirm that the domain will accept cookies from your browser. For details, see the list of [forbidden top-level domains](https://dt-url.net/9n6b0pfz).
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "same_site_cookie_attribute", same_site_cookie_attribute)
        pulumi.set(__self__, "use_secure_cookie_attribute", use_secure_cookie_attribute)
        if cookie_placement_domain is not None:
            pulumi.set(__self__, "cookie_placement_domain", cookie_placement_domain)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[builtins.str]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="sameSiteCookieAttribute")
    def same_site_cookie_attribute(self) -> pulumi.Input[builtins.str]:
        """
        Possible Values: `LAX`, `NONE`, `NOTSET`, `STRICT`
        """
        return pulumi.get(self, "same_site_cookie_attribute")

    @same_site_cookie_attribute.setter
    def same_site_cookie_attribute(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "same_site_cookie_attribute", value)

    @property
    @pulumi.getter(name="useSecureCookieAttribute")
    def use_secure_cookie_attribute(self) -> pulumi.Input[builtins.bool]:
        """
        If your application is only accessible via SSL, you can add the Secure attribute to all cookies set by Dynatrace. This setting prevents the display of warnings from PCI-compliance security scanners. Be aware that with this setting enabled Dynatrace correlation of user actions with server-side web requests is only possible over SSL connections.
        """
        return pulumi.get(self, "use_secure_cookie_attribute")

    @use_secure_cookie_attribute.setter
    def use_secure_cookie_attribute(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "use_secure_cookie_attribute", value)

    @property
    @pulumi.getter(name="cookiePlacementDomain")
    def cookie_placement_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specify an alternative domain for cookies set by Dynatrace. Keep in mind that your browser may not allow placement of cookies on certain domains (for example, top-level domains). Before typing a domain name here, confirm that the domain will accept cookies from your browser. For details, see the list of [forbidden top-level domains](https://dt-url.net/9n6b0pfz).
        """
        return pulumi.get(self, "cookie_placement_domain")

    @cookie_placement_domain.setter
    def cookie_placement_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cookie_placement_domain", value)


@pulumi.input_type
class _WebAppInjectionCookieState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 cookie_placement_domain: Optional[pulumi.Input[builtins.str]] = None,
                 same_site_cookie_attribute: Optional[pulumi.Input[builtins.str]] = None,
                 use_secure_cookie_attribute: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering WebAppInjectionCookie resources.
        :param pulumi.Input[builtins.str] application_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        :param pulumi.Input[builtins.str] cookie_placement_domain: Specify an alternative domain for cookies set by Dynatrace. Keep in mind that your browser may not allow placement of cookies on certain domains (for example, top-level domains). Before typing a domain name here, confirm that the domain will accept cookies from your browser. For details, see the list of [forbidden top-level domains](https://dt-url.net/9n6b0pfz).
        :param pulumi.Input[builtins.str] same_site_cookie_attribute: Possible Values: `LAX`, `NONE`, `NOTSET`, `STRICT`
        :param pulumi.Input[builtins.bool] use_secure_cookie_attribute: If your application is only accessible via SSL, you can add the Secure attribute to all cookies set by Dynatrace. This setting prevents the display of warnings from PCI-compliance security scanners. Be aware that with this setting enabled Dynatrace correlation of user actions with server-side web requests is only possible over SSL connections.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if cookie_placement_domain is not None:
            pulumi.set(__self__, "cookie_placement_domain", cookie_placement_domain)
        if same_site_cookie_attribute is not None:
            pulumi.set(__self__, "same_site_cookie_attribute", same_site_cookie_attribute)
        if use_secure_cookie_attribute is not None:
            pulumi.set(__self__, "use_secure_cookie_attribute", use_secure_cookie_attribute)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="cookiePlacementDomain")
    def cookie_placement_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specify an alternative domain for cookies set by Dynatrace. Keep in mind that your browser may not allow placement of cookies on certain domains (for example, top-level domains). Before typing a domain name here, confirm that the domain will accept cookies from your browser. For details, see the list of [forbidden top-level domains](https://dt-url.net/9n6b0pfz).
        """
        return pulumi.get(self, "cookie_placement_domain")

    @cookie_placement_domain.setter
    def cookie_placement_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cookie_placement_domain", value)

    @property
    @pulumi.getter(name="sameSiteCookieAttribute")
    def same_site_cookie_attribute(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Possible Values: `LAX`, `NONE`, `NOTSET`, `STRICT`
        """
        return pulumi.get(self, "same_site_cookie_attribute")

    @same_site_cookie_attribute.setter
    def same_site_cookie_attribute(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "same_site_cookie_attribute", value)

    @property
    @pulumi.getter(name="useSecureCookieAttribute")
    def use_secure_cookie_attribute(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If your application is only accessible via SSL, you can add the Secure attribute to all cookies set by Dynatrace. This setting prevents the display of warnings from PCI-compliance security scanners. Be aware that with this setting enabled Dynatrace correlation of user actions with server-side web requests is only possible over SSL connections.
        """
        return pulumi.get(self, "use_secure_cookie_attribute")

    @use_secure_cookie_attribute.setter
    def use_secure_cookie_attribute(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_secure_cookie_attribute", value)


@pulumi.type_token("dynatrace:index/webAppInjectionCookie:WebAppInjectionCookie")
class WebAppInjectionCookie(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 cookie_placement_domain: Optional[pulumi.Input[builtins.str]] = None,
                 same_site_cookie_attribute: Optional[pulumi.Input[builtins.str]] = None,
                 use_secure_cookie_attribute: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        Create a WebAppInjectionCookie resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        :param pulumi.Input[builtins.str] cookie_placement_domain: Specify an alternative domain for cookies set by Dynatrace. Keep in mind that your browser may not allow placement of cookies on certain domains (for example, top-level domains). Before typing a domain name here, confirm that the domain will accept cookies from your browser. For details, see the list of [forbidden top-level domains](https://dt-url.net/9n6b0pfz).
        :param pulumi.Input[builtins.str] same_site_cookie_attribute: Possible Values: `LAX`, `NONE`, `NOTSET`, `STRICT`
        :param pulumi.Input[builtins.bool] use_secure_cookie_attribute: If your application is only accessible via SSL, you can add the Secure attribute to all cookies set by Dynatrace. This setting prevents the display of warnings from PCI-compliance security scanners. Be aware that with this setting enabled Dynatrace correlation of user actions with server-side web requests is only possible over SSL connections.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WebAppInjectionCookieArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a WebAppInjectionCookie resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param WebAppInjectionCookieArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WebAppInjectionCookieArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 cookie_placement_domain: Optional[pulumi.Input[builtins.str]] = None,
                 same_site_cookie_attribute: Optional[pulumi.Input[builtins.str]] = None,
                 use_secure_cookie_attribute: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WebAppInjectionCookieArgs.__new__(WebAppInjectionCookieArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            __props__.__dict__["cookie_placement_domain"] = cookie_placement_domain
            if same_site_cookie_attribute is None and not opts.urn:
                raise TypeError("Missing required property 'same_site_cookie_attribute'")
            __props__.__dict__["same_site_cookie_attribute"] = same_site_cookie_attribute
            if use_secure_cookie_attribute is None and not opts.urn:
                raise TypeError("Missing required property 'use_secure_cookie_attribute'")
            __props__.__dict__["use_secure_cookie_attribute"] = use_secure_cookie_attribute
        super(WebAppInjectionCookie, __self__).__init__(
            'dynatrace:index/webAppInjectionCookie:WebAppInjectionCookie',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[builtins.str]] = None,
            cookie_placement_domain: Optional[pulumi.Input[builtins.str]] = None,
            same_site_cookie_attribute: Optional[pulumi.Input[builtins.str]] = None,
            use_secure_cookie_attribute: Optional[pulumi.Input[builtins.bool]] = None) -> 'WebAppInjectionCookie':
        """
        Get an existing WebAppInjectionCookie resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        :param pulumi.Input[builtins.str] cookie_placement_domain: Specify an alternative domain for cookies set by Dynatrace. Keep in mind that your browser may not allow placement of cookies on certain domains (for example, top-level domains). Before typing a domain name here, confirm that the domain will accept cookies from your browser. For details, see the list of [forbidden top-level domains](https://dt-url.net/9n6b0pfz).
        :param pulumi.Input[builtins.str] same_site_cookie_attribute: Possible Values: `LAX`, `NONE`, `NOTSET`, `STRICT`
        :param pulumi.Input[builtins.bool] use_secure_cookie_attribute: If your application is only accessible via SSL, you can add the Secure attribute to all cookies set by Dynatrace. This setting prevents the display of warnings from PCI-compliance security scanners. Be aware that with this setting enabled Dynatrace correlation of user actions with server-side web requests is only possible over SSL connections.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WebAppInjectionCookieState.__new__(_WebAppInjectionCookieState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["cookie_placement_domain"] = cookie_placement_domain
        __props__.__dict__["same_site_cookie_attribute"] = same_site_cookie_attribute
        __props__.__dict__["use_secure_cookie_attribute"] = use_secure_cookie_attribute
        return WebAppInjectionCookie(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[builtins.str]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="cookiePlacementDomain")
    def cookie_placement_domain(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specify an alternative domain for cookies set by Dynatrace. Keep in mind that your browser may not allow placement of cookies on certain domains (for example, top-level domains). Before typing a domain name here, confirm that the domain will accept cookies from your browser. For details, see the list of [forbidden top-level domains](https://dt-url.net/9n6b0pfz).
        """
        return pulumi.get(self, "cookie_placement_domain")

    @property
    @pulumi.getter(name="sameSiteCookieAttribute")
    def same_site_cookie_attribute(self) -> pulumi.Output[builtins.str]:
        """
        Possible Values: `LAX`, `NONE`, `NOTSET`, `STRICT`
        """
        return pulumi.get(self, "same_site_cookie_attribute")

    @property
    @pulumi.getter(name="useSecureCookieAttribute")
    def use_secure_cookie_attribute(self) -> pulumi.Output[builtins.bool]:
        """
        If your application is only accessible via SSL, you can add the Secure attribute to all cookies set by Dynatrace. This setting prevents the display of warnings from PCI-compliance security scanners. Be aware that with this setting enabled Dynatrace correlation of user actions with server-side web requests is only possible over SSL connections.
        """
        return pulumi.get(self, "use_secure_cookie_attribute")

