# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WebAppIpAddressExclusionArgs', 'WebAppIpAddressExclusion']

@pulumi.input_type
class WebAppIpAddressExclusionArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[builtins.str],
                 ip_address_exclusion_include: pulumi.Input[builtins.bool],
                 ip_exclusion_list: Optional[pulumi.Input['WebAppIpAddressExclusionIpExclusionListArgs']] = None):
        """
        The set of arguments for constructing a WebAppIpAddressExclusion resource.
        :param pulumi.Input[builtins.str] application_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        :param pulumi.Input[builtins.bool] ip_address_exclusion_include: These are the only IP addresses that should be monitored
        :param pulumi.Input['WebAppIpAddressExclusionIpExclusionListArgs'] ip_exclusion_list: **Examples:** - 84.112.10.5 - fe80::10a1:c6b2:5f68:785d
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "ip_address_exclusion_include", ip_address_exclusion_include)
        if ip_exclusion_list is not None:
            pulumi.set(__self__, "ip_exclusion_list", ip_exclusion_list)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[builtins.str]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="ipAddressExclusionInclude")
    def ip_address_exclusion_include(self) -> pulumi.Input[builtins.bool]:
        """
        These are the only IP addresses that should be monitored
        """
        return pulumi.get(self, "ip_address_exclusion_include")

    @ip_address_exclusion_include.setter
    def ip_address_exclusion_include(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "ip_address_exclusion_include", value)

    @property
    @pulumi.getter(name="ipExclusionList")
    def ip_exclusion_list(self) -> Optional[pulumi.Input['WebAppIpAddressExclusionIpExclusionListArgs']]:
        """
        **Examples:** - 84.112.10.5 - fe80::10a1:c6b2:5f68:785d
        """
        return pulumi.get(self, "ip_exclusion_list")

    @ip_exclusion_list.setter
    def ip_exclusion_list(self, value: Optional[pulumi.Input['WebAppIpAddressExclusionIpExclusionListArgs']]):
        pulumi.set(self, "ip_exclusion_list", value)


@pulumi.input_type
class _WebAppIpAddressExclusionState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address_exclusion_include: Optional[pulumi.Input[builtins.bool]] = None,
                 ip_exclusion_list: Optional[pulumi.Input['WebAppIpAddressExclusionIpExclusionListArgs']] = None):
        """
        Input properties used for looking up and filtering WebAppIpAddressExclusion resources.
        :param pulumi.Input[builtins.str] application_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        :param pulumi.Input[builtins.bool] ip_address_exclusion_include: These are the only IP addresses that should be monitored
        :param pulumi.Input['WebAppIpAddressExclusionIpExclusionListArgs'] ip_exclusion_list: **Examples:** - 84.112.10.5 - fe80::10a1:c6b2:5f68:785d
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if ip_address_exclusion_include is not None:
            pulumi.set(__self__, "ip_address_exclusion_include", ip_address_exclusion_include)
        if ip_exclusion_list is not None:
            pulumi.set(__self__, "ip_exclusion_list", ip_exclusion_list)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="ipAddressExclusionInclude")
    def ip_address_exclusion_include(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        These are the only IP addresses that should be monitored
        """
        return pulumi.get(self, "ip_address_exclusion_include")

    @ip_address_exclusion_include.setter
    def ip_address_exclusion_include(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ip_address_exclusion_include", value)

    @property
    @pulumi.getter(name="ipExclusionList")
    def ip_exclusion_list(self) -> Optional[pulumi.Input['WebAppIpAddressExclusionIpExclusionListArgs']]:
        """
        **Examples:** - 84.112.10.5 - fe80::10a1:c6b2:5f68:785d
        """
        return pulumi.get(self, "ip_exclusion_list")

    @ip_exclusion_list.setter
    def ip_exclusion_list(self, value: Optional[pulumi.Input['WebAppIpAddressExclusionIpExclusionListArgs']]):
        pulumi.set(self, "ip_exclusion_list", value)


@pulumi.type_token("dynatrace:index/webAppIpAddressExclusion:WebAppIpAddressExclusion")
class WebAppIpAddressExclusion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address_exclusion_include: Optional[pulumi.Input[builtins.bool]] = None,
                 ip_exclusion_list: Optional[pulumi.Input[Union['WebAppIpAddressExclusionIpExclusionListArgs', 'WebAppIpAddressExclusionIpExclusionListArgsDict']]] = None,
                 __props__=None):
        """
        > Configuration overlaps with dynatrace_web_application.

        > This resource requires the API token scopes **Read settings** (`settings.read`) and **Write settings** (`settings.write`)

        ## Dynatrace Documentation

        - Exclude IP addresses, browsers, bots, and spiders from monitoring for web applications - https://docs.dynatrace.com/docs/shortlink/rum-exclude-bots

        - Settings API - https://www.dynatrace.com/support/help/dynatrace-api/environment-api/settings (schemaId: `builtin:rum.web.ipaddress-exclusion`)

        ## Resource Example Usage

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        _name_ = dynatrace.WebAppIpAddressExclusion("#name#",
            application_id="APPLICATION-1234567890000000",
            ip_address_exclusion_include=False,
            ip_exclusion_list={
                "ip_exclusions": [
                    {
                        "ip": "192.168.1.5",
                    },
                    {
                        "ip": "10.0.0.1",
                        "ip_to": "10.0.0.5",
                    },
                ],
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        :param pulumi.Input[builtins.bool] ip_address_exclusion_include: These are the only IP addresses that should be monitored
        :param pulumi.Input[Union['WebAppIpAddressExclusionIpExclusionListArgs', 'WebAppIpAddressExclusionIpExclusionListArgsDict']] ip_exclusion_list: **Examples:** - 84.112.10.5 - fe80::10a1:c6b2:5f68:785d
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WebAppIpAddressExclusionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > Configuration overlaps with dynatrace_web_application.

        > This resource requires the API token scopes **Read settings** (`settings.read`) and **Write settings** (`settings.write`)

        ## Dynatrace Documentation

        - Exclude IP addresses, browsers, bots, and spiders from monitoring for web applications - https://docs.dynatrace.com/docs/shortlink/rum-exclude-bots

        - Settings API - https://www.dynatrace.com/support/help/dynatrace-api/environment-api/settings (schemaId: `builtin:rum.web.ipaddress-exclusion`)

        ## Resource Example Usage

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        _name_ = dynatrace.WebAppIpAddressExclusion("#name#",
            application_id="APPLICATION-1234567890000000",
            ip_address_exclusion_include=False,
            ip_exclusion_list={
                "ip_exclusions": [
                    {
                        "ip": "192.168.1.5",
                    },
                    {
                        "ip": "10.0.0.1",
                        "ip_to": "10.0.0.5",
                    },
                ],
            })
        ```

        :param str resource_name: The name of the resource.
        :param WebAppIpAddressExclusionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WebAppIpAddressExclusionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address_exclusion_include: Optional[pulumi.Input[builtins.bool]] = None,
                 ip_exclusion_list: Optional[pulumi.Input[Union['WebAppIpAddressExclusionIpExclusionListArgs', 'WebAppIpAddressExclusionIpExclusionListArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WebAppIpAddressExclusionArgs.__new__(WebAppIpAddressExclusionArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            if ip_address_exclusion_include is None and not opts.urn:
                raise TypeError("Missing required property 'ip_address_exclusion_include'")
            __props__.__dict__["ip_address_exclusion_include"] = ip_address_exclusion_include
            __props__.__dict__["ip_exclusion_list"] = ip_exclusion_list
        super(WebAppIpAddressExclusion, __self__).__init__(
            'dynatrace:index/webAppIpAddressExclusion:WebAppIpAddressExclusion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[builtins.str]] = None,
            ip_address_exclusion_include: Optional[pulumi.Input[builtins.bool]] = None,
            ip_exclusion_list: Optional[pulumi.Input[Union['WebAppIpAddressExclusionIpExclusionListArgs', 'WebAppIpAddressExclusionIpExclusionListArgsDict']]] = None) -> 'WebAppIpAddressExclusion':
        """
        Get an existing WebAppIpAddressExclusion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        :param pulumi.Input[builtins.bool] ip_address_exclusion_include: These are the only IP addresses that should be monitored
        :param pulumi.Input[Union['WebAppIpAddressExclusionIpExclusionListArgs', 'WebAppIpAddressExclusionIpExclusionListArgsDict']] ip_exclusion_list: **Examples:** - 84.112.10.5 - fe80::10a1:c6b2:5f68:785d
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WebAppIpAddressExclusionState.__new__(_WebAppIpAddressExclusionState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["ip_address_exclusion_include"] = ip_address_exclusion_include
        __props__.__dict__["ip_exclusion_list"] = ip_exclusion_list
        return WebAppIpAddressExclusion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[builtins.str]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="ipAddressExclusionInclude")
    def ip_address_exclusion_include(self) -> pulumi.Output[builtins.bool]:
        """
        These are the only IP addresses that should be monitored
        """
        return pulumi.get(self, "ip_address_exclusion_include")

    @property
    @pulumi.getter(name="ipExclusionList")
    def ip_exclusion_list(self) -> pulumi.Output[Optional['outputs.WebAppIpAddressExclusionIpExclusionList']]:
        """
        **Examples:** - 84.112.10.5 - fe80::10a1:c6b2:5f68:785d
        """
        return pulumi.get(self, "ip_exclusion_list")

