# mypy-boto3-logs

[![PyPI - mypy-boto3-logs](https://img.shields.io/pypi/v/mypy-boto3-logs.svg?color=blue)](https://pypi.org/project/mypy-boto3-logs)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-logs.svg?color=blue)](https://pypi.org/project/mypy-boto3-logs)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.CloudWatchLogs 1.16.10](https://boto3.amazonaws.com/v1/documentation/api/1.16.10/reference/services/logs.html#CloudWatchLogs) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.2.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-logs](#mypy-boto3-logs)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `CloudWatchLogs` service.

```bash
python -m pip install boto3-stubs[logs]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[logs]` in your environment: `python -m pip install 'boto3-stubs[logs]'`

Both type checking and auto-complete should work for `CloudWatchLogs` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[logs]` in your environment: `python -m pip install 'boto3-stubs[logs]'`

Both type checking and auto-complete should work for `CloudWatchLogs` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[logs]` in your environment: `python -m pip install 'boto3-stubs[logs]'`
- Run `mypy` as usual

Type checking should work for `CloudWatchLogs` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[logs]` in your environment: `python -m pip install 'boto3-stubs[logs]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `CloudWatchLogs` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`CloudWatchLogsClient` provides annotations for `boto3.client("logs")`.

```python
import boto3

from mypy_boto3_logs import CloudWatchLogsClient

client: CloudWatchLogsClient = boto3.client("logs")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CloudWatchLogsClient = session.client("logs")
```

### Paginators annotations

`mypy_boto3_logs.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_logs import CloudWatchLogsClient
from mypy_boto3_logs.paginator import (
    DescribeDestinationsPaginator,
    DescribeExportTasksPaginator,
    DescribeLogGroupsPaginator,
    DescribeLogStreamsPaginator,
    DescribeMetricFiltersPaginator,
    DescribeQueriesPaginator,
    DescribeResourcePoliciesPaginator,
    DescribeSubscriptionFiltersPaginator,
    FilterLogEventsPaginator,
)

client: CloudWatchLogsClient = boto3.client("logs")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_destinations_paginator: DescribeDestinationsPaginator = client.get_paginator("describe_destinations")
describe_export_tasks_paginator: DescribeExportTasksPaginator = client.get_paginator("describe_export_tasks")
describe_log_groups_paginator: DescribeLogGroupsPaginator = client.get_paginator("describe_log_groups")
describe_log_streams_paginator: DescribeLogStreamsPaginator = client.get_paginator("describe_log_streams")
describe_metric_filters_paginator: DescribeMetricFiltersPaginator = client.get_paginator("describe_metric_filters")
describe_queries_paginator: DescribeQueriesPaginator = client.get_paginator("describe_queries")
describe_resource_policies_paginator: DescribeResourcePoliciesPaginator = client.get_paginator("describe_resource_policies")
describe_subscription_filters_paginator: DescribeSubscriptionFiltersPaginator = client.get_paginator("describe_subscription_filters")
filter_log_events_paginator: FilterLogEventsPaginator = client.get_paginator("filter_log_events")
```







### Typed dictionations

`mypy_boto3_logs.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_logs.type_defs import (
    CreateExportTaskResponseTypeDef,
    DeleteQueryDefinitionResponseTypeDef,
    DescribeDestinationsResponseTypeDef,
    DescribeExportTasksResponseTypeDef,
    DescribeLogGroupsResponseTypeDef,
    DescribeLogStreamsResponseTypeDef,
    DescribeMetricFiltersResponseTypeDef,
    DescribeQueriesResponseTypeDef,
    DescribeQueryDefinitionsResponseTypeDef,
    DescribeResourcePoliciesResponseTypeDef,
    DescribeSubscriptionFiltersResponseTypeDef,
    DestinationTypeDef,
    ExportTaskExecutionInfoTypeDef,
    ExportTaskStatusTypeDef,
    ExportTaskTypeDef,
    FilteredLogEventTypeDef,
    FilterLogEventsResponseTypeDef,
    GetLogEventsResponseTypeDef,
    GetLogGroupFieldsResponseTypeDef,
    GetLogRecordResponseTypeDef,
    GetQueryResultsResponseTypeDef,
    InputLogEventTypeDef,
    ListTagsLogGroupResponseTypeDef,
    LogGroupFieldTypeDef,
    LogGroupTypeDef,
    LogStreamTypeDef,
    MetricFilterMatchRecordTypeDef,
    MetricFilterTypeDef,
    MetricTransformationTypeDef,
    OutputLogEventTypeDef,
    PaginatorConfigTypeDef,
    PutDestinationResponseTypeDef,
    PutLogEventsResponseTypeDef,
    PutQueryDefinitionResponseTypeDef,
    PutResourcePolicyResponseTypeDef,
    QueryDefinitionTypeDef,
    QueryInfoTypeDef,
    QueryStatisticsTypeDef,
    RejectedLogEventsInfoTypeDef,
    ResourcePolicyTypeDef,
    ResultFieldTypeDef,
    SearchedLogStreamTypeDef,
    StartQueryResponseTypeDef,
    StopQueryResponseTypeDef,
    SubscriptionFilterTypeDef,
    TestMetricFilterResponseTypeDef,
)

def get_structure() -> DestinationTypeDef:
    return {
      ...
    }
```
