# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['click_loguru']

package_data = \
{'': ['*']}

install_requires = \
['attrs>=20.1.0,<21.0.0',
 'click>=7.1.2,<8.0.0',
 'loguru>=0.5.0,<0.6.0',
 'memory_profiler>=0.57.0,<0.58.0']

setup_kwargs = {
    'name': 'click-loguru',
    'version': '1.3.6',
    'description': 'Logging to stderr and file for click applications.',
    'long_description': '============\nclick_loguru\n============\n.. badges-begin\n\n| |pypi| |Python Version| |repo| |downloads| |dlrate|\n| |license| |build| |coverage| |codacy| |issues|\n\n.. |pypi| image:: https://img.shields.io/pypi/v/click_loguru.svg\n    :target: https://pypi.python.org/pypi/click_loguru\n    :alt: Python package\n\n.. |Python Version| image:: https://img.shields.io/pypi/pyversions/click_loguru\n   :target: https://github.com/joelb/click_loguru\n\n.. |repo| image:: https://img.shields.io/github/last-commit/joelb123/click_loguru\n    :target: https://github.com/joelb123/click_loguru\n    :alt: GitHub repository\n\n.. |license| image:: https://img.shields.io/badge/License-BSD%203--Clause-blue.svg\n    :target: https://github.com/joelb123/click_loguru/blob/main/LICENSE.txt\n    :alt: License terms\n\n.. |build| image:: https://github.com/joelb123/click_loguru/workflows/tests/badge.svg\n    :target:  https://github.com/joelb123/click_loguru/actions\n    :alt: GitHub Actions\n\n.. |codacy| image:: https://api.codacy.com/project/badge/Grade/83706d2404e3436d94494eb3bbfe467d\n    :target: https://www.codacy.com/gh/joelb123/click_loguru?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=joelb123/click_loguru&amp;utm_campaign=Badge_Grade\n    :alt: Codacy.io grade\n\n.. |coverage| image:: https://codecov.io/gh/joelb123/click_loguru/branch/main/graph/badge.svg\n    :target: https://codecov.io/gh/joelb123/click_loguru\n    :alt: Codecov.io test coverage\n\n.. |issues| image:: https://img.shields.io/github/issues/joelb123/click_loguru.svg\n    :target:  https://github.com/joelb123/click_loguru/issues\n    :alt: Issues reported\n\n.. |depend| image:: https://api.dependabot.com/badges/status?host=github&repo=joelb123/click_loguru\n     :target: https://app.dependabot.com/accounts/joelb123/repos/236847525\n     :alt: dependabot dependencies\n\n.. |dlrate| image:: https://img.shields.io/pypi/dm/click_loguru\n    :target: https://pypistats.org/packages/click_loguru\n    :alt: Download stats\n\n.. |downloads| image:: https://pepy.tech/badge/click_loguru\n    :target: https://pepy.tech/project/click_loguru\n    :alt: Download stats\n\n.. badges-end\n \n.. image:: https://raw.githubusercontent.com/joelb123/click_loguru/main/docs/_static/logo.png\n   :target: https://raw.githubusercontent.com/joelb123/click_loguru/main/LICENSE.artwork.txt\n   :alt: Click/Loguru merged artwork licenses\n\n\n\n``click_loguru`` initializes `click <https://click.palletsprojects.com/>`_ CLI-based\nprograms for logging to stderr and (optionally) a log file via the\n`loguru <https://github.com/Delgan/loguru/>`_ logger.  It can optionally log run time,\nCPU use, and peak memory use of user functions.\n\nLog file names will include the name of your program and (if your application uses\nsubcommands via ``@click.group()``), the name of the subcommand. Log files are \n(optionally) numbered, with a retention policy specified.  Log files can be\nenabled or disabled per-subcommand and written to a subdirectory that your\napplication specifies.  \n\nGlobal CLI options control verbose/quiet levels and log file creation.\nThe values of these global options are accessible, along with the path to the\nlog file, from your application.\n\nInstantiation\n-------------\n``click_loguru`` objects are instantiated from the ``ClickLoguru`` class as::\n\n      click_loguru = ClickLoguru(name,\n                                 version,\n                                 retention=4,\n                                 stderr_format_func=None,\n                                 log_dir_parent="./logs",\n                                 file_log_level="DEBUG",\n                                 stderr_log_level="INFO",\n                                 timer_log_level="debug",\n        )\n\nwhere:\n\n* **name** is the name of your application\n* **version** is the version string of your application\n* **retention** is the log file retention policy.  If set to a non-zero value, the\n  log files will be given by ``logs/NAME[-SUBCOMMAND]_n.log`` where ```NAME`` is the name\n  of your application, ``SUBCOMMAND`` is the group subcommand (if you are using\n  click groups), and ``n`` is an integer number.  The value of ``retention`` specifies\n  the number of log files to be kept.\n* **stderr_format_func** is the format function to be used for messages to stderr, as\n  defined by ``loguru``.  Default is very short, with ``INFO``-level messages having\n  no level name printed.\n* **log_dir_parent** sets the location of the log file directory.  This value may be\n  overridden per-command.\n* **file_log_level**  sets the level of logging to the log file.\n* **stderr_log_level** sets the level of logging to stderr.  This value may be overridden\n  by the ``--quiet`` or ``--verbose`` options.\n* **timer_log_level** is the level at which ``elapsed_time`` results will be logged.\n\n\nMethods\n-------\nThe ``ClickLoguru`` class defines the following methods:\n\n* **logging_options** is a decorator to be used for your application\'s CLI function.  This\n  decorator defines the global options that allows control of ``quiet``, ``verbose``,\n  and ``log file`` booleans.\n\n* **stash_subcommand** is a  decorator to be used for the CLI method for applications\n  which define subcommands.\n\n* **init_logger** is  a decorator which must be used for each subcommand.   It allows\n  override of the default ``log_dir_parent`` established at instantiation,\n  as well as turning off file logging for that command by setting ``log file`` to ``False``.\n\n* **log_elapsed_time** is a decorator which causes the elapsed wall-clock time and\n  CPU time in seconds for the (sub)command\n  to be emitted at the level specified by the ``level=`` argument (``debug`` by default).\n\n* **get_global_options** is a method that returns the context object associated with the\n  global options. The context object is printable.  The attributes of the context object are the booleans ``verbose``,\n  ``quiet``, and ``log file``, the string ``subcommand`` showing the subcommand that was invoked,\n  and ``log file_handler_id`` if your code wishes to manipulate the handler directly.\n\n* **user_global_options_callback** is a method to be used as\n  a callback when your code declares a global option.  Values\n  of these global options will be stored in a user global\n  options context dictionary.\n\n* **get_user_global_options** is a method to retrieve a\n  dictionary of values of user global options.\n\n* **elapsed_timer** is a method that accepts a single argument, ``phase``.\n  The next invocation of this method will produce a log entry at ``timer_log_level``\n  showing the elapsed wall clock and CPU time.  If ``phase`` is ``None``, \n  the next invocation will not produce a message.\n\n* **log_peak_memory_use** is a method that results in the peak memory usage for\n  the function and children of the function to be emitted at a level specified\n  by the ``level=`` keyword (``debug`` is default).  This functionality\n  is somewhat expensive in that it requires an additional thread, so the global\n  option ``--profile_mem`` must be enabled.\n\n\nSee the `simple test CLI application\n<https://github.com/joelb123/click_loguru/blob/main/tests/__init__.py>`_\nfor usage examples.\n\nPrerequisites\n-------------\nPython 3.6 or greater is required.\nThis package is tested under Linux, MacOS, and Windows using Python 3.9.\n',
    'author': 'Joel Berendzen',
    'author_email': 'joel@generisbio.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/joelb123/click_loguru',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
