# Changelog

## 1.1.6 - 2025-10-31

### Исправлено

- Исправлена ошибка импорта в новых виртуальных окружениях (закреплена зависимость `hishel<1.0.0`)


## 1.1.5 - 2025-10-20

### Добавлено

- Добавлены слои новой группы "Негативные процессы"

### Исправлено

- Исправлена обработка геометрии типов MultiLineString и MultiPoint 

- Использование метода `.to_multi_shape()` в не Polygon-слоях


## 1.1.4 - 2025-10-08

### Изменено

- Обновлена схема слоя "Границы лесопарка"


## 1.1.3 - 2025-08-12

### Добавлено

- `PynspdResponseError` - базовый класс для "плохих" ответ от НСПД. Все сетевые ошибки наследуются от этого класса

### Исправлено

- Рандомная генереация User-Agent для обхода блокировки по нему


## 1.1.2 - 2025-08-04

### Добавлено

- `PynspdServerError` для неизвестных серверных ошибок НСПД

### Изменено

- Возвращены ошибка `TooBigContour` и метод `.search_in_contour_iter(...)` ([#6](https://github.com/yazmolod/pynspd/issues/6))

### Исправлено

- Аргумент `client_retries` при значении `0` не сбрасывается до значения по умолчанию `10`
- CLI: исправлен баг определения WKT-текста при поиске


## 1.1.1 - 2025-06-28

### Добавлено

- Метод `.search_in_layers(query, layer1, layer2, ...)` для поиска в нескольких слоях
- CLI: добавлен флаг для интерактивного выбора слоев
- CLI: добавлен флаг для поиска не по кадастровым номерам

### Изменено

- Команда `find` в CLI заменена на `search`

### Исправлено

- Ошибка валидации для полей с датой, смена с date на datetime
- Ошибки рантайма в CLI


## 1.1.0 - 2025-06-05

### Добавлено

- Быстрая настройка кэширования через конструктор клиента
- Настройка клиента через переменные окружения (в том числе CLI)
- Детекция блокировки со стороны НСПД

### Изменено

- Аргументы в конструкторе клиента переименованы и приведены к новому формату 

### Исправлено

- Расширена обработка сетевых ошибок
- Исправлена и доработана работа через прокси


## 1.0.2 - 2025-04-30

### Добавлено

- Поддержка списка координат в команде `pynspd geo`


## 1.0.1 - 2025-04-29

### Исправлено

- Критическая ошибка, мешающая запуску CLI


## 1.0.0 - 2025-04-29

### Добавлено

- Утилита для работы в командной строке ([CLI](https://yazmolod.github.io/pynspd/advanced/cli/))
- Метод `.get_tab_data(feat, tab_name)` для получения данных из вкладки по ее имени

### Изменено

- Все кастомные ошибки этой библиотеки наследуются от одной - `PynspdError`

### Удалено

- Методы с суффиксом `_by_model` переименованы (`.search_at_point_by_model(...)` -> `.search_at_point(...)`)
- Метод `.search_in_theme`, используйте `.find` вместо него
- Убраны ошибка `TooBigContour` и метод `.search_in_contour_iter(...)`, т.к. НСПД перестал ограничивать зону поиска


## 0.7.4 - 2025-04-19

### Добавлено

- Слой "Граница лесопарка"


## 0.7.3 - 2025-03-24

### Исправлено

- Ключи словаря в ответе с вкладки "Объекты" очищаются от лишних пробелов и двоеточий

### Изменено

- Обновлена схема для слоя `Негативные процессы` в соответствие с НСПД


## 0.7.2 - 2025-03-13

### Исправлено

- Пустые поля с датой не приводят к ошибке валидации
- Поля с системной информацией помечены как необязательные, т.к. обнаружился кейс их отсутствия

### Изменено

- К ключам кэша добавляется суффикс `pynspd-` для удобной фильтрации в Redis и других хранилищах

### Устарело

- В методы частицы `zu` в имени будут заменены на частицу `landplot[s]`, `oks` - на `building[s]`


## 0.7.1 - 2025-03-10

### Исправлено

- Критическая ошибка генерации синхронного кода, приводящая библиотеку в неработоспособное состояние


## 0.7.0 - 2025-03-10

### Добавлено 

- Метод `.search_in_contour_iter(...)`, позволяющий искать объекты в контуре без ограничений
- Метод `.search_at_coords(lat, lng, layer_def)` для поиска по координатам
- Методы `.find(...)`, `.find_in_layer(...)`, `.find_landplot(...)`, `.find_building(...)` для поиска исключительно одного объекта

### Изменено

- Методы поиска, принимающие id слоя, переведены в приватные методы (например, `.search_at_point` -> `._search_at_point`); методы, принимающие определение слоя, переименованы (например, `.search_at_point_by_model` -> `.search_at_point`) и рекомендованы к использованию по умолчанию
- Текстовые поисковые методы (`search`) выдают массив вместо одного объекта
- Изменено отображение (`repr`) для класса `NspdFeature`

### Устарело

- Методы с суффиксом `_by_model` (например, `.search_at_point_by_model(...)`) будут убраны в следующей версии (используйте методы без суффикса вместо него)
- Метод `.search_in_theme` будет убраны в следующей версии (используйте `.find` вместо него)


## 0.6.1 - 2025-02-28

### Исправлено

- Нестандартные кейсы, когда на один к/н API выдается несколько результатов, 
а на сайте отображается один (например, 77:04:0004018:3371) 

### Добавлено 
- Ошибка `AmbiguousSearchError`, если поиск не дает однозначный результат


## 0.6.0 - 2025-02-18

### Добавлено 

- Поддержка кэширования результатов благодаря [Hishel](https://github.com/karpetrosyan/hishel)
- [Пользовательская документация](https://yazmolod.github.io/pynspd/)

### Устарело

- Будут убраны в версии `0.7.0` методы:
    - `api.search_by_theme()` - заменится на `api.search_in_theme()`
    - `api.search_by_layers()` - заменится на `api.search_in_layer()`
    - `api.search_by_model()` - заменится на `api.search_in_layer_by_model()`

### Изменено

- Статический анализатор теперь понимает вывод метода `NspdFeature.by_title(...)` 
  и приводит его к типу конкретного слоя

### Удалено

- Методы `api.search_many_zu()` и `api.search_many_oks()`


## 0.5.4 - 2025-02-07

### Исправлено

- Обновление схем ответа от НСПД


## 0.5.3 - 2025-02-04

### Исправлено

- Исправлен некорректный тип для площадей (несоответствие схемы НСПД и реальных данных)


## 0.5.2 - 2025-02-04

### Устарело

- Методы `api.search_many_zu()` и `api.search_many_oks()` будут убраны в версии `0.6.0`  

### Исправлено

- Обновление схем: добавлено свойство "Учетный номер"
- Исправлен некорректный тип для `specified_area`


## 0.5.1 - 2025-02-04

### Исправлено

- Доработана обработка исключений при запросах (разрыв соединения со стороны сервера, таймауты, многочисленные запросы)


## 0.5.0 - 2025-02-04

- Добавлена возможность получения информации из вкладок объекта ("Объекты", "Части ЗУ" и т.д.)