Спасибо за интерес к проекту! Поспособствовать развитию `pynspd` можно несколькими способами:

- Поставить ⭐ на [GitHub](https://github.com/yazmolod/pynspd);
- Попробовать `pynspd` в работе и [сообщить о найденных проблемах](https://github.com/yazmolod/pynspd/issues);
- Поучаствовать в разработке проекта.

## Старт для разработки

Для начала разработки вам нужно сделать свой [форк репозитория pynspd](https://github.com/yazmolod/pynspd/fork).

После этого клонировать репозиторий локально, перейти в скачанную папку и запустить скрипт установки:

!!! warning "Внимание: внешняя зависимость"
    `pynspd` использует пакетный менеджер [uv](https://docs.astral.sh/uv/) - невероятно быструю замену `pip` и многих других инструментов.

    Убедитесь, что он [установлен](https://docs.astral.sh/uv/getting-started/installation/) перед запуском `make`-команд.

```bash
git clone https://github.com/YOUR-USERNAME/pynspd
cd pynspd
make install
```


??? info "Утилита `make` для Windows"
    Если вы пользователь Windows, `make` нужно установить отдельно. 
    Автор рекомендует использовать для этого пакетный менеджер [chocolatey](https://chocolatey.org/install):
    ```pwsh
    choco install make
    ```


## Async/Sync

Подход к поддержке обоих async/sync API в `pynspd` был вдохновлен аналогичным в [Hishel](https://hishel.com/contributing/#async-and-sync). 
Если кратко: мы пишем только асинхронный код, а потом специальным скриптом создаем синхронную версию.

Исходя из этого, от разработчика требуется писать код только в папках `**/_async`.
Синхронный код генерируется при помощи команды:

```bash
make unasync
```

## Тестирование и линтинг
Запуск тестов осуществляется при помощи команды:

```bash
make tests
```

Линтинг и форматирование:

```bash
make lint
```

## Написание документации

Страницы документации располагаются в папке `docs/` проекта.

Для локального разворачивания сайта документации, воспользуйтесь командой:

```bash
make docs
```

