# This file was auto-generated by Fern from our API Definition.

from ..core.client_wrapper import SyncClientWrapper
import typing
from ..core.request_options import RequestOptions
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper


class ProfilesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def delete(
        self,
        *,
        profile_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        profile_names: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Delete profiles matching by id

        Parameters
        ----------
        profile_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            DEPRECATED. Use profileNames.

        profile_names : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A comma-separated list of profile names.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from airtop import Airtop

        client = Airtop(
            api_key="YOUR_API_KEY",
        )
        client.profiles.delete()
        """
        _response = self._client_wrapper.httpx_client.request(
            "profiles",
            method="DELETE",
            params={
                "profileIds": profile_ids,
                "profileNames": profile_names,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncProfilesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def delete(
        self,
        *,
        profile_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        profile_names: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Delete profiles matching by id

        Parameters
        ----------
        profile_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            DEPRECATED. Use profileNames.

        profile_names : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A comma-separated list of profile names.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from airtop import AsyncAirtop

        client = AsyncAirtop(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.profiles.delete()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "profiles",
            method="DELETE",
            params={
                "profileIds": profile_ids,
                "profileNames": profile_names,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
