# This file was auto-generated by Fern from our API Definition.

import typing
from ..core.client_wrapper import SyncClientWrapper
from .types.sessions_list_request_status import SessionsListRequestStatus
from ..core.request_options import RequestOptions
from ..types.sessions_response import SessionsResponse
from ..core.pydantic_utilities import parse_obj_as
from ..errors.not_found_error import NotFoundError
from ..types.error_model import ErrorModel
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..errors.internal_server_error import InternalServerError
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..types.session_config_v1 import SessionConfigV1
from ..types.session_response import SessionResponse
from ..core.serialization import convert_and_respect_annotation_metadata
from ..core.jsonable_encoder import jsonable_encoder
from .types.sessions_events_response import SessionsEventsResponse
import httpx_sse
import json
from ..core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SessionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        session_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        status: typing.Optional[SessionsListRequestStatus] = None,
        offset: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SessionsResponse:
        """
        Get a list of sessions by ID

        Parameters
        ----------
        session_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A comma-separated list of IDs of the sessions to retrieve.

        status : typing.Optional[SessionsListRequestStatus]
            Status of the session to get.

        offset : typing.Optional[int]
            Offset for pagination.

        limit : typing.Optional[int]
            Limit for pagination.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SessionsResponse
            OK

        Examples
        --------
        from airtop import Airtop

        client = Airtop(
            api_key="YOUR_API_KEY",
        )
        client.sessions.list(
            offset=1,
            limit=10,
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "sessions",
            method="GET",
            params={
                "sessionIds": session_ids,
                "status": status,
                "offset": offset,
                "limit": limit,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SessionsResponse,
                    parse_obj_as(
                        type_=SessionsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        ErrorModel,
                        parse_obj_as(
                            type_=ErrorModel,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorModel,
                        parse_obj_as(
                            type_=ErrorModel,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        ErrorModel,
                        parse_obj_as(
                            type_=ErrorModel,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create(
        self,
        *,
        configuration: typing.Optional[SessionConfigV1] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SessionResponse:
        """
        Parameters
        ----------
        configuration : typing.Optional[SessionConfigV1]
            Session configuration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SessionResponse
            Created

        Examples
        --------
        from airtop import Airtop

        client = Airtop(
            api_key="YOUR_API_KEY",
        )
        client.sessions.create()
        """
        _response = self._client_wrapper.httpx_client.request(
            "sessions",
            method="POST",
            json={
                "configuration": convert_and_respect_annotation_metadata(
                    object_=configuration, annotation=SessionConfigV1, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SessionResponse,
                    parse_obj_as(
                        type_=SessionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_info(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> SessionResponse:
        """
        Get a session by ID

        Parameters
        ----------
        id : str
            Id of the session to get

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SessionResponse
            OK

        Examples
        --------
        from airtop import Airtop

        client = Airtop(
            api_key="YOUR_API_KEY",
        )
        client.sessions.get_info(
            id="6aac6f73-bd89-4a76-ab32-5a6c422e8b0b",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SessionResponse,
                    parse_obj_as(
                        type_=SessionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        ErrorModel,
                        parse_obj_as(
                            type_=ErrorModel,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorModel,
                        parse_obj_as(
                            type_=ErrorModel,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        ErrorModel,
                        parse_obj_as(
                            type_=ErrorModel,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def terminate(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Ends a session by ID. If a given session id does not exist within the organization, it is ignored.

        Parameters
        ----------
        id : str
            ID of the session to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from airtop import Airtop

        client = Airtop(
            api_key="YOUR_API_KEY",
        )
        client.sessions.terminate(
            id="6aac6f73-bd89-4a76-ab32-5a6c422e8b0b",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def events(
        self,
        id: str,
        *,
        last_event_id: typing.Optional[int] = None,
        all_: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[SessionsEventsResponse]:
        """
        Get a session event stream for a given session ID

        Parameters
        ----------
        id : str
            ID of the session to get status info for

        last_event_id : typing.Optional[int]
            last known event id

        all_ : typing.Optional[bool]
            Get all events

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.Iterator[SessionsEventsResponse]
            OK
        """
        with self._client_wrapper.httpx_client.stream(
            f"sessions/{jsonable_encoder(id)}/events",
            method="GET",
            params={
                "lastEventId": last_event_id,
                "all": all_,
            },
            request_options=request_options,
        ) as _response:
            try:
                if 200 <= _response.status_code < 300:
                    _event_source = httpx_sse.EventSource(_response)
                    for _sse in _event_source.iter_sse():
                        try:
                            yield typing.cast(
                                SessionsEventsResponse,
                                parse_obj_as(
                                    type_=SessionsEventsResponse,  # type: ignore
                                    object_=json.loads(_sse.data),
                                ),
                            )
                        except:
                            pass
                    return
                _response.read()
                if _response.status_code == 404:
                    raise NotFoundError(
                        typing.cast(
                            ErrorModel,
                            parse_obj_as(
                                type_=ErrorModel,  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                if _response.status_code == 422:
                    raise UnprocessableEntityError(
                        typing.cast(
                            ErrorModel,
                            parse_obj_as(
                                type_=ErrorModel,  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                if _response.status_code == 500:
                    raise InternalServerError(
                        typing.cast(
                            ErrorModel,
                            parse_obj_as(
                                type_=ErrorModel,  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                _response_json = _response.json()
            except JSONDecodeError:
                raise ApiError(status_code=_response.status_code, body=_response.text)
            raise ApiError(status_code=_response.status_code, body=_response_json)

    def save_extension_configuration_on_termination(
        self,
        session_id: str,
        extension_configuration_name: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Parameters
        ----------
        session_id : str
            ID of the session.

        extension_configuration_name : str
            Name under which to save the extension configuration.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from airtop import Airtop

        client = Airtop(
            api_key="YOUR_API_KEY",
        )
        client.sessions.save_extension_configuration_on_termination(
            session_id="6aac6f73-bd89-4a76-ab32-5a6c422e8b0b",
            extension_configuration_name="myExtensionConfiguration",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/save-extension-configuration-on-termination/{jsonable_encoder(extension_configuration_name)}",
            method="PUT",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def save_profile_on_termination(
        self, session_id: str, profile_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        session_id : str
            ID of the session.

        profile_name : str
            Name under which to save the profile.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from airtop import Airtop

        client = Airtop(
            api_key="YOUR_API_KEY",
        )
        client.sessions.save_profile_on_termination(
            session_id="6aac6f73-bd89-4a76-ab32-5a6c422e8b0b",
            profile_name="myProfile",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/save-profile-on-termination/{jsonable_encoder(profile_name)}",
            method="PUT",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncSessionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        session_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        status: typing.Optional[SessionsListRequestStatus] = None,
        offset: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SessionsResponse:
        """
        Get a list of sessions by ID

        Parameters
        ----------
        session_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A comma-separated list of IDs of the sessions to retrieve.

        status : typing.Optional[SessionsListRequestStatus]
            Status of the session to get.

        offset : typing.Optional[int]
            Offset for pagination.

        limit : typing.Optional[int]
            Limit for pagination.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SessionsResponse
            OK

        Examples
        --------
        import asyncio

        from airtop import AsyncAirtop

        client = AsyncAirtop(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.sessions.list(
                offset=1,
                limit=10,
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "sessions",
            method="GET",
            params={
                "sessionIds": session_ids,
                "status": status,
                "offset": offset,
                "limit": limit,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SessionsResponse,
                    parse_obj_as(
                        type_=SessionsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        ErrorModel,
                        parse_obj_as(
                            type_=ErrorModel,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorModel,
                        parse_obj_as(
                            type_=ErrorModel,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        ErrorModel,
                        parse_obj_as(
                            type_=ErrorModel,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create(
        self,
        *,
        configuration: typing.Optional[SessionConfigV1] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SessionResponse:
        """
        Parameters
        ----------
        configuration : typing.Optional[SessionConfigV1]
            Session configuration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SessionResponse
            Created

        Examples
        --------
        import asyncio

        from airtop import AsyncAirtop

        client = AsyncAirtop(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.sessions.create()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "sessions",
            method="POST",
            json={
                "configuration": convert_and_respect_annotation_metadata(
                    object_=configuration, annotation=SessionConfigV1, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SessionResponse,
                    parse_obj_as(
                        type_=SessionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_info(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> SessionResponse:
        """
        Get a session by ID

        Parameters
        ----------
        id : str
            Id of the session to get

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SessionResponse
            OK

        Examples
        --------
        import asyncio

        from airtop import AsyncAirtop

        client = AsyncAirtop(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.sessions.get_info(
                id="6aac6f73-bd89-4a76-ab32-5a6c422e8b0b",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SessionResponse,
                    parse_obj_as(
                        type_=SessionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        ErrorModel,
                        parse_obj_as(
                            type_=ErrorModel,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorModel,
                        parse_obj_as(
                            type_=ErrorModel,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        ErrorModel,
                        parse_obj_as(
                            type_=ErrorModel,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def terminate(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Ends a session by ID. If a given session id does not exist within the organization, it is ignored.

        Parameters
        ----------
        id : str
            ID of the session to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from airtop import AsyncAirtop

        client = AsyncAirtop(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.sessions.terminate(
                id="6aac6f73-bd89-4a76-ab32-5a6c422e8b0b",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def events(
        self,
        id: str,
        *,
        last_event_id: typing.Optional[int] = None,
        all_: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[SessionsEventsResponse]:
        """
        Get a session event stream for a given session ID

        Parameters
        ----------
        id : str
            ID of the session to get status info for

        last_event_id : typing.Optional[int]
            last known event id

        all_ : typing.Optional[bool]
            Get all events

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.AsyncIterator[SessionsEventsResponse]
            OK
        """
        async with self._client_wrapper.httpx_client.stream(
            f"sessions/{jsonable_encoder(id)}/events",
            method="GET",
            params={
                "lastEventId": last_event_id,
                "all": all_,
            },
            request_options=request_options,
        ) as _response:
            try:
                if 200 <= _response.status_code < 300:
                    _event_source = httpx_sse.EventSource(_response)
                    async for _sse in _event_source.aiter_sse():
                        try:
                            yield typing.cast(
                                SessionsEventsResponse,
                                parse_obj_as(
                                    type_=SessionsEventsResponse,  # type: ignore
                                    object_=json.loads(_sse.data),
                                ),
                            )
                        except:
                            pass
                    return
                await _response.aread()
                if _response.status_code == 404:
                    raise NotFoundError(
                        typing.cast(
                            ErrorModel,
                            parse_obj_as(
                                type_=ErrorModel,  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                if _response.status_code == 422:
                    raise UnprocessableEntityError(
                        typing.cast(
                            ErrorModel,
                            parse_obj_as(
                                type_=ErrorModel,  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                if _response.status_code == 500:
                    raise InternalServerError(
                        typing.cast(
                            ErrorModel,
                            parse_obj_as(
                                type_=ErrorModel,  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                _response_json = _response.json()
            except JSONDecodeError:
                raise ApiError(status_code=_response.status_code, body=_response.text)
            raise ApiError(status_code=_response.status_code, body=_response_json)

    async def save_extension_configuration_on_termination(
        self,
        session_id: str,
        extension_configuration_name: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Parameters
        ----------
        session_id : str
            ID of the session.

        extension_configuration_name : str
            Name under which to save the extension configuration.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from airtop import AsyncAirtop

        client = AsyncAirtop(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.sessions.save_extension_configuration_on_termination(
                session_id="6aac6f73-bd89-4a76-ab32-5a6c422e8b0b",
                extension_configuration_name="myExtensionConfiguration",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/save-extension-configuration-on-termination/{jsonable_encoder(extension_configuration_name)}",
            method="PUT",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def save_profile_on_termination(
        self, session_id: str, profile_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        session_id : str
            ID of the session.

        profile_name : str
            Name under which to save the profile.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from airtop import AsyncAirtop

        client = AsyncAirtop(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.sessions.save_profile_on_termination(
                session_id="6aac6f73-bd89-4a76-ab32-5a6c422e8b0b",
                profile_name="myProfile",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/save-profile-on-termination/{jsonable_encoder(profile_name)}",
            method="PUT",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
