# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import typing
import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class AirtopProxyConfiguration(UniversalBaseModel):
    country: typing.Optional[str] = pydantic.Field(default=None)
    """
    Country to exit from, in [ISO 3166-1 alpha-2 format](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). Or `global` to get IP addresses from random countries. We do not guarantee an available proxy in all countries.
    """

    sticky: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Try to maintain the same IP address for the duration for up to a maximum of 30 minutes. `true` by default. <Note>Stickiness is on a best-effort basis; we cannot guarantee that the same IP address will be available for 30 minutes at a time.</Note>
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
