# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import typing_extensions
import typing
from ..core.serialization import FieldMetadata
import pydantic
from .external_session_config import ExternalSessionConfig
import datetime as dt
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class ExternalSessionWithConnectionInfo(UniversalBaseModel):
    cdp_url: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="cdpUrl")] = pydantic.Field(
        default=None
    )
    """
    Url to connect to chrome devtools protocol port on the Airtop browser. Include the header 'Authorization: Bearer <api-key>.'
    """

    cdp_ws_url: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="cdpWsUrl")] = pydantic.Field(
        default=None
    )
    """
    Websocket url to connect to the Airtop browser for CDP-based automation frameworks (e.g. Puppeteer or Playwright). Include the header 'Authorization: Bearer <airtop-api-key>.'
    """

    chromedriver_url: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="chromedriverUrl")] = (
        pydantic.Field(default=None)
    )
    """
    Websocket url to connect to the Airtop browser for webdriver-based automation frameworks (e.g. Selenium). Include the header 'Authorization: Bearer <airtop-api-key>.'
    """

    configuration: ExternalSessionConfig = pydantic.Field()
    """
    Session configuration details. DEPRECATED
    """

    current_usage: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="currentUsage")] = (
        pydantic.Field(default=None)
    )
    """
    Current usage in minutes.
    """

    date_created: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="dateCreated")] = (
        pydantic.Field(default=None)
    )
    """
    Date the session was created.
    """

    id: str = pydantic.Field()
    """
    Id of the session.
    """

    last_activity: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="lastActivity")] = (
        pydantic.Field(default=None)
    )
    """
    Date of the last activity.
    """

    profile_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="profileId")] = pydantic.Field(
        default=None
    )
    """
    Id of a newly persisted profile. DEPRECATED: Use profileName.
    """

    status: str = pydantic.Field()
    """
    Session status.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
